class LaserScorch expands Decal;

#exec TEXTURE IMPORT NAME=energymark FILE=TEXTURES\energymark.pcx LODSET=2

var bool bAttached, bStartedLife, bImportant;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	SetTimer(1.0, false);
}

simulated function Timer()
{
	// Check for nearby players, if none then destroy self

	if ( !bAttached )
	{
		Destroy();
		return;
	}

	if ( !bStartedLife )
	{
		RemoteRole = ROLE_None;
		bStartedLife = true;

		if ( Level.bDropDetail )
			SetTimer(5.0 + 3 * FRand(), false);
		else
			SetTimer(13.0 + 7 * FRand(), false);

		return;
	}
	if ( Level.bDropDetail && (MultiDecalLevel < 6) )
	{
		if ( (Level.TimeSeconds - LastRenderedTime > 20.35)
			|| (!bImportant && (FRand() < 0.20)) )
			Destroy();
		else
		{
			SetTimer(1.0, true);
			return;
		}
	}
	else if ( Level.TimeSeconds - LastRenderedTime < 1 )
	{
		SetTimer(5.0, true);
		return;
	}
	Destroy();
}


defaultproperties
{
     bAttached=True
     bImportant=True
     MultiDecalLevel=0
     Texture=Texture'LoathsomeLaser_RC2.energymark'
     LifeSpan=24.000000
     DrawScale=0.050000
}
