//=============================================================================
// Loathsome Laser.  - 2015
//=============================================================================
class LL extends TournamentWeapon;

#exec MESH IMPORT MESH=LaserGunL ANIVFILE=MODELS\PulseGun_a.3d DATAFILE=MODELS\PulseGun_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=LaserGunL X=0 Y=0 Z=0 YAW=64 ROLL=0 PITCH=0

#exec MESH DROPFRAMES MESH=LaserGunL STARTFRAME=65    NUMFRAMES=50
#exec MESH DROPFRAMES MESH=LaserGunL STARTFRAME=86    NUMFRAMES=79

#exec MESH SEQUENCE MESH=LaserGunL SEQ=All          STARTFRAME=0     NUMFRAMES=126
#exec MESH SEQUENCE MESH=LaserGunL SEQ=Down		    STARTFRAME=8     NUMFRAMES=1
#exec MESH SEQUENCE MESH=LaserGunL SEQ=Select       STARTFRAME=9     NUMFRAMES=16 RATE=36 GROUP=Select
#exec MESH SEQUENCE MESH=LaserGunL SEQ=Still        STARTFRAME=25    NUMFRAMES=1
#exec MESH SEQUENCE MESH=LaserGunL SEQ=shoot1       STARTFRAME=25    NUMFRAMES=5
#exec MESH SEQUENCE MESH=LaserGunL SEQ=shoot2       STARTFRAME=30    NUMFRAMES=5
#exec MESH SEQUENCE MESH=LaserGunL SEQ=shoot3       STARTFRAME=35    NUMFRAMES=5
#exec MESH SEQUENCE MESH=LaserGunL SEQ=spindown     STARTFRAME=40    NUMFRAMES=25
#exec MESH SEQUENCE MESH=LaserGunL SEQ=bolt         STARTFRAME=65   NUMFRAMES=20
#exec MESH SEQUENCE MESH=LaserGunL SEQ=boltstart    STARTFRAME=65   NUMFRAMES=15
#exec MESH SEQUENCE MESH=LaserGunL SEQ=boltloop     STARTFRAME=70   NUMFRAMES=10
#exec MESH SEQUENCE MESH=LaserGunL SEQ=boltend      STARTFRAME=80   NUMFRAMES=5
#exec MESH SEQUENCE MESH=LaserGunL SEQ=idle         STARTFRAME=85   NUMFRAMES=1 
#exec MESH SEQUENCE MESH=LaserGunL SEQ=Shootloop    STARTFRAME=86   NUMFRAMES=40   

#exec MESHMAP NEW   MESHMAP=LaserGunL MESH=LaserGunL
#exec MESHMAP SCALE MESHMAP=LaserGunL X=0.013 Y=0.013 Z=0.026

//#exec TEXTURE IMPORT NAME=JLaserGun_01 FILE=Textures\Pulse-tex.pcx GROUP=Skins LODSET=2
//#exec TEXTURE IMPORT NAME=JLaserGun_01 FILE=Textures\LaserPulse01.pcx GROUP=Skins LODSET=2
//#exec TEXTURE IMPORT NAME=JLaserGun_02 FILE=Textures\Pulse-tex.pcx GROUP=Skins LODSET=2
//#exec TEXTURE IMPORT NAME=JLaserGun_02 FILE=Textures\LaserPulse01.pcx GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=JLaserGun_01 FILE=Textures\LaserPulse02.pcx GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=JLaserGun_02 FILE=Textures\LaserPulse02.pcx GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=JLaserGun_03 FILE=Textures\Hand.pcx GROUP=Skins LODSET=2

#exec MESHMAP SETTEXTURE MESHMAP=LaserGunL NUM=1 TEXTURE=JLaserGun_01
#exec MESHMAP SETTEXTURE MESHMAP=LaserGunL NUM=2 TEXTURE=JLaserGun_02
#exec MESHMAP SETTEXTURE MESHMAP=LaserGunL NUM=3 TEXTURE=JLaserGun_03

// right handed view version
#exec MESH IMPORT MESH=LaserGunR ANIVFILE=MODELS\PulseGun_a.3d DATAFILE=MODELS\PulseGun_d.3d unmirror=1 unmirrortex=1
#exec MESH ORIGIN MESH=LaserGunR X=0 Y=0 Z=0 YAW=64 ROLL=0 PITCH=0

#exec MESH DROPFRAMES MESH=LaserGunR STARTFRAME=65    NUMFRAMES=50
#exec MESH DROPFRAMES MESH=LaserGunR STARTFRAME=86    NUMFRAMES=79

#exec MESH SEQUENCE MESH=LaserGunR SEQ=All          STARTFRAME=0     NUMFRAMES=255
#exec MESH SEQUENCE MESH=LaserGunR SEQ=Down         STARTFRAME=8     NUMFRAMES=1
#exec MESH SEQUENCE MESH=LaserGunR SEQ=Select       STARTFRAME=9     NUMFRAMES=16 RATE=36 GROUP=Select
#exec MESH SEQUENCE MESH=LaserGunR SEQ=Still        STARTFRAME=25    NUMFRAMES=1
#exec MESH SEQUENCE MESH=LaserGunR SEQ=shoot1       STARTFRAME=25    NUMFRAMES=5
#exec MESH SEQUENCE MESH=LaserGunR SEQ=shoot2       STARTFRAME=30    NUMFRAMES=5
#exec MESH SEQUENCE MESH=LaserGunR SEQ=shoot3       STARTFRAME=35    NUMFRAMES=5
#exec MESH SEQUENCE MESH=LaserGunR SEQ=spindown     STARTFRAME=40    NUMFRAMES=25
#exec MESH SEQUENCE MESH=LaserGunR SEQ=bolt         STARTFRAME=65   NUMFRAMES=20
#exec MESH SEQUENCE MESH=LaserGunR SEQ=boltstart    STARTFRAME=65   NUMFRAMES=15
#exec MESH SEQUENCE MESH=LaserGunR SEQ=boltloop     STARTFRAME=70   NUMFRAMES=10
#exec MESH SEQUENCE MESH=LaserGunR SEQ=boltend      STARTFRAME=80   NUMFRAMES=5
#exec MESH SEQUENCE MESH=LaserGunR SEQ=idle         STARTFRAME=85   NUMFRAMES=1 
#exec MESH SEQUENCE MESH=LaserGunR SEQ=Shootloop    STARTFRAME=86   NUMFRAMES=40   

#exec MESHMAP NEW   MESHMAP=LaserGunR MESH=LaserGunR
//#exec MESHMAP NEW   MESHMAP=LaserGunR MESH=LaserGun   <-- PulseGun Bug ?
#exec MESHMAP SCALE MESHMAP=LaserGunR X=0.013 Y=0.013 Z=0.026

#exec MESHMAP SETTEXTURE MESHMAP=LaserGunR NUM=1 TEXTURE=JLaserGun_01
#exec MESHMAP SETTEXTURE MESHMAP=LaserGunR NUM=2 TEXTURE=JLaserGun_02
#exec MESHMAP SETTEXTURE MESHMAP=LaserGunR NUM=3 TEXTURE=JLaserGun_03


// 3rd person view
#exec MESH IMPORT MESH=LaserGun3rd ANIVFILE=MODELS\Pulse3rd_a.3d DATAFILE=MODELS\Pulse3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=LaserGun3rd X=0 Y=200 Z=-50 YAW=64 ROLL=0 PITCH=0
#exec MESH SEQUENCE MESH=LaserGun3rd SEQ=All                      STARTFRAME=0 NUMFRAMES=50
#exec MESH SEQUENCE MESH=LaserGun3rd SEQ=still                      STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=LaserGun3rd SEQ=shootloop                  STARTFRAME=5 NUMFRAMES=20
#exec MESH SEQUENCE MESH=LaserGun3rd SEQ=spindown                   STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW   MESHMAP=LaserGun3rd MESH=LaserGun3rd
#exec MESHMAP SCALE MESHMAP=LaserGun3rd X=0.1 Y=0.1 Z=0.2
//#exec TEXTURE IMPORT NAME=JLaser3rd_01 FILE=Textures\LaserPulse01.pcx GROUP=Skins LODSET=2
//#exec TEXTURE IMPORT NAME=JLaser3rd_01 FILE=Textures\Pulse-tex.pcx GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=JLaser3rd_01 FILE=Textures\LaserPulse02.pcx GROUP=Skins LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=LaserGun3rd NUM=1 TEXTURE=JLaser3rd_01

// Pickup view
#exec MESH IMPORT MESH=LaserPickup ANIVFILE=MODELS\PulsePickup_a.3d DATAFILE=MODELS\PulsePickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=LaserPickup X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=LaserPickup SEQ=All                      STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW   MESHMAP=LaserPickup MESH=LaserPickup
#exec MESHMAP SCALE MESHMAP=LaserPickup X=0.08 Y=0.08 Z=0.16
//#exec TEXTURE IMPORT NAME=JLaserPickup_01 FILE=Textures\LaserPulse01.pcx GROUP=Skins LODSET=2
//#exec TEXTURE IMPORT NAME=JLaserPickup_01 FILE=Textures\Pulse-tex.pcx GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=JLaserPickup_01 FILE=Textures\LaserPulse02.pcx GROUP=Skins LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=LaserPickup NUM=1 TEXTURE=JLaserPickup_01

#exec AUDIO IMPORT FILE="Sounds\PulseBolt.WAV" NAME="LaserBolt" GROUP="LaserGun"
#exec AUDIO IMPORT FILE="Sounds\PulseDown.WAV" NAME="LaserDown" GROUP="LaserGun"
#exec AUDIO IMPORT FILE="Sounds\PulsePickup.WAV" NAME="LaserPickup" GROUP="LaserGun"

#exec TEXTURE IMPORT NAME=IconPulse FILE=TEXTURES\WpnPulse.pcx GROUP="Icons" MIPS=OFF
#exec TEXTURE IMPORT NAME=UsePulse FILE=TEXTURES\UsePulse.pcx GROUP="Icons" MIPS=OFF

#exec MESH IMPORT MESH=muzzPF3 ANIVFILE=MODELS\muzzle2_a.3d DATAFILE=MODELS\muzzle2_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=muzzPF3 MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=muzzPF3 X=0 Y=890 Z=-10 YAW=64
#exec MESH SEQUENCE MESH=muzzPF3 SEQ=All                      STARTFRAME=0 NUMFRAMES=9
#exec MESHMAP NEW   MESHMAP=muzzPF3 MESH=muzzPF3
#exec MESHMAP SCALE MESHMAP=muzzPF3 X=0.08 Y=0.05 Z=0.16
#exec TEXTURE IMPORT NAME=MuzzyPulse FILE=Textures\Pulseflash.pcx GROUP=Skins

var() int LaserDamage;
var() int LaserLength;
var() bool bShowLen;

var float Angle, Count;
var FLBolt LaserBeam;
var sound DownSound;
var vector OwnerLocation;
var float StillTime, StillStart;
var int CurLength;

replication
{
	// Things the server should send to the client.
	reliable if( bNetOwner && (Role==ROLE_Authority) )
		LaserDamage, LaserLength, bShowLen;
}

simulated function PostRender( canvas Canvas )
{
	local PlayerPawn P;
	local float Scale;

	Super.PostRender(Canvas);
	P = PlayerPawn(Owner);
	if (P != None)
	{
		Scale = Canvas.ClipX/640;
		Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale);
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
	}
	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) ) 
	{
		bOwnsCrossHair = true;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.DrawText("x"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale))$"  "$CurLength);
	}
	else
	{
		if (bShowLen) Canvas.DrawText(CurLength);
		bOwnsCrossHair = false;
	}
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;
	local Pawn P;

	bestAim = 0.95;
	P = Pawn(Owner);
	if ( P == None )
	{
		GotoState('');
		return;
	}
	if ( VSize(P.Location - OwnerLocation) < 6 )
		StillTime += FMin(2.0, Level.TimeSeconds - StillStart);

	else
		StillTime = 0;
	StillStart = Level.TimeSeconds;
	OwnerLocation = P.Location;
	FireDir = vector(P.ViewRotation);
	targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(P, 200, FireDir);
	}
	else 
	{
		SetTimer(0.4 + 1.6 * FRand(), false);
		if ( (P.bFire == 0) && (P.bAltFire == 0) )
			bPointing = false;
	}
}	

simulated function Destroyed()
{
	if ( LaserBeam != None )
		LaserBeam.Destroy();
	Class'LL'.default.bShowLen = bShowLen;
	Super.Destroyed();
}

simulated function AnimEnd()
{
	if ( (Level.NetMode == NM_Client) && (Mesh != PickupViewMesh) )
	{
		if ( AnimSequence == 'SpinDown' )
			AnimSequence = 'Idle';
		PlayIdleAnim();
	}
}

// set which hand is holding weapon
function setHand(float Hand)
{
	if ( Hand == 2 )
	{
		FireOffset.Y = 0;
		bHideWeapon = true;
		if ( LaserBeam != None )
			LaserBeam.bCenter = true;
		return;
	}
	else
		bHideWeapon = false;
	PlayerViewOffset = Default.PlayerViewOffset * 100;
	if ( Hand == 1 )
	{
		if ( LaserBeam != None )
		{
			LaserBeam.bCenter = false;
			LaserBeam.bRight = false;
		}
		FireOffset.Y = Default.FireOffset.Y;
		Mesh = mesh(DynamicLoadObject("LoathsomeLaser_RC2.LaserGunL", class'Mesh'));
	}
	else
	{
		if ( LaserBeam != None )
		{
			LaserBeam.bCenter = false;
			LaserBeam.bRight = true;
		}
		FireOffset.Y = -1 * Default.FireOffset.Y;
		Mesh = mesh'LaserGunR';
	}
}

// return delta to combat style
function float SuggestAttackStyle()
{
	local float EnemyDist;

	EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
	if ( EnemyDist < 1000 )
		return 0.4;
	else
		return 0;
}

function float RateSelf( out int bUseAltMode )
{
	local Pawn P;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	P = Pawn(Owner);
	if ( (P.Enemy == None) || (Owner.IsA('Bot') && Bot(Owner).bQuickFire) )
	{
		bUseAltMode = 0;
		return AIRating;
	}
	if ( P.Enemy.IsA('StationaryPawn') )
	{
		bUseAltMode = 0;
		return (AIRating + 0.4);
	}
	AIRating *= FMin(Pawn(Owner).DamageScaling, 1.5);
	return AIRating;
}

simulated function PlayFiring()
{
	AmbientSound = AltFireSound;
	if ( (AnimSequence == 'BoltLoop') || (AnimSequence == 'BoltStart') )		
		PlayAnim( 'boltloop');
	else
		PlayAnim( 'boltstart' );
}

function Fire( float Value )
{
	if ( AmmoType == None )
	{
		// ammocheck
		GiveAmmo(Pawn(Owner));
	}
	if (AmmoType.UseAmmo(1))
	{
		GotoState('Firing');
		bCanClientFire = true;
		bPointing=True;
		Pawn(Owner).PlayRecoil(FiringSpeed);
		ClientFire(value);
		if ( LaserBeam == None )
		{
			LaserBeam = FLBolt(ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget));
			if ( FireOffset.Y == 0 )
				LaserBeam.bCenter = true;
			else if ( Mesh == mesh'LaserGunR' )
				LaserBeam.bRight = false;
			LaserBeam.Damage = LaserDamage;
			LaserBeam.DamageRate = (100 - LaserDamage);
			LaserBeam.BeamLength = LaserLength;
		}
	}
}

simulated function bool ClientAltFire( float Value )
{
	GotoState('Zooming');
	return true;
}

function AltFire( float Value )
{
	if ( (PlayerPawn(Owner) != None) && (PlayerPawn(Owner).bFire != 1) )
		ClientAltFire(Value);
}

simulated function PlaySpinDown()
{
	if ( (Mesh != PickupViewMesh) && (Owner != None) )
	{
		PlayAnim('Spindown', 1.0, 0.0);
		Owner.PlayOwnedSound(DownSound, SLOT_None,1.0*Pawn(Owner).SoundDampening);
	}
}	

state ClientFiring
{
	simulated function Tick( float DeltaTime )
	{
		if ( (Pawn(Owner) != None) && (Pawn(Owner).bFire != 0) )
			AmbientSound = FireSound;
		else
			AmbientSound = None;
	}

	simulated function AnimEnd()
	{
		if ( (AmmoType != None) && (AmmoType.AmmoAmount <= 0) )
		{
			PlaySpinDown();
			GotoState('');
		}
		else if ( !bCanClientFire )
			GotoState('');
		else if ( Pawn(Owner) == None )
		{
			PlaySpinDown();
			GotoState('');
		}
		else if ( Pawn(Owner).bFire != 0 )
			LoopAnim('BoltLoop');
		else
		{
			PlaySpinDown();
			GotoState('');
		}
	}
}

state Firing
{
	ignores AnimEnd;

	function Tick(float DeltaTime)
	{
		local Pawn P;

		P = Pawn(Owner);
		if ( P == None )
		{
			GotoState('Pickup');
			return;
		}
		if ( (P.bFire == 0) || (P.IsA('Bot')
					&& ((P.Enemy == None) || (Level.TimeSeconds - Bot(P).LastSeenTime > 5))) )
		{
			P.bFire = 0;
			Finish();
			return;
		}

		Count += Deltatime;
		if ( Count > 0.24 )
		{
			if ( Owner.IsA('PlayerPawn') )
			{
				PlayerPawn(Owner).ClientInstantFlash( InstFlash,InstFog);
//				if ( (P.bFire == 1) && (P.bAltFire == 1) )
				if ((P.bFire == 1) && (P.bAltFire == 1) && (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV))
					bShowLen = !bShowLen;
			}
			if ( Affector != None )
				Affector.FireEffect();
			Count -= 0.24;
			if ( !AmmoType.UseAmmo(1) )
				Finish();
		}

	}
	
	function EndState()
	{
		AmbientGlow = 0;
		AmbientSound = None;
		if ( LaserBeam != None )
		{
			LaserBeam.Destroy();
			LaserBeam = None;
		}
		Super.EndState();
	}

Begin:
	AmbientGlow = 200;
	FinishAnim();	
	LoopAnim('boltloop');
}


state Idle
{
Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	if ( (Pawn(Owner).bAltFire!=0) && (Pawn(Owner).IsA('Bot')))
	{
		Pawn(Owner).bFire=1;
		Pawn(Owner).bAltFire=0;
		Fire(0.0);
	}
	Disable('AnimEnd');
	PlayIdleAnim();
}

///////////////////////////////////////////////////////
state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			if ( (PlayerPawn(Owner) != None) && PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).StopZoom();
			SetTimer(0.0,False);
			GoToState('Idle');
		}
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{

		if (Pawn(Owner).bFire != 1)
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).ToggleZoom();
			SetTimer(0.2,True);
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}

///////////////////////////////////////////////////////////
simulated function PlayIdleAnim()
{
	if ( Mesh == PickupViewMesh )
		return;

	if ( (AnimSequence == 'BoltLoop') || (AnimSequence == 'BoltStart') )
		PlayAnim('BoltEnd');		
	else if ( AnimSequence != 'SpinDown' )
		TweenAnim('Idle', 0.1);
}

simulated function TweenDown()
{
	if ( IsAnimating() && (AnimSequence != '') && (GetAnimGroup(AnimSequence) == 'Select') )
		TweenAnim( AnimSequence, AnimFrame * 0.4 );
	else
		TweenAnim('Down', 0.26);
}


defaultproperties
{
     LaserDamage=72.0
     LaserLength=20
     bShowLen=0
     InstFlash=-0.15
     InstFog=(X=139.00000,Y=218.00000,Z=72.00000)
     DownSound=Sound'LoathsomeLaser_RC2.LaserGun.LaserDown'
     AmmoName=Class'LoathsomeLaser_RC2.LAmmo'
     PickupAmmoCount=80
     bRapidFire=False
     FireOffset=(X=15.000000,Y=-15.000000,Z=2.000000)
     ProjectileClass=Class'LoathsomeLaser_RC2.lstarterbolt'
     AltProjectileClass=None
     shakemag=135.000000
     shakevert=8.000000
     AIRating=0.700000
     RefireRate=0.990000
     AltRefireRate=0.0
     FireSound=Sound'LoathsomeLaser_RC2.LaserGun.LaserBolt'
     AltFireSound=None
     MessageNoAmmo=" has no power."
     DeathMessage="%o ate %k's burning laser death."
     FlashLength=0.020000
     AutoSwitchPriority=5
     InventoryGroup=5
     PickupMessage="You got a Loathsome Laser"
     ItemName="Loathsome Laser"
     PlayerViewOffset=(X=1.500000,Z=-2.000000)
     PlayerViewMesh=LodMesh'LoathsomeLaser_RC2.LaserGunR'
     PickupViewMesh=LodMesh'LoathsomeLaser_RC2.LaserPickup'
     ThirdPersonMesh=LodMesh'LoathsomeLaser_RC2.LaserGun3rd'
     ThirdPersonScale=0.400000
     StatusIcon=Texture'LoathsomeLaser_RC2.Icons.UsePulse'
     bMuzzleFlashParticles=True
     MuzzleFlashStyle=STY_Translucent
     MuzzleFlashMesh=LodMesh'LoathsomeLaser_RC2.muzzPF3'
     MuzzleFlashScale=0.40000
     MuzzleFlashTexture=Texture'LoathsomeLaser_RC2.Skins.MuzzyPulse'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     SelectSound=Sound'LoathsomeLaser_RC2.LaserGun.LaserPickup'
     Icon=Texture'LoathsomeLaser_RC2.Icons.UsePulse'
     Mesh=LodMesh'LoathsomeLaser_RC2.LaserPickup'
     bNoSmooth=False
     SoundRadius=64
     SoundVolume=255
     CollisionRadius=32.0
     WeaponDescription="Classification: Loathsome Laser\\n\\nPrimary Fire: Laser Beam of Death.\\n\\nSecondary Fire: Scope.\\n\\nTechniques: Shoot stuff with it."
     NameColor=(R=128,G=255,B=128)
}
