//=============================================================================
// flbolt.
//=============================================================================
class FLBolt extends Projectile;

#exec MESH IMPORT MESH=lbolt ANIVFILE=MODELS\pbolt_a.3d DATAFILE=MODELS\pbolt_d.3d
#exec MESH ORIGIN MESH=lbolt X=0 Y=-400 Z=0 YAW=192

#exec MESHMAP NEW   MESHMAP=lbolt MESH=lbolt
#exec MESHMAP SCALE MESHMAP=lbolt X=0.10125 Y=0.10125 Z=0.2025

#exec TEXTURE IMPORT NAME=lbolt0 FILE=Textures\L1.pcx GROUP=Skins LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=lbolt NUM=0 TEXTURE=lbolt0

var() int BeamLength, DamageRate;
var FLBolt PlasmaBeam;
var LBCap WallEffect;
var int Position, DRCnt;
var vector FireOffset;
var float BeamSize;
var bool bRight, bCenter;
var float AccumulatedDamage, LastHitTime;
var Actor DamagedActor;

var int BSCnt;

replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority )
		bRight, bCenter;
}

simulated function Destroyed()
{
//log(self@BSCnt);
	if ((Instigator != None) && (Instigator.Weapon != None))
		LL(Instigator.Weapon).CurLength = 0;
	Super.Destroyed();
	if ( PlasmaBeam != None )
		PlasmaBeam.Destroy();
	if ( WallEffect != None )
		WallEffect.Destroy();
}

simulated function CheckBeam(vector X, float DeltaTime)
{
	local actor HitActor;
	local vector HitLocation, HitNormal;

	LL(Instigator.Weapon).CurLength = VSize((Location + BeamSize * X) - Instigator.Location);

	// check to see if hits something, else spawn or orient child

	HitActor = Trace(HitLocation, HitNormal, Location + BeamSize * X, Location, true);
	if ( (HitActor != None)	&& (HitActor != Instigator)
		&& (HitActor.bProjTarget || (HitActor == Level) || (HitActor.bBlockActors && HitActor.bBlockPlayers)) 
		&& ((Pawn(HitActor) == None) || Pawn(HitActor).AdjustHitLocation(HitLocation, Velocity)) )
	{
		if (( Level.Netmode != NM_Client ) && (DRCnt <= 0))
		{
			if ( DamagedActor == None )
			{
				AccumulatedDamage = FMin(0.5 * (Level.TimeSeconds - LastHitTime), 0.1);
				HitActor.TakeDamage(damage * AccumulatedDamage, instigator,HitLocation,
					(MomentumTransfer * X * AccumulatedDamage), MyDamageType);
				AccumulatedDamage = 0;
			}				
			else if ( DamagedActor != HitActor )
			{
				DamagedActor.TakeDamage(damage * AccumulatedDamage, instigator,HitLocation,
					(MomentumTransfer * X * AccumulatedDamage), MyDamageType);
				AccumulatedDamage = 0;
			}				
			LastHitTime = Level.TimeSeconds;
			DamagedActor = HitActor;
			AccumulatedDamage += DeltaTime;
			if ( AccumulatedDamage > 0.22 )
			{
				if ( DamagedActor.IsA('Carcass') && (FRand() < 0.09) )
					AccumulatedDamage = 35/damage;
				DamagedActor.TakeDamage(damage * AccumulatedDamage, instigator,HitLocation,
					(MomentumTransfer * X * AccumulatedDamage), MyDamageType);
				AccumulatedDamage = 0;
			}
			DRCnt = DamageRate;
		}

		if ( (WallEffect == None) || WallEffect.bDeleteMe )
			WallEffect = Spawn(class'LBHit',,, HitLocation - 5 * X);
		else if ( !WallEffect.IsA('LBHit') )
		{
			WallEffect.Destroy();	
			WallEffect = Spawn(class'LBHit',,, HitLocation - 5 * X);
		}
		else
			WallEffect.SetLocation(HitLocation - 5 * X);

		if ( (WallEffect != None) && (Level.NetMode != NM_DedicatedServer) )
		{
			if ( (Level.Netmode != NM_Client) || (BSCnt <= 32) )
			{
				Spawn(class'LaserScorch',,,HitLocation,rotator(HitNormal));
				BSCnt++;
			}
			if (FRand() < 0.50) Spawn(class'Spark35',,,HitLocation,rotator(HitNormal));
			if (FRand() < 0.50) Spawn(class'SpriteSmokePuff',,,HitLocation+HitNormal*9);	
		}
		if ( PlasmaBeam != None )
		{
			AccumulatedDamage += PlasmaBeam.AccumulatedDamage;
			PlasmaBeam.Destroy();
			PlasmaBeam = None;
		}
		DRCnt--;
		return;
	}
	else if ( (Level.Netmode != NM_Client) && (DamagedActor != None)  && (DRCnt <= 0) )
	{
		DamagedActor.TakeDamage(damage * AccumulatedDamage, instigator, DamagedActor.Location - X * 1.2 * DamagedActor.CollisionRadius,
			(MomentumTransfer * X * AccumulatedDamage), MyDamageType);
		AccumulatedDamage = 0;
		DamagedActor = None;
		DRCnt = DamageRate;
		return;
	}			

	if ( Position >= BeamLength )
	{
		if ( (WallEffect == None) || WallEffect.bDeleteMe )
			WallEffect = Spawn(class'LBCap',,, Location + (BeamSize - 4) * X);
		else if ( WallEffect.IsA('LBHit') )
		{
			WallEffect.Destroy();	
			WallEffect = Spawn(class'LBCap',,, Location + (BeamSize - 4) * X);
		}
		else
			WallEffect.SetLocation(Location + (BeamSize - 4) * X);
	}
	else
	{
		if ( WallEffect != None )
		{
			WallEffect.Destroy();
			WallEffect = None;
		}
		if ( PlasmaBeam == None )
		{
			PlasmaBeam = Spawn(class'FLBolt',,, Location + BeamSize * X); 
			PlasmaBeam.BeamLength = BeamLength;
			PlasmaBeam.Damage = Damage;
			PlasmaBeam.DamageRate = DamageRate;
			PlasmaBeam.Position = Position + 1;
			PlasmaBeam.BSCnt = BSCnt;
		}
		else
			PlasmaBeam.UpdateBeam(self, X, DeltaTime);
	}
	if (DRCnt > 0) DRCnt--;
}

simulated function UpdateBeam(FLBolt ParentBolt, vector Dir, float DeltaTime)
{
	SetLocation(ParentBolt.Location + BeamSize * Dir);
	SetRotation(ParentBolt.Rotation);
	CheckBeam(Dir, DeltaTime);
}

defaultproperties
{
     BeamLength=10.000000
     DamageRate=50
     BeamSize=81.000000
     MaxSpeed=0.000000
     Damage=50.000000
     MomentumTransfer=6500
     FireOffset=(X=16.000000,Y=-14.000000,Z=-8.000000)
     bRight=True
     MyDamageType=zapped
     bNetTemporary=False
     Physics=PHYS_None
     RemoteRole=ROLE_None
     LifeSpan=60.000000
     Style=STY_Translucent
     Texture=Texture'LoathsomeLaser_RC2.lbolt0'
     Skin=Texture'LoathsomeLaser_RC2.lbolt0'
     Mesh=LodMesh'LoathsomeLaser_RC2.lbolt'
     bUnlit=True
     AmbientSound=Sound'UnrealI.Pickups.ffieldl2'
     SoundRadius=16
     SoundVolume=255
     bCollideActors=False
     bCollideWorld=False
}
