//=============================================================================
// LoathsomeLaserArena.
// replaces all weapons and ammo with Loathsome Lasers and Laser Batteries.
//=============================================================================

class LLA expands Arena config(LaserArena_RC2);

var() config int LaDamage;
var() config int LaLength;
var() config bool bLaShowLen;

function bool AlwaysKeep(Actor Other)
{
	local bool bTemp;

	if ( Other.IsA(WeaponName) )
	{
		Weapon(Other).PickupAmmoCount = Weapon(Other).AmmoName.Default.MaxAmmo;
		LL(Other).LaserDamage = LaDamage;
		LL(Other).LaserLength = LaLength;
		LL(Other).bShowLen = bLaShowLen;
		return true;
	}
	if ( Other.IsA(AmmoName) )
	{
		Ammo(Other).AmmoAmount = Ammo(Other).MaxAmmo;
		return true;
	}

	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

defaultproperties
{
     LaDamage=72.0
     LaLength=12
     bLaShowLen=0
     WeaponName=LL
     AmmoName=LAmmo
     WeaponString="LoathsomeLaser_RC2.LL"
     AmmoString="LoathsomeLaser_RC2.LAmmo"
     DefaultWeapon=Class'LoathsomeLaser_RC2.LL'
}
