class sg552 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=SG552Mesh MODELFILE=Models\SG552\SG552Mesh.psk
#exec MESH ORIGIN MESH=SG552Mesh X=-1 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=sg552Pick ANIVFILE=MODELS\sg552\sg552Pick_a.3d DATAFILE=MODELS\sg552\sg552Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=sg552Pick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=sg5523rd ANIVFILE=MODELS\sg552\sg5523rd_a.3d DATAFILE=MODELS\sg552\sg5523rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=sg5523rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=SG552Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=sg552Pick MESH=sg552Pick
#exec MESHMAP SCALE MESHMAP=sg552Pick X=0.09 Y=0.09 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=sg5523rd MESH=sg5523rd
#exec MESHMAP SCALE MESHMAP=sg5523rd X=0.09 Y=0.09 Z=0.13

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=SG552MeshAnims ANIMFILE=Models\SG552\SG552MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=SG552MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=197
#exec ANIM SEQUENCE ANIM=SG552MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=38
#exec ANIM SEQUENCE ANIM=SG552MeshAnims SEQ=Still STARTFRAME=39 NUMFRAMES=8
#exec ANIM SEQUENCE ANIM=SG552MeshAnims SEQ=Reload STARTFRAME=48 NUMFRAMES=118
#exec ANIM SEQUENCE ANIM=SG552MeshAnims SEQ=Fire STARTFRAME=167 NUMFRAMES=30
#exec ANIM SEQUENCE ANIM=SG552MeshAnims SEQ=AfterFire STARTFRAME=180 NUMFRAMES=17

#exec ANIM DIGEST ANIM=SG552MeshAnims
#exec MESH DEFAULTANIM MESH=SG552Mesh ANIM=SG552MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=sg552Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=sg552Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=sg5523rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=sg5523rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=SG552MeshSkin00 FILE=Textures\sg552\forearm.bmp GROUP=sg552 LODSET=2
#exec TEXTURE IMPORT NAME=SG552MeshSkin01 FILE=Textures\sg552\magazine_transp.bmp GROUP=sg552 LODSET=2
#exec TEXTURE IMPORT NAME=SG552MeshSkin02 FILE=Textures\sg552\acog.bmp GROUP=sg552 LODSET=2
#exec TEXTURE IMPORT NAME=SG552MeshSkin03 FILE=Textures\sg552\view_glove.bmp GROUP=sg552 LODSET=2
#exec TEXTURE IMPORT NAME=SG552MeshSkin04 FILE=Textures\sg552\sg552_FingerButtstock.bmp GROUP=sg552 LODSET=2
#exec TEXTURE IMPORT NAME=SG552MeshSkin05 FILE=Textures\sg552\sg552_SkinHandle.bmp GROUP=sg552 LODSET=2
#exec TEXTURE IMPORT NAME=SGW FILE=Textures\sg552\sg552_skin.bmp GROUP=sg552 LODSET=2

#exec TEXTURE IMPORT NAME=SGIcon FILE=Icons\Rifles\sg552Icon.bmp GROUP=sg552 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=SG552Mesh NUM=0 TEXTURE=SG552MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=SG552Mesh NUM=1 TEXTURE=SG552MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=SG552Mesh NUM=2 TEXTURE=SG552MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=SG552Mesh NUM=3 TEXTURE=SG552MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=SG552Mesh NUM=4 TEXTURE=SG552MeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=SG552Mesh NUM=5 TEXTURE=SG552MeshSkin05

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=sg552Pick NUM=1 TEXTURE=SGW

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=sg5523rd NUM=1 TEXTURE=SGW

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="SGFire" FILE=Sounds\sg552\sg552_fire.wav GROUP="sg552"
#exec AUDIO IMPORT NAME="SGBoltPull" FILE=Sounds\sg552\sg552_boltpull.wav GROUP="sg552"
#exec AUDIO IMPORT NAME="SGClipOut" FILE=Sounds\sg552\sg552_clipout.wav GROUP="sg552"
#exec AUDIO IMPORT NAME="SGClipIn" FILE=Sounds\sg552\sg552_clipin.wav GROUP="sg552"

//=========================================================================================

#exec MESH IMPORT MESH=SG552Muzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=SG552Muzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=SG552Muzz X=30 Y=1000 Z=-220 YAW=64
#exec MESH SEQUENCE MESH=SG552Muzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=SG552Muzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=SG552Muzz MESH=SG552Muzz
#exec MESHMAP SCALE MESHMAP=SG552Muzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var Sound ReloadSounds[5];
var Texture RandFlash[6];
var float NFlashO, NFlashY;
var float FireRate;
var byte PZoomLevel;

replication
{
	Reliable if(bNetOwner && Role==ROLE_Authority)
		FireRate, PZoomLevel;
}

function DropFrom(vector StartLocation)
{
	Super.DropFrom(StartLocation);
	FlashO = default.FlashO;
	FlashY = default.FlashY;
	PZoomLevel = 0;
	FireRate = Default.FireRate;
}

simulated function TweenDown()
{
	PZoomLevel = 0;
	FireRate = Default.FireRate;
}

simulated event RenderOverlays(canvas Canvas)
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	MFTexture = RandFlash[Rand(5)];

	if (Owner.IsA('PlayerPawn'))
	{
		if(bHideWeapon || (Owner==None))
			return;
		PlayerOwner = PlayerPawn(Owner);
		if(PlayerOwner!=None)
		{
			bPlayerOwner = true;
			Hand = PlayerOwner.Handedness;
		}

		if((Level.NetMode == NM_Client) && (Hand == 2))
		{
			bHideWeapon = true;
			return;
		}
	
		if(!bPlayerOwner || (PlayerOwner.Player == None))
			Pawn(Owner).WalkBob = vect(0,0,0);
	
		if(bMuzzleFlash>0 && bDrawMuzzleFlash /*&& Level.bHighDetailMode*/ && (MFTexture != None))
		{
			MuzzleScale = Default.MuzzleScale*(Canvas.ClipX/640.0);
			if(!bSetFlashTime)
			{
				bSetFlashTime = true;
				FlashTime = Level.TimeSeconds+FlashLength;
			}
			else if(FlashTime<Level.TimeSeconds)
				bMuzzleFlash = 0;
		
			if(bMuzzleFlash > 0)
			{
				if ( Hand == 0 )
                	Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
          	  	else
                	Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);
				Canvas.Style = 3;
				Canvas.DrawIcon(MFTexture, MuzzleScale);
				Canvas.Style = 1;
			}
		}
		else
			bSetFlashTime = false;

		SetLocation(Owner.Location + CalcDrawOffset2());
		NewRot = Pawn(Owner).ViewRotation;
		if(Hand==0)
			newRot.Roll = -2*Default.Rotation.Roll;
		else
			newRot.Roll = Default.Rotation.Roll*Hand;
		setRotation(newRot);
		Canvas.DrawActor(self, false);
	}
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	Sleep(0.3);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		PZoomLevel = 0;
		FireRate = Default.FireRate;
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
	 		bDrawMuzzleFlash = True; 
		}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire, AltFire;

	Begin:
		Sleep(0.3);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');
	FlashO = default.FlashO;
	FlashY = default.FlashY;
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = 50.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.NFlashO;
					FlashY = default.NFlashY;
				}
				else
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.FlashO;
					FlashY = default.FlashY;
				}
			}
		}
	}
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', FireRate, 0.04);
	
	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();
	
	ClipCount--;

	if (PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		if(PZoomLevel == 0)
			TraceFire(3.0);
		else if(PZoomLevel == 1)
			TraceFire(1.0);
		bPointing=True;
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);
		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner).bFire == 0)
		{
			PlayAfterFire();
			GoToState('Idle');
		}
		else if(Pawn(Owner).bFire != 0)
		{
			Global.Fire(0.0);
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner).bFire == 0)
		{
			PlayAfterFire();
			GoToState('Idle');
		}
		else if(Pawn(Owner).bFire != 0)
		{
			Global.Fire(0.0);
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function AltFire(float Value)
{
	if(PZoomLevel == 0)
	{
		PZoomLevel = 1;			//Zoomed
		FireRate = 8.0;
	}
	else if(PZoomLevel == 1)
	{
		PZoomLevel = 0;			//UnZoomed
		FireRate = Default.FireRate;
	}
	ClientAltFire(Value);
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function Reload()
{
	PZoomLevel = 0;
	FireRate = Default.FireRate;
    if((AmmoType.AmmoAmount > 0) && (ClipCount < Default.ClipCount)) 
    {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.FlashO;
					FlashY = default.FlashY;
					MuzzleScale = default.MuzzleScale;
				}
			}
		}
    }
}

simulated function ClientReload()
{
	PZoomLevel = 0;
	FireRate = Default.FireRate;
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
          GoToState('ClientReloading');
          PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.FlashO;
					FlashY = default.FlashY;
					MuzzleScale = default.MuzzleScale;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		PZoomLevel = 0;
		FireRate = Default.FireRate;
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	PZoomLevel = 0;
		FireRate = Default.FireRate;
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 266.00;
		else
			Penetration = 250.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.80;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	FireRate=12.00
	RandFlash(0)=Texture'CS_v16_2.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16_2.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16_2.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16_2.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16_2.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16_2.AK47.CSRifleMuzz6'
    ReloadSounds(0)=Sound'CS_v16_2.sg552.SGClipOut'
    ReloadSounds(1)=Sound'CS_v16_2.sg552.SGClipIn'
    ReloadSounds(2)=Sound'CS_v16_2.sg552.SGBoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.sg552.SGFire'
    EjectOffset=(X=15.000000,Y=10.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=30
    PickupAmmoCount=90
    VRecoil=850.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16_2.AmmoRifles'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.730000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=500.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    NFlashY=0.210000
    NFlashO=0.020000
    FlashY=0.100000
    FlashO=0.010000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Skins.Flakmuz'
    AutoSwitchPriority=6
    InventoryGroup=6
    PickupMessage="You got a SG-552 Krieg Commando."
    ItemName="SG-552"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'SG552Mesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'sg552Pick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'sg5523rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.SG552Muzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'sg552Pick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16_2.sg552.sgIcon'
    StatusIcon=Texture'CS_v16_2.sg552.sgIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}