class sg550 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=SG550Mesh MODELFILE=Models\SG550\SG550Mesh.psk
#exec MESH ORIGIN MESH=SG550Mesh X=-1 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=sg550Pick ANIVFILE=MODELS\sg550\sg550Pick_a.3d DATAFILE=MODELS\sg550\sg550Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=sg550Pick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=sg5503rd ANIVFILE=MODELS\sg550\sg5503rd_a.3d DATAFILE=MODELS\sg550\sg5503rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=sg5503rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=SG550Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=sg550Pick MESH=sg550Pick
#exec MESHMAP SCALE MESHMAP=sg550Pick X=0.09 Y=0.09 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=sg5503rd MESH=sg5503rd
#exec MESHMAP SCALE MESHMAP=sg5503rd X=0.09 Y=0.09 Z=0.13

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=SG550MeshAnims ANIMFILE=Models\SG550\SG550MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=187
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=Still STARTFRAME=32 NUMFRAMES=2
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=Reload STARTFRAME=35 NUMFRAMES=106
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=Fire STARTFRAME=142 NUMFRAMES=45
#exec ANIM SEQUENCE ANIM=SG550MeshAnims SEQ=AfterFire STARTFRAME=177 NUMFRAMES=10

#exec ANIM DIGEST ANIM=SG550MeshAnims
#exec MESH DEFAULTANIM MESH=SG550Mesh ANIM=SG550MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=sg550Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=sg550Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=sg5503rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=sg5503rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=SG550MeshSkin00 FILE=Textures\sg550\magazine_transp.bmp GROUP=sg550 LODSET=2
#exec TEXTURE IMPORT NAME=SG550MeshSkin01 FILE=Textures\sg550\receiver.bmp GROUP=sg550 LODSET=2
#exec TEXTURE IMPORT NAME=SG550MeshSkin02 FILE=Textures\sg550\scope.bmp GROUP=sg550 LODSET=2
#exec TEXTURE IMPORT NAME=SG550MeshSkin03 FILE=Textures\sg550\view_skin.bmp GROUP=sg550 LODSET=2
#exec TEXTURE IMPORT NAME=SG550MeshSkin04 FILE=Textures\sg550\sg550_ButtHandleFinger.bmp GROUP=sg550 LODSET=2
#exec TEXTURE IMPORT NAME=SG550MeshSkin05 FILE=Textures\sg550\sg550_ForeGlove.bmp GROUP=sg550 LODSET=2

#exec TEXTURE IMPORT NAME=SG5W FILE=Textures\sg550\sg550_profile.bmp GROUP=sg550 LODSET=2

#exec TEXTURE IMPORT NAME=SG5Icon FILE=Icons\Rifles\Sg550Icon.bmp GROUP=sg550 MIPS=OFF

#exec TEXTURE IMPORT NAME=SG5SniperScope FILE=Textures\sg550\ScopeCrosshair.bmp GROUP=sg550 FLAGS=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SG5SniperBack FILE=Textures\sg550\SniperScoper.bmp GROUP=sg550 FLAGS=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SG5Snipe FILE=Textures\sg550\SniperScope2.bmp GROUP=sg550 FLAGS=2 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=0 TEXTURE=SG550MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=1 TEXTURE=SG550MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=2 TEXTURE=SG550MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=3 TEXTURE=SG550MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=4 TEXTURE=SG550MeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=SG550Mesh NUM=5 TEXTURE=SG550MeshSkin05

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=sg550Pick NUM=1 TEXTURE=SG5W

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=sg5503rd NUM=1 TEXTURE=SG5W

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="SG5Fire" FILE=Sounds\sg550\sg550_fire.wav GROUP="sg550"
#exec AUDIO IMPORT NAME="SG5BoltPull" FILE=Sounds\sg550\sg550_boltpull.wav GROUP="sg550"
#exec AUDIO IMPORT NAME="SG5ClipOut" FILE=Sounds\sg550\sg550_clipout.wav GROUP="sg550"
#exec AUDIO IMPORT NAME="SG5ClipIn" FILE=Sounds\sg550\sg550_clipin.wav GROUP="sg550"

//=========================================================================================

#exec MESH IMPORT MESH=SG550Muzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=SG550Muzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=SG550Muzz X=20 Y=1300 Z=-150 YAW=64
#exec MESH SEQUENCE MESH=SG550Muzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=SG550Muzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=SG550Muzz MESH=SG550Muzz
#exec MESHMAP SCALE MESHMAP=SG550Muzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var Sound ReloadSounds[5];
var Texture RandFlash[6];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(5)];
	Super.RenderOverlays(Canvas);
}

simulated function PostRender( canvas Canvas )
{
    local PlayerPawn P;
    local float Scale;

    Super.PostRender(Canvas);
    P = PlayerPawn(Owner);
    if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
    {
    	bOwnsCrossHair = true;
    	Scale = Canvas.ClipX/256;
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.Style = ERenderStyle.STY_Modulated;
        Canvas.DrawIcon(Texture'SG5SniperBack', Scale);
        Scale = Canvas.ClipX/640;
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.DrawIcon(Texture'SG5SniperScope', Scale);
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.Style = ERenderStyle.STY_Translucent;
        Canvas.DrawIcon(Texture'SG5Snipe', Scale);
        Scale = P.DefaultFOV/P.DesiredFOV;
    }
    else if(Class'CSMut16'.default.bEnableCrosshair)
        bOwnsCrossHair = false;
    else
    	bOwnsCrossHair = true;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');	
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				Owner.PlaySound(Sound'ZoomScope1');
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = 45.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
				else if (PlayerPawn(Owner).DesiredFOV == 45.0)
				{
					PlayerPawn(Owner).DesiredFOV = 15.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
				else if (PlayerPawn(Owner).DesiredFOV == 15.0)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
	}
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim('Fire', 6, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
			bMuzzleFlash++;
		else if (PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
			bMuzzleFlash = 0;
	}
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(0.8);
		bPointing=True;
		PlayFire();
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function AltFire( float Value )
{
	ClientAltFire(Value);
}

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
          GotoState('NewClip');
          PlayReloading();
          ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					bDrawMuzzleFlash = True;
					bMuzzleFlash++;
				}
			}
		}
    }
}

simulated function ClientReload()
{
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
    	GoToState('ClientReloading');
        PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 336.00;
		else
			Penetration = 320.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.80;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16_2.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16_2.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16_2.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16_2.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16_2.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16_2.AK47.CSRifleMuzz6'
    ReloadSounds(0)=Sound'CS_v16_2.sg550.SG5ClipOut'
    ReloadSounds(1)=Sound'CS_v16_2.sg550.SG5ClipIn'
    ReloadSounds(2)=Sound'CS_v16_2.sg550.SG5BoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.sg550.SG5Fire'
    EjectOffset=(X=20.000000,Y=10.000000,Z=-10.000000)
    HitDamage=38
    ClipCount=30
    PickupAmmoCount=90
    VRecoil=850.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16_2.AmmoRifles'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-8.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.900000
    RefireRate=0.900000
    AltRefireRate=0.900000
    AimError=430.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.080000
    FlashO=0.010000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Skins.Flakmuz'
    AutoSwitchPriority=7
    InventoryGroup=7
    PickupMessage="You got a SG-550 Krieg Commando."
    ItemName="SG-550"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'SG550Mesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'sg550Pick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'sg5503rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.SG550Muzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'sg550Pick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16_2.sg550.sg5Icon'
    StatusIcon=Texture'CS_v16_2.sg550.sg5Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}