class g3sg1 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=G3SG1Mesh MODELFILE=Models\G3SG1\G3SG1Mesh.psk
#exec MESH ORIGIN MESH=G3SG1Mesh X=0 Y=-1 Z=2 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=g3sg1Pick ANIVFILE=MODELS\g3sg1\g3sg1Pick_a.3d DATAFILE=MODELS\g3sg1\g3sg1Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=g3sg1Pick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=g3sg13rd ANIVFILE=MODELS\g3sg1\g3sg13rd_a.3d DATAFILE=MODELS\g3sg1\g3sg13rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=g3sg13rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=G3SG1Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=g3sg1Pick MESH=g3sg1Pick
#exec MESHMAP SCALE MESHMAP=g3sg1Pick X=0.09 Y=0.09 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=g3sg13rd MESH=g3sg13rd
#exec MESHMAP SCALE MESHMAP=g3sg13rd X=0.09 Y=0.09 Z=0.13

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=G3SG1MeshAnims ANIMFILE=Models\G3SG1\G3SG1MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=G3SG1MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=199
#exec ANIM SEQUENCE ANIM=G3SG1MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=G3SG1MeshAnims SEQ=Still STARTFRAME=32 NUMFRAMES=42
#exec ANIM SEQUENCE ANIM=G3SG1MeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=140
#exec ANIM SEQUENCE ANIM=G3SG1MeshAnims SEQ=Fire STARTFRAME=185 NUMFRAMES=14
#exec ANIM SEQUENCE ANIM=G3SG1MeshAnims SEQ=AfterFire STARTFRAME=192 NUMFRAMES=7

#exec ANIM DIGEST ANIM=G3SG1MeshAnims
#exec MESH DEFAULTANIM MESH=G3SG1Mesh ANIM=G3SG1MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=g3sg1Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=g3sg1Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=g3sg13rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=g3sg13rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=G3SG1MeshSkin00 FILE=Textures\g3sg1\body.bmp GROUP=g3sg1 LODSET=2
#exec TEXTURE IMPORT NAME=G3SG1MeshSkin01 FILE=Textures\g3sg1\barrel.bmp GROUP=g3sg1 LODSET=2
#exec TEXTURE IMPORT NAME=G3SG1MeshSkin02 FILE=Textures\g3sg1\g3sg1_forearm_skin.bmp GROUP=g3sg1 LODSET=2
#exec TEXTURE IMPORT NAME=G3SG1MeshSkin03 FILE=Textures\g3sg1\g3sg1_knob_finger.bmp GROUP=g3sg1 LODSET=2
#exec TEXTURE IMPORT NAME=G3SG1MeshSkin04 FILE=Textures\g3sg1\g3sg1_scope_butt_glove_LB.bmp GROUP=g3sg1 LODSET=2
#exec TEXTURE IMPORT NAME=G3W FILE=Textures\g3sg1\w_g3sg1.bmp GROUP=g3sg1 LODSET=2

#exec TEXTURE IMPORT NAME=G3Icon FILE=Icons\Rifles\g3sg1Icon.bmp GROUP=g3sg1 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=G3SG1Mesh NUM=0 TEXTURE=G3SG1MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=G3SG1Mesh NUM=1 TEXTURE=G3SG1MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=G3SG1Mesh NUM=2 TEXTURE=G3SG1MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=G3SG1Mesh NUM=3 TEXTURE=G3SG1MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=G3SG1Mesh NUM=4 TEXTURE=G3SG1MeshSkin04

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=g3sg1Pick NUM=1 TEXTURE=G3W

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=g3sg13rd NUM=1 TEXTURE=G3W

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="G3Fire" FILE=Sounds\g3sg1\g3sg1_fire.wav GROUP="g3sg1"
#exec AUDIO IMPORT NAME="G3Slide" FILE=Sounds\g3sg1\g3sg1_slide.wav GROUP="g3sg1"
#exec AUDIO IMPORT NAME="G3ClipOut" FILE=Sounds\g3sg1\g3sg1_clipout.wav GROUP="g3sg1"
#exec AUDIO IMPORT NAME="G3ClipIn" FILE=Sounds\g3sg1\g3sg1_clipin.wav GROUP="g3sg1"

//=========================================================================================

#exec MESH IMPORT MESH=G3SG1Muzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=G3SG1Muzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=G3SG1Muzz X=30 Y=1250 Z=-200 YAW=64
#exec MESH SEQUENCE MESH=G3SG1Muzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=G3SG1Muzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=G3SG1Muzz MESH=G3SG1Muzz
#exec MESHMAP SCALE MESHMAP=G3SG1Muzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var Sound ReloadSounds[5];
var Texture RandFlash[6];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(5)];
	Super.RenderOverlays(Canvas);
}

simulated function PostRender( canvas Canvas )
{
    local PlayerPawn P;
    local float Scale;

    Super.PostRender(Canvas);
    P = PlayerPawn(Owner);
    if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
    {
    	bOwnsCrossHair = true;
    	Scale = Canvas.ClipX/256;
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.Style = ERenderStyle.STY_Modulated;
        Canvas.DrawIcon(Texture'SG5SniperBack', Scale);
        Scale = Canvas.ClipX/640;
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.DrawIcon(Texture'SG5SniperScope', Scale);
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.Style = ERenderStyle.STY_Translucent;
        Canvas.DrawIcon(Texture'SG5Snipe', Scale);
        Scale = P.DefaultFOV/P.DesiredFOV;
    }
    else if(Class'CSMut16'.default.bEnableCrosshair)
        bOwnsCrossHair = false;
    else
    	bOwnsCrossHair = true;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	Sleep(0.5);
	//PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		//Play1stSelectionSound();
		Sleep(0.4);
		//PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');	
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				Owner.PlaySound(Sound'ZoomScope1');
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = 45.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
				else if (PlayerPawn(Owner).DesiredFOV == 45.0)
				{
					PlayerPawn(Owner).DesiredFOV = 15.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
				else if (PlayerPawn(Owner).DesiredFOV == 15.0)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
	}
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayAnim('Fire', 2, 0.04);
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if(PlayerPawn(Owner) != None)
	{
		if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
			bMuzzleFlash++;
		else if (PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
			bMuzzleFlash = 0;
	}
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(0.8);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function AltFire( float Value )
{
	ClientAltFire(Value);
}

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
          GotoState('NewClip');
          PlayReloading();
          ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					bDrawMuzzleFlash = True;
					bMuzzleFlash++;
				}
			}
		}
    }
}

simulated function ClientReload()
{
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
    	GoToState('ClientReloading');
        PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.1, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
	Begin:
		if(isAnimating())
			FinishAnim();
		PlayIdleAnim();
		if(AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();
	Checks:
		if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
			Reload();
		Sleep(0.0);
		GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 336.00;
		else
			Penetration = 320.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16_2.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16_2.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16_2.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16_2.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16_2.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16_2.AK47.CSRifleMuzz6'
    ReloadSounds(0)=Sound'CS_v16_2.g3sg1.G3ClipOut'
    ReloadSounds(1)=Sound'CS_v16_2.g3sg1.G3ClipIn'
    ReloadSounds(2)=Sound'CS_v16_2.g3sg1.G3Slide'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.g3sg1.G3Fire'
    EjectOffset=(X=20.000000,Y=10.000000,Z=-10.000000)
    HitDamage=38
    ClipCount=20
    PickupAmmoCount=60
    VRecoil=850.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16_2.AmmoRifles'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-8.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.920000
    RefireRate=0.900000
    AltRefireRate=0.900000
    AimError=430.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.124000
    FlashO=0.013000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Skins.Flakmuz'
    AutoSwitchPriority=8
    InventoryGroup=7
    PickupMessage="You got a G3-SG1."
    ItemName="G3-SG1"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'G3SG1Mesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'g3sg1Pick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'g3sg13rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.G3SG1Muzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'g3sg1Pick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16_2.g3sg1.G3Icon'
    StatusIcon=Texture'CS_v16_2.g3sg1.G3Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}