class ShellsShotgun extends Projectile;

#exec MESH IMPORT MESH=SGShell ANIVFILE=MODELS\EjectingShells\Shotguns\SGShell_a.3d DATAFILE=MODELS\EjectingShells\Shotguns\SGShell_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SGShell X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=SGShell SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=SGShell SEQ=Still STARTFRAME=0 NUMFRAMES=30
//#exec MESH SEQUENCE MESH=SGShell SEQ=??? STARTFRAME=0 NUMFRAMES=30

#exec MESHMAP NEW MESHMAP=SGShell MESH=SGShell
#exec MESHMAP SCALE MESHMAP=SGShell X=0.1 Y=0.1 Z=0.2

#exec TEXTURE IMPORT NAME=SGG1Shell FILE=Textures\EjectingShells\Shotguns\sgg1shell.bmp GROUP=EjectingShells FLAGS=2 LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=SGShell NUM=1 TEXTURE=SGG1Shell


#exec AUDIO IMPORT NAME="SGBounce1" FILE=Sounds\EjectingShells\Shotguns\sshell1.wav GROUP="EjectingShells"
#exec AUDIO IMPORT NAME="SGBounce2" FILE=Sounds\EjectingShells\Shotguns\sshell2.wav GROUP="EjectingShells"
#exec AUDIO IMPORT NAME="SGBounce3" FILE=Sounds\EjectingShells\Shotguns\sshell3.wav GROUP="EjectingShells"

var bool bHasBounced;
var int numBounces;
var sound Bounces[3];

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	if ( Level.bDropDetail && (Level.NetMode != NM_DedicatedServer)
		&& (Level.NetMode != NM_ListenServer) )
		LifeSpan = 1.5;
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	local vector RealHitNormal;

	if ( Level.bDropDetail )
	{
		Destroy();
		return;
	}
	if ( bHasBounced && ((numBounces > 3) || (FRand() < 0.85) || (Velocity.Z > -50)) )
		bBounce = false;
	numBounces++;
	if ( numBounces > 3 )
	{
		Destroy();
		return;
	}
	else if ( !Region.Zone.bWaterZone )
		PlaySound(Bounces[Rand(3)]);
	RealHitNormal = HitNormal;
	HitNormal = Normal(HitNormal + 0.4 * VRand());
	if ( (HitNormal Dot RealHitNormal) < 0 )
		HitNormal *= -0.5; 
	Velocity = 0.5 * (Velocity - 2 * HitNormal * (Velocity Dot HitNormal));
	RandSpin(100000);
	bHasBounced = True;
}

simulated function ZoneChange( Zoneinfo NewZone )
{
	if (NewZone.bWaterZone && !Region.Zone.bWaterZone) 
	{
		Velocity=0.2*Velocity;	
		PlaySound(sound 'Drip1');			
		bHasBounced=True;
	}
}


simulated function Landed( vector HitNormal )
{
	local rotator RandRot;

	if ( Level.bDropDetail )
	{
		Destroy();
		return;
	}
	if ( !Region.Zone.bWaterZone )
		PlaySound(sound 'shell2');
	if ( numBounces > 3 )
	{
		Destroy();
		return;
	}
	
	SetPhysics(PHYS_None);
	RandRot = Rotation;
	RandRot.Pitch = 0;
	RandRot.Roll = 0;
	SetRotation(RandRot);
}

function Eject(Vector Vel)
{
	Velocity = Vel;
	RandSpin(100000);
	if ( (Instigator != None) && Instigator.HeadRegion.Zone.bWaterZone ) 
	{
		Velocity += 0.85 * Instigator.Velocity;
		Velocity = Velocity * (0.2+FRand()*0.2);
		bHasBounced=True;
	}
}

defaultproperties
{
	Bounces(0)=Sound'CS_v16_2.EjectingShells.SGBounce1'
	Bounces(1)=Sound'CS_v16_2.EjectingShells.SGBounce2'
	Bounces(2)=Sound'CS_v16_2.EjectingShells.SGBounce3'
    MaxSpeed=1000.000000
    bNetOptional=True
    bReplicateInstigator=False
    Physics=PHYS_Falling
    RemoteRole=ROLE_SimulatedProxy
    LifeSpan=3.000000
    Mesh=LodMesh'CS_v16_2.SGShell'
    bUnlit=False
    AmbientGlow=64
    bCollideActors=False
    bBounce=True
    bFixedRotationDir=True
    NetPriority=1.400000
}
