class ScoutSniper extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=ScoutMesh MODELFILE=Models\Scout\SniperScoutMesh.psk
#exec MESH ORIGIN MESH=ScoutMesh X=-1 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=ScoutPick ANIVFILE=MODELS\Scout\ScoutPick_a.3d DATAFILE=MODELS\Scout\ScoutPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ScoutPick X=0 Y=0 Z=13

//3rd Person
#exec MESH IMPORT MESH=Scout3rd ANIVFILE=MODELS\Scout\Scout3rd_a.3d DATAFILE=MODELS\Scout\Scout3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Scout3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=ScoutMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=ScoutPick MESH=ScoutPick
#exec MESHMAP SCALE MESHMAP=ScoutPick X=0.09 Y=0.09 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=Scout3rd MESH=Scout3rd
#exec MESHMAP SCALE MESHMAP=Scout3rd X=0.09 Y=0.09 Z=0.19

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=ScoutMeshAnims ANIMFILE=Models\Scout\SniperScoutMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=149
#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=Still STARTFRAME=32 NUMFRAMES=42
#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=60
#exec ANIM SEQUENCE ANIM=ScoutMeshAnims SEQ=Fire STARTFRAME=104 NUMFRAMES=45

#exec ANIM DIGEST ANIM=ScoutMeshAnims
#exec MESH DEFAULTANIM MESH=ScoutMesh ANIM=ScoutMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=ScoutPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ScoutPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=Scout3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=Scout3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=ScoutMeshSkin00 FILE=Textures\Scout\base.bmp GROUP=Scout LODSET=2
#exec TEXTURE IMPORT NAME=ScoutMeshSkin01 FILE=Textures\Scout\view_skin.bmp GROUP=Scout LODSET=2
#exec TEXTURE IMPORT NAME=ScoutMeshSkin02 FILE=Textures\Scout\view_finger.bmp GROUP=Scout LODSET=2
#exec TEXTURE IMPORT NAME=ScoutMeshSkin03 FILE=Textures\Scout\Scout_Rail_Scope.bmp GROUP=Scout LODSET=2
#exec TEXTURE IMPORT NAME=ScoutMeshSkin04 FILE=Textures\Scout\Scout_Mag_Clamp_Glove.bmp GROUP=Scout LODSET=2
#exec TEXTURE IMPORT NAME=ScW FILE=Textures\Scout\w_Scout.bmp GROUP=Scout LODSET=2

#exec TEXTURE IMPORT NAME=ScIcon FILE=Icons\Sniper\ScoutIcon.bmp GROUP=Scout MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=0 TEXTURE=ScoutMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=1 TEXTURE=ScoutMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=2 TEXTURE=ScoutMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=3 TEXTURE=ScoutMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=ScoutMesh NUM=4 TEXTURE=ScoutMeshSkin04

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=ScoutPick NUM=1 TEXTURE=ScW

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Scout3rd NUM=1 TEXTURE=ScW

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="ScFire" FILE=Sounds\Scout\scout_fire.wav GROUP="Scout"
#exec AUDIO IMPORT NAME="ScClipIn" FILE=Sounds\Scout\scout_clipin.wav GROUP="Scout"
#exec AUDIO IMPORT NAME="ScClipOut" FILE=Sounds\Scout\scout_clipout.wav GROUP="Scout"
#exec AUDIO IMPORT NAME="ScBolt" FILE=Sounds\Scout\scout_bolt.wav GROUP="Scout"

//=========================================================================================

#exec MESH IMPORT MESH=ScoutMuzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=ScoutMuzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=ScoutMuzz X=70 Y=1350 Z=-230 YAW=64
#exec MESH SEQUENCE MESH=ScoutMuzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=ScoutMuzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=ScoutMuzz MESH=ScoutMuzz
#exec MESHMAP SCALE MESHMAP=ScoutMuzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var Sound ReloadSounds[4];
var int ZoomLevel;

replication
{
	reliable if(bNetOwner && Role == ROLE_Authority)
		ZoomLevel;
	reliable if(Role == ROLE_Authority)
		PlayerZoomCheck;
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	ZoomLevel = 0;
	//log("Scout Sniper Select Zoom = "$ZoomLevel);
}

function DropFrom(vector StartLocation)
{
	Super.DropFrom(StartLocation);
	ZoomLevel = 0;
}

simulated function PostRender( canvas Canvas )
{
    local PlayerPawn P;
    local float Scale;

    Super.PostRender(Canvas);
    P = PlayerPawn(Owner);
    if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
    {
    	bOwnsCrossHair = true;
    	Scale = Canvas.ClipX/256;
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.Style = ERenderStyle.STY_Modulated;
        Canvas.DrawIcon(Texture'SG5SniperBack', Scale);
        Scale = Canvas.ClipX/640;
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.DrawIcon(Texture'SG5SniperScope', Scale);
        Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
        Canvas.Style = ERenderStyle.STY_Translucent;
        Canvas.DrawIcon(Texture'SG5Snipe', Scale);
        Scale = P.DefaultFOV/P.DesiredFOV;
    }
    else if(Class'CSMut16'.default.bEnableCrosshair)
        bOwnsCrossHair = false;
    else
    	bOwnsCrossHair = true;
}

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	FinishAnim();
	Finish();
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		ZoomLevel = 0;
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
	 		bDrawMuzzleFlash = True; 
		}
}

simulated function TweenDown()
{
	ZoomLevel = 0;
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');	
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				Owner.PlaySound(Sound'ZoomScope1');
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = 55.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
				else if (PlayerPawn(Owner).DesiredFOV == 55.0)
				{
					PlayerPawn(Owner).DesiredFOV = 25.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
				else
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
	}
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	PlayAnim('Fire', 1, 0.04);

	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if(Owner.IsA('PlayerPawn'))
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
			{
	        	PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
	        	PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
			}

	if(PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{	
		bPointing=True;

		if(!Owner.IsA('Bot'))
		{
			if(ZoomLevel == 0)
				TraceFire(17.0);
			else if(ZoomLevel == 1)
				TraceFire(0.0);
			else if(ZoomLevel == 2)
				TraceFire(0.0);
		}
		else if(Owner.IsA('Bot'))
			if(Bot(Owner) != None)
				TraceFire(0.0);
		else if((Owner.IsA('SkaarjTrooper')))
			if(SkaarjTrooper(Owner) != None)
				TraceFire(3.0);

		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		ZoomLevel = 0;
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		Sleep(0.35);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.26);
		SpawnShellCase(vect(10,-500,1));
		FinishAnim();
		Finish();
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function AltFire( float Value )
{
	if(ZoomLevel == 0)				//Was Default FOV
		ZoomLevel = 1;
	else if(ZoomLevel == 1)			//New FOV : 45
		ZoomLevel = 2;
	else if(ZoomLevel == 2)			//New FOV : 15
		ZoomLevel = 0;				//Back to Default FOV

	ClientAltFire(Value);
}

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
    	ZoomLevel = 0;
        GotoState('NewClip');
        PlayReloading();
        ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function ClientReload()
{
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
    	ZoomLevel = 0;
    	GoToState('ClientReloading');
        PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.8, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
	Begin:
		if(isAnimating())
			FinishAnim();
		PlayIdleAnim();
		if(AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();
	Checks:
		if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
			Reload();
		Sleep(0.0);
		GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local Pawn PawnOwner;
	local float Penetration;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 366.00;
		else
			Penetration = 340.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.80;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

simulated function ZoomCheck()
{
	JustZoomCheck();
	PlayerZoomCheck();
}

simulated function JustZoomCheck()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				if (ZoomLevel == 0)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
				else if (ZoomLevel == 1)
				{
					PlayerPawn(Owner).DesiredFOV = 55.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
				else if(ZoomLevel == 2)
				{
					PlayerPawn(Owner).DesiredFOV = 25.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
				}
			}
		}
	}
}

simulated function PlayerZoomCheck()
{
	if( Role < ROLE_Authority )
		JustZoomCheck();
}

function Finish()
{
  	ZoomCheck();
  	Super.Finish();
}

defaultproperties
{
    ReloadSounds(0)=Sound'CS_v16_2.Scout.ScBolt'
    ReloadSounds(1)=Sound'CS_v16_2.Scout.ScClipOut'
    ReloadSounds(2)=Sound'CS_v16_2.Scout.ScClipIn'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.Scout.ScFire'
    EjectOffset=(X=20.000000,Y=10.000000,Z=-10.000000)
    HitDamage=58
    ClipCount=10
    PickupAmmoCount=30
    VRecoil=550.00
    HRecoil=0.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16_2.AmmoSniper'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000,Z=0.00)
    MuzzleOffset=(X=0.00,Y=-8.000000,Z=0.00)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.950000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.080000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CS_v16_2.Deagle.PistolGenericMuzz'
    AutoSwitchPriority=9
    InventoryGroup=9
    PickupMessage="You got a Scout."
    ItemName="Scout"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'ScoutMesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'ScoutPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'Scout3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.ScoutMuzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'ScoutPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16_2.Scout.ScIcon'
    StatusIcon=Texture'CS_v16_2.Scout.ScIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}