class P228 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=P228Mesh MODELFILE=Models\P228\P228Mesh.psk
#exec MESH ORIGIN MESH=P228Mesh X=0 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=P228Pick ANIVFILE=MODELS\P228\P228Pick_a.3d DATAFILE=MODELS\P228\P228Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=P228Pick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=P2283rd ANIVFILE=MODELS\P228\P2283rd_a.3d DATAFILE=MODELS\P228\P2283rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=P2283rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=P228Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=P228Pick MESH=P228Pick
#exec MESHMAP SCALE MESHMAP=P228Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=P2283rd MESH=P2283rd
#exec MESHMAP SCALE MESHMAP=P2283rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=P228Anims ANIMFILE=Models\P228\P228MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=P228Anims SEQ=All STARTFRAME=0 NUMFRAMES=164
#exec ANIM SEQUENCE ANIM=P228Anims SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=P228Anims SEQ=Still STARTFRAME=32 NUMFRAMES=9
#exec ANIM SEQUENCE ANIM=P228Anims SEQ=Reload STARTFRAME=42 NUMFRAMES=95
#exec ANIM SEQUENCE ANIM=P228Anims SEQ=Fire STARTFRAME=139 NUMFRAMES=25

#exec ANIM DIGEST ANIM=P228Anims
#exec MESH DEFAULTANIM MESH=P228Mesh ANIM=P228Anims

//Pickup
#exec MESH SEQUENCE MESH=P228Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=P228Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=P2283rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=P2283rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=P228MeshSkin00 FILE=Textures\P228\p228_handle.bmp GROUP=P228 LODSET=2
#exec TEXTURE IMPORT NAME=P228MeshSkin01 FILE=Textures\P228\p228_slide.bmp GROUP=P228 LODSET=2
#exec TEXTURE IMPORT NAME=P228MeshSkin02 FILE=Textures\P228\p228_mag.bmp GROUP=P228 LODSET=2
#exec TEXTURE IMPORT NAME=P228MeshSkin03 FILE=Textures\P228\view_glove.bmp GROUP=P228 LODSET=2
#exec TEXTURE IMPORT NAME=P228MeshSkin04 FILE=Textures\P228\view_skin.bmp GROUP=P228 LODSET=2
#exec TEXTURE IMPORT NAME=P228MeshSkin05 FILE=Textures\P228\view_finger.bmp GROUP=P228 LODSET=2
#exec TEXTURE IMPORT NAME=P228W FILE=Textures\P228\w_p228.bmp GROUP=P228 LODSET=2

#exec TEXTURE IMPORT NAME=P228Icon FILE=Icons\Pistols\P228Icon.bmp GROUP=P228 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=P228Mesh NUM=0 TEXTURE=P228MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=P228Mesh NUM=1 TEXTURE=P228MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=P228Mesh NUM=2 TEXTURE=P228MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=P228Mesh NUM=3 TEXTURE=P228MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=P228Mesh NUM=4 TEXTURE=P228MeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=P228Mesh NUM=5 TEXTURE=P228MeshSkin05

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=P228Pick NUM=1 TEXTURE=P228W

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=P2283rd NUM=1 TEXTURE=P228W

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="P228Fire" FILE=Sounds\P228\p228_fire.wav GROUP="P228"
#exec AUDIO IMPORT NAME="P228ClipIn" FILE=Sounds\P228\p228_clipin.wav GROUP="P228"
#exec AUDIO IMPORT NAME="P228ClipOut" FILE=Sounds\P228\p228_clipout.wav GROUP="P228"
#exec AUDIO IMPORT NAME="P228SlidePull" FILE=Sounds\P228\p228_slidepull.wav GROUP="P228"
#exec AUDIO IMPORT NAME="P228SlideRelease" FILE=Sounds\P228\p228_sliderelease.wav GROUP="P228"

//=========================================================================================

var Sound ReloadSounds[5];

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0,0.04);
	Sleep(0.35);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
	ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',1.0,0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.35);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if(!Owner.IsA('Bot'))
		PlayAnim('Fire', 1.3, 0.04);
	else if(Owner.IsA('Bot'))
		PlayAnim('Fire', 4.3, 0.04);
	
	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			bMuzzleFlashParticles = False;
			bSteadyFlash3rd = False;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		bMuzzleFlashParticles = True;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.16);
	if (Pawn(Owner).bFire != 0)
	{
		bSteadyFlash3rd = False;
		bMuzzleFlashParticles = False;
		GoTo('Begin');
	}
	else
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.1); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still', 1.0);
	GoToState('Idle', 'Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 136.00;
		else
			Penetration = 120.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	ReloadSounds(0)=Sound'CS_v16_2.P228.P228ClipOut'
    ReloadSounds(1)=Sound'CS_v16_2.P228.P228ClipIn'
    ReloadSounds(2)=Sound'CS_v16_2.P228.P228SlidePull'
    ReloadSounds(3)=Sound'CS_v16_2.P228.P228SlideRelease'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.P228.P228Fire'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=18
    ClipCount=13
    PickupAmmoCount=65
    VRecoil=550.00
    HRecoil=1.20
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16_2.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.250000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.115000
    FlashO=0.017500
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CS_v16_2.Deagle.PistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a P228."
    ItemName="P228"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'P228Mesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'P228Pick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'P2283rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.PistolMuzz'
    MuzzleFlashScale=0.080000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'P228Pick'
    bNoSmooth=False
    Icon=Texture'CS_v16_2.P228.P228Icon'
    StatusIcon=Texture'CS_v16_2.P228.P228Icon'
    DrawScale=3.000000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}