class Mac10 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=Mac10Mesh MODELFILE=Models\Mac10\Mac10Mesh.psk
#exec MESH ORIGIN MESH=Mac10Mesh X=-1 Y=-3 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=Mac10Pick ANIVFILE=MODELS\Mac10\Mac10Pick_a.3d DATAFILE=MODELS\Mac10\Mac10Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Mac10Pick X=0 Y=0 Z=18

//3rd Person
#exec MESH IMPORT MESH=Mac103rd ANIVFILE=MODELS\Mac10\Mac103rd_a.3d DATAFILE=MODELS\Mac10\Mac103rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Mac103rd X=0 Y=0 Z=-9 Yaw=64

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=Mac10Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=Mac10Pick MESH=Mac10Pick
#exec MESHMAP SCALE MESHMAP=Mac10Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=Mac103rd MESH=Mac103rd
#exec MESHMAP SCALE MESHMAP=Mac103rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=Mac10MeshAnims ANIMFILE=Models\Mac10\Mac10MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=177
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=Still STARTFRAME=32 NUMFRAMES=8
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=Reload STARTFRAME=41 NUMFRAMES=110
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=Fire STARTFRAME=152 NUMFRAMES=25
#exec ANIM SEQUENCE ANIM=Mac10MeshAnims SEQ=AfterFire STARTFRAME=158 NUMFRAMES=10

#exec ANIM DIGEST ANIM=Mac10MeshAnims
#exec MESH DEFAULTANIM MESH=Mac10Mesh ANIM=Mac10MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=Mac10Pick SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=Mac10Pick SEQ=Still STARTFRAME=0 NUMFRAMES=30

//3rd Person
#exec MESH SEQUENCE MESH=Mac103rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Mac103rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=Mac10MeshSkin00 FILE=Textures\Mac10\handle.bmp GROUP=Mac10 LODSET=2
#exec TEXTURE IMPORT NAME=Mac10MeshSkin01 FILE=Textures\Mac10\body.bmp GROUP=Mac10 LODSET=2
#exec TEXTURE IMPORT NAME=Mac10MeshSkin02 FILE=Textures\Mac10\buttstock.bmp GROUP=Mac10 LODSET=2
#exec TEXTURE IMPORT NAME=Mac10MeshSkin03 FILE=Textures\Mac10\view_glove.bmp GROUP=Mac10 LODSET=2
#exec TEXTURE IMPORT NAME=Mac10MeshSkin04 FILE=Textures\Mac10\view_skin.bmp GROUP=Mac10 LODSET=2
#exec TEXTURE IMPORT NAME=Mac10MeshSkin05 FILE=Textures\Mac10\view_finger.bmp GROUP=Mac10 LODSET=2
#exec TEXTURE IMPORT NAME=Mac10W FILE=Textures\Mac10\w_mac10.bmp GROUP=Mac10 LODSET=2

#exec TEXTURE IMPORT NAME=Mac10Icon FILE=Icons\SMG\Mac10Icon.bmp GROUP=Mac10 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=0 TEXTURE=Mac10MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=1 TEXTURE=Mac10MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=2 TEXTURE=Mac10MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=3 TEXTURE=Mac10MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=4 TEXTURE=Mac10MeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Mesh NUM=5 TEXTURE=Mac10MeshSkin05

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=Mac10Pick NUM=1 TEXTURE=Mac10W

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Mac103rd NUM=1 TEXTURE=Mac10W

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="MacFire" FILE=Sounds\Mac10\mac10_fire.wav GROUP="Mac10"
#exec AUDIO IMPORT NAME="MacClipIn" FILE=Sounds\Mac10\mac10_clipin.wav GROUP="Mac10"
#exec AUDIO IMPORT NAME="MacClipOut" FILE=Sounds\Mac10\mac10_clipout.wav GROUP="Mac10"
#exec AUDIO IMPORT NAME="MacBoltPull" FILE=Sounds\Mac10\mac10_boltpull.wav GROUP="Mac10"

//=========================================================================================

#exec MESH IMPORT MESH=Mac10Muzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=Mac10Muzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=Mac10Muzz X=0 Y=600 Z=-305 YAW=64
#exec MESH SEQUENCE MESH=Mac10Muzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=Mac10Muzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=Mac10Muzz MESH=Mac10Muzz
#exec MESHMAP SCALE MESHMAP=Mac10Muzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

Var() sound ReloadSounds[4];
var Texture RandFlash[9];

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(8)];
	Super.RenderOverlays(Canvas);
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',0.8,0.04);
	FinishAnim();
	Finish();
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
	 		bDrawMuzzleFlash = True; 
		}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',0.8,0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.8, 0.04);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 17, 0.04);
	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
	{
		bMuzzleFlash++;
	}
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(3.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

simulated function PlayReload()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Reload', 1.3, 0.04);
	}
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.3, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.65);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.73);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.65);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.73);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
	ignores AltFire;

	Begin:
		if(isAnimating())
			FinishAnim();
		PlayIdleAnim();
		if(AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();
	Checks:
		if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
			Reload();
		Sleep(0.0);
		GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16_2.MP5.SMGMuzz1'
	RandFlash(1)=Texture'CS_v16_2.MP5.SMGMuzz2'
	RandFlash(2)=Texture'CS_v16_2.MP5.SMGMuzz3'
	RandFlash(3)=Texture'CS_v16_2.MP5.SMGMuzz4'
	RandFlash(4)=Texture'CS_v16_2.MP5.SMGMuzz5'
	RandFlash(5)=Texture'CS_v16_2.MP5.SMGMuzz6'
	RandFlash(6)=Texture'CS_v16_2.MP5.SMGMuzz7'
	RandFlash(7)=Texture'CS_v16_2.MP5.SMGMuzz8'
	RandFlash(8)=Texture'CS_v16_2.MP5.SMGMuzz9'
    ReloadSounds(0)=Sound'CS_v16_2.Mac10.MacClipIn'
    ReloadSounds(1)=Sound'CS_v16_2.Mac10.MacClipOut'
    ReloadSounds(2)=Sound'CS_v16_2.Mac10.MacBoltPull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.Mac10.MacFire'
    EjectOffset=(X=20.000000,Y=10.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=30
    VRecoil=350.00
    HRecoil=0.90
    RecoilMultiplier=0.01
    PickupAmmoCount=90
    AmmoName=Class'CS_v16_2.AmmoSMG'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.600000
    RefireRate=0.900000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.130000
    FlashO=0.012500
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'CS_v16_2.MP5.SMGMuzz1'
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a Mac-10."
    ItemName="Mac-10"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=3.000000
    PlayerViewMesh=SkeletalMesh'CS_v16_2.Mac10Mesh'
    PickupViewMesh=LodMesh'Mac10Pick'
    PickupViewScale=1.700000
    ThirdPersonMesh=LodMesh'Mac103rd'
    ThirdPersonScale=2.200000
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.Mac10Muzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'Mac10Pick'
    bNoSmooth=False
    Icon=Texture'CS_v16_2.Mac10.Mac10Icon'
    StatusIcon=Texture'CS_v16_2.Mac10.Mac10Icon'
    DrawScale=1.700000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}