class MP5 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=MP5Mesh MODELFILE=Models\MP5\MP5Mesh.psk
#exec MESH ORIGIN MESH=MP5Mesh X=-1 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=MP5Pick ANIVFILE=MODELS\MP5\MP5Pick_a.3d DATAFILE=MODELS\MP5\MP5Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MP5Pick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=MP53rd ANIVFILE=MODELS\MP5\MP53rd_a.3d DATAFILE=MODELS\MP5\MP53rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MP53rd X=0 Y=0 Z=-9 Yaw=64

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=MP5Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=MP5Pick MESH=MP5Pick
#exec MESHMAP SCALE MESHMAP=MP5Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=MP53rd MESH=MP53rd
#exec MESHMAP SCALE MESHMAP=MP53rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=MP5MeshAnims ANIMFILE=Models\MP5\MP5MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=162
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=32
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=Still STARTFRAME=32 NUMFRAMES=8
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=Reload STARTFRAME=41 NUMFRAMES=100
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=Fire STARTFRAME=142 NUMFRAMES=20
#exec ANIM SEQUENCE ANIM=MP5MeshAnims SEQ=AfterFire STARTFRAME=151 NUMFRAMES=10

#exec ANIM DIGEST ANIM=MP5MeshAnims
#exec MESH DEFAULTANIM MESH=MP5Mesh ANIM=MP5MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=MP5Pick SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=MP5Pick SEQ=Still STARTFRAME=0 NUMFRAMES=30

//3rd Person
#exec MESH SEQUENCE MESH=MP53rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MP53rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Textures

#exec TEXTURE IMPORT NAME=MP5MeshSkin00 FILE=Textures\MP5\barrel.bmp GROUP=MP5 LODSET=2
#exec TEXTURE IMPORT NAME=MP5MeshSkin01 FILE=Textures\MP5\clip.bmp GROUP=MP5 LODSET=2
#exec TEXTURE IMPORT NAME=MP5MeshSkin02 FILE=Textures\MP5\view_skin.bmp GROUP=MP5 LODSET=2
#exec TEXTURE IMPORT NAME=MP5MeshSkin03 FILE=Textures\MP5\MP5HG.bmp GROUP=MP5 LODSET=2
#exec TEXTURE IMPORT NAME=MP5MeshSkin04 FILE=Textures\MP5\MP5FLR.bmp GROUP=MP5 LODSET=2
#exec TEXTURE IMPORT NAME=MP5MeshSkin05 FILE=Textures\MP5\MP5BF.bmp GROUP=MP5 LODSET=2
#exec TEXTURE IMPORT NAME=WMP5 FILE=Textures\MP5\w_MP5.bmp GROUP=MP5 LODSET=2

#exec TEXTURE IMPORT NAME=MP5Icon FILE=Icons\SMG\MP5Icon.bmp GROUP=MP5 MIPS=OFF

#exec TEXTURE IMPORT NAME=SMGMuzz1 FILE=Textures\SMGMuzz1.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz2 FILE=Textures\SMGMuzz2.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz3 FILE=Textures\SMGMuzz3.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz4 FILE=Textures\SMGMuzz4.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz5 FILE=Textures\SMGMuzz5.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz6 FILE=Textures\SMGMuzz6.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz7 FILE=Textures\SMGMuzz7.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz8 FILE=Textures\SMGMuzz8.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF
#exec TEXTURE IMPORT NAME=SMGMuzz9 FILE=Textures\SMGMuzz9.bmp GROUP=MP5 FLAGS=2 LODSET=2 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=0 TEXTURE=MP5MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=1 TEXTURE=MP5MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=2 TEXTURE=MP5MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=3 TEXTURE=MP5MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=4 TEXTURE=MP5MeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=MP5Mesh NUM=5 TEXTURE=MP5MeshSkin05

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=MP5Pick NUM=1 TEXTURE=WMP5

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=MP53rd NUM=1 TEXTURE=WMP5

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="MP5Fire" FILE=Sounds\MP5\mp5_fire.wav GROUP="MP5"
#exec AUDIO IMPORT NAME="MP5ClipIn" FILE=Sounds\MP5\mp5_clipin.wav GROUP="MP5"
#exec AUDIO IMPORT NAME="MP5ClipOut" FILE=Sounds\MP5\mp5_clipout.wav GROUP="MP5"
#exec AUDIO IMPORT NAME="MP5SlideBack" FILE=Sounds\MP5\mp5_slideback.wav GROUP="MP5"

//=========================================================================================

#exec MESH IMPORT MESH=MP5Muzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=MP5Muzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=MP5Muzz X=-30 Y=800 Z=-205 YAW=64
#exec MESH SEQUENCE MESH=MP5Muzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=MP5Muzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=MP5Muzz MESH=MP5Muzz
#exec MESHMAP SCALE MESHMAP=MP5Muzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

Var() sound ReloadSounds[4];
Var Texture RandFlash[9];

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(8)];
	Super.RenderOverlays(Canvas);
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',0.8,0.04);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',0.8,0.04);
		GoToState('Selector');
	}
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.8, 0.04);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 10, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();
	
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		TraceFire(3.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.5, 0.04);
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.04);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.6);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.8);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.85);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
	ignores AltFire;
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle', 'Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 236.00;
		else
			Penetration = 220.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16_2.MP5.SMGMuzz1'
	RandFlash(1)=Texture'CS_v16_2.MP5.SMGMuzz2'
	RandFlash(2)=Texture'CS_v16_2.MP5.SMGMuzz3'
	RandFlash(3)=Texture'CS_v16_2.MP5.SMGMuzz4'
	RandFlash(4)=Texture'CS_v16_2.MP5.SMGMuzz5'
	RandFlash(5)=Texture'CS_v16_2.MP5.SMGMuzz6'
	RandFlash(6)=Texture'CS_v16_2.MP5.SMGMuzz7'
	RandFlash(7)=Texture'CS_v16_2.MP5.SMGMuzz8'
	RandFlash(8)=Texture'CS_v16_2.MP5.SMGMuzz9'
    ReloadSounds(0)=Sound'CS_v16_2.MP5.MP5ClipIn'
    ReloadSounds(1)=Sound'CS_v16_2.MP5.MP5ClipOut'
    ReloadSounds(2)=Sound'CS_v16_2.MP5.MP5SlideBack'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.MP5.MP5Fire'
    EjectOffset=(X=20.000000,Y=10.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=30
    PickupAmmoCount=60
    VRecoil=300.00
    HRecoil=0.90
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16_2.AmmoSMG'
    bInstantHit=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.600000
    RefireRate=0.900000
    AltRefireRate=0.900000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'CS_v16_2.MP5.SMGMuzz1'
    BobDamping=1.11
    AutoSwitchPriority=4
    InventoryGroup=4
    PickupMessage="You got a MP5."
    ItemName="MP5"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=3.000000
    PlayerViewMesh=SkeletalMesh'CS_v16_2.MP5Mesh'
    PickupViewMesh=LodMesh'MP5Pick'
    PickupViewScale=2.000000
    ThirdPersonMesh=LodMesh'MP53rd'
    ThirdPersonScale=1.800000
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.MP5Muzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'MP5Pick'
    bNoSmooth=False
    Icon=Texture'CS_v16_2.MP5.MP5Icon'
    StatusIcon=Texture'CS_v16_2.MP5.MP5Icon'
    DrawScale=2.00
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}