class M4A1 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=M4A1Mesh MODELFILE=Models\M4A1\M4A1Mesh.psk
#exec MESH ORIGIN MESH=M4A1Mesh X=-1 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=M4A1Pick ANIVFILE=MODELS\M4A1\M4A1Pick_a.3d DATAFILE=MODELS\M4A1\M4A1Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M4A1Pick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=M4A13rd ANIVFILE=MODELS\M4A1\M4A13rd_a.3d DATAFILE=MODELS\M4A1\M4A13rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M4A13rd X=0 Y=0 Z=-7 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=M4A1Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=M4A1Pick MESH=M4A1Pick
#exec MESHMAP SCALE MESHMAP=M4A1Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=M4A13rd MESH=M4A13rd
#exec MESHMAP SCALE MESHMAP=M4A13rd X=0.09 Y=0.09 Z=0.16

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=M4A1MeshAnims ANIMFILE=Models\M4A1\M4A1MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=512
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=SelectUnSilenced STARTFRAME=0 NUMFRAMES=41
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=SelectSilenced STARTFRAME=42 NUMFRAMES=40
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=StillUnSilenced STARTFRAME=83 NUMFRAMES=8
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=StillSilenced STARTFRAME=92 NUMFRAMES=8
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=ReloadUnSilenced STARTFRAME=101 NUMFRAMES=113
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=ReloadSilenced STARTFRAME=215 NUMFRAMES=113
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=AddSilencer STARTFRAME=329 NUMFRAMES=60
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=RemoveSilencer STARTFRAME=390 NUMFRAMES=60
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=FireUnSilenced STARTFRAME=451 NUMFRAMES=30
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=AfterFireUnSilenced STARTFRAME=454 NUMFRAMES=27
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=FireSilenced STARTFRAME=482 NUMFRAMES=30
#exec ANIM SEQUENCE ANIM=M4A1MeshAnims SEQ=AfterFireSilenced STARTFRAME=485 NUMFRAMES=27

#exec ANIM DIGEST ANIM=M4A1MeshAnims
#exec MESH DEFAULTANIM MESH=M4A1Mesh ANIM=M4A1MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=M4A1Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M4A1Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=M4A13rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=M4A13rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=M4A1MeshSkin00 FILE=Textures\M4A1\handle.bmp GROUP=M4A1 LODSET=2
#exec TEXTURE IMPORT NAME=M4A1MeshSkin01 FILE=Textures\M4A1\buttstock.bmp GROUP=M4A1 LODSET=2
#exec TEXTURE IMPORT NAME=M4A1MeshSkin02 FILE=Textures\M4A1\silencer.bmp GROUP=M4A1 LODSET=2
#exec TEXTURE IMPORT NAME=M4A1MeshSkin03 FILE=Textures\M4A1\M4_RSkin.bmp GROUP=M4A1 LODSET=2
#exec TEXTURE IMPORT NAME=M4A1MeshSkin04 FILE=Textures\M4A1\M4_BGlove.bmp GROUP=M4A1 LODSET=2
#exec TEXTURE IMPORT NAME=M4A1MeshSkin05 FILE=Textures\M4A1\M4_MSkin.bmp GROUP=M4A1 LODSET=2
#exec TEXTURE IMPORT NAME=M4A1W FILE=Textures\M4A1\m4a1_skin.bmp GROUP=M4A1 LODSET=2

#exec TEXTURE IMPORT NAME=M4A1Icon FILE=Icons\Rifles\M4A1Icon.bmp GROUP=M4A1 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=0 TEXTURE=M4A1MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=1 TEXTURE=M4A1MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=2 TEXTURE=M4A1MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=3 TEXTURE=M4A1MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=4 TEXTURE=M4A1MeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Mesh NUM=5 TEXTURE=M4A1MeshSkin05

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=M4A1Pick NUM=1 TEXTURE=M4A1W

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=M4A13rd NUM=1 TEXTURE=M4A1W

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="M4A1Fire_Unsil" FILE=Sounds\M4A1\m4a1_unsil_fire.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1Fire_Sil" FILE=Sounds\M4A1\m4a1_sil_fire.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1Select" FILE=Sounds\M4A1\m4a1_deploy.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1BoltPull" FILE=Sounds\M4A1\m4a1_boltpull.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1ClipIn" FILE=Sounds\M4A1\m4a1_clipin.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1ClipOut" FILE=Sounds\M4A1\m4a1_clipout.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1AddSilencer" FILE=Sounds\M4A1\m4a1_silencer_on.wav GROUP="M4A1"
#exec AUDIO IMPORT NAME="M4A1RemoveSilencer" FILE=Sounds\M4A1\m4a1_silencer_off.wav GROUP="M4A1"

//=========================================================================================

#exec MESH IMPORT MESH=M4A1Muzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=M4A1Muzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=M4A1Muzz X=50 Y=1350 Z=-220 YAW=64
#exec MESH SEQUENCE MESH=M4A1Muzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=M4A1Muzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=M4A1Muzz MESH=M4A1Muzz
#exec MESHMAP SCALE MESHMAP=M4A1Muzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var() int FireMode;				//0 = Normal, 1 = Silenced
var Sound ReloadSounds[5];
var Sound AddSilencerSound;
var Sound RemoveSilencerSound;
var Texture RandFlash[6];

Replication
{
	Reliable if(bNetOwner && Role==ROLE_Authority)
		FireMode;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	return AIRating;
}

simulated event RenderOverlays(canvas Canvas)
{
	if(FireMode == 0)
		MFTexture = RandFlash[Rand(6)];
	else if(FireMode == 1)
		MFTexture = Texture'CS_v16_2.Deagle.PistolGenericMuzz';
	Super.RenderOverlays(Canvas);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	if(FireMode == 0)
		PlayAnim('SelectUnSilenced', 1.1, 0.04);
	else if(FireMode == 1)
		PlayAnim('SelectSilenced', 1.1, 0.04);
	Play1stSelectionSound();
	Sleep(0.4);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
	else if(EventType == 'DoSilencer')
		PlaySilencer();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		if(FireMode == 0)
			PlayAnim('SelectUnSilenced', 1.1, 0.04);
		else if(FireMode == 1)
			PlayAnim('SelectSilenced', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Play1stSelectionSound();
		Sleep(0.4);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function Play1stSelectionSound()
{
	if(Owner != None)
		Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelectionSound()
{
	if(Owner != None)
		Owner.PlaySound(ReloadSounds[3], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	if(FireMode == 0)
		PlayAnim('SelectUnSilenced', 1.1, 0.04);
	else if(FireMode == 1)
		PlayAnim('SelectSilenced', 1.1, 0.04);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	if(FireMode == 0)
		PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	else if(FireMode == 1)
		PlayOwnedSound(AltFireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	if(FireMode == 0)
		PlayAnim('FireUnSilenced', 14, 0.04);
	else if(FireMode == 1)
		PlayAnim('FireSilenced', 14, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if(PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(3.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	ignores AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

Begin:
	FlashCount++;
	FinishAnim();
	Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

simulated function PlayAfterFire()
{
	if(FireMode == 0)
		PlayAnim('AfterFireUnSilenced', 1.0, 0.04);
	else if(FireMode == 1)
		PlayAnim('AfterFireSilenced', 1.0, 0.04);
}

simulated function PlayAltFiring()
{
	if(!Owner.IsA('Bot'))
	{
		if(FireMode == 0)
		{
			PlayAnim('RemoveSilencer', 0.8, 0.04);
		}
		else if(FireMode == 1)
		{
			PlayAnim('AddSilencer', 0.8, 0.04);
		}
	}
}

simulated function PlaySilencer()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		if(FireMode == 0)
		{
			PlayAnim('AddSilencer', 0.8, 0.04);
		}
		else if(FireMode == 1)
		{
			PlayAnim('RemoveSilencer', 0.8, 0.04);
		}
	}
}

function AltFire(float Value)
{
	if(FireMode == 0)
		FireMode = 1;
	else if(FireMode == 1)
		FireMode = 0;

	if(Level.NetMode == NM_DedicatedServer)
	{
		if (PlayerPawn(Owner) != None) 
			PlayerPawn(Owner).ClientWeaponEvent('DoSilencer');
	}

	GotoState('AltFiring');
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;

Begin:
	if(FireMode == 0)
	{
		Sleep(0.7);
		Owner.PlaySound(RemoveSilencerSound,SLOT_None,Pawn(Owner).SoundDampening);
	}
	else if(FireMode == 1)
	{
		Sleep(0.92);
		Owner.PlaySound(AddSilencerSound,SLOT_None,Pawn(Owner).SoundDampening);
	}
	FinishAnim();
	Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
    if ( (Owner == None) )
        return;

    if(FireMode == 0)
		PlayAnim('ReloadUnSilenced', 1.0, 0.05);
	else if(FireMode == 1)
		PlayAnim('ReloadSilenced', 1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated function TweenToStill()
{
	if(Mesh != PlayerViewMesh)
	{
		if(FireMode == 0)
			TweenAnim('StillUnSilenced',1.0);
		else if(FireMode == 1)
			TweenAnim('StillSilenced',1.0);
	}
}

simulated state Idle
{
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	if(FireMode == 0)
		TweenAnim('StillUnSilenced',1.0);
	else if(FireMode == 1)
		TweenAnim('StillSilenced',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 236.00;
		else
			Penetration = 220.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.80;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16_2.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16_2.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16_2.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16_2.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16_2.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16_2.AK47.CSRifleMuzz6'
    ReloadSounds(0)=Sound'CS_v16_2.M4A1.M4A1ClipOut'
    ReloadSounds(1)=Sound'CS_v16_2.M4A1.M4A1ClipIn'
    ReloadSounds(2)=Sound'CS_v16_2.M4A1.M4A1Select'
    ReloadSounds(3)=Sound'CS_v16_2.M4A1.M4A1BoltPull'
    AddSilencerSound=Sound'CS_v16_2.M4A1.M4A1AddSilencer'
    RemoveSilencerSound=Sound'CS_v16_2.M4A1.M4A1RemoveSilencer'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.M4A1.M4A1Fire_Unsil'
    AltFireSound=Sound'CS_v16_2.M4A1.M4A1Fire_Sil'
    EjectOffset=(X=20.000000,Y=10.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=30
    PickupAmmoCount=60
    VRecoil=550.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16_2.AmmoRifles'
    bInstantHit=True
    bAltInstantHit=True
    bRapidFire=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.730000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=500.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.100000
    FlashO=0.010000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
    AutoSwitchPriority=5
    InventoryGroup=5
    PickupMessage="You got a M4A1."
    ItemName="M4A1"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'M4A1Mesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'M4A1Pick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'M4A13rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.M4A1Muzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'M4A1Pick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16_2.M4A1.M4A1Icon'
    StatusIcon=Texture'CS_v16_2.M4A1.M4A1Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}