class M3 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=M3Mesh MODELFILE=Models\M3\M3Mesh.psk
#exec MESH ORIGIN MESH=M3Mesh X=-1.8 Y=-3 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=M3Pick ANIVFILE=MODELS\M3\M3Pick_a.3d DATAFILE=MODELS\M3\M3Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M3Pick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=M33rd ANIVFILE=MODELS\M3\M33rd_a.3d DATAFILE=MODELS\M3\M33rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M33rd X=10 Y=0 Z=-5 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=M3Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=M3Pick MESH=M3Pick
#exec MESHMAP SCALE MESHMAP=M3Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=M33rd MESH=M33rd
#exec MESHMAP SCALE MESHMAP=M33rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=M3MeshAnims ANIMFILE=Models\M3\M3MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=196
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=StartReload STARTFRAME=32 NUMFRAMES=15
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=InsertShell STARTFRAME=48 NUMFRAMES=27
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=EndReload STARTFRAME=76 NUMFRAMES=33
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=Still STARTFRAME=110 NUMFRAMES=10
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=Fire1 STARTFRAME=121 NUMFRAMES=37
#exec ANIM SEQUENCE ANIM=M3MeshAnims SEQ=Fire2 STARTFRAME=159 NUMFRAMES=37

#exec ANIM DIGEST ANIM=M3MeshAnims
#exec MESH DEFAULTANIM MESH=M3Mesh ANIM=M3MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=M3Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M3Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=M33rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=M33rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=M3MeshSkin00 FILE=Textures\M3\sights.bmp GROUP=M3 LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin01 FILE=Textures\M3\handle.bmp GROUP=M3 LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin02 FILE=Textures\M3\Barrel.bmp GROUP=M3 LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin03 FILE=Textures\M3\forearm.bmp GROUP=M3 LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin04 FILE=Textures\M3\view_glove.bmp GROUP=M3 LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin05 FILE=Textures\M3\view_skin.bmp GROUP=M3 LODSET=2
#exec TEXTURE IMPORT NAME=M3MeshSkin06 FILE=Textures\M3\view_finger.bmp GROUP=M3 LODSET=2
#exec TEXTURE IMPORT NAME=M3W FILE=Textures\M3\w_m3super90.bmp GROUP=M3 LODSET=2

#exec TEXTURE IMPORT NAME=M3Icon FILE=Icons\Shotguns\M3Icon.bmp GROUP=M3 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=0 TEXTURE=M3MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=1 TEXTURE=M3MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=2 TEXTURE=M3MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=3 TEXTURE=M3MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=4 TEXTURE=M3MeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=5 TEXTURE=M3MeshSkin05
#exec MESHMAP SETTEXTURE MESHMAP=M3Mesh NUM=6 TEXTURE=M3MeshSkin06

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=M3Pick NUM=1 TEXTURE=M3W

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=M33rd NUM=1 TEXTURE=M3W

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="M3Fire" FILE=Sounds\M3\m3_fire.wav GROUP="M3"
#exec AUDIO IMPORT NAME="M3Pump" FILE=Sounds\M3\m3_pump.wav GROUP="M3"
#exec AUDIO IMPORT NAME="M3Insert" FILE=Sounds\M3\m3_insertshell.wav GROUP="M3"

//=========================================================================================

#exec MESH IMPORT MESH=M3Muzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=M3Muzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=M3Muzz X=0 Y=1200 Z=-105 YAW=64
#exec MESH SEQUENCE MESH=M3Muzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=M3Muzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=M3Muzz MESH=M3Muzz
#exec MESHMAP SCALE MESHMAP=M3Muzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var() sound ReloadSounds[3];
var name FireAnims[2];

replication
{
	reliable if(Role == ROLE_Authority)
		ClientReloadStart, ClientReloadInsert, ClientReloadEnd;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0,0.04);
	Sleep(0.4);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',1.0,0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.4);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[0], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.04);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim(FireAnims[Rand(2)], 0.9, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();
		
	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	local int shots;

	if(ClipCount>0 && AmmoType.UseAmmo(1))
	{
		for (shots = 0; shots < 5; shots++)
			TraceFire(12.0);

		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount<=0 && AmmoType.AmmoAmount>0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	Begin:
		FlashCount++;
		Sleep(0.77);
		SpawnShellCase(vect(10,-500,1));
		FinishAnim();
		Finish();
}

//---------------------------------------------------------------------------------------------------------------

function ReloadStart()
{
	PlayReloadStart();
	ClientReloadStart();
}

simulated function PlayReloadStart()
{
	PlayAnim('StartReload', 1.1, 0.04);
}

simulated function ClientReloadStart()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadStart();
		GoToState('ClientReloading');
	}
}

//---------------------------------------------------------------------------------------------------------------
function ReloadInsert()
{
	PlayReloadInsert();
	ClientReloadInsert();
}

simulated function PlayReloadInsert()
{
	PlayAnim('InsertShell', 1.7, 0.04);
}

simulated function ClientReloadInsert()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadInsert();
		GoToState('ClientReloading');
	}
}
//---------------------------------------------------------------------------------------------------------------
function ReloadEnd()
{
	PlayReloadEnd();
	ClientReloadEnd();
}

simulated function PlayReloadEnd()
{
	PlayAnim('EndReload', 1.3, 0.04);
}

simulated function ClientReloadEnd()
{
	if ( ( Role < ROLE_Authority ) )
	{
		PlayReloadEnd();
		GoToState('ClientReloading');
	}
}
//---------------------------------------------------------------------------------------------------------------

function Reload()
{
    if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
    {
    	GoToState('NewClip');
    	ClientReload();
    }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
     }
}

simulated state NewClip
{
	ignores AltFire, Reload;

Begin:
	ReloadStart();
	FinishAnim();
Shell:
	do
	{
		ReloadInsert();
		Owner.PlaySound(ReloadSounds[1], SLOT_Misc, Pawn(Owner).SoundDampening);
		FinishAnim();
		ClipCount++;
	} until (ClipCount >= Default.Clipcount)
	ReloadEnd();
	Sleep(0.25);
	Owner.PlaySound(ReloadSounds[0], SLOT_Misc, Pawn(Owner).SoundDampening);
	FinishAnim();
	Sleep(0.1);
	Finish();
	PlayAnim('Still', 1.5, 0.04);
	FinishAnim();
	GotoState('Idle');
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }
}

simulated state Idle
{
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle', 'Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local ShellsShotgun s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'ShellsShotgun', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 2.0;
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	}
}

defaultproperties
{
	FireAnims(0)=Fire1
	FireAnims(1)=Fire2
    ReloadSounds(0)=Sound'CS_v16_2.M3.M3Pump'
    ReloadSounds(1)=Sound'CS_v16_2.M3.M3Insert'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    EjectOffset=(X=25.000000,Y=10.000000,Z=-10.000000)
    FireSound=Sound'CS_v16_2.M3.M3Fire'
    HitDamage=20
    VRecoil=850.00
    HRecoil=0.90
    RecoilMultiplier=0.01
    ClipCount=8
    PickupAmmoCount=40
    AmmoName=Class'CS_v16_2.AmmoShotgun'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-10.000000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.700000
    RefireRate=0.800000
    AltRefireRate=0.900000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.110000
    FlashO=0.010000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
    AutoSwitchPriority=4
    InventoryGroup=3
    PickupMessage="You got a M3 Shotgun."
    ItemName="M3 Shotgun"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'M3Mesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'M3Pick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'M33rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.M3Muzz'
    MuzzleFlashScale=0.200000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'M3Pick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16_2.M3.M3Icon'
    StatusIcon=Texture'CS_v16_2.M3.M3Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}