class M249 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=M249Mesh MODELFILE=Models\M249\M249Mesh.psk
#exec MESH ORIGIN MESH=M249Mesh X=-1 Y=-3 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=M249Pick ANIVFILE=MODELS\M249\M249Pick_a.3d DATAFILE=MODELS\M249\M249Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M249Pick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=M2493rd ANIVFILE=MODELS\M249\M2493rd_a.3d DATAFILE=MODELS\M249\M2493rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=M2493rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=M249Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=M249Pick MESH=M249Pick
#exec MESHMAP SCALE MESHMAP=M249Pick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=M2493rd MESH=M2493rd
#exec MESHMAP SCALE MESHMAP=M2493rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=M249MeshAnims ANIMFILE=Models\M249\M249MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=199
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=Still STARTFRAME=32 NUMFRAMES=10
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=140
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=Fire STARTFRAME=184 NUMFRAMES=15
#exec ANIM SEQUENCE ANIM=M249MeshAnims SEQ=AfterFire STARTFRAME=190 NUMFRAMES=9

#exec ANIM DIGEST ANIM=M249MeshAnims
#exec MESH DEFAULTANIM MESH=M249Mesh ANIM=M249MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=M249Pick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=M249Pick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=M2493rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=M2493rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=M249MeshSkin00 FILE=Textures\M249\sight.bmp GROUP=M249 LODSET=2
#exec TEXTURE IMPORT NAME=M249MeshSkin01 FILE=Textures\M249\view_glove.bmp GROUP=M249 LODSET=2
#exec TEXTURE IMPORT NAME=M249MeshSkin02 FILE=Textures\M249\m249_skin1.bmp GROUP=M249 LODSET=2
#exec TEXTURE IMPORT NAME=M249MeshSkin03 FILE=Textures\M249\m249_skin2.bmp GROUP=M249 LODSET=2
#exec TEXTURE IMPORT NAME=M249MeshSkin04 FILE=Textures\M249\m249_skin3.bmp GROUP=M249 LODSET=2
#exec TEXTURE IMPORT NAME=M249MeshSkin05 FILE=Textures\M249\m249_skin4.bmp GROUP=M249 LODSET=2
#exec TEXTURE IMPORT NAME=M249W FILE=Textures\M249\w_m249.bmp GROUP=M249 LODSET=2

#exec TEXTURE IMPORT NAME=M249Icon FILE=Icons\Heavy\m249Icon.bmp GROUP=M249 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=0 TEXTURE=M249MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=1 TEXTURE=M249MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=2 TEXTURE=M249MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=3 TEXTURE=M249MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=4 TEXTURE=M249MeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=M249Mesh NUM=5 TEXTURE=M249MeshSkin05

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=M249Pick NUM=1 TEXTURE=M249W

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=M2493rd NUM=1 TEXTURE=M249W

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="M249Fire" FILE=Sounds\M249\m249_fire.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249Boxin" FILE=Sounds\M249\m249_boxin.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249BoxOut" FILE=Sounds\M249\m249_boxout.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249Chain" FILE=Sounds\M249\m249_chain.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249CoverDown" FILE=Sounds\M249\m249_coverdown.wav GROUP="M249"
#exec AUDIO IMPORT NAME="M249CoverUp" FILE=Sounds\M249\m249_coverup.wav GROUP="M249"

//=========================================================================================

#exec MESH IMPORT MESH=M249Muzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=M249Muzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=M249Muzz X=20 Y=1300 Z=-380 YAW=64
#exec MESH SEQUENCE MESH=M249Muzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=M249Muzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=M249Muzz MESH=M249Muzz
#exec MESHMAP SCALE MESHMAP=M249Muzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var Sound ReloadSounds[6];
var Texture RandFlash[6];

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(5)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	FinishAnim();
	Finish();
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
	 		bDrawMuzzleFlash = True; 
		}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);

	PlayAnim('Fire', 6, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if(PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(3.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

simulated function PlayReload()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Reload', 0.8, 0.05);
	}
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.8, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.5); 							
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.9);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.5); 							
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0); 							
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 246.00;
		else
			Penetration = 240.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.80;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	RandFlash(0)=Texture'CS_v16_2.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16_2.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16_2.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16_2.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16_2.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16_2.AK47.CSRifleMuzz6'
    ReloadSounds(0)=Sound'CS_v16_2.M249.M249CoverUp'
    ReloadSounds(1)=Sound'CS_v16_2.M249.M249BoxOut'
    ReloadSounds(2)=Sound'CS_v16_2.M249.M249Boxin'
    ReloadSounds(3)=Sound'CS_v16_2.M249.M249Chain'
    ReloadSounds(4)=Sound'CS_v16_2.M249.M249CoverDown'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.M249.M249Fire'
    EjectOffset=(X=20.000000,Y=10.000000,Z=-10.000000)
    HitDamage=42
    ClipCount=100
    PickupAmmoCount=200
    VRecoil=850.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16_2.AmmoMachine'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-10.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.800000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=700.000000
    bDrawMuzzleFlash=True
    MuzzleScale=1.000000
    FlashY=0.080000
    FlashO=0.010000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Skins.Flakmuz'
    AutoSwitchPriority=8
    InventoryGroup=8
    PickupMessage="You got a M249."
    ItemName="M249"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'M249Mesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'M249Pick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'M2493rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.M249Muzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'M249Pick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16_2.M249.M249Icon'
    StatusIcon=Texture'CS_v16_2.M249.M249Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}