class KevlarArmor extends Armor2;

#exec MESH IMPORT	 MESH=KevlarAr ANIVFILE=MODELS\Armors\Kevlar_a.3d DATAFILE=MODELS\Armors\Kevlar_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=KevlarAr HYSTERESIS=0.00 STRENGTH=1.00 MINVERTS=10.00 MORPH=0.30 ZDISP=0.00
#exec MESH ORIGIN    MESH=KevlarAr X=0 Y=0 Z=23 YAW=64 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=KevlarAr SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=KevlarAr SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW 	MESHMAP=KevlarAr MESH=KevlarAr
#exec MESHMAP SCALE MESHMAP=KevlarAr X=0.1 Y=0.1 Z=0.2

#exec TEXTURE IMPORT NAME=CSKevlar FILE=Textures\Armors\CSKevlar.bmp GROUP=KevlarArmor
#exec MESHMAP SETTEXTURE MESHMAP=KevlarAr NUM=0 TEXTURE=CSKevlar

#exec AUDIO IMPORT FILE=Sounds\Armors\KevlarArPickup.wav NAME=KevlarPickup GROUP=KevlarArmor

function PostBeginPlay()
{
     if(Class'CSMut16'.default.bAllAmbientGlow)
     {
          AmbientGlow = 64;
          bAmbientGlow = True;
     }
     else
     {
          AmbientGlow = 0;
          bAmbientGlow = False;
     }
     Super.PostBeginPlay();
}

defaultproperties
{
     AmbientGlow=0
     bDisplayableInv=True
     PickupMessage="You got the Kevlar Armor."
     ItemName="Kevlar Armor"
     RespawnTime=30.000000
     PickupViewMesh=LodMesh'CS_v16_2.KevlarAr'
     Charge=100
     ArmorAbsorption=75
     Physics=PHYS_Falling
     bIsAnArmor=True
     MultiSkins(1)=Texture'CS_v16_2.KevlarArmor.CSKevlar'
     AbsorptionPriority=7
     MaxDesireability=2.000000
     PickupSound=Sound'CS_v16_2.KevlarArmor.KevlarPickup'
     PickupViewScale=2.00
     DrawScale=2.00
     Mesh=LodMesh'CS_v16_2.KevlarAr'
     CollisionRadius=32.000000
     CollisionHeight=8.000000
}