class GrenadeSmokeProj extends GrenadeFlashProj;

#exec AUDIO IMPORT NAME="SmokeBooom" FILE=Sounds\SmokeGrenade\smoke_boom.wav GROUP="SmokeGrenade"

var bool bEnableSmokeTrail;

simulated function PostBeginPlay()
{
	bEnableSmokeTrail = False;
	Super.PostBeginPlay();
}

function SpawnGrenade()
{
	bEnableSmokeTrail = False;
	Super.SpawnGrenade();
}

simulated function BlowUp(vector HitLocation)
{
}

simulated function Explosion(vector HitLocation)
{
	local GrenadeSmokeGen f;

	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(Sound'SmokeBooom',,3.0,,2200);
	
	f = spawn(class'GrenadeSmokeGen',,,HitLocation);
	f.RemoteRole = ROLE_None;
	bEnableSmokeTrail = True;
	LifeSpan=10.00;
}

simulated function Tick(float DeltaTime)
{
	local UT_SpriteSmokePuff b;

	if(bEnableSmokeTrail)
	{
		if ( bHitWater || Level.bDropDetail ) 
		{
			Disable('Tick');
			return;
		}
		b = Spawn(class'UT_SpriteSmokePuff');
		b.RemoteRole = ROLE_None;
		b.DrawScale = 0.7;
	}
}

defaultproperties
{
	ImpactSound=Sound'CS_v16_2.FlashGrenade.FlashBounce'
	Mesh=LODMesh'CS_v16_2.SmokePick'
}