class GrenadeSmoke extends GrenadeFrag;

//=========================================================================================

#exec MESH MODELIMPORT MESH=GrenadeSmokeMesh MODELFILE=Models\SmokeGrenade\GrenadeSmokeMesh.psk
#exec MESH ORIGIN MESH=GrenadeSmokeMesh X=-1 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

#exec MESH IMPORT MESH=SmokePick ANIVFILE=MODELS\SmokeGrenade\SmokePick_a.3d DATAFILE=MODELS\SmokeGrenade\SmokePick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=SmokePick X=0 Y=-50 Z=18

#exec MESH IMPORT MESH=Smoke3rd ANIVFILE=MODELS\SmokeGrenade\Smoke3rd_a.3d DATAFILE=MODELS\SmokeGrenade\Smoke3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Smoke3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

#exec MESHMAP SCALE MESHMAP=GrenadeSmokeMesh X=1.0 Y=1.0 Z=1.0

#exec MESHMAP NEW MESHMAP=SmokePick MESH=SmokePick
#exec MESHMAP SCALE MESHMAP=SmokePick X=0.1 Y=0.1 Z=0.2

#exec MESHMAP NEW MESHMAP=Smoke3rd MESH=Smoke3rd
#exec MESHMAP SCALE MESHMAP=Smoke3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

#exec ANIM IMPORT ANIM=GrenadeSmokeMeshAnims ANIMFILE=Models\SmokeGrenade\GrenadeSmokeMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=97
#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=22
#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=Still STARTFRAME=23 NUMFRAMES=10
#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=Throw STARTFRAME=33 NUMFRAMES=23
#exec ANIM SEQUENCE ANIM=GrenadeSmokeMeshAnims SEQ=Pull STARTFRAME=57 NUMFRAMES=40

#exec ANIM DIGEST ANIM=GrenadeSmokeMeshAnims
#exec MESH DEFAULTANIM MESH=GrenadeSmokeMesh ANIM=GrenadeSmokeMeshAnims

#exec MESH SEQUENCE MESH=SmokePick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SmokePick SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESH SEQUENCE MESH=Smoke3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Smoke3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

#exec TEXTURE IMPORT NAME=SmokeBody FILE=Textures\SmokeGrenade\smoke_body.bmp GROUP=GrenadeSmoke LODSET=2
#exec TEXTURE IMPORT NAME=SmokeTop FILE=Textures\SmokeGrenade\smoke_top.bmp GROUP=GrenadeSmoke LODSET=2
#exec TEXTURE IMPORT NAME=SmokeSpoon FILE=Textures\SmokeGrenade\smoke_spoon.bmp GROUP=GrenadeSmoke LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeSmokeMeshSkin03 FILE=Textures\FragGrenade\view_glove.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeSmokeMeshSkin04 FILE=Textures\FragGrenade\view_skin.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeSmokeMeshSkin05 FILE=Textures\FragGrenade\view_finger.bmp GROUP=GrenadeFrag LODSET=2

#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=0 TEXTURE=SmokeBody
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=1 TEXTURE=SmokeTop
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=2 TEXTURE=SmokeSpoon
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=3 TEXTURE=GrenadeSmokeMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=4 TEXTURE=GrenadeSmokeMeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeSmokeMesh NUM=5 TEXTURE=GrenadeSmokeMeshSkin05

#exec MESHMAP SETTEXTURE MESHMAP=SmokePick NUM=1 TEXTURE=SmokeBody
#exec MESHMAP SETTEXTURE MESHMAP=SmokePick NUM=2 TEXTURE=SmokeTop

#exec MESHMAP SETTEXTURE MESHMAP=Smoke3rd NUM=1 TEXTURE=SmokeBody
#exec MESHMAP SETTEXTURE MESHMAP=Smoke3rd NUM=2 TEXTURE=SmokeTop

simulated function SpawnGrenade( float grenadeSpeed )
{
	Local GrenadeSmokeProj Grenade;
	local vector StartLoc, FireLocation, X, Y, Z;

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CalcDrawOffset(); 
	FireLocation = StartLoc + ThrowOffset.X * X + ThrowOffset.Y * Y + ThrowOffset.Z * Z; 
	Grenade = Spawn( class 'GrenadeSmokeProj',,, FireLocation, Pawn(Owner).ViewRotation);
	Grenade.Speed = grenadeSpeed;
	Grenade.SpawnGrenade();
	//NewGrenade();
}

defaultproperties
{
	ThrowOffset=(Y=7.000000)
	PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Misc1Sound=Sound'CS_v16_2.FragGrenade.GPull'
    FireSound=None
    HitDamage=0
    ClipCount=0
    VRecoil=0.00
    HRecoil=0.00
    RecoilMultiplier=0.00
    PickupAmmoCount=2
    AmmoName=Class'CS_v16_2.GrenadeSmokeAmmo'
    FireOffset=(X=0.00,Y=-11.600000),
	AIRating=0.200000
    RefireRate=0.700000
    AltRefireRate=0.900000
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a Smoke Grenade."
    ItemName="Smoke Grenade"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=4.00
    PlayerViewMesh=SkeletalMesh'CS_v16_2.GrenadeSmokeMesh'
    PickupViewMesh=LodMesh'CS_v16_2.SmokePick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CS_v16_2.Smoke3rd'
    ThirdPersonScale=1.90
    Mesh=LodMesh'CS_v16_2.SmokePick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16_2.GrenadeFlash.GFlashIcon'
    StatusIcon=Texture'CS_v16_2.GrenadeFlash.GFlashIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	Mass=10.00
}