class GrenadeFrag extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=GrenadeFragMesh MODELFILE=Models\FragGrenade\GrenadeFragMesh.psk
#exec MESH ORIGIN MESH=GrenadeFragMesh X=-1 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=FragPick ANIVFILE=MODELS\FragGrenade\FragPick_a.3d DATAFILE=MODELS\FragGrenade\FragPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FragPick X=0 Y=-50 Z=18

//3rd Person
#exec MESH IMPORT MESH=Frag3rd ANIVFILE=MODELS\FragGrenade\Frag3rd_a.3d DATAFILE=MODELS\FragGrenade\Frag3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Frag3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=GrenadeFragMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=FragPick MESH=FragPick
#exec MESHMAP SCALE MESHMAP=FragPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=Frag3rd MESH=Frag3rd
#exec MESHMAP SCALE MESHMAP=Frag3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=GrenadeFragMeshAnims ANIMFILE=Models\FragGrenade\GrenadeFragMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=97
#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=22
#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=Still STARTFRAME=23 NUMFRAMES=10
#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=Throw STARTFRAME=33 NUMFRAMES=23
#exec ANIM SEQUENCE ANIM=GrenadeFragMeshAnims SEQ=Pull STARTFRAME=57 NUMFRAMES=40

#exec ANIM DIGEST ANIM=GrenadeFragMeshAnims
#exec MESH DEFAULTANIM MESH=GrenadeFragMesh ANIM=GrenadeFragMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=FragPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FragPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=Frag3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Frag3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin00 FILE=Textures\FragGrenade\he_body.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin01 FILE=Textures\FragGrenade\he_top.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin02 FILE=Textures\FragGrenade\he_spoon.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin03 FILE=Textures\FragGrenade\view_glove.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin04 FILE=Textures\FragGrenade\view_skin.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFragMeshSkin05 FILE=Textures\FragGrenade\view_finger.bmp GROUP=GrenadeFrag LODSET=2

#exec TEXTURE IMPORT NAME=FragGBody FILE=Textures\FragGrenade\f_body.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=FragGTop FILE=Textures\FragGrenade\f_top.bmp GROUP=GrenadeFrag LODSET=2

#exec TEXTURE IMPORT NAME=GFragIcon FILE=Icons\Grenades\GrenadeFragIcon.bmp GROUP=GrenadeFrag MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=0 TEXTURE=GrenadeFragMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=1 TEXTURE=GrenadeFragMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=2 TEXTURE=GrenadeFragMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=3 TEXTURE=GrenadeFragMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=4 TEXTURE=GrenadeFragMeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFragMesh NUM=5 TEXTURE=GrenadeFragMeshSkin05

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=FragPick NUM=1 TEXTURE=FragGBody
#exec MESHMAP SETTEXTURE MESHMAP=FragPick NUM=2 TEXTURE=FragGTop

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Frag3rd NUM=1 TEXTURE=FragGBody
#exec MESHMAP SETTEXTURE MESHMAP=Frag3rd NUM=2 TEXTURE=FragGTop

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="GPull" FILE=Sounds\FragGrenade\pinpull.wav GROUP="FragGrenade"

//=========================================================================================

Var(CSWeapons) Vector ThrowOffset;

simulated function PostRender(Canvas C)
{
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	Sleep(0.5);
	//PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'PullMe')
		PlayPullPin();
	else if(EventType == 'ThrowMe')
		PlayThrow();
	else if(EventType == 'SelectMe')
		PlaySelection();
}

simulated function PlayPullPin()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Pull', 1.5, 0.04);
	}
}

simulated function PlayThrow()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Throw', 1.3, 0.04);
	}	
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',1.35, 0.04);
	}
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
		GiveAmmo(Pawn(Owner));

	if(AmmoType.UseAmmo(1))
	{
		bPointing=True;
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);
		bCanClientFire = True;
		ClientFire(Value);
		GoToState('NormalFire');
	}
}

Function AltFire(float Value)
{
	if(Pawn(Owner) != None)
		Pawn(Owner).bAltFire = 0;
}

state NormalFire
{
	ignores Fire, AltFire;

Begin:
	PlayAnim('Pull', 1.5, 0.04);
	if(Level.NetMode == NM_DedicatedServer)
		if(PlayerPawn(Owner) != None)
			PlayerPawn(Owner).ClientWeaponEvent('PullMe');
	Sleep(0.5);
	Owner.PlaySound(Misc1Sound);
	//FinishAnim();\
	PlayAnim('Throw', 1.0, 0.04);
	if(Level.NetMode == NM_DedicatedServer)
		if(PlayerPawn(Owner) != None)
			PlayerPawn(Owner).ClientWeaponEvent('ThrowMe');
	Sleep(0.45);
	SpawnGrenade(1400);
	//FinishAnim();
	Sleep(0.2);
	if(Level.NetMode == NM_DedicatedServer)
		if(PlayerPawn(Owner) != None)
			PlayerPawn(Owner).ClientWeaponEvent('SelectMe');
	PlayAnim('Select',1.35, 0.04);
	//FinishAnim();
	//GoTostate('Idle');
}

simulated function SpawnGrenade( float grenadeSpeed )
{
	local GrenadeFragProj Grenade;
	local vector StartLoc, FireLocation, X, Y, Z;

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CalcDrawOffset(); 
	FireLocation = StartLoc + ThrowOffset.X * X + ThrowOffset.Y * Y + ThrowOffset.Z * Z; 
	Grenade = Spawn( class 'GrenadeFragProj',,, FireLocation, Pawn(Owner).ViewRotation);
	Grenade.Speed = grenadeSpeed;
	Grenade.SpawnGrenade();
}

state Idle
{	
	Begin:
		PlayIdleAnim();
		if(AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
}

function Finish()
{
	local Pawn PawnOwner;

	if(bChangeWeapon)
	{
		GotoState('DownWeapon');
		return;
	}
	PawnOwner = Pawn(Owner);
	if(PlayerPawn(Owner)==None)
	{
		if(AmmoType.AmmoAmount<=0)
		{
			PawnOwner.StopFiring();
			PawnOwner.SwitchToBestWeapon();
			if(bChangeWeapon) GotoState('DownWeapon');
		}
		else if((PawnOwner.bFire != 0) && (FRand()<RefireRate))
			Global.Fire(0);
		else if((PawnOwner.bAltFire != 0) && (FRand()<AltRefireRate))
			Global.AltFire(0);
		else
		{ 
			PawnOwner.StopFiring();
			GotoState('Idle');
		}
		return;
	}
	if(AmmoType.AmmoAmount<=0 || PawnOwner.Weapon!=self)
		GotoState('Idle');
	else if(PawnOwner.bFire!=0)
		Global.Fire(0);
	else if(PawnOwner.bAltFire!=0)
		Global.AltFire(0);
	else GotoState('Idle');
}

defaultproperties
{
	ThrowOffset=(Y=7.000000)
	PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Misc1Sound=Sound'CS_v16_2.FragGrenade.GPull'
    FireSound=None
    HitDamage=0
    ClipCount=0
    VRecoil=0.00
    HRecoil=0.00
    RecoilMultiplier=0.00
    PickupAmmoCount=2
    AmmoName=Class'CS_v16_2.GrenadeFragAmmo'
    FireOffset=(X=0.00,Y=-11.600000),
	AIRating=0.200000
    RefireRate=0.700000
    AltRefireRate=0.900000
    bSplashDamage=True
    bRecommendSplashDamage=True
    bWarnTarget=True
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a HE Grenade."
    ItemName="HE Grenade"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=4.00
    PlayerViewMesh=SkeletalMesh'CS_v16_2.GrenadeFragMesh'
    PickupViewMesh=LodMesh'CS_v16_2.FragPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CS_v16_2.Frag3rd'
    ThirdPersonScale=1.90
    Mesh=LodMesh'CS_v16_2.FragPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16_2.GrenadeFrag.GFragIcon'
    StatusIcon=Texture'CS_v16_2.GrenadeFrag.GFragIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	Mass=10.00
}