class GrenadeFlashProj extends GrenadeFragProj;

#exec AUDIO IMPORT NAME="FlashBooom" FILE=Sounds\FlashGrenade\flash_boom.wav GROUP="FlashGrenade"
#exec AUDIO IMPORT NAME="FlashBounce" FILE=Sounds\FlashGrenade\flash_bounce.wav GROUP="FlashGrenade"

simulated function BlowUp(vector HitLocation)
{
}

//Credits: Wormbo
simulated function Explosion(vector HitLocation)
{
	local Pawn Victims;
	local float Distance, Direction, ScaledRadius;
	local Vector dir;
	local CSFlashBlindEffect FlashEffect;
	
	if ( bHurtEntry )
		return;

	if ( Level.NetMode != NM_DedicatedServer )
		Spawn(class'BlastMark',,,,rot(16384,0,0));

	For (Victims = Level.PawnList; Victims != None; Victims = Victims.NextPawn) 
	{
		dir = Victims.Location + vect(0,0,1) * Victims.EyeHeight;
		if ( (Victims.bIsPlayer || !Victims.IsA('StationaryPawn')) && FastTrace(HitLocation, dir) ) 
		{
			dir = HitLocation - dir;
			Distance = VSize(dir);
			Direction = vector(Victims.ViewRotation) dot Normal(dir);
			
			if ( Instigator != None )
				Distance /= Instigator.DamageScaling;
			if ( Instigator.IsA('Bot') && Bot(Instigator).bNovice )
				Distance *= 1;
			
			if ( Victims.bIsPlayer ) 
			{
				if ( Instigator.bIsPlayer
						&& Instigator.PlayerReplicationInfo.Team == Victims.PlayerReplicationInfo.Team )
					Distance *= 1;
				else if ( Instigator.IsA('StationaryPawn')
						&& StationaryPawn(Instigator).SameTeamAs(Victims.PlayerReplicationInfo.Team) )
					Distance *= 1;
			}
			
			FlashEffect = Spawn(class'CSFlashBlindEffect', Victims);
			if ( FlashEffect != None ) 
			{
				FlashEffect.GiveTo(Victims);
				FlashEffect.SetBlinding(Direction, Distance);
			}
		} 
	}

	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(Sound'FlashBooom',,3.0,,2200);

	Destroy();
}

simulated function Tick(float DeltaTime);

defaultproperties
{
	Damage=0.000000
	MomentumTransfer=0
	ImpactSound=Sound'CS_v16_2.FlashGrenade.FlashBounce'
	Mesh=LODMesh'CS_v16_2.FlashPick'
}