class GrenadeFlash extends GrenadeFrag;

//=========================================================================================

#exec MESH MODELIMPORT MESH=GrenadeFlashMesh MODELFILE=Models\FlashGrenade\GrenadeFlashMesh.psk
#exec MESH ORIGIN MESH=GrenadeFlashMesh X=-1 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

#exec MESH IMPORT MESH=FlashPick ANIVFILE=MODELS\FlashGrenade\FlashPick_a.3d DATAFILE=MODELS\FlashGrenade\FlashPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FlashPick X=0 Y=-50 Z=18

#exec MESH IMPORT MESH=Flash3rd ANIVFILE=MODELS\FlashGrenade\Flash3rd_a.3d DATAFILE=MODELS\FlashGrenade\Flash3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Flash3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

#exec MESHMAP SCALE MESHMAP=GrenadeFlashMesh X=1.0 Y=1.0 Z=1.0

#exec MESHMAP NEW MESHMAP=FlashPick MESH=FlashPick
#exec MESHMAP SCALE MESHMAP=FlashPick X=0.1 Y=0.1 Z=0.2

#exec MESHMAP NEW MESHMAP=Flash3rd MESH=Flash3rd
#exec MESHMAP SCALE MESHMAP=Flash3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

#exec ANIM IMPORT ANIM=GrenadeFlashMeshAnims ANIMFILE=Models\FlashGrenade\GrenadeFlashMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=97
#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=22
#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=Still STARTFRAME=23 NUMFRAMES=10
#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=Throw STARTFRAME=33 NUMFRAMES=23
#exec ANIM SEQUENCE ANIM=GrenadeFlashMeshAnims SEQ=Pull STARTFRAME=57 NUMFRAMES=40

#exec ANIM DIGEST ANIM=GrenadeFlashMeshAnims
#exec MESH DEFAULTANIM MESH=GrenadeFlashMesh ANIM=GrenadeFlashMeshAnims

#exec MESH SEQUENCE MESH=FlashPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FlashPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESH SEQUENCE MESH=Flash3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Flash3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

#exec TEXTURE IMPORT NAME=GrenadeFlashMeshSkin02 FILE=Textures\FragGrenade\he_spoon.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFlashMeshSkin03 FILE=Textures\FragGrenade\view_glove.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFlashMeshSkin04 FILE=Textures\FragGrenade\view_skin.bmp GROUP=GrenadeFrag LODSET=2
#exec TEXTURE IMPORT NAME=GrenadeFlashMeshSkin05 FILE=Textures\FragGrenade\view_finger.bmp GROUP=GrenadeFrag LODSET=2

#exec TEXTURE IMPORT NAME=FlashBody FILE=Textures\FlashGrenade\fl_body.bmp GROUP=GrenadeFlash LODSET=2
#exec TEXTURE IMPORT NAME=FlashTop FILE=Textures\FlashGrenade\fl_top.bmp GROUP=GrenadeFlash LODSET=2

#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=0 TEXTURE=FlashBody
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=1 TEXTURE=FlashTop
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=2 TEXTURE=GrenadeFlashMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=3 TEXTURE=GrenadeFlashMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=4 TEXTURE=GrenadeFlashMeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=GrenadeFlashMesh NUM=5 TEXTURE=GrenadeFlashMeshSkin05

#exec MESHMAP SETTEXTURE MESHMAP=FlashPick NUM=1 TEXTURE=FlashBody
#exec MESHMAP SETTEXTURE MESHMAP=FlashPick NUM=2 TEXTURE=FlashTop

#exec MESHMAP SETTEXTURE MESHMAP=Flash3rd NUM=1 TEXTURE=FlashBody
#exec MESHMAP SETTEXTURE MESHMAP=Flash3rd NUM=2 TEXTURE=FlashTop

//=========================================================================================

#exec TEXTURE IMPORT NAME=GFlashIcon FILE=Icons\Grenades\GrenadeSmokeIcon.bmp GROUP=GrenadeFlash MIPS=OFF

//=========================================================================================

simulated function SpawnGrenade( float grenadeSpeed )
{
	local GrenadeFlashProj Grenade;
	local vector StartLoc, FireLocation, X, Y, Z;

	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CalcDrawOffset(); 
	FireLocation = StartLoc + ThrowOffset.X * X + ThrowOffset.Y * Y + ThrowOffset.Z * Z; 
	Grenade = Spawn( class 'GrenadeFlashProj',,, FireLocation, Pawn(Owner).ViewRotation);
	Grenade.Speed = grenadeSpeed;
	Grenade.SpawnGrenade();
	//NewGrenade();
}

defaultproperties
{
	ThrowOffset=(Y=7.000000)
	PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	Misc1Sound=Sound'CS_v16_2.FragGrenade.GPull'
    FireSound=None
    HitDamage=0
    ClipCount=0
    VRecoil=0.00
    HRecoil=0.00
    RecoilMultiplier=0.00
    PickupAmmoCount=2
    AmmoName=Class'CS_v16_2.GrenadeFlashAmmo'
    FireOffset=(X=0.00,Y=-11.600000),
	AIRating=0.200000
    RefireRate=0.700000
    AltRefireRate=0.900000
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a Flash Grenade."
    ItemName="Flash Grenade"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=4.00
    PlayerViewMesh=SkeletalMesh'CS_v16_2.GrenadeFlashMesh'
    PickupViewMesh=LodMesh'CS_v16_2.FlashPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'CS_v16_2.Flash3rd'
    ThirdPersonScale=1.90
    Mesh=LodMesh'CS_v16_2.FlashPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16_2.GrenadeFlash.GFlashIcon'
    StatusIcon=Texture'CS_v16_2.GrenadeFlash.GFlashIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	Mass=10.00
}