class Glock extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=GlockMesh MODELFILE=Models\Glock\GlockMesh.psk
#exec MESH ORIGIN MESH=GlockMesh X=0 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=GlockPick ANIVFILE=MODELS\Glock\GlockPick_a.3d DATAFILE=MODELS\Glock\GlockPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=GlockPick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=Glock3rd ANIVFILE=MODELS\Glock\Glock3rd_a.3d DATAFILE=MODELS\Glock\Glock3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Glock3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales
//1st Person
#exec MESHMAP SCALE MESHMAP=GlockMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=GlockPick MESH=GlockPick
#exec MESHMAP SCALE MESHMAP=GlockPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=Glock3rd MESH=Glock3rd
#exec MESHMAP SCALE MESHMAP=Glock3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=GlockMeshAnims ANIMFILE=Models\Glock\GlockMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=195
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=50
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=Still STARTFRAME=51 NUMFRAMES=10
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=Reload STARTFRAME=62 NUMFRAMES=75
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=BurstFire STARTFRAME=138 NUMFRAMES=30
#exec ANIM SEQUENCE ANIM=GlockMeshAnims SEQ=Fire STARTFRAME=168 NUMFRAMES=26

#exec ANIM DIGEST ANIM=GlockMeshAnims
#exec MESH DEFAULTANIM MESH=GlockMesh ANIM=GlockMeshAnims

#exec ANIM NOTIFY ANIM=GlockMeshAnims SEQ=BurstFire Time=0.1 FUNCTION=BurstEffects
#exec ANIM NOTIFY ANIM=GlockMeshAnims SEQ=BurstFire Time=0.2 FUNCTION=BurstEffects

//Pickup
#exec MESH SEQUENCE MESH=GlockPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GlockPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=Glock3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=Glock3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=GlockMeshSkin00 FILE=Textures\Glock\glock_mag.bmp GROUP=Glock18 LODSET=2
#exec TEXTURE IMPORT NAME=GlockMeshSkin01 FILE=Textures\Glock\glock_slide.bmp GROUP=Glock18 LODSET=2
#exec TEXTURE IMPORT NAME=GlockMeshSkin02 FILE=Textures\Glock\glock_base.bmp GROUP=Glock18 LODSET=2
#exec TEXTURE IMPORT NAME=GlockMeshSkin03 FILE=Textures\Glock\glock_barrel.bmp GROUP=Glock18 LODSET=2
#exec TEXTURE IMPORT NAME=GlockMeshSkin04 FILE=Textures\Glock\view_glove.bmp GROUP=Glock18 LODSET=2
#exec TEXTURE IMPORT NAME=GlockMeshSkin05 FILE=Textures\Glock\view_skin.bmp GROUP=Glock18 LODSET=2
#exec TEXTURE IMPORT NAME=GlockMeshSkin06 FILE=Textures\Glock\view_finger.bmp GROUP=Glock18 LODSET=2
#exec TEXTURE IMPORT NAME=GlockW FILE=Textures\Glock\w_glock18.bmp GROUP=Glock18 LODSET=2

#exec TEXTURE IMPORT NAME=GlockIcon FILE=Icons\Pistols\GlockIcon.bmp GROUP=Glock18 MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=GlockMesh NUM=0 TEXTURE=GlockMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=GlockMesh NUM=1 TEXTURE=GlockMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=GlockMesh NUM=2 TEXTURE=GlockMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=GlockMesh NUM=3 TEXTURE=GlockMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=GlockMesh NUM=4 TEXTURE=GlockMeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=GlockMesh NUM=5 TEXTURE=GlockMeshSkin05
#exec MESHMAP SETTEXTURE MESHMAP=GlockMesh NUM=6 TEXTURE=GlockMeshSkin06

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=GlockPick NUM=1 TEXTURE=GlockW

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Glock3rd NUM=1 TEXTURE=GlockW

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="GlockFire" FILE=Sounds\Glock\Glock18_fire.wav GROUP="Glock"
#exec AUDIO IMPORT NAME="GlockBurst" FILE=Sounds\Glock\Glock18_Burst.wav GROUP="Glock"
#exec AUDIO IMPORT NAME="GlockReload" FILE=Sounds\Glock\Glock18_reload.wav GROUP="Glock"

//=========================================================================================

var() int FireMode;
var Sound ReloadSounds[3];

Replication
{
	Reliable if(bNetOwner && Role == ROLE_Authority)
		FireMode;
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0,0.04);
	Sleep(0.45);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
	ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',1.0,0.0);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.45);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[1], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.0);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));

	if(!Owner.IsA('Bot'))
	{
		if(FireMode == 0)
		{
			ClipCount--;
			if(ClipCount <= 0)
				ClipCount = 0;
			PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
			PlayAnim('Fire', 1.3, 0.04);
		}
		else if(FireMode == 1)
		{
			ClipCount --;
			if(ClipCount <= 0)
				ClipCount = 0;
			PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
			PlayAnim('BurstFire', 1.3, 0.04);
		}
	}
	else if(Owner.IsA('Bot') || (Owner.IsA('SkaarjTrooper')))
	{
		PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
		PlayAnim('Fire', 4.3, 0.04);
	}

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0)
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
		{
			if(FireMode == 0 && AmmoType.UseAmmo(1))
				GotoState('NormalFire');
			else if(FireMode == 1 && AmmoType.UseAmmo(1))
				GoToState('BurstFire');
		}
		else if(Owner.IsA('Bot') && AmmoType.UseAmmo(1))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			bMuzzleFlashParticles = False;
			bSteadyFlash3rd = False;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		bMuzzleFlashParticles = True;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.16);
	if (Pawn(Owner).bFire != 0)
	{
		bSteadyFlash3rd = False;
		bMuzzleFlashParticles = False;
		GoTo('Begin');
	}
	else
		Finish();
}

state BurstFire
{
	Ignores fire,altfire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.1);
	FlashCount++;
	Sleep(0.1);
	FlashCount++;
	FinishAnim();
	Finish();
}

simulated function BurstEffects()
{
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	SpawnShellCase(vect(10,-500,1));
	ClipCount--;

	if(ClipCount <= 0)
		ClipCount = 0;

	TraceFire(5.0);

	if(AmmoType != None)
		AmmoType.UseAmmo(1);

	if(PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

simulated function PlayAltFiring()
{
	PlayAnim('Still', 1.0, 0.04);
}

function AltFire(float Value)
{
	if(FireMode == 0 && ClipCount >= 3)
	{
		FireMode = 1;
		if((Pawn(Owner) != None) && (Pawn(Owner).PlayerReplicationInfo != None))
			Pawn(Owner).ReceiveLocalizedMessage(Class'GlockModeMessage',1,Pawn(Owner).PlayerReplicationInfo);
	}
	else if(FireMode == 1 && ClipCount >= 1)
	{
		FireMode = 0;
		if((Pawn(Owner) != None) && (Pawn(Owner).PlayerReplicationInfo != None))
			Pawn(Owner).ReceiveLocalizedMessage(Class'GlockModeMessage',0,Pawn(Owner).PlayerReplicationInfo);
	}

	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire;

Begin:
	Sleep(0.16);
	if (Pawn(Owner).bAltFire != 0)
		GoTo('Begin');
	Else
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(2.2);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(2.2);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 136.00;
		else
			Penetration = 120.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
    ReloadSounds(0)=Sound'CS_v16_2.Glock.GlockReload'
    ReloadSounds(1)=Sound'CS_v16_2.FiveSeven.FSSlidePull'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.Glock.GlockFire'
    AltFireSound=Sound'CS_v16_2.Glock.GlockBurst'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=16
    ClipCount=20
    PickupAmmoCount=60
    AmmoName=Class'CS_v16_2.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.200000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.132000
    FlashO=0.013500
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CS_v16_2.Deagle.PistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a Glock-18."
    ItemName="Glock-18"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'GlockMesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'GlockPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'Glock3rd'
    ThirdPersonScale=2.200000
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.PistolMuzz'
    MuzzleFlashScale=0.080000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'GlockPick'
    bNoSmooth=False
    DrawScale=3.000000
    Icon=Texture'CS_v16_2.Glock18.GlockIcon'
    StatusIcon=Texture'CS_v16_2.Glock18.GlockIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}