class FiveSeven extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=FiveSevenMesh MODELFILE=Models/FiveSeven/FiveSevenMesh.psk
#exec MESH ORIGIN MESH=FiveSevenMesh X=0 Y=-2 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=FiveSevenPick ANIVFILE=MODELS\FiveSeven\FiveSevenPick_a.3d DATAFILE=MODELS\FiveSeven\FiveSevenPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FiveSevenPick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=FiveSeven3rd ANIVFILE=MODELS\FiveSeven\FiveSeven3rd_a.3d DATAFILE=MODELS\FiveSeven\FiveSeven3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FiveSeven3rd X=0 Y=14 Z=-5 Yaw=128

//=========================================================================================

//Scales
//1st Person
#exec MESHMAP SCALE MESHMAP=FiveSevenMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=FiveSevenPick MESH=FiveSevenPick
#exec MESHMAP SCALE MESHMAP=FiveSevenPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=FiveSeven3rd MESH=FiveSeven3rd
#exec MESHMAP SCALE MESHMAP=FiveSeven3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=FiveSevenAnims ANIMFILE=Models\FiveSeven\FiveSevenMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=All STARTFRAME=0 NUMFRAMES=155
#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=Still STARTFRAME=32 NUMFRAMES=3
#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=Reload STARTFRAME=35 NUMFRAMES=96
#exec ANIM SEQUENCE ANIM=FiveSevenAnims SEQ=Fire STARTFRAME=132 NUMFRAMES=23

#exec ANIM DIGEST ANIM=FiveSevenAnims
#exec MESH DEFAULTANIM MESH=FiveSevenMesh ANIM=FiveSevenAnims

//Pickup
#exec MESH SEQUENCE MESH=FiveSevenPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FiveSevenPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=FiveSeven3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=FiveSeven3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=FiveSevenMeshSkin00 FILE=Textures\FiveSeven\fs1.bmp GROUP=FiveSeven LODSET=2
#exec TEXTURE IMPORT NAME=FiveSevenMeshSkin01 FILE=Textures\FiveSeven\fs2.bmp GROUP=FiveSeven LODSET=2
#exec TEXTURE IMPORT NAME=FiveSevenMeshSkin02 FILE=Textures\FiveSeven\view_glove.bmp GROUP=FiveSeven LODSET=2
#exec TEXTURE IMPORT NAME=FiveSevenMeshSkin03 FILE=Textures\FiveSeven\view_skin.bmp GROUP=FiveSeven LODSET=2
#exec TEXTURE IMPORT NAME=FiveSevenMeshSkin04 FILE=Textures\FiveSeven\view_finger.bmp GROUP=FiveSeven LODSET=2
#exec TEXTURE IMPORT NAME=FSProfile FILE=Textures\FiveSeven\57_Profile.bmp GROUP=FiveSeven LODSET=2

#exec TEXTURE IMPORT NAME=FSIcon FILE=Icons\Pistols\FiveSevenIcon.bmp GROUP=FiveSeven MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenMesh NUM=0 TEXTURE=FiveSevenMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenMesh NUM=1 TEXTURE=FiveSevenMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenMesh NUM=2 TEXTURE=FiveSevenMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenMesh NUM=3 TEXTURE=FiveSevenMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenMesh NUM=4 TEXTURE=FiveSevenMeshSkin04

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=FiveSevenPick NUM=1 TEXTURE=FSProfile

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=FiveSeven3rd NUM=1 TEXTURE=FSProfile

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="FSFire" FILE=Sounds\FiveSeven\FiveSeven_fire.wav GROUP="FiveSeven"
#exec AUDIO IMPORT NAME="FSClipIn" FILE=Sounds\FiveSeven\FiveSeven_clipin.wav GROUP="FiveSeven"
#exec AUDIO IMPORT NAME="FSClipOut" FILE=Sounds\FiveSeven\FiveSeven_clipout.wav GROUP="FiveSeven"
#exec AUDIO IMPORT NAME="FSSlidePull" FILE=Sounds\FiveSeven\FiveSeven_SlidePull.wav GROUP="FiveSeven"
#exec AUDIO IMPORT NAME="FSSlideRelease" FILE=Sounds\FiveSeven\FiveSeven_SlideRelease.wav GROUP="FiveSeven"

//=========================================================================================

var Sound ReloadSounds[5];

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',1.0,0.0);
	Sleep(0.5);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select',1.0,0.0);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.5);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.0, 0.0);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if(!Owner.IsA('Bot'))
		PlayAnim('Fire', 1.3, 0.04);
	else if(Owner.IsA('Bot'))
		PlayAnim('Fire', 4.3, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if ((PlayerPawn(Owner) != None))
		bMuzzleFlash++;
}

//simulated function TweenDown();
simulated function PlayFiring()
{
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		bCanClientFire = true;
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
        ClientFire(Value);
        if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			bMuzzleFlashParticles = False;
			bSteadyFlash3rd = False;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		bMuzzleFlashParticles = True;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.16);
	if (Pawn(Owner).bFire != 0)
	{
		bSteadyFlash3rd = False;
		bMuzzleFlashParticles = False;
		GoTo('Begin');
	}
	else
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4); 							
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4); 								
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 36.00;
		else
			Penetration = 20.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	ReloadSounds(0)=Sound'CS_v16_2.FiveSeven.FSClipOut'
    ReloadSounds(1)=Sound'CS_v16_2.FiveSeven.FSClipIn'
    ReloadSounds(2)=Sound'CS_v16_2.FiveSeven.FSSlidePull'
    ReloadSounds(3)=Sound'CS_v16_2.FiveSeven.FSSlideRelease'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.FiveSeven.FSFire'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    HitDamage=18
    ClipCount=20
    VRecoil=600.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    PickupAmmoCount=60
    AmmoName=Class'CS_v16_2.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.200000
    RefireRate=0.700000
    AltRefireRate=0.900000
    AimError=400.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.115000
    FlashO=0.015500
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CS_v16_2.Deagle.PistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a Five-Seven."
    ItemName="Five-Seven"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'FiveSevenMesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'FiveSevenPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'FiveSeven3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.PistolMuzz'
    MuzzleFlashScale=0.080000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'FiveSevenPick'
    Icon=Texture'CS_v16_2.FiveSeven.FSIcon'
    StatusIcon=Texture'CS_v16_2.FiveSeven.FSIcon'
    bNoSmooth=False
    DrawScale=3.000000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}