class Famas extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=FamasMesh MODELFILE=Models\Famas\FamasMesh.psk
#exec MESH ORIGIN MESH=FamasMesh X=4 Y=-2 Z=2 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=FamasPick ANIVFILE=MODELS\FAMAS\FamasPick_a.3d DATAFILE=MODELS\FAMAS\FamasPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FamasPick X=0 Y=0 Z=25

//3rd Person
#exec MESH IMPORT MESH=Famas3rd ANIVFILE=MODELS\FAMAS\Famas3rd_a.3d DATAFILE=MODELS\FAMAS\Famas3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Famas3rd X=5 Y=0 Z=-12 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=FamasMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=FamasPick MESH=FamasPick
#exec MESHMAP SCALE MESHMAP=FamasPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=Famas3rd MESH=Famas3rd
#exec MESHMAP SCALE MESHMAP=Famas3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=FamasMeshAnims ANIMFILE=Models\Famas\FamasMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=285
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=27
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=Still STARTFRAME=28 NUMFRAMES=131
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=Reload STARTFRAME=160 NUMFRAMES=98
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=Fire STARTFRAME=259 NUMFRAMES=26
#exec ANIM SEQUENCE ANIM=FamasMeshAnims SEQ=AfterFire STARTFRAME=268 NUMFRAMES=17

#exec ANIM DIGEST ANIM=FamasMeshAnims
#exec MESH DEFAULTANIM MESH=FamasMesh ANIM=FamasMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=FamasPick SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=FamasPick SEQ=Still STARTFRAME=0 NUMFRAMES=2

//3rd Person
#exec MESH SEQUENCE MESH=Famas3rd SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Famas3rd SEQ=Still STARTFRAME=0 NUMFRAMES=1

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=FAMASMeshSkin00 FILE=Textures\FAMAS\famasw.bmp GROUP=FAMAS LODSET=2
#exec TEXTURE IMPORT NAME=FAMASMeshSkin01 FILE=Textures\FAMAS\view_glove.bmp GROUP=FAMAS LODSET=2
#exec TEXTURE IMPORT NAME=FAMASMeshSkin02 FILE=Textures\FAMAS\view_finger.bmp GROUP=FAMAS LODSET=2
#exec TEXTURE IMPORT NAME=FAMASMeshSkin03 FILE=Textures\FAMAS\view_skin.bmp GROUP=FAMAS LODSET=2
#exec TEXTURE IMPORT NAME=FAMASW FILE=Textures\FAMAS\3rdfamas.bmp GROUP=FAMAS LODSET=2

#exec TEXTURE IMPORT NAME=FAMASIcon FILE=Icons\Rifles\FamasIcon.bmp GROUP=FAMAS MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=FamasMesh NUM=0 TEXTURE=FAMASMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=FamasMesh NUM=1 TEXTURE=FAMASMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=FamasMesh NUM=2 TEXTURE=FAMASMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=FamasMesh NUM=3 TEXTURE=FAMASMeshSkin03

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=FamasPick NUM=1 TEXTURE=FAMASW

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Famas3rd NUM=1 TEXTURE=FAMASW

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="FamasFire" FILE=Sounds\FAMAS\famas_fire.wav GROUP="FAMAS"
#exec AUDIO IMPORT NAME="FamasSelect" FILE=Sounds\FAMAS\famas_select.wav GROUP="FAMAS"
#exec AUDIO IMPORT NAME="FamasClipIn" FILE=Sounds\FAMAS\famas_clipin.wav GROUP="FAMAS"
#exec AUDIO IMPORT NAME="FamasClipOut" FILE=Sounds\FAMAS\famas_clipout.wav GROUP="FAMAS"
#exec AUDIO IMPORT NAME="FamasBurst" FILE=Sounds\FAMAS\famas_burst.wav GROUP="FAMAS"

//=========================================================================================

#exec MESH IMPORT MESH=FamasMuzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=FamasMuzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=FamasMuzz X=0 Y=900 Z=-200 YAW=64
#exec MESH SEQUENCE MESH=FamasMuzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=FamasMuzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=FamasMuzz MESH=FamasMuzz
#exec MESHMAP SCALE MESHMAP=FamasMuzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var() sound ReloadSounds[5];
var() int NumFire;
var() int BurstShots;
var Texture RandFlash[6];
var int FireMode;

Replication
{
	Reliable if(bNetOwner && Role==ROLE_Authority)
		FireMode;
}

simulated event RenderOverlays(canvas Canvas)
{
	MFTexture = RandFlash[Rand(5)];
	Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist, Rating;
	local Pawn P;

	P = Pawn(Owner);

	//No enemy, ready to fire
	if ( P.Enemy == None )
        return AIRating;

	//Don't recommend self if out of ammo
	if ( AmmoType.AmmoAmount <=0 )
        return -2;

	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

// Changed some stuff here to stop the anim playing twice
Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select',0.8,0.04);
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	if(Pawn(Owner) != None)
		Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 0.8, 0.04);
		GoToState('Selector');
	}
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[2], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		FinishAnim();
		Finish();
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.8, 0.04);
	GoToState('Selector');	
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', 11, 0.04);

	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if(PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

simulated function PlayFiring()
{
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		PlayFire();
		bPointing=True;
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);

		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(FireMode == 0)
			GotoState('NormalFire');
		else if(FireMode == 1)
			GoToState('BurstFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores Fire, AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner) != None)
		{
			if(Pawn(Owner).bFire == 0)
			{
				PlayAfterFire();
				GoToState('Idle');
			}
			else if(Pawn(Owner).bFire != 0)
			{
				Global.Fire(0.0);
			}
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

state BurstFire
{
	ignores Fire, AltFire;

	function AnimEnd()
   	{
   		NumFire--;
	    if (NumFire > 0)
	    {
	    	if(AmmoType != None)
	       		AmmoType.UseAmmo(1);
	       	TraceFire(0.1);
	       	PlayFire();
	    }
	    else if ( (Pawn(Owner) != None) && Pawn(Owner).bFire != 0)
	       	GoToState('Idle');
	}

	function BeginState()
   	{
   		NumFire = Min(AmmoType.AmmoAmount, burstShots);
      	Super.BeginState();
   	}

	Begin:
		FlashCount++;
		Sleep(0.1);
		FlashCount++;
		Sleep(0.1);
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientBurstFiring
{
	ignores Fire, AltFire;

	simulated function AnimEnd()
   	{
   		NumFire--;
	    if (NumFire > 0)
	    {
	       	AmmoType.UseAmmo(1);
	       	TraceFire(0.1);
	       	PlayFire();
	    }
	    else if ( (Pawn(Owner) != None) && Pawn(Owner).bFire != 0)
	       	GoToState('Idle');
	}

	simulated function BeginState()
   	{
   		NumFire = Min(AmmoType.AmmoAmount, burstShots);
      	Super.BeginState();
   	}

	Begin:
		FlashCount++;
		Sleep(0.1);
		FlashCount++;
		Sleep(0.1);
		FlashCount++;
		FinishAnim();
		Finish();
}

simulated function PlayAltFiring()
{
	PlayAnim('Still', 0.01);
}

function AltFire(float Value)
{
	if(FireMode == 0 && ClipCount >= 3)
	{
		FireMode = 1;
		if((Pawn(Owner) != None) && (Pawn(Owner).PlayerReplicationInfo != None))
			Pawn(Owner).ReceiveLocalizedMessage(Class'GlockModeMessage',1,Pawn(Owner).PlayerReplicationInfo);
	}
	else if(FireMode == 1 && ClipCount >= 1)
	{
		FireMode = 0;
		if((Pawn(Owner) != None) && (Pawn(Owner).PlayerReplicationInfo != None))
			Pawn(Owner).ReceiveLocalizedMessage(Class'GlockModeMessage',0,Pawn(Owner).PlayerReplicationInfo);
	}

	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Ignores Fire, AltFire;

	function AnimEnd()
	{
		if ( (Pawn(Owner) != None) && Pawn(Owner).bAltFire != 0)
	      	GoToState('Idle');
	}

Begin:
	Sleep(0.16);
	if (Pawn(Owner).bAltFire != 0)
		GoTo('Begin');
	Else
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.04);
}

simulated state NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Sleep(0.7);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.4);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
	Begin:
		if(isAnimating())
			FinishAnim();
		PlayIdleAnim();
		if(AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();
	Checks:
		if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
			Reload();
		Sleep(0.0);
		GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	LoopAnim('Still',1.0);
	GoToState('Idle', 'Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 236.00;
		else
			Penetration = 220.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	BurstShots=3
	RandFlash(0)=Texture'CS_v16_2.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16_2.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16_2.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16_2.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16_2.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16_2.AK47.CSRifleMuzz6'
	ReloadSounds(0)=Sound'CS_v16_2.FAMAS.FamasClipOut'
    ReloadSounds(1)=Sound'CS_v16_2.FAMAS.FamasClipIn'
    ReloadSounds(2)=Sound'CS_v16_2.FAMAS.FamasSelect'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.FAMAS.FamasFire'
    AltFireSound=Sound'CS_v16_2.FAMAS.FamasBurst'
    EjectOffset=(X=20.000000,Y=10.000000,Z=-10.000000)
    HitDamage=22
    ClipCount=25
    PickupAmmoCount=50
    AmmoName=Class'CS_v16_2.AmmoRifles'
    bInstantHit=True
    bAltInstantHit=True
    bRapidFire=True
    FireOffset=(X=0.00,Y=0.000000),
    MuzzleOffset=(X=0.00,Y=-11.600000)
    MyDamageType=shot
    VRecoil=450.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AltDamageType=Decapitated
    AIRating=0.730000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=500.000000
    bDrawMuzzleFlash=True
    MuzzleScale=1.000000
    FlashY=0.110000
    FlashO=0.010000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
	MFTexture=Texture'Botpack.Skins.Flakmuz'
    BobDamping=1.11
    AutoSwitchPriority=5
    InventoryGroup=5
    PickupMessage="You got a FAMAS."
    ItemName="FAMAS"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=3.00
    PlayerViewMesh=SkeletalMesh'CS_v16_2.FamasMesh'
    PickupViewMesh=LodMesh'FamasPick'
    PickupViewScale=2.00
    ThirdPersonMesh=LodMesh'Famas3rd'
    ThirdPersonScale=1.80
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.FamasMuzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'FamasPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16_2.Famas.FamasIcon'
    StatusIcon=Texture'CS_v16_2.Famas.FamasIcon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}