class DualElites extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=ElitesMesh MODELFILE=Models\DualElites\DualElitesMesh.psk
#exec MESH ORIGIN MESH=ElitesMesh X=0 Y=-2 Z=0.5 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=ElitesFirstPick ANIVFILE=MODELS\DualElites\DualElitesPick_a.3d DATAFILE=MODELS\DualElites\DualElitesPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ElitesFirstPick X=0 Y=0 Z=14

//3rd Person
#exec MESH IMPORT MESH=ElitesFirst3rd ANIVFILE=MODELS\DualElites\DualElites3rd_a.3d DATAFILE=MODELS\DualElites\DualElites3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ElitesFirst3rd X=-25 Y=0 Z=-9 Yaw=0

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=ElitesMeshAnims ANIMFILE=Models\DualElites\DualElitesMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=262
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=33
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=Still STARTFRAME=34 NUMFRAMES=8
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=Reload STARTFRAME=43 NUMFRAMES=137
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=FireLeft STARTFRAME=181 NUMFRAMES=40
#exec ANIM SEQUENCE ANIM=ElitesMeshAnims SEQ=FireRight STARTFRAME=222 NUMFRAMES=40

#exec ANIM DIGEST ANIM=ElitesMeshAnims
#exec MESH DEFAULTANIM MESH=ElitesMesh ANIM=ElitesMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=ElitesFirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ElitesFirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=ElitesFirst3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=ElitesFirst3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=ElitesMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=ElitesFirstPick MESH=ElitesFirstPick
#exec MESHMAP SCALE MESHMAP=ElitesFirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=ElitesFirst3rd MESH=ElitesFirst3rd
#exec MESHMAP SCALE MESHMAP=ElitesFirst3rd X=0.07 Y=0.07 Z=0.17

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=ElitesMeshSkin00 FILE=Textures\DualElites\handle.bmp GROUP=DualElites LODSET=2
#exec TEXTURE IMPORT NAME=ElitesMeshSkin01 FILE=Textures\DualElites\slide.bmp GROUP=DualElites LODSET=2
#exec TEXTURE IMPORT NAME=ElitesMeshSkin02 FILE=Textures\DualElites\barrel.bmp GROUP=DualElites LODSET=2
#exec TEXTURE IMPORT NAME=ElitesMeshSkin03 FILE=Textures\DualElites\magazine.bmp GROUP=DualElites LODSET=2
#exec TEXTURE IMPORT NAME=ElitesMeshSkin04 FILE=Textures\DualElites\view_glove.bmp GROUP=DualElites LODSET=2
#exec TEXTURE IMPORT NAME=ElitesMeshSkin05 FILE=Textures\DualElites\view_skin.bmp GROUP=DualElites LODSET=2
#exec TEXTURE IMPORT NAME=ElitesMeshSkin06 FILE=Textures\DualElites\view_finger.bmp GROUP=DualElites LODSET=2

#exec TEXTURE IMPORT NAME=ElitesPickup FILE=Textures\DualElites\ElitesPickup.bmp GROUP=DualElites LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMesh NUM=0 TEXTURE=ElitesMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMesh NUM=1 TEXTURE=ElitesMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMesh NUM=2 TEXTURE=ElitesMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMesh NUM=3 TEXTURE=ElitesMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMesh NUM=4 TEXTURE=ElitesMeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMesh NUM=5 TEXTURE=ElitesMeshSkin05
#exec MESHMAP SETTEXTURE MESHMAP=ElitesMesh NUM=6 TEXTURE=ElitesMeshSkin06

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=ElitesFirstPick NUM=1 TEXTURE=ElitesPickup

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=ElitesFirst3rd NUM=1 TEXTURE=ElitesPickup

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="EliteFire" FILE=Sounds\DualElites\elite_fire.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteDeploy" FILE=Sounds\DualElites\elite_deploy.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteClipOut" FILE=Sounds\DualElites\elite_clipout.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteRightClipIn" FILE=Sounds\DualElites\elite_rightclipin.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteLeftClipIn" FILE=Sounds\DualElites\elite_leftclipin.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteReloadStart" FILE=Sounds\DualElites\elite_reloadstart.wav GROUP="DualElites"
#exec AUDIO IMPORT NAME="EliteSlideRelease" FILE=Sounds\DualElites\elite_sliderelease.wav GROUP="DualElites"

//=========================================================================================

//Icons
#exec TEXTURE IMPORT NAME=ElitesIcon FILE=Icons\Pistols\DualElitesIcon.bmp GROUP=DualElites MIPS=OFF

//=========================================================================================

#exec MESH IMPORT MESH=ElitesMuzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=ElitesMuzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=ElitesMuzz X=0 Y=500 Z=-205 YAW=64
#exec MESH SEQUENCE MESH=ElitesMuzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=ElitesMuzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=ElitesMuzz MESH=ElitesMuzz
#exec MESHMAP SCALE MESHMAP=ElitesMuzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var byte AnimNo;
var float LFlashO;
var Sound ReloadSounds[5];

simulated event RenderOverlays( canvas Canvas )
{
	local int Hand;
	local PlayerPawn PlayerOwner;
	local bool bPlayerOwner;
	local rotator NewRot;
	local bool bHasInvisibility;
	
	if(PlayerPawn(Owner) != None)
		PlayerOwner = PlayerPawn(Owner);
	
	if ( PlayerOwner != None )
   	{
        if ( PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
            return;
        bPlayerOwner = true;
        Hand = PlayerOwner.Handedness;
		
		if (  (Level.NetMode == NM_Client) && (Hand == 2) )
        {
            bHideWeapon = true;
            return;
        }
   	}
	
	if ( !bPlayerOwner || (PlayerOwner.Player == None) )
      Pawn(Owner).WalkBob = vect(0,0,0);

   	if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash /*&& Level.bHighDetailMode*/ && (MFTexture != None) )
   	{
      	MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
      	if ( !bSetFlashTime )
      	{
         	bSetFlashTime = true;
         	FlashTime = Level.TimeSeconds + FlashLength;
      	}
      	else if ( FlashTime < Level.TimeSeconds )
         	bMuzzleFlash = 0;
      	if ( bMuzzleFlash > 0 )
      	{
      		if(AnimNo == 0)
      			FlashO = default.FlashO;
      		else if(AnimNo == 1)
      			FlashO = default.LFlashO;

         	//if ( Hand == 0 )
            	//Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
         	//else
            Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);

            Canvas.Style = 3;
            Canvas.DrawIcon(MFTexture, MuzzleScale);
            Canvas.Style = 1;
      	}
   	}
   	else
    	bSetFlashTime = false;

   	SetLocation( Owner.Location + CalcDrawOffset2());
   	NewRot = Pawn(Owner).ViewRotation;

    if ( Hand == 0 )
        newRot.Roll = -2 * Default.Rotation.Roll;
    else
        newRot.Roll = Default.Rotation.Roll * Hand;

   	setRotation(newRot);
   	Canvas.DrawActor(self, False, True);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 0.8, 0.04);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

State DownWeapon
{
ignores Fire, AltFire;

Begin:
	Pawn(Owner).ChangedWeapon();
	if (Owner.IsA('PlayerPawn'))
	{
		PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
		PlayerPawn(Owner).bRun = 0;
 		bDrawMuzzleFlash = True; 
	}
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.8, 0.04);
	PlayOwnedSound(SelectSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	GoToState('Selector');	
}

simulated state Selector
{
	ignores Fire, AltFire;

	Begin:
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(SelectSound, SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	if(!Owner.IsA('Bot'))
	{
		if(AnimNo == 0)
		{
			EjectOffset.Y = default.EjectOffset.Y;
			PlayAnim('FireRight', 0.7, 0.04);
			AnimNo++;
		}
		else if(AnimNo == 1)
		{
			EjectOffset.Y = -5.000000;
			PlayAnim('FireLeft', 0.7, 0.04);
			AnimNo = 0;	
		}
	}
	else if(Owner.IsA('Bot'))
	{
		if(AnimNo == 0)
		{
			PlayAnim('FireRight', 4.3, 0.04);
			AnimNo++;
		}
		else if(AnimNo == 1)
		{
			PlayAnim('FireLeft', 4.3, 0.04);
			AnimNo = 0;	
		}
	}
	
	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();

	ClipCount--;

	if(PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		TraceFire(2.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		if(!Owner.IsA('Bot'))
			GotoState('NormalFire');
		else if(Owner.IsA('Bot'))
			GotoState('BotNormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
	{
		//PlayReload();
		Reload();
	}
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state BotNormalFire
{
	ignores Fire, AltFire;

	function EndState()
	{
		OldFlashCount = FlashCount;
		Super.EndState();
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state NormalFire
{
	ignores Fire, AltFire;

	function AnimEnd()
	{
		if(Pawn(Owner).bFire != 0)
		{
			TweenToStill();
			bMuzzleFlashParticles = False;
			bSteadyFlash3rd = False;
		}
	}

	function EndState()
	{
		OldFlashCount = FlashCount;
		bMuzzleFlashParticles = True;
		Super.EndState();
	}

Begin:
	FlashCount++;
	Sleep(0.16);
	if (Pawn(Owner).bFire != 0)
	{
		bSteadyFlash3rd = False;
		bMuzzleFlashParticles = False;
		GoTo('Begin');
	}
	else
		Finish();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',0.8, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.9);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.2); 								
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.3);
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.67);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.9);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.2); 								
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.3);
		Owner.PlaySound(ReloadSounds[4], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.67);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.40);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 136.00;
		else
			Penetration = 120.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.50;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

simulated state Idle
{
	ignores AltFire;

	Begin:
		if(isAnimating())
			FinishAnim();
		PlayIdleAnim();
		if(AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();
	Checks:
		if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
			Reload();
		Sleep(0.0);
		GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still', 1.0);
	GoToState('Idle','Checks');
}

defaultproperties
{
	ReloadSounds(0)=Sound'CS_v16_2.DualElites.EliteReloadStart'
	ReloadSounds(1)=Sound'CS_v16_2.DualElites.EliteRightClipIn'
	ReloadSounds(2)=Sound'CS_v16_2.DualElites.EliteSlideRelease'
    ReloadSounds(3)=Sound'CS_v16_2.DualElites.EliteClipOut'
    ReloadSounds(4)=Sound'CS_v16_2.DualElites.EliteLeftClipIn'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.DualElites.EliteFire'
    SelectSound=Sound'CS_v16_2.DualElites.EliteDeploy'
    EjectOffset=(X=20.000000,Y=5.000000,Z=-5.000000)
    VRecoil=550.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    HitDamage=18
    ClipCount=30
    PickupAmmoCount=90
    AmmoName=Class'CS_v16_2.AmmoPistols'
    bInstantHit=True
    FireOffset=(Y=0.000000)
    MuzzleOffset=(Y=-11.600000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.250000
    RefireRate=0.700000
    AimError=300.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    FlashY=0.120000
    FlashO=0.012500
    LFlashO=-0.01000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'CS_v16_2.Deagle.PistolGenericMuzz'
    AutoSwitchPriority=2
    InventoryGroup=2
    PickupMessage="You got a Dual Elites."
    ItemName="Dual Elites"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'CS_v16_2.ElitesMesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'CS_v16_2.ElitesFirstPick'
    PickupViewScale=3.00
    ThirdPersonMesh=LodMesh'CS_v16_2.ElitesFirst3rd'
    ThirdPersonScale=2.20
    bMuzzleFlashParticles=True
    bSteadyFlash3rd=False
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.ElitesMuzz'
    MuzzleFlashScale=0.080000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'CS_v16_2.ElitesFirstPick'
    bNoSmooth=False
    Icon=Texture'CS_v16_2.DualElites.ElitesIcon'
    StatusIcon=Texture'CS_v16_2.DualElites.ElitesIcon'
    DrawScale=3.000000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
    Mass=10.00
}