class CSWeapons16 extends TournamentWeapon
	abstract;

#exec AUDIO IMPORT NAME="CSGPick" FILE=Sounds\PickupSounds\CSGunPickup.wav GROUP="GeneralPickup"

var(CSWeapons) int ClipCount, HitDamage;
var(CSWeapons) float VRecoil, HRecoil;
var(CSWeapons) float RecoilMultiplier;		
var(CSWeapons) float RecoilVal;
var(CSWeapons) vector EjectOffset;
var(CSWeapons) vector MuzzleOffset;

var localized string MyClip;

Replication
{
	Reliable if(Role == ROLE_Authority)
		ClipCount, HitDamage, HRecoil, VRecoil, RecoilMultiplier, RecoilVal, EjectOffset, ClientReload, PlayerFire, PlayerAltFire, MuzzleOffset;
}

function PostBeginPlay()
{
	if(Class'CSMut16'.default.bAllAmbientGlow)
	{
		AmbientGlow = 64;
		bAmbientGlow = True;
	}
	else
	{
		AmbientGlow = 0;
		bAmbientGlow = False;
	}

	Switch(Class'CSMut16'.default.GunPickupSoundType)
	{
		Case 0:
			PickupSound = Sound'CSGPick';
			break;
		Case 1:
			PickupSound = default.PickupSound;
			break;
	}
    
    Super.PostBeginPlay();
}

simulated function PostRender(canvas Canvas)
{
	local int X, Y;
	local PlayerPawn PL;
	local ChallengeHUD HUD;

    Super.PostRender(Canvas);
     
    if(Class'CSMut16'.default.bEnableCrosshair)
        bOwnsCrosshair = False;
    else
        bOwnsCrosshair = True;

    PL = PlayerPawn(Owner);

	if(PL != None)
	{
		HUD = ChallengeHUD(PL.myHUD);
		if(HUD != None)
		{
			Canvas.Style = HUD.Style;
			Canvas.DrawColor = HUD.HUDColor;
			if ( (HUD.HudScale * HUD.WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * HUD.Scale) )
        Y = Canvas.ClipY - 127.5 * HUD.Scale;
      else
        Y = Canvas.ClipY - 191.5 * HUD.Scale;
			
			X = Canvas.ClipX - 128 * HUD.Scale;
			Canvas.SetPos(X, Y);
			Canvas.DrawTile(Texture'BotPack.HudElements1', 128*HUD.Scale, 64*HUD.Scale, 128, 192, 128.0, 64.0);

			if ( (PL.Weapon == None) || (PL.Weapon.AmmoType == None) )
				return;

			Canvas.DrawColor = HUD.GoldColor;
			HUD.DrawBigNum(Canvas, ClipCount, X + 4 * HUD.Scale, Y + 16 * HUD.Scale);
		}
	}
}

simulated event RenderOverlays( canvas Canvas )
{
	local int Hand;
	local PlayerPawn PlayerOwner;
	local bool bPlayerOwner;
	local rotator NewRot;
	local bool bHasInvisibility;
	
	if(PlayerPawn(Owner) != None)
		PlayerOwner = PlayerPawn(Owner);
	
	if ( PlayerOwner != None )
        {
        if ( PlayerOwner.DesiredFOV != PlayerOwner.DefaultFOV )
            return;
        bPlayerOwner = true;
        Hand = PlayerOwner.Handedness;
		
		if (  (Level.NetMode == NM_Client) && (Hand == 2) )
          {
               bHideWeapon = true;
               return;
          }
        }
	
     if(PlayerOwner != None)
     {
     	if ( !bPlayerOwner || (PlayerOwner.Player == None) )
             Pawn(Owner).WalkBob = vect(0,0,0);

          if ( (bMuzzleFlash > 0) && bDrawMuzzleFlash /*&& Level.bHighDetailMode*/ && (MFTexture != None) )
          {
               MuzzleScale = Default.MuzzleScale * Canvas.ClipX/640.0;
               if ( !bSetFlashTime )
               {
                    bSetFlashTime = true;
                    FlashTime = Level.TimeSeconds + FlashLength;
               }
               else if ( FlashTime < Level.TimeSeconds )
                    bMuzzleFlash = 0;
               if ( bMuzzleFlash > 0 )
               {
                    if ( Hand == 0 )
                         Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
                    else
                         Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);

                    Canvas.Style = 3;
                    Canvas.DrawIcon(MFTexture, MuzzleScale);
                    Canvas.Style = 1;
               }
          }
          else
               bSetFlashTime = false;
     }

     if(Pawn(Owner) != None)
     {
          SetLocation( Owner.Location + CalcDrawOffset2() );
          NewRot = Pawn(Owner).ViewRotation;

          if ( Hand == 0 )
               newRot.Roll = -2 * Default.Rotation.Roll;
          else
               newRot.Roll = Default.Rotation.Roll * Hand;

          setRotation(newRot);
          Canvas.DrawActor(self, False, True);
     }
}

simulated final function vector CalcDrawOffset2()
{
	local vector DrawOffset, WeaponBob;
	local PlayerPawn PawnOwner;

	if(Owner.IsA('PlayerPawn'))
	{
		PawnOwner = PlayerPawn(Owner);
		DrawOffset = ((0.01 * PlayerViewOffset) >> PawnOwner.ViewRotation);

		if ( (Level.NetMode == NM_DedicatedServer) 
			|| ((Level.NetMode == NM_ListenServer) && (Owner.RemoteRole == ROLE_AutonomousProxy)) )
			DrawOffset += (PawnOwner.BaseEyeHeight * vect(0,0,1));
		else
		{	
			DrawOffset += (PawnOwner.EyeHeight * vect(0,0,1));
			WeaponBob = BobDamping * PawnOwner.WalkBob;
			WeaponBob.Z = (0.45 + 0.55 * BobDamping) * PawnOwner.WalkBob.Z;
			DrawOffset += WeaponBob;
		}
		return DrawOffset;
	}
}

function Finish()
{
     local Pawn PawnOwner;
     local bool bForce, bForceAlt;

     bForce = bForceFire;
     bForceAlt = bForceAltFire;
     bForceFire = false;
     bForceAltFire = false;

     if ( bChangeWeapon )
     {
          GotoState('DownWeapon');
          return;
     }

     PawnOwner = Pawn(Owner);
     if ( PawnOwner == None )
          return;

     if ( PlayerPawn(Owner) == None )
     {
          if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0 && ClipCount <=0) )
          {
               PawnOwner.StopFiring();
               PawnOwner.SwitchToBestWeapon();

               if ( bChangeWeapon )
                    GotoState('DownWeapon');
          }
          else if ( (PawnOwner.bFire != 0) && (FRand() < RefireRate) )
               Global.Fire(0);
          else if ( (PawnOwner.bAltFire != 0) && (FRand() < AltRefireRate) )
               Global.AltFire(0);  
          else 
          {
               PawnOwner.StopFiring();
               GotoState('Idle');
          }
          return;
     }
     if ( ((AmmoType != None) && (AmmoType.AmmoAmount<=0 && ClipCount<=0)) || (PawnOwner.Weapon != self) )
          GotoState('Idle');
     else if ( (PawnOwner.bFire!=0) || bForce )
          Global.Fire(0);
     else if ( (PawnOwner.bAltFire!=0) || bForceAlt )
          Global.AltFire(0);
     else 
          GotoState('Idle');
}

simulated function PlayFiring()
{
	if ( Affector != None )
		Affector.FireEffect();

	if (Level.NetMode != NM_DedicatedServer)
		if(Class'CSMut16'.default.bEnableRecoil)
		  Recoil();
}

simulated function bool ClientFire( float Value )
{
  if ( bCanClientFire && ((Role == ROLE_Authority) || (AmmoType == None) || (AmmoType.AmmoAmount > 0)) )
  {
    if ( (PlayerPawn(Owner) != None) 
      && ((Level.NetMode == NM_Standalone) || PlayerPawn(Owner).Player.IsA('ViewPort')) )
    {
      if ( InstFlash != 0.0 )
        PlayerPawn(Owner).ClientInstantFlash( InstFlash, InstFog);
      PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
    }
    if ( Affector != None )
      Affector.FireEffect();
    PlayFiring();
    if ( Role < ROLE_Authority )
      GotoState('ClientFiring');
    return true;
  }
  return false;
}

simulated function Recoil()
{
	local float RecoilYaw;
	local PlayerPawn PO;
	local float VH, VV;
	local Vector v;

    if(!Owner.IsA('Bot') || !Owner.IsA('SkaarjTrooper'))
    {
        if (PlayerPawn(Owner) == None) 
    		return;

    	PO = PlayerPawn(Owner);
    	
    	// Tweak Player aiming
    	v = PO.Velocity;
    	v.z = 0;

    	VV = 1 + Abs(PO.Velocity.Z) / 150;
    	VH = 1 + VSize(V) / 200;
     
    	RecoilVal = (RecoilVal * RecoilMultiplier) + VRecoil;
    	//RecoilVal += RecoilVal * VSize(PO.Velocity) / 300;

    	//if (Shotcount < 2)
    		//rPower = 0.8;

    	if (PO.bPressedJump)
    		RecoilVal *= 1 +  2 * FRand();

      	if (!(PO.ViewRotation.Pitch > 17000 && PO.ViewRotation.Pitch < 48000))
        	PO.ViewRotation.Pitch += RecoilVal / 4 * VV;

    	if (VRecoil > 0)
    	{
    		RecoilYaw = FRand();

    		if (RecoilYaw > 0.5)
          		PO.ViewRotation.Yaw += RecoilVal/10 * HRecoil * VH;
    		else
          		PO.ViewRotation.Yaw -= RecoilVal/10 * HRecoil * VH;
    	}
    }
	//if (rPower < 1.5)
		//rPower += 0.2;
}

simulated function TweenDown()
{
}

simulated function PlayAltFiring()
{
	PlayAnim('Still', 100.0, 0.04);
}

function AltFire(float value)
{
	GotoState('AltFiring');
	bPointing=True;
	bCanClientFire = true;
	ClientAltFire(Value);
}

state AltFiring
{
	Begin:
		FinishAnim();
		Finish();
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function JustFire()
{
	PlayAnim('Fire', 1.3, 0.04);
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

function PlayAltFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustAltFire();
		PlayerAltFire();
	}
}

simulated function JustAltFire()
{
	PlayAnim('Fire', 1.3, 0.04);
}

simulated function PlayerAltFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustAltFire();
}

function Reload()
{
     if ((AmmoType.AmmoAmount>0) && (ClipCount < Default.ClipCount)) 
     {
          Reload();
          ClientReload();
     }
}

simulated function ClientReload()
{
     if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
     {
          GoToState('ClientReloading');
          PlayReloading();
     }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None))
          return;
     PlayAnim('Reload',1.0, 0.05);
}

state ClientReloading
{
     simulated function bool ClientFire(float Value)
     {
          return false;
     }

     simulated function bool ClientAltFire(float Value)
     {
          return false;
     }

     Begin:
          ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
          FinishAnim();
          Finish();
}

defaultproperties
{
	shakemag=0.000000
    shaketime=0.000000
    shakevert=0.000000
	AmbientGlow=0
	bAmbientGlow=False
	bNoSmooth=False
	Physics=PHYS_Falling
	PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	DrawScale=1.00
	bFixedRotationDir=True
    RotationRate=(Roll=0,Yaw=0,Pitch=0)
    DesiredRotation=(Roll=0,Yaw=0,Pitch=0)
}