//=============================================================================
// CS Weapons v1.6 Mutator, SpEcTra_7
//=============================================================================
class CSMut16 extends Mutator
	config(CS_v16_2);

var config string DefaultCSWeapon;
var config string DefaultShotgunWeapon;
var config string DefaultSMGWeapon;
var config string DefaultRifleWeapon;
var config string DefaultSniperWeapon;
var config bool bEnableRecoil;
var config bool bAllAmbientGlow;
var config bool bEnableCrosshair;
var config bool bRespawnWithRandomPistols;
var config bool bRandomPistolReplacement;
var config bool bRandomShotgunReplacement;
var config bool bRandomSMGReplacement;
var config bool bRandomRiflesReplacement;
var config bool bRandomSniperReplacement;
var config bool bBulletPenetration;
var config bool bReplaceOldSkoolWeapons;
var config byte GunPickupSoundType;
var config byte AmmoPickupSoundType;

var bool bFixedSkaarj;
var Class<CSWeapons16> SkaarjWeapons[8];

native(1718) final function bool AddToPackageMap( optional string PkgName);

function PostBeginPlay()
{
	local Actor Other, W, NewW;
	local class<Actor> NewWeaponClass;
	
	Log("===========================================================================");
	Log("|| Counter Strike 1.6 Weapons Version 2.0 - Mutator is active! -By SpEcTra_7 ||");
	Log("===========================================================================");

	if(bEnableRecoil)
		Log("Weapons Recoil is enabled!!");
	else
		Log("Weapons Recoil is disabled!!");

	if(bAllAmbientGlow)
		Log("Weapons, Ammo, Pickups ambient glow is enabled!!");
	else
		Log("Weapons, Ammo, Pickups ambient glow is disabled!!");

	if(bEnableCrosshair)
		Log("Crosshair is enabled!!");
	else
		Log("Crosshair is disabled!!");

	if(bRespawnWithRandomPistols)
		Log("Respawn with Random Pistols enabled!!");
	else
	{
		if(DefaultCSWeapon != "")
			Log("Respawn with Random Pistols is disabled!! Setting weapon by 'DefaultCSWeapon'");
		else
			Log("'DefaultCSWeapon' is not set!! Setting USP as default pistol!!");
	}

	if(bRandomPistolReplacement)
		Log("Random Pistols replacement enabled!!");
	else
		Log("Random Pistols replacement disabled!!");

	if(bRandomShotgunReplacement)
		Log("Random Shotguns replacement enabled!!");
	else
	{
		if(DefaultShotgunWeapon != "")
			Log("Random Shotguns replacement disabled!! Setting Shotgun by 'DefaultShotgunWeapon'");
		else
			Log("'DefaultShotgunWeapon' is not set!! Setting M3 as default Shotgun!");
	}

	if(bRandomSMGReplacement)
		Log("Random SMG replacement enabled!!");
	else
	{
		if(DefaultSMGWeapon != "")
			Log("Random SMG replacement disabled!! Setting SMG by 'DefaultSMGWeapon'");
		else
			Log("'DefaultSMGWeapon' is not set!! Setting MP5 as default SMG!!");
	}

	if(bRandomRiflesReplacement)
		Log("Random Rifles replacement enabled!!");
	else
	{
		if(DefaultRifleWeapon != "")
			Log("Random Rifles replacement disabled!! Setting Rifles by 'DefaultRifleWeapon'");
		else
			Log("'DefaultRifleWeapon' is not set!! Setting M4A1 as default Rifle!!");
	}

	if(bRandomSniperReplacement)
		Log("Random Sniper Rifles replacement enabled!!");
	else
	{
		if(DefaultSniperWeapon != "")
			Log("Random Sniper Rifles replacement disabled!! Setting Sniper by 'DefaultSniperWeapon'");
		else
			Log("'DefaultSniperWeapon' is not set!! Setting AWP as default Sniper!!");
	}

	if(bBulletPenetration)
		Log("Bodies and wall penetration enabled!!");
	else
		Log("Bodies and wall penetration disabled!!");

	if(bReplaceOldSkoolWeapons)
		Log("Old Skool weapons replacement enabled!!");
	else
		Log("Old Skool weapons replacement disabled!!");

	Log("===========================================================================");

	foreach AllActors(Class'Actor', Other)
	{
		ActorTweaking(Other);
	}

	ForEach AllActors(Class'Actor', W)
	{
		if ( ((W.IsA('DispersionPistol') && bReplaceOldSkoolWeapons) || W.IsA('ImpactHammer')) && Pawn(W.Owner)==None )
		{
			NewW = Spawn(Class'Knife',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( ((W.IsA('AutoMag') && bReplaceOldSkoolWeapons) || W.IsA('Enforcer')) && Pawn(W.Owner)==None )
		{
			if(bRandomPistolReplacement)
				NewW = Spawn(Class'RandPistolReplacer',,, W.Location, W.Rotation);
			else
				NewW = Spawn(Class'USP',,, W.Location, W.Rotation);
			
			W.Destroy();
		}
		else if ( ((W.IsA('GESBioRifle') && bReplaceOldSkoolWeapons) || W.IsA('UT_BioRifle')))
		{
			if(bRandomShotgunReplacement)
				NewW = Spawn(Class'RandShotgunReplacer',,, W.Location, W.Rotation);
			else
			{
				if(DefaultShotgunWeapon != "")
				{
					NewWeaponClass = class<Actor>(DynamicLoadObject( DefaultShotgunWeapon, class'Class' ));
					NewW = Spawn(NewWeaponClass,,, W.Location, W.Rotation);
				}
				else
					NewW = Spawn(Class'M3',,, W.Location, W.Rotation);
			}
			
			W.Destroy();
		}
		else if ( ((W.IsA('ASMD') && bReplaceOldSkoolWeapons) || W.IsA('ShockRifle')))
		{
			if(bRandomSMGReplacement)
				NewW = Spawn(Class'RandSMGReplacer',,, W.Location, W.Rotation);
			else
			{
				if(DefaultSMGWeapon != "")
				{
					NewWeaponClass = class<Actor>(DynamicLoadObject( DefaultSMGWeapon, class'Class' ));
					NewW = Spawn(NewWeaponClass,,, W.Location, W.Rotation);
				}
				else
					NewW = Spawn(Class'MP5',,, W.Location, W.Rotation);
			}
			
			W.Destroy();
		}
		else if ( ((W.IsA('Stinger') && bReplaceOldSkoolWeapons) || W.IsA('Pulsegun')))
		{
			if(bRandomRiflesReplacement)
				NewW = Spawn(Class'RandRiflesReplacer',,, W.Location, W.Rotation);
			else
			{
				if(DefaultRifleWeapon != "")
				{
					NewWeaponClass = class<Actor>(DynamicLoadObject( DefaultRifleWeapon, class'Class' ));
					NewW = Spawn(NewWeaponClass,,, W.Location, W.Rotation);
				}
				else
					NewW = Spawn(Class'M4A1',,, W.Location, W.Rotation);
			}
			
			W.Destroy();
		}
		else if ( ((W.IsA('Razorjack') && bReplaceOldSkoolWeapons) || W.IsA('Ripper')))
		{
			NewW = Spawn(Class'RandGrenadesReplacer',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( ((W.IsA('Minigun') && bReplaceOldSkoolWeapons) || W.IsA('minigun2')))
		{
			if(bRandomRiflesReplacement)
				NewW = Spawn(Class'RandRifles2Replacer',,, W.Location, W.Rotation);
			else
			{
				if(DefaultRifleWeapon != "")
				{
					NewWeaponClass = class<Actor>(DynamicLoadObject( DefaultRifleWeapon, class'Class' ));
					NewW = Spawn(NewWeaponClass,,, W.Location, W.Rotation);
				}
				else
					NewW = Spawn(Class'Aug',,, W.Location, W.Rotation);
			}
			
			W.Destroy();
		}
		else if ( ((W.IsA('FlakCannon') && bReplaceOldSkoolWeapons) || W.IsA('UT_FlakCannon')))
		{
			NewW = Spawn(Class'M249',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( ((W.IsA('Eightball') && bReplaceOldSkoolWeapons) || W.IsA('UT_Eightball')))
		{
			if(bRandomRiflesReplacement)
				NewW = Spawn(Class'RandRifles2Replacer',,, W.Location, W.Rotation);
			else
			{
				if(DefaultRifleWeapon != "")
				{
					NewWeaponClass = class<Actor>(DynamicLoadObject( DefaultRifleWeapon, class'Class' ));
					NewW = Spawn(NewWeaponClass,,, W.Location, W.Rotation);
				}
				else
					NewW = Spawn(Class'SG550',,, W.Location, W.Rotation);
			}
			
			W.Destroy();
		}
		else if ( ((W.IsA('Rifle') && bReplaceOldSkoolWeapons) || W.IsA('SniperRifle')))
		{
			if(bRandomRiflesReplacement)
				NewW = Spawn(Class'RandSniperReplacer',,, W.Location, W.Rotation);
			else
			{
				if(DefaultSniperWeapon != "")
				{
					NewWeaponClass = class<Actor>(DynamicLoadObject( DefaultSniperWeapon, class'Class' ));
					NewW = Spawn(NewWeaponClass,,, W.Location, W.Rotation);
				}
				else
					NewW = Spawn(Class'AWP',,, W.Location, W.Rotation);
			}
			
			W.Destroy();
		}
		else if ( W.IsA('WarHeadLauncher'))
		{
			NewW = Spawn(Class'C4',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( W.IsA('SuperShockRifle'))
		{
			NewW = Spawn(Class'AWP',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( W.IsA('WarHeadAmmo') )
		{
			NewW = Spawn(Class'AmmoC4',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('Clip') && bReplaceOldSkoolWeapons) || W.IsA('EClip'))
		{
			NewW = Spawn(Class'AmmoPistols',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('Sludge') && bReplaceOldSkoolWeapons) || W.IsA('BioAmmo'))
		{
			NewW = Spawn(Class'AmmoShotgun',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('ASMDAmmo') && bReplaceOldSkoolWeapons) || W.IsA('ShockCore'))
		{
			NewW = Spawn(Class'AmmoSMG',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('StingerAmmo') && bReplaceOldSkoolWeapons) || W.IsA('PAmmo') )
		{
			NewW = Spawn(Class'AmmoRifles',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('RazorAmmo') && bReplaceOldSkoolWeapons) || W.IsA('BladeHopper') )
		{
			NewW = Spawn(Class'RandGrenadesReplacer',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('ShellBox') && bReplaceOldSkoolWeapons) || W.IsA('MiniAmmo') )
		{
			NewW = Spawn(Class'AmmoRifles',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('FlakBox') && bReplaceOldSkoolWeapons) || W.IsA('FlakAmmo') )
		{
			NewW = Spawn(Class'AmmoMachine',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('RocketCan') && bReplaceOldSkoolWeapons) || W.IsA('RocketPack') )
		{
			NewW = Spawn(Class'AmmoRifles',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('RifleAmmo') && bReplaceOldSkoolWeapons) || W.IsA('BulletBox') )
		{
			NewW = Spawn(Class'AmmoSniper',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( (W.IsA('Sludge') && bReplaceOldSkoolWeapons) || W.IsA('BioAmmo') )
		{
			NewW = Spawn(Class'AmmoSMG',,, W.Location, W.Rotation);
			W.Destroy();
		}
		else if ( W.IsA('SuperShockCore') )
		{
			NewW = Spawn(Class'AmmoSniper',,, W.Location, W.Rotation);
			W.Destroy();
		}
	}

	SaveConfig();

	if (int(ConsoleCommand("Get ini:Engine.Engine.GameEngine XC_Version")) >= 11 || int(ConsoleCommand("XC_Engine")) >= 11)
		AddToPackageMap();	//Add this package as ServerPackages if XC_Engine detected.

	if(NextMutator != None)
		NextMutator.PostBeginPlay();
}

simulated function ActorTweaking(Actor Other)
{
		if(SkaarjTrooper(Other) != None)
		{
			Switch(SkaarjTrooper(Other).DropWhenKilled)
			{
				case class'AutoMag':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.Deagle';
					break;
				case class'GESBioRifle':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.M3';
					break;
				case class'ASMD':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.MP5';
					break;
				case class'Stinger':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.M4A1';
					break;
				case class'Razorjack':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.GrenadeFrag';
					break;
				case class'Minigun':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.Aug';
					break;
				case class'FlakCannon':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.M249';
					break;
				case class'Rifle':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AWP';
					break;
				case class'ImpactHammer':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.Knife';
					break;
				case class'Enforcer':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.Deagle';
					break;
				case class'UT_BioRifle':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.M3';
					break;
				case class'ShockRifle':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.MP5';
					break;
				case class'Pulsegun':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AK47';
					break;
				case class'Ripper':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.GrenadeFrag';
					break;
				case class'minigun2':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.SG550';
					break;
				case class'UT_FlakCannon':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.M249';
					break;
				case class'UT_Eightball':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.M4A1';
					break;
				case class'SniperRifle':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AWP';
					break;
				case class'WarHeadLauncher':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.C4';
					break;
				case class'SuperShockRifle':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AWP';
					break;
				case class'Clip':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoPistols';
					break;
				case class'Sludge':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoShotgun';
					break;
				case class'ASMDAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoSMG';
					break;
				case class'StingerAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'RazorAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.GrenadeFragAmmo';
					break;
				case class'ShellBox':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'FlakBox':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoMachine';
					break;
				case class'RocketCan':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'RifleAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoSniper';
					break;
				case class'Armor':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.KevlarArmor';
					break;
				case class'Suits':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.KevlarArmor';
					break;
				case class'EClip':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoPistols';
					break;
				case class'BioAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoShotgun';
					break;
				case class'ShockCore':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoSMG';
					break;
				case class'PAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'BladeHopper':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'MiniAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'FlakAmmo':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoMachine';
					break;
				case class'RocketPack':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'BulletBox':
					SkaarjTrooper(Other).DropWhenKilled = Class'CS_v16_2.AmmoSniper';
					break;
			}
		}
		else if(ScriptedPawn(Other) != None)
		{
			Switch(ScriptedPawn(Other).DropWhenKilled)
			{
				case class'DispersionPistol':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.Knife';
					break;
				case class'AutoMag':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.Deagle';
					break;
				case class'GESBioRifle':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.M3';
					break;
				case class'ASMD':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.MP5';
					break;
				case class'Stinger':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.M4A1';
					break;
				case class'Razorjack':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.GrenadeFrag';
					break;
				case class'Minigun':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.Aug';
					break;
				case class'FlakCannon':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.M249';
					break;
				case class'Rifle':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AWP';
					break;
				case class'ImpactHammer':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.Knife';
					break;
				case class'Enforcer':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.Deagle';
					break;
				case class'UT_BioRifle':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.M3';
					break;
				case class'ShockRifle':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.MP5';
					break;
				case class'Pulsegun':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AK47';
					break;
				case class'Ripper':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.GrenadeFrag';
					break;
				case class'minigun2':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.SG550';
					break;
				case class'UT_FlakCannon':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.M249';
					break;
				case class'UT_Eightball':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.M4A1';
					break;
				case class'SniperRifle':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AWP';
					break;
				case class'WarHeadLauncher':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.C4';
					break;
				case class'SuperShockRifle':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AWP';
					break;
				case class'Clip':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoPistols';
					break;
				case class'Sludge':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoShotgun';
					break;
				case class'ASMDAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoSMG';
					break;
				case class'StingerAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'RazorAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.GrenadeFragAmmo';
					break;
				case class'ShellBox':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'FlakBox':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoMachine';
					break;
				case class'RocketCan':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'RifleAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoSniper';
					break;
				case class'Armor':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.KevlarArmor';
					break;
				case class'Suits':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.KevlarArmor';
					break;
				case class'EClip':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoPistols';
					break;
				case class'BioAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoShotgun';
					break;
				case class'ShockCore':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoSMG';
					break;
				case class'PAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'BladeHopper':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'MiniAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'FlakAmmo':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoMachine';
					break;
				case class'RocketPack':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoRifles';
					break;
				case class'BulletBox':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.AmmoSniper';
					break;
				case class'Armor2':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.KevlarArmor';
					break;
				case class'ThighPads':
					ScriptedPawn(Other).DropWhenKilled = Class'CS_v16_2.KevlarArmor';
					break;
			}
		}
		else if(Decoration(Other) != None)
		{
			Switch(Decoration(Other).Contents)
			{
				case class'Clip':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoPistols';
					break;
				case class'Sludge':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoShotgun';
					break;
				case class'ASMDAmmo':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoSMG';
					break;
				case class'StingerAmmo':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoRifles';
					break;
				case class'RazorAmmo':
					Decoration(Other).Contents = Class'CS_v16_2.GrenadeFragAmmo';
					break;
				case class'ShellBox':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoRifles';
					break;
				case class'FlakBox':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoMachine';
					break;
				case class'RocketCan':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoRifles';
					break;
				case class'RifleAmmo':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoSniper';
					break;
				case class'Armor':
					Decoration(Other).Contents = Class'CS_v16_2.KevlarArmor';
					break;
				case class'Suits':
					Decoration(Other).Contents = Class'CS_v16_2.KevlarArmor';
					break;
				case class'EClip':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoPistols';
					break;
				case class'BioAmmo':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoShotgun';
					break;
				case class'ShockCore':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoSMG';
					break;
				case class'PAmmo':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoRifles';
					break;
				case class'BladeHopper':
					Decoration(Other).Contents = Class'CS_v16_2.GrenadeFragAmmo';
					break;
				case class'MiniAmmo':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoRifles';
					break;
				case class'FlakAmmo':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoMachine';
					break;
				case class'RocketPack':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoRifles';
					break;
				case class'BulletBox':
					Decoration(Other).Contents = Class'CS_v16_2.AmmoSniper';
					break;
				case class'Armor2':
					Decoration(Other).Contents = Class'CS_v16_2.KevlarArmor';
					break;
				case class'ThighPads':
					Decoration(Other).Contents = Class'CS_v16_2.KevlarArmor';
					break;
				case class'DispersionPistol':
					Decoration(Other).Contents = Class'CS_v16_2.Knife';
					break;
				case class'AutoMag':
					Decoration(Other).Contents = Class'CS_v16_2.Deagle';
					break;
				case class'GESBioRifle':
					Decoration(Other).Contents = Class'CS_v16_2.M3';
					break;
				case class'ASMD':
					Decoration(Other).Contents = Class'CS_v16_2.MP5';
					break;
				case class'Stinger':
					Decoration(Other).Contents = Class'CS_v16_2.M4A1';
					break;
				case class'Razorjack':
					Decoration(Other).Contents = Class'CS_v16_2.GrenadeFrag';
					break;
				case class'Minigun':
					Decoration(Other).Contents = Class'CS_v16_2.Aug';
					break;
				case class'FlakCannon':
					Decoration(Other).Contents = Class'CS_v16_2.M249';
					break;
				case class'Rifle':
					Decoration(Other).Contents = Class'CS_v16_2.AWP';
					break;
				case class'ImpactHammer':
					Decoration(Other).Contents = Class'CS_v16_2.Knife';
					break;
				case class'Enforcer':
					Decoration(Other).Contents = Class'CS_v16_2.Deagle';
					break;
				case class'UT_BioRifle':
					Decoration(Other).Contents = Class'CS_v16_2.M3';
					break;
				case class'ShockRifle':
					Decoration(Other).Contents = Class'CS_v16_2.MP5';
					break;
				case class'Pulsegun':
					Decoration(Other).Contents = Class'CS_v16_2.AK47';
					break;
				case class'Ripper':
					Decoration(Other).Contents = Class'CS_v16_2.GrenadeFrag';
					break;
				case class'minigun2':
					Decoration(Other).Contents = Class'CS_v16_2.SG550';
					break;
				case class'UT_FlakCannon':
					Decoration(Other).Contents = Class'CS_v16_2.M249';
					break;
				case class'UT_Eightball':
					Decoration(Other).Contents = Class'CS_v16_2.M4A1';
					break;
				case class'SniperRifle':
					Decoration(Other).Contents = Class'CS_v16_2.AWP';
					break;
				case class'WarHeadLauncher':
					Decoration(Other).Contents = Class'CS_v16_2.C4';
					break;
				case class'SuperShockRifle':
					Decoration(Other).Contents = Class'CS_v16_2.AWP';
					break;
			}
		}
}

function ModifyPlayer(Pawn Other)
{
	local inventory i;
	local weapon w;
	local class<Weapon> WClass;
	local byte MyPistolIndex;
	local byte j;

	if(Other != None)
	{
		W = Spawn(Class'GrenadeFrag');
		if(W != None)
		{
			W.Instigator = Other;
			W.RespawnTime = 0.0;
			W.bHeldItem = true;
			W.BecomeItem();
			Other.AddInventory(W);
			W.GiveAmmo(Other);
			W.SetSwitchPriority(Other);
			W.WeaponSet(Other);
		}

		if( /*Other.FindInventoryType(Class'Enforcer') != None &&*/ Other.IsA('PlayerPawn') || Other.IsA('Bot') && !Other.IsA('Spectator') )
		{
			W = Weapon(Other.FindInventoryType(Class'Enforcer'));
			if(W != None)
			{
				W.Destroy();
				W = None;
			}
						
			if(bRespawnWithRandomPistols)
			{	
				MyPistolIndex = Rand(6);

				Switch(MyPistolIndex)
				{
					case 0:
						W = Spawn(Class'USP');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;

					case 1:
						W = Spawn(Class'FiveSeven');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;

					case 2:
						W = Spawn(Class'P228');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;

					case 3:
						W = Spawn(Class'Deagle');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;

					case 4:
						W = Spawn(Class'Glock');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;

					case 5:
						W = Spawn(Class'DualElites');

						if(W != None)
						{
							W.bTossedOut = false;
							W.Instigator = Other;
							W.RespawnTime = 0.0;
							W.bHeldItem = true;
							W.BecomeItem();
							Other.AddInventory(W);
							W.GiveAmmo(Other);
							W.SetSwitchPriority(Other);
							W.WeaponSet(Other);
						}
						break;
				}
			}
			else if(!bRespawnWithRandomPistols)
			{
				if(DefaultCSWeapon != "")
				{
					WClass = class<Weapon>(DynamicLoadObject( DefaultCSWeapon, class'Class' ));
					W = Spawn(WClass);

					if(W != None)
					{
						W.bTossedOut = false;
						W.Instigator = Other;
						W.RespawnTime = 0.0;
						W.bHeldItem = true;
						W.BecomeItem();
						Other.AddInventory(W);
						W.GiveAmmo(Other);
						W.SetSwitchPriority(Other);
						W.WeaponSet(Other);
					}
				}
				else
				{
					W = Spawn(Class'USP');

					if(W != None)
					{
						W.bTossedOut = false;
						W.Instigator = Other;
						W.RespawnTime = 0.0;
						W.bHeldItem = true;
						W.BecomeItem();
						Other.AddInventory(W);
						W.GiveAmmo(Other);
						W.SetSwitchPriority(Other);
						W.WeaponSet(Other);
					}	
				}
			}
		}

		if(DeathMatchPlus(Level.Game) != None)
		{
			if(DeathMatchPlus(Level.Game).bStartMatch)
			{
				if(!bFixedSkaarj)
				{
					GiveSkaarjGuns();
					bFixedSkaarj = True;
				}
			}
		}
	}

	if(NextMutator != None)
		NextMutator.ModifyPlayer(Other);
}

simulated function GiveSkaarjGuns()
{
	local ScriptedPawn S;
	local Weapon W1, W2;

	foreach AllActors(class 'ScriptedPawn', S)
	{
		if ( S != None && S.IsA('SkaarjTrooper') && S.Weapon != None )
		{
			W1 = S.Weapon;
			if(W1.Class == Class'Enforcer')
				W2 = Spawn(Class'Deagle',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'UT_BioRifle')
				W2 = Spawn(Class'M3',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'ShockRifle')
				W2 = Spawn(Class'P90',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'Pulsegun')
				W2 = Spawn(Class'M4A1',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'Ripper')
				W2 = Spawn(Class'Aug',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'minigun2')
				W2 = Spawn(Class'SG550',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'UT_FlakCannon')
				W2 = Spawn(Class'M249',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'UT_Eightball')
				W2 = Spawn(Class'AK47',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'SniperRifle')
				W2 = Spawn(Class'AWP',S,,S.Location,S.Rotation);
			else if(W1.Class == Class'SuperShockRifle')
				W2 = Spawn(Class'AWP',S,,S.Location,S.Rotation);
			if ( W2 != None )
			{
				S.Weapon = None;
				W1.Instigator=None;
				W1.Destroy();
				W2.ReSpawnTime = 0.0;
				W2.bHeldItem=True;
				W2.Instigator=S;
				W2.BecomeItem(); //Do not mess anims
				S.AddInventory(W2);
				W2.GiveAmmo(S);
				W2.WeaponSet(S);
			}
		}
	}
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if(Pickup(Other) != None)
	{
		if(Other.Class == Class'Botpack.Armor2' || (Other.Class == Class'UnrealShare.Armor' && bReplaceOldSkoolWeapons))
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16_2.KevlarArmor");
				return false;
			}
		}
		else if(Other.Class == Class'Botpack.ThighPads' || (Other.Class == Class'UnrealShare.Suits' && bReplaceOldSkoolWeapons))
		{
			if(Inventory(Other).MyMarker != None)
			{
				ReplaceWith(Other, "CS_v16_2.KevlarArmor");
				return false;
			}
		}
	}

	return true;
}

simulated function Tick(float DeltaTime)
{
	local ScriptedPawn S;
	local Weapon W;

	foreach AllActors(Class'ScriptedPawn', S)
	{
		if(S != None && S.IsA('SkaarjTrooper') && S.Weapon == None)
		{
			W = Spawn(SkaarjWeapons[Rand(7)],S,,S.Location,S.Rotation);
			if ( W != None )
			{
				W.ReSpawnTime = 0.0;
				W.bHeldItem=True;
				W.Instigator=S;
				W.BecomeItem(); //Do not mess anims
				S.AddInventory(W);
				W.GiveAmmo(S);
				W.GiveAmmo(S);
				W.WeaponSet(S);
			}
		}
	}
}

function Mutate (string MutateString, PlayerPawn Sender)
{
	if ( Left(Caps(MutateString),8) == "CSRELOAD" )
	{
			if(Sender != None)
			{
				if(Sender.Weapon != None && !Sender.Weapon.bMeleeWeapon)
				{
					if(Sender.Weapon.IsA('CSWeapons16'))
					{
						if( (CSWeapons16(Sender.Weapon).ClipCount < CSWeapons16(Sender.Weapon).default.ClipCount) && (CSWeapons16(Sender.Weapon).AmmoType.AmmoAmount > 0))
						{
							if(!CSWeapons16(Sender.Weapon).IsInState('NewClip'))
							{
								//CSWeapons16(Sender.Weapon).GotoState('NewClip');
								CSWeapons16(Sender.Weapon).Reload();
							}
						}
					}
				}
			}
	}

	Super.Mutate(MutateString,Sender);

	if(NextMutator != None)
		NextMutator.Mutate(MutateString,Sender);
}

defaultproperties
{
	DefaultWeapon=Class'CS_v16_2.Knife'
	DefaultCSWeapon="CS_v16_2.USP"
	DefaultShotgunWeapon="CS_v16_2.M3"
	DefaultSMGWeapon="CS_v16_2.MP5"
	DefaultRifleWeapon="CS_v16_2.M4A1"
	DefaultSniperWeapon="CS_v16_2.AWP"
	bEnableRecoil=True
	bAllAmbientGlow=True
	bEnableCrosshair=True
	bRespawnWithRandomPistols=True
	bRandomPistolReplacement=True
	bRandomShotgunReplacement=True
	bRandomSMGReplacement=True
	bRandomRiflesReplacement=True
	bRandomSniperReplacement=True
	bBulletPenetration=True
	GunPickupSoundType=0
	AmmoPickupSoundType=0

	SkaarjWeapons(0)=Class'M4A1'
	SkaarjWeapons(1)=Class'AK47'
	SkaarjWeapons(2)=Class'M3'
	SkaarjWeapons(3)=Class'XM1014'
	SkaarjWeapons(4)=Class'ScoutSniper'
	SkaarjWeapons(5)=Class'AWP'
	SkaarjWeapons(6)=Class'Famas'
	SkaarjWeapons(7)=Class'M249'
}