class C4Proj extends Projectile;

var int TimerCount;
var bool bCanHitOwner, bHitWater;

#exec AUDIO IMPORT NAME="C4Beep2" FILE=Sounds\C4\c4_beep2.wav GROUP="C4"
#exec AUDIO IMPORT NAME="C4Beep3" FILE=Sounds\C4\c4_beep3.wav GROUP="C4"
#exec AUDIO IMPORT NAME="C4Beep4" FILE=Sounds\C4\c4_beep4.wav GROUP="C4"
#exec AUDIO IMPORT NAME="C4Beep5" FILE=Sounds\C4\c4_beep5.wav GROUP="C4"
#exec AUDIO IMPORT NAME="C4Plant" FILE=Sounds\C4\c4_plant.wav GROUP="C4"
#exec AUDIO IMPORT NAME="C4Explode" FILE=Sounds\C4\c4_explode.wav GROUP="C4"

simulated function PostBeginPlay()
{
	TimerCount = Default.TimerCount;
	SetTimer(0.7, True);			//45 Seconds Timer
	
	PlaySound(ImpactSound);

	SetPhysics(PHYS_Falling);

	if( (Instigator != None) && Instigator.HeadRegion.Zone.bWaterZone )
	{
		bHitWater = True;
		Velocity = 0.6 * Velocity;
	}

	Super.PostBeginPlay();
}

simulated function Timer()
{
	TimerCount--;
	Spawn(class'C4Beacon',,,Location + Vect(0,0,1) * 5);
	if(TimerCount > 0)
	{
		if(TimerCount < 45)
		{
			AmbientSound = Sound'C4Beep2';
			SoundRadius = 100;
			SoundVolume = 255;
		}
		if(TimerCount < 35)
		{
			AmbientSound = Sound'C4Beep2';
			SoundRadius = 110;
			SoundVolume = 255;
		}
		if(TimerCount < 25)
		{
			AmbientSound = Sound'C4Beep3';
			SoundRadius = 128;
			SoundVolume = 255;
		}
		if(TimerCount < 15)
		{
			AmbientSound = Sound'C4Beep4';
			SoundRadius = 150;
			SoundVolume = 255;
		}
		if(TimerCount < 5)
		{
			AmbientSound = Sound'C4Beep5';
			SoundRadius = 255;
			SoundVolume = 255;
		}
	}
	else if(TimerCount == 0)
	{
		TimerCount = -1;
		AmbientSound = None;
		Explosion(Location+Vect(0,0,1)*16);
	}
}

simulated function ZoneChange( Zoneinfo NewZone )
{
	local waterring w;
	
	if (!NewZone.bWaterZone || bHitWater) Return;

	bHitWater = True;
	w = Spawn(class'WaterRing',,,,rot(16384,0,0));
	w.DrawScale = 0.2;
	w.RemoteRole = ROLE_None;
	Velocity=0.6*Velocity;
}

simulated function BlowUp(vector HitLocation)
{
	//PlaySound(MiscSound);
	HurtRadius(Damage, 1700, MyDamageType, MomentumTransfer, HitLocation);
	MakeNoise(1.0);
}

simulated function Explosion(vector HitLocation)
{
	BlowUp(HitLocation);
	if ( Level.NetMode != NM_DedicatedServer )
	{
		Spawn(class'C4BlastMark',,,,rot(16384,0,0));
		Spawn(class'C4ExplosionA',,,HitLocation + Vect(0,0,1) * 100);
		Spawn(class'C4ExplosionB',,,HitLocation + Vect(0,1,1) * 100);
		Spawn(class'C4ExplosionC',,,HitLocation + Vect(1,0,1) * 100);
		Spawn(class'C4ExplosionD',,,HitLocation + Vect(1,1,1) * 100);

		PlaySound(Sound'C4Explode', SLOT_Interface, 64.0, True, 50000.0);
    	PlaySound(Sound'C4Explode', SLOT_None, 64.0, True, 50000.0);
    	PlaySound(Sound'C4Explode', SLOT_Misc, 64.0, True, 50000.0);
	}
	Destroy();
}

defaultproperties
{
	TimerCount=45
	speed=150.000000
	MaxSpeed=150.000000
	Damage=11350.000000
	MomentumTransfer=100000
	bUnlit=False
	AmbientGlow=0
	Physics=PHYS_Falling
	ImpactSound=Sound'CS_v16_2.C4.C4Plant'
	Mesh=LodMesh'CS_v16_2.C4FirstPick'
	DrawScale=2.700000
	RemoteRole=ROLE_SimulatedProxy
	bBounce=False
	LODBias=20.000000
    bFixedRotationDir=True
    DesiredRotation=(Pitch=0,Yaw=0,Roll=0)
	CollisionRadius=12.000000
    CollisionHeight=8.000000
}