class C4 extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=C4Mesh MODELFILE=Models\C4\C4Mesh.psk
#exec MESH ORIGIN MESH=C4Mesh X=-0.8 Y=-1 Z=0 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=C4FirstPick ANIVFILE=MODELS\C4\C4Pick_a.3d DATAFILE=MODELS\C4\C4Pick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=C4FirstPick X=0 Y=0 Z=17.4

//3rd Person
#exec MESH IMPORT MESH=C4First3rd ANIVFILE=MODELS\C4\C43rd_a.3d DATAFILE=MODELS\C4\C43rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=C4First3rd X=20 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=C4MeshAnims ANIMFILE=Models\C4\C4MeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=C4MeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=194
#exec ANIM SEQUENCE ANIM=C4MeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=16
#exec ANIM SEQUENCE ANIM=C4MeshAnims SEQ=Still STARTFRAME=17 NUMFRAMES=30
#exec ANIM SEQUENCE ANIM=C4MeshAnims SEQ=PressButtons STARTFRAME=48 NUMFRAMES=100
#exec ANIM SEQUENCE ANIM=C4MeshAnims SEQ=DropC4 STARTFRAME=149 NUMFRAMES=46

#exec ANIM DIGEST ANIM=C4MeshAnims
#exec MESH DEFAULTANIM MESH=C4Mesh ANIM=C4MeshAnims

//Pickup
#exec MESH SEQUENCE MESH=C4FirstPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=C4FirstPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=C4First3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=C4First3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=C4Mesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=C4FirstPick MESH=C4FirstPick
#exec MESHMAP SCALE MESHMAP=C4FirstPick X=0.1 Y=0.1 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=C4First3rd MESH=C4First3rd
#exec MESHMAP SCALE MESHMAP=C4First3rd X=0.1 Y=0.1 Z=0.2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=C4MeshSkin00 FILE=Textures\C4\C4base.bmp GROUP=C4 LODSET=2
#exec TEXTURE IMPORT NAME=C4MeshSkin01 FILE=Textures\C4\C4Timer.bmp GROUP=C4 LODSET=2
#exec TEXTURE IMPORT NAME=C4MeshSkin02 FILE=Textures\C4\C4Wires.bmp GROUP=C4 LODSET=2
#exec TEXTURE IMPORT NAME=C4MeshSkin03 FILE=Textures\C4\C4Buttons.bmp GROUP=C4 LODSET=2
#exec TEXTURE IMPORT NAME=C4MeshSkin04 FILE=Textures\C4\view_skin.bmp GROUP=C4 LODSET=2
#exec TEXTURE IMPORT NAME=C4MeshSkin05 FILE=Textures\C4\view_finger.bmp GROUP=C4 LODSET=2
#exec TEXTURE IMPORT NAME=C4MeshSkin06 FILE=Textures\C4\C4BodyGlove.bmp GROUP=C4 LODSET=2

#exec TEXTURE IMPORT NAME=C4BodyPick FILE=Textures\C4\C4BodyPick.bmp GROUP=C4 LODSET=2
#exec TEXTURE IMPORT NAME=C4TimerPick FILE=Textures\C4\C4TimerPick.bmp GROUP=C4 LODSET=2
#exec TEXTURE IMPORT NAME=C4WiresPick FILE=Textures\C4\C4WiresPick.bmp GROUP=C4 LODSET=2

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=C4Mesh NUM=0 TEXTURE=C4MeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=C4Mesh NUM=1 TEXTURE=C4MeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=C4Mesh NUM=2 TEXTURE=C4MeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=C4Mesh NUM=3 TEXTURE=C4MeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=C4Mesh NUM=4 TEXTURE=C4MeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=C4Mesh NUM=5 TEXTURE=C4MeshSkin05
#exec MESHMAP SETTEXTURE MESHMAP=C4Mesh NUM=6 TEXTURE=C4MeshSkin06

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=C4FirstPick NUM=1 TEXTURE=C4BodyPick
#exec MESHMAP SETTEXTURE MESHMAP=C4FirstPick NUM=2 TEXTURE=C4TimerPick
#exec MESHMAP SETTEXTURE MESHMAP=C4FirstPick NUM=3 TEXTURE=C4WiresPick

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=C4First3rd NUM=1 TEXTURE=C4BodyPick
#exec MESHMAP SETTEXTURE MESHMAP=C4First3rd NUM=2 TEXTURE=C4TimerPick
#exec MESHMAP SETTEXTURE MESHMAP=C4First3rd NUM=3 TEXTURE=C4WiresPick

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="C4Click" FILE=Sounds\C4\c4_click.wav GROUP="C4"

//=========================================================================================

#exec TEXTURE IMPORT NAME=C4Icon FILE=Icons\C4\C4Icon.bmp GROUP=C4 MIPS=OFF

//=========================================================================================

simulated function PostRender(Canvas C)
{
}

function float RateSelf( out int bUseAltMode )
{
	return 0;	//No bot support for this... :(
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 0.7, 0.04);
	FinishAnim();
	Finish();
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
 			bDrawMuzzleFlash = True; 
		}
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'DropMe')
		PlayDrop();
	else if(EventType == 'SelectMe')
		PlaySelection();
	else if(EventType == 'PressMe')
		PlayButtonPress();
}

simulated function PlayDrop()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('DropC4', 1.0, 0.04);
	}	
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.0, 0.04);
	}
}

simulated function PlaySelect()
{
	PlayAnim('Select', 0.7, 0.04);
}

simulated function PlayButtonPress()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('PressButtons', 1.0, 0.04);
	}
}

simulated function PlayFiring();

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

    if(AmmoType.UseAmmo(1))
	{
		bPointing=True;
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);
		bCanClientFire = True;
		ClientFire(Value);
		GoToState('PlantingC4');
	}
}

simulated state PlantingC4
{
	ignores Fire, AltFire;

	Begin:
		PlayAnim('PressButtons', 1.0, 0.04);
		if(Level.NetMode == NM_DedicatedServer)
			if(PlayerPawn(Owner) != None)
				PlayerPawn(Owner).ClientWeaponEvent('PressMe');
		Sleep(0.7);
		Owner.PlaySound(Misc1Sound);
		Sleep(0.35);
		Owner.PlaySound(Misc1Sound);
		Sleep(0.29);
		Owner.PlaySound(Misc1Sound);
		Sleep(0.29);
		Owner.PlaySound(Misc1Sound);
		Sleep(0.23);
		Owner.PlaySound(Misc1Sound);
		Sleep(0.23);
		Owner.PlaySound(Misc1Sound);
		Sleep(0.23);
		Owner.PlaySound(Misc1Sound);
		Sleep(0.5);
		GoToState('DroppingC4');
}

simulated state DroppingC4
{
	ignores Fire, AltFire;

	Begin:
		PlayAnim('DropC4', 1.0, 0.04);
		if(Level.NetMode == NM_DedicatedServer)
			if(PlayerPawn(Owner) != None)
				PlayerPawn(Owner).ClientWeaponEvent('DropMe');
		FinishAnim();
		if(Pawn(Owner) != None)
			Spawn(Class'C4Proj',,,Pawn(Owner).Location, rot(0,16384,0));
		GoToState('SelectC4');
}

simulated state SelectC4
{
	ignores Fire, AltFire;

	Begin:
		if(Level.NetMode == NM_DedicatedServer)
			if(PlayerPawn(Owner) != None)
				PlayerPawn(Owner).ClientWeaponEvent('SelectMe');
		PlayAnim('Select', 1.0, 0.04);
		FinishAnim();
		GoToState('Idle');
}

function AltFire(float Value)
{
	if(Pawn(Owner) != None)
		Pawn(Owner).bAltFire = 0;
}

state Idle
{
	Begin:
		if(isAnimating())
			FinishAnim();
		PlayIdleAnim();
		if(AmmoType.AmmoAmount<=0)
			Pawn(Owner).SwitchToBestWeapon();
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
}

defaultproperties
{
	FireSound=None
	AltFireSound=None
	Misc1Sound=Sound'CS_v16_2.C4.C4Click'
	PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
	HitDamage=0
    ClipCount=0
    PickupAmmoCount=1
    AmmoName=Class'CS_v16_2.AmmoC4'
    FireOffset=(X=0.00,Y=0.000000,Z=0.00),
	AIRating=0.00000
    RefireRate=0.000000
    AltRefireRate=0.000000
    BobDamping=1.11
    AutoSwitchPriority=10
    InventoryGroup=10
    PickupMessage="You got a C4."
    ItemName="C4"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewScale=3.00
    PlayerViewMesh=SkeletalMesh'CS_v16_2.C4Mesh'
    PickupViewMesh=LodMesh'CS_v16_2.C4FirstPick'
    PickupViewScale=2.70
    ThirdPersonMesh=LodMesh'CS_v16_2.C4First3rd'
    ThirdPersonScale=2.50
    Mesh=LodMesh'CS_v16_2.C4FirstPick'
    bNoSmooth=False
    DrawScale=2.00
    Icon=Texture'CS_v16_2.C4.C4Icon'
    StatusIcon=Texture'CS_v16_2.C4.C4Icon'
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
	//Mass=10.00
}