class Aug extends CSWeapons16;

//=========================================================================================

//1st Person
#exec MESH MODELIMPORT MESH=AugMesh MODELFILE=Models\Bullpup\AugMesh.psk
#exec MESH ORIGIN MESH=AugMesh X=-0.5 Y=-1 Z=0.5 YAW=-64 PITCH=0 ROLL=0

//Pickup
#exec MESH IMPORT MESH=BullpupPick ANIVFILE=MODELS\Bullpup\BullpupPick_a.3d DATAFILE=MODELS\Bullpup\BullpupPick_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=BullpupPick X=0 Y=0 Z=15

//3rd Person
#exec MESH IMPORT MESH=Bullpup3rd ANIVFILE=MODELS\Bullpup\Bullpup3rd_a.3d DATAFILE=MODELS\Bullpup\Bullpup3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Bullpup3rd X=0 Y=0 Z=-9 Yaw=128

//=========================================================================================

//Scales

//1st Person
#exec MESHMAP SCALE MESHMAP=AugMesh X=1.0 Y=1.0 Z=1.0

//Pickup
#exec MESHMAP NEW MESHMAP=BullpupPick MESH=BullpupPick
#exec MESHMAP SCALE MESHMAP=BullpupPick X=0.09 Y=0.09 Z=0.2

//3rd Person
#exec MESHMAP NEW MESHMAP=Bullpup3rd MESH=Bullpup3rd
#exec MESHMAP SCALE MESHMAP=Bullpup3rd X=0.09 Y=0.09 Z=0.13

//=========================================================================================

//Animations

//1st Person
#exec ANIM IMPORT ANIM=AugMeshAnims ANIMFILE=Models\Bullpup\AugMeshAnims.psa COMPRESS=1

#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=All STARTFRAME=0 NUMFRAMES=204
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=Select STARTFRAME=0 NUMFRAMES=31
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=Still STARTFRAME=32 NUMFRAMES=8
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=Reload STARTFRAME=41 NUMFRAMES=132
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=Fire STARTFRAME=174 NUMFRAMES=30
#exec ANIM SEQUENCE ANIM=AugMeshAnims SEQ=AfterFire STARTFRAME=184 NUMFRAMES=20

#exec ANIM DIGEST ANIM=AugMeshAnims
#exec MESH DEFAULTANIM MESH=AugMesh ANIM=AugMeshAnims

//Pickup
#exec MESH SEQUENCE MESH=BullpupPick SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=BullpupPick SEQ=Still STARTFRAME=0 NUMFRAMES=1

//3rd Person
#exec MESH SEQUENCE MESH=Bullpup3rd SEQ=All STARTFRAME=0 NUMFRAMES=2
#exec MESH SEQUENCE MESH=Bullpup3rd SEQ=Still STARTFRAME=0 NUMFRAMES=2

//=========================================================================================

//Textures
#exec TEXTURE IMPORT NAME=AugMeshSkin00 FILE=Textures\Bullpup\barrel.bmp GROUP=Bullpup LODSET=2
#exec TEXTURE IMPORT NAME=AugMeshSkin01 FILE=Textures\Bullpup\body.bmp GROUP=Bullpup LODSET=2
#exec TEXTURE IMPORT NAME=AugMeshSkin02 FILE=Textures\Bullpup\magazine.bmp GROUP=Bullpup LODSET=2
#exec TEXTURE IMPORT NAME=AugMeshSkin03 FILE=Textures\Bullpup\view_glove.bmp GROUP=Bullpup LODSET=2
#exec TEXTURE IMPORT NAME=AugMeshSkin04 FILE=Textures\Bullpup\view_skin.bmp GROUP=Bullpup LODSET=2
#exec TEXTURE IMPORT NAME=AugMeshSkin05 FILE=Textures\Bullpup\view_finger.bmp GROUP=Bullpup LODSET=2
#exec TEXTURE IMPORT NAME=AugW FILE=Textures\Bullpup\w_aug.bmp GROUP=Bullpup LODSET=2

#exec TEXTURE IMPORT NAME=AugIcon FILE=Icons\Rifles\AugIcon.bmp GROUP=Bullpup MIPS=OFF

//1st Person
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=0 TEXTURE=AugMeshSkin00
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=1 TEXTURE=AugMeshSkin01
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=2 TEXTURE=AugMeshSkin02
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=3 TEXTURE=AugMeshSkin03
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=4 TEXTURE=AugMeshSkin04
#exec MESHMAP SETTEXTURE MESHMAP=AugMesh NUM=5 TEXTURE=AugMeshSkin05

//Pickup
#exec MESHMAP SETTEXTURE MESHMAP=BullpupPick NUM=1 TEXTURE=AugW

//3rd Person
#exec MESHMAP SETTEXTURE MESHMAP=Bullpup3rd NUM=1 TEXTURE=AugW

//=========================================================================================

//Sounds
#exec AUDIO IMPORT NAME="AugFire" FILE=Sounds\Bullpup\aug_fire.wav GROUP="Bullpup"
#exec AUDIO IMPORT NAME="AugBoltPull" FILE=Sounds\Bullpup\aug_boltpull.wav GROUP="Bullpup"
#exec AUDIO IMPORT NAME="AugBoltSlap" FILE=Sounds\Bullpup\aug_boltslap.wav GROUP="Bullpup"
#exec AUDIO IMPORT NAME="AugCLipIn" FILE=Sounds\Bullpup\aug_clipin.wav GROUP="Bullpup"
#exec AUDIO IMPORT NAME="AugCLipOut" FILE=Sounds\Bullpup\aug_clipout.wav GROUP="Bullpup"
#exec AUDIO IMPORT NAME="AugForeArm" FILE=Sounds\Bullpup\aug_forearm.wav GROUP="Bullpup"

//=========================================================================================

#exec MESH IMPORT MESH=AugMuzz ANIVFILE=MODELS\muzzEF3_a.3d DATAFILE=MODELS\muzzEF3_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=AugMuzz MINVERTS=8 STRENGTH=0.7 ZDISP=800.0
#exec MESH ORIGIN MESH=AugMuzz X=50 Y=1200 Z=-220 YAW=64
#exec MESH SEQUENCE MESH=AugMuzz SEQ=All                      STARTFRAME=0 NUMFRAMES=3
#exec MESH SEQUENCE MESH=AugMuzz SEQ=Shoot                   STARTFRAME=0 NUMFRAMES=3
#exec MESHMAP NEW   MESHMAP=AugMuzz MESH=AugMuzz
#exec MESHMAP SCALE MESHMAP=AugMuzz X=0.02 Y=0.05 Z=0.04

//=========================================================================================

var Sound ReloadSounds[5];
var Texture RandFlash[6];
var float NFlashO, NFlashY;
var float FireRate;
var byte PZoomLevel;

replication
{
	Reliable if(bNetOwner && Role==ROLE_Authority)
		FireRate, PZoomLevel;
}

function DropFrom(vector StartLocation)
{
	Super.DropFrom(StartLocation);
	FlashO = default.FlashO;
	FlashY = default.FlashY;
	PZoomLevel = 0;
	FireRate = Default.FireRate;
}

simulated function TweenDown()
{
	PZoomLevel = 0;
	FireRate = Default.FireRate;
}

State DownWeapon
{
	ignores Fire, AltFire;

	Begin:
		PZoomLevel = 0;
		FireRate = Default.FireRate;
		if(Pawn(Owner) != None)
			Pawn(Owner).ChangedWeapon();
		if (Owner.IsA('PlayerPawn'))
		{
			PlayerPawn(Owner).DodgeClickTime = PlayerPawn(Owner).Default.DodgeClickTime;
			PlayerPawn(Owner).bRun = 0;
 			bDrawMuzzleFlash = True; 
		}
}

simulated event RenderOverlays(canvas Canvas)
{
	local rotator NewRot;
	local bool bPlayerOwner;
	local int Hand;
	local PlayerPawn PlayerOwner;

	MFTexture = RandFlash[Rand(5)];

	if (Owner.IsA('PlayerPawn'))
	{
		if(bHideWeapon || (Owner==None))
			return;
		PlayerOwner = PlayerPawn(Owner);
		if(PlayerOwner!=None)
		{
			bPlayerOwner = true;
			Hand = PlayerOwner.Handedness;
		}

		if((Level.NetMode == NM_Client) && (Hand == 2))
		{
			bHideWeapon = true;
			return;
		}
	
		if(!bPlayerOwner || (PlayerOwner.Player == None))
			Pawn(Owner).WalkBob = vect(0,0,0);
	
		if(bMuzzleFlash>0 && bDrawMuzzleFlash /*&& Level.bHighDetailMode*/ && (MFTexture != None))
		{
			MuzzleScale = Default.MuzzleScale*(Canvas.ClipX/640.0);
			if(!bSetFlashTime)
			{
				bSetFlashTime = true;
				FlashTime = Level.TimeSeconds+FlashLength;
			}
			else if(FlashTime<Level.TimeSeconds)
				bMuzzleFlash = 0;
		
			if(bMuzzleFlash > 0)
			{
				if ( Hand == 0 )
                	Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (-0.2 * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * (FlashY + FlashC));
          	  	else
                	Canvas.SetPos(Canvas.ClipX/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipX * (Hand * Default.MuzzleOffset.Y * FlashO), Canvas.ClipY/2 - 0.5 * MuzzleScale * FlashS + Canvas.ClipY * FlashY);
				Canvas.Style = 3;
				Canvas.DrawIcon(MFTexture, MuzzleScale);
				Canvas.Style = 1;
			}
		}
	else
		bSetFlashTime = false;

	SetLocation(Owner.Location + CalcDrawOffset2());
	NewRot = Pawn(Owner).ViewRotation;
	if(Hand==0)
		newRot.Roll = -2*Default.Rotation.Roll;
	else
		newRot.Roll = Default.Rotation.Roll*Hand;
	setRotation(newRot);
	Canvas.DrawActor(self, false);
	}
	//else
	//Super.RenderOverlays(Canvas);
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	
	bUseAltMode = 0;

	return (AIRating + FRand() * 0.05);
}

simulated state Active
{
	function Fire(float F)
	{
	}

	function AltFire(float F)
	{
	}

	function bool PutDown()
	{
		if ( bWeaponUp || (AnimFrame < 0.75) )
			GotoState('DownWeapon');
		else
			bChangeWeapon = true;
		return True;
	}

	function BeginState()
	{
		bChangeWeapon = false;
	}

Begin:
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	bWeaponUp = True;
	PlayAnim('Select', 1.1, 0.04);
	Sleep(0.3);
	PlaySelectionSound();
	FinishAnim();
	Finish();
}

simulated function ClientWeaponEvent(name EventType)
{
	if(EventType == 'Selecting')
		PlaySelection();
}

simulated function PlaySelection()
{
	if ((Role < ROLE_Authority) || (Level.NetMode != NM_DedicatedServer))
	{
		PlayAnim('Select', 1.1, 0.04);
		GoToState('Selector');
	}
}

simulated state Selector
{
	ignores Fire,AltFire;

	Begin:
		Sleep(0.3);
		PlaySelectionSound();
		FinishAnim();
		Finish();
}

simulated function PlaySelectionSound()
{
	Owner.PlaySound(ReloadSounds[4], SLOT_Misc, Pawn(Owner).SoundDampening);
}

simulated function PlaySelect()
{
	PlayAnim('Select', 1.1, 0.04);
	GoToState('Selector');
	FlashO = default.FlashO;
	FlashY = default.FlashY;
}

simulated function SetZoom()
{
	if ( Owner.IsA('PlayerPawn') )
	{
		if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
		{
			if (PlayerPawn(Owner) != None && AmmoType.AmmoAmount > 0)
			{
				if (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = 50.0;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.NFlashO;
					FlashY = default.NFlashY;
				}
				else
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.FlashO;
					FlashY = default.FlashY;
				}
			}
		}
	}
}

function PlayFire()
{
	if(AmmoType.AmmoAmount > 0 && (ClipCount > 0))
	{
		JustFire();
		PlayerFire();
	}
}

simulated function PlayerFire()
{
	if ( ( Role < ROLE_Authority ) && (ClipCount > 0) && (AmmoType.AmmoAmount>0)) 
		JustFire();
}

simulated function JustFire()
{
	SpawnShellCase(vect(10,-500,1));
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Fire', FireRate, 0.04);
	
	if(Class'CSMut16'.default.bEnableRecoil)
		Recoil();
	
	ClipCount--;

	if (PlayerPawn(Owner) != None)
		bMuzzleFlash++;
}

simulated function PlayFiring()
{	
}

function Fire(float Value)
{
	if ( (AmmoType == None) && (AmmoName != None) )
    {
        // ammocheck
        GiveAmmo(Pawn(Owner));
    }

	if(ClipCount > 0 && AmmoType.UseAmmo(1))
	{
		if(PZoomLevel == 0)
			TraceFire(3.0);
		else if(PZoomLevel == 1)
			TraceFire(1.0);
		bPointing=True;
		//PlayFiring();
		PlayFire();
		Spawn(Class'CSWeaponsLight',,,Owner.Location,rot(0,0,0));
		bCanClientFire = true;
        ClientFire(Value);
		if(!bRapidFire && (FiringSpeed>0))
			Pawn(Owner).PlayRecoil(FiringSpeed);

		GotoState('NormalFire');
	}
	else if(ClipCount <= 0 && AmmoType.AmmoAmount > 0)
		Reload();
	else if(!IsInState('Idle'))
		GoToState('Idle');
}

state NormalFire
{
	function AnimEnd()
	{
		if(Pawn(Owner).bFire == 0)
		{
			PlayAfterFire();
			GoToState('Idle');
		}
		else if(Pawn(Owner).bFire != 0)
		{
			Global.Fire(0.0);
		}
	}

	Begin:
		FlashCount++;
		FinishAnim();
		Finish();
}

state ClientFiring
{
	ignores AltFire;

	simulated function AnimEnd()
	{
		if(Pawn(Owner).bFire == 0)
		{
			PlayAfterFire();
			GoToState('Idle');
		}
		else if(Pawn(Owner).bFire != 0)
		{
			Global.Fire(0.0);
		}
	}
}

simulated function PlayAfterFire()
{
	PlayAnim('AfterFire', 0.7, 0.04);
}

function AltFire(float Value)
{
	if(PZoomLevel == 0)
	{
		PZoomLevel = 1;			//Zoomed
		FireRate = 7.0;
	}
	else if(PZoomLevel == 1)
	{
		PZoomLevel = 0;			//UnZoomed
		FireRate = Default.FireRate;
	}
	ClientAltFire(Value);
}

simulated function bool ClientAltFire( float Value )
{
	SetZoom();
	GotoState('Idle');
	return true;
}

function Reload()
{
	PZoomLevel = 0;
	FireRate = Default.FireRate;
    if ((AmmoType.AmmoAmount > 0) && (ClipCount < Default.ClipCount)) 
    {
          GoToState('NewClip');
          PlayReloading();
          ClientReload();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.FlashO;
					FlashY = default.FlashY;
					MuzzleScale = default.MuzzleScale;
				}
			}
		}
    }
}

simulated function ClientReload()
{
	PZoomLevel = 0;
	FireRate = Default.FireRate;
    if ( ( Role < ROLE_Authority ) && (ClipCount < Default.ClipCount) && (AmmoType.AmmoAmount>0)) 
    {
          GoToState('ClientReloading');
          PlayReloading();

        if(Owner.IsA('PlayerPawn'))
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
			{
				if(PlayerPawn(Owner).DesiredFOV != PlayerPawn(Owner).DefaultFOV)
				{
					PlayerPawn(Owner).DesiredFOV = PlayerPawn(Owner).DefaultFOV;
					PlayerPawn(Owner).FOVAngle = PlayerPawn(Owner).DesiredFOV;
					FlashO = default.FlashO;
					FlashY = default.FlashY;
					MuzzleScale = default.MuzzleScale;
				}
			}
		}
    }
}

simulated function PlayReloading()
{
     //Play reloading animation and sound
     if ( (Owner == None) )
          return;
     PlayAnim('Reload',1.0, 0.05);
}

simulated State NewClip
{
	ignores Fire, AltFire, Reload;

	Begin:
		PZoomLevel = 0;
		FireRate = Default.FireRate;
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

state ClientReloading
{
	simulated function bool ClientFire(float Value)
    {
        return false;
    }

    simulated function bool ClientAltFire(float Value)
    {
        return false;
    }

    Begin:
    	PZoomLevel = 0;
		FireRate = Default.FireRate;
		Sleep(0.45);
		Owner.PlaySound(ReloadSounds[0], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.2);
		Owner.PlaySound(ReloadSounds[1], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[2], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(1.0);
		Owner.PlaySound(ReloadSounds[3], SLOT_None, Pawn(Owner).SoundDampening * 1.0);
		Sleep(0.35);
		FinishAnim();
		ClipCount=Min(Default.ClipCount,AmmoType.AmmoAmount);
		Finish();
}

simulated state Idle
{
Begin:
	if(isAnimating())
		FinishAnim();
	PlayIdleAnim();
	if(AmmoType.AmmoAmount<=0)
		Pawn(Owner).SwitchToBestWeapon();
Checks:
	if(AmmoType.AmmoAmount > 0 && ClipCount <= 0)
		Reload();
	Sleep(0.0);
	GoTo('Checks');
}

simulated function PlayIdleAnim()
{
	TweenAnim('Still',1.0);
	GoToState('Idle','Checks');
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local float Penetration;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset2() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (100000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);

	if(Class'CSMut16'.default.bBulletPenetration)
	{
		if(Other.IsA('Pawn'))
			Penetration = 266.00;
		else
			Penetration = 250.00;

		StartTrace = HitLocation + HitNormal + (Penetration * X);
    	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000 + Accuracy * (FRand() - 0.5 ) * Z * 1000;
    	EndTrace += (100000 * X);
    	Other = PawnOwner.TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);

    	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(Hitdamage * 1.5, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(Hitdamage,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function SpawnShellCase(Vector Offset)
{
	local CSShellCase s;
	local vector X,Y,Z;
	
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	s = Spawn(class'CSShellCase', Pawn(Owner), '', Owner.Location + CalcDrawOffset2() + EjectOffset.X * X + EjectOffset.Y * Y + EjectOffset.Z * Z);
	if(s!=None)
	{
		s.bNoSmooth = False;
		s.DrawScale = 0.80;
		s.Eject(((FRand()*0.3+0.8)*Offset.X*X + (FRand()*0.3+0.4)*Offset.Y*Y + (FRand()*0.3+1.0)*Offset.Z*100*Z));
	}
}

defaultproperties
{
	FireRate=12.00
	RandFlash(0)=Texture'CS_v16_2.AK47.CSRifleMuzz1'
	RandFlash(1)=Texture'CS_v16_2.AK47.CSRifleMuzz2'
	RandFlash(2)=Texture'CS_v16_2.AK47.CSRifleMuzz3'
	RandFlash(3)=Texture'CS_v16_2.AK47.CSRifleMuzz4'
	RandFlash(4)=Texture'CS_v16_2.AK47.CSRifleMuzz5'
	RandFlash(5)=Texture'CS_v16_2.AK47.CSRifleMuzz6'
    ReloadSounds(0)=Sound'CS_v16_2.Bullpup.AugBoltPull'
    ReloadSounds(1)=Sound'CS_v16_2.Bullpup.AugClipOut'
    ReloadSounds(2)=Sound'CS_v16_2.Bullpup.AugClipIn'
    ReloadSounds(3)=Sound'CS_v16_2.Bullpup.AugBoltSlap'
    ReloadSounds(4)=Sound'CS_v16_2.Bullpup.AugForeArm'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    FireSound=Sound'CS_v16_2.Bullpup.AugFire'
    EjectOffset=(X=20.000000,Y=10.000000,Z=-10.000000)
    HitDamage=28
    ClipCount=30
    PickupAmmoCount=90
    VRecoil=850.00
    HRecoil=1.00
    RecoilMultiplier=0.01
    AmmoName=Class'CS_v16_2.AmmoRifles'
    bInstantHit=True
    bRapidFire=True
    FireOffset=(Y=0.000000,Z=0.000000)
    MuzzleOffset=(Y=-11.000000,Z=-17.100000)
    MyDamageType=shot
    AltDamageType=Decapitated
    AIRating=0.730000
    RefireRate=0.990000
    AltRefireRate=0.990000
    AimError=500.000000
    bDrawMuzzleFlash=True
    MuzzleScale=0.500000
    NFlashY=0.210000
    NFlashO=0.024000
    FlashY=0.089000
    FlashO=0.011000
    FlashC=0.031000
    FlashLength=0.013000
    FlashS=256
    BobDamping=1.11
    MFTexture=Texture'Botpack.Skins.Flakmuz'
    AutoSwitchPriority=6
    InventoryGroup=6
    PickupMessage="You got a AUG."
    ItemName="AUG"
    Physics=PHYS_Falling
    PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
    PlayerViewMesh=SkeletalMesh'AugMesh'
    PlayerViewScale=3.000000
    PickupViewMesh=LodMesh'BullpupPick'
    PickupViewScale=3.000000
    ThirdPersonMesh=LodMesh'Bullpup3rd'
    ThirdPersonScale=2.200000
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=STY_Translucent
    MuzzleFlashMesh=LodMesh'CS_v16_2.AugMuzz'
    MuzzleFlashScale=0.100000
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy2'
    Mesh=LodMesh'BullpupPick'
    bNoSmooth=False
    Icon=Texture'CS_v16_2.Bullpup.AugIcon'
    StatusIcon=Texture'CS_v16_2.Bullpup.AugIcon'
    DrawScale=3.000000
    CollisionRadius=32.000000
    CollisionHeight=8.000000
    LODBias=20.00
}