/*
 * Decompiled with CFR 0.152.
 */
package bothandler;

import bothandler.BHSkin;
import bothandler.BHType;
import bothandler.BHVoice;
import bothandler.BHWeapon;
import bothandler.BotHandlerApp;
import java.util.Random;

class BHSettingsHandler {
    static int PASS_THRESHOLD = 64;
    static float COMPLEX_SKIN_FACTOR = 1.0f;
    static final String ALPHABET = "aeioubcdfghjklmnpqrstvwxyzAEIOUBCDFGHJKLMNPQRSTVWXYZ0123456789";
    boolean bInitialized = false;
    BHSkin[] skinz;
    BHWeapon[] weapz;
    BHType[] typez;
    BHVoice[] voicez;
    Random randomGenerator;
    String[] takenNames = new String[32];

    public BHSettingsHandler() {
        this.randomGenerator = new Random();
    }

    public void updateSettings() {
        this.skinz = BotHandlerApp.bHLogic.skinz;
        this.weapz = BotHandlerApp.bHLogic.weapz;
        this.typez = BotHandlerApp.bHLogic.typez;
        this.voicez = BotHandlerApp.bHLogic.voicez;
        this.bInitialized = true;
    }

    public void updateRandom() {
        this.randomGenerator = new Random();
    }

    public void updateTakenNames() {
        for (int i = 0; i < this.takenNames.length; ++i) {
            this.takenNames[i] = BotHandlerApp.bHLogic.bList.bNames[i];
        }
    }

    public String[] getFacesAndNames(String nick, int face, int skin, int type, int index, boolean bGenNicks, boolean bGenFaces) {
        String[] s = new String[]{"", "", "", ""};
        int iPassed = PASS_THRESHOLD;
        if (face == -300 || nick.equals("[BOTHANDLERRANDOMVALUE]")) {
            while (iPassed > 0) {
                int ind;
                if (type == -300) {
                    skin = this.randomGenerator.nextInt(this.skinz.length);
                } else if (skin == -300) {
                    skin = this.typez[type].indices[this.randomGenerator.nextInt(this.typez[type].indices.length)];
                }
                if (bGenNicks) {
                    if (nick.equals("[BOTHANDLERRANDOMVALUE]")) {
                        ind = this.randomGenerator.nextInt(this.skinz[skin].botNickNames.length);
                        s[0] = this.treatNames(this.skinz[skin].botNickNames[ind], index);
                        if (this.nameAlreadyTaken(s[0]) && --iPassed > 0) {
                            continue;
                        }
                    } else {
                        s[0] = this.treatNames(nick, index);
                    }
                }
                if (bGenFaces) {
                    if (face == -300) {
                        ind = this.randomGenerator.nextInt(this.skinz[skin].botFaces.length);
                        s[1] = this.skinz[skin].botFaces[ind];
                        s[2] = this.skinz[skin].botSkin;
                        s[3] = this.skinz[skin].botClass;
                    } else {
                        s[1] = this.skinz[skin].botFaces[face];
                        s[2] = this.skinz[skin].botSkin;
                        s[3] = this.skinz[skin].botClass;
                    }
                }
                if (Math.random() / (double)COMPLEX_SKIN_FACTOR < (double)((float)this.skinz[skin].botFaces.length / 10.0f)) {
                    iPassed = 0;
                    continue;
                }
                --iPassed;
            }
        } else {
            s[0] = this.treatNames(nick, index);
            s[1] = this.skinz[skin].botFaces[face];
            s[2] = this.skinz[skin].botSkin;
            s[3] = this.skinz[skin].botClass;
        }
        this.takenNames[index] = s[0];
        return s;
    }

    public int getTeams(int team, float chance) {
        int t = Math.random() < (double)chance ? (team == -300 ? this.randomGenerator.nextInt(4) : team) : 255;
        return t;
    }

    public float getSpins(float limitUp, float limitDown, int divisor, float chance) {
        int up;
        int down;
        if (divisor == 0) {
            divisor = 10;
        }
        if ((down = (int)(limitDown * (float)divisor)) > (up = (int)(limitUp * (float)divisor))) {
            down = 0;
            up = 0;
        }
        float f = Math.random() < (double)chance ? (float)((double)down + Math.floor(Math.random() * (double)(up - down))) / (float)divisor : 0.0f;
        return f;
    }

    public String getFavoriteWeapon(String weapon, float chance) {
        if (Math.random() < (double)chance) {
            if (weapon.equals("[BOTHANDLERRANDOMVALUE]")) {
                return this.weapz[this.randomGenerator.nextInt((int)this.weapz.length)].weapon;
            }
            return weapon;
        }
        return "";
    }

    public String getVoiceType(String voice, float chance) {
        if (Math.random() < (double)chance) {
            if (voice.equals("[BOTHANDLERRANDOMVALUE]")) {
                int randInd = this.randomGenerator.nextInt(this.voicez.length);
                return this.voicez[randInd].vVoiceClasses[this.randomGenerator.nextInt(this.voicez[randInd].vVoiceClasses.length)];
            }
            return voice;
        }
        return "";
    }

    public boolean nameAlreadyTaken(String name) {
        for (int i = 0; i < 32; ++i) {
            if (!this.takenNames[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public void cleanTakenNames(int index) {
        this.takenNames[index] = "";
    }

    public void cleanTakenNames(int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            this.takenNames[indices[i]] = "";
        }
    }

    public void cleanTakenNames(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.takenNames[i] = "";
        }
    }

    public String treatNames(String name, int index) {
        int place;
        while (name.contains("%i")) {
            name = name.replace("%i", Integer.toString(index + 1));
        }
        while (name.contains("%r")) {
            place = name.indexOf("%r");
            String toR = name.substring(place, place + 3);
            int toN = Integer.parseInt(name.substring(place + 2, place + 3));
            toN = (int)Math.pow(10.0, toN);
            name = name.replaceFirst(toR, Integer.toString(this.randomGenerator.nextInt(toN)));
        }
        while (name.contains("%c(")) {
            place = name.indexOf("%c(");
            int endPlace = name.indexOf(")", place);
            String toR = name.substring(place, endPlace + 1);
            if (place + 3 >= endPlace) {
                name = name.replaceFirst(toR, "ERROR");
                continue;
            }
            int chIx = place + 3 + this.randomGenerator.nextInt(endPlace - (place + 3));
            name = this.noRegexReplaceFirst(name, toR, name.substring(chIx, chIx + 1));
        }
        while (name.contains("%a")) {
            place = name.indexOf("%a");
            int alpDn = 0;
            int alpUp = 0;
            String toR = name.substring(place, place + 3);
            String letter = name.substring(place + 2, place + 3);
            if (letter.equals("v")) {
                alpDn = 0;
                alpUp = 5;
            } else if (letter.equals("V")) {
                alpDn = 26;
                alpUp = 31;
            } else if (letter.equals("c")) {
                alpDn = 5;
                alpUp = 26;
            } else if (letter.equals("C")) {
                alpDn = 31;
                alpUp = 52;
            } else if (letter.equals("l")) {
                alpDn = 0;
                alpUp = 26;
            } else if (letter.equals("L")) {
                alpDn = 26;
                alpUp = 52;
            } else if (letter.equals("n")) {
                alpDn = 52;
                alpUp = 62;
            } else if (letter.equals("a")) {
                alpDn = 0;
                alpUp = 52;
            } else {
                if (!letter.equals("r")) continue;
                alpDn = 0;
                alpUp = 62;
            }
            int letterIndex = alpDn + this.randomGenerator.nextInt(alpUp - alpDn);
            name = name.replaceFirst(toR, ALPHABET.substring(letterIndex, letterIndex + 1));
        }
        while (name.contains("%d")) {
            place = name.indexOf("%d");
            int endPlace = name.indexOf(")", place);
            String toR = name.substring(place, endPlace + 1);
            if (place + 4 >= endPlace) {
                name = name.replaceFirst(toR, "ERROR");
                continue;
            }
            if (Math.random() < (double)((float)Integer.parseInt(name.substring(place + 2, place + 3)) / 10.0f)) {
                name = this.noRegexReplaceFirst(name, toR, "");
                continue;
            }
            name = this.noRegexReplaceFirst(name, toR, name.substring(place + 4, endPlace));
        }
        return name;
    }

    private String noRegexReplaceFirst(String dest, String toR, String newS) {
        int startPoint = dest.indexOf(toR);
        return dest.substring(0, startPoint) + newS + dest.substring(startPoint + toR.length());
    }
}

