class RDM extends Arena;

var bool preInit;
var bool postInit;

function PreBeginPlay ()
{
	if(preInit)
		return;
    preInit = True;

	DeathMatchPlus(Level.Game).MinPlayers = 6;
	
	Log(">>RocketDM+ loaded");
}

function PostBeginPlay ()
{
	if(postInit)
		return;
  
	postInit = True;
	Level.Game.RegisterDamageMutator(self);
}

function MutatorTakeDamage (out int actualDamage, Pawn Victim, Pawn instigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	if((Victim == None) || (instigatedBy == None) || actualDamage > 5000)
		return;
  
	if(instigatedBy == Victim)
	{
		actualDamage = 0;
		Momentum = vect(0.00,0.00,0.00);
	}
  
	Super.MutatorTakeDamage(actualDamage, Victim, instigatedBy, HitLocation, Momentum, DamageType);
}

function bool AlwaysKeep(Actor Other)
{
    local bool bTemp;

	if ( Other.IsA('WarHeadLauncher') || Other.IsA('WarHeadAmmo'))
    {
        //Weapon(Other).PickupAmmoCount = Weapon(Other).AmmoName.Default.MaxAmmo;
        return true;
    }
	
    if ( Other.IsA(WeaponName) )
    {
        Weapon(Other).PickupAmmoCount = Weapon(Other).AmmoName.Default.MaxAmmo;
        return true;
    }
    if ( Other.IsA(AmmoName) )
    {
        Ammo(Other).AmmoAmount = Ammo(Other).MaxAmmo;
        return true;
    }

    if ( NextMutator != None )
        return ( NextMutator.AlwaysKeep(Other) );
    return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	
    if ( Other.IsA('Weapon') )
    {
        if (WeaponString == "")
            return false;
		else if (WeaponString == "Botpack.WarHeadLauncher")
		{
			Level.Game.bCoopWeaponMode = false;
            //ReplaceWith(Other, "Botpack.UT_Eightball");
            return false;
		}
        else if ((WeaponString != "") && !Other.IsA(WeaponName))
        {
            Level.Game.bCoopWeaponMode = false;
            ReplaceWith(Other, WeaponString);
            return false;
        }
    }

    if ( Other.IsA('Ammo') )
    {
        if (AmmoString == "")
            return false;
		else if ((AmmoString == "Botpack.WarHeadAmmo"))
        {
			
            return false;
        }
        else if ((AmmoString != "") && !Other.IsA(AmmoName))
        {
            ReplaceWith(Other, AmmoString);
            return false;
        }
    }

    bSuperRelevant = 0;
    return true;
}

defaultproperties
{
    WeaponName=UT_Eightball
    AmmoName=RocketPack
    WeaponString="Botpack.UT_Eightball"
    AmmoString="Botpack.RocketPack"
    DefaultWeapon=class'Botpack.UT_Eightball'
}