/*
EnhancedFeedback 2
   Copyright (C) 2011 Xil[e]y
   
   This program is free software; you can redistribute and/or modify 
   it under the terms of the Open Unreal Mod License version 1.1.
*/
class EF_LamerSpree expands EF_Messages;

var string t_lamerSpree;
var string t_lamerSpree_P;
var string t_lamerSpreeEnd_F;
var string t_lamerSpreeEnd_M;
var string t_lamerSpreeEnd_P;
var string t_teamLamerSpree;
var string t_teamLamerSpreeEnd1;
var string t_teamLamerSpreeEnd2;

static function color GetColor(
    optional int Switch,
    optional PlayerReplicationInfo RelatedPRI_1, 
    optional PlayerReplicationInfo RelatedPRI_2
    )
{

switch(Switch)
{
	case 3:
		if(RelatedPRI_1 != RelatedPRI_2)
			return Default.WHITE;
		else
			return Default.RED;
	case 4:
		if(RelatedPRI_1 != RelatedPRI_2)
			return Default.WHITE;
		else
			return Default.GreenColor;
	case 10:
		if(RelatedPRI_1.Team != RelatedPRI_2.Team)
			return Default.WHITE;
		else
			return Default.RED;
	case 11:
		if(RelatedPRI_1.Team == RelatedPRI_2.Team)
			return Default.GreenColor;
		else
			return Default.WHITE;
}

}


static function string GetString
(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
)
{
	switch(Switch)
	{
		case 3:
			if(RelatedPRI_1 != RelatedPRI_2)
				return RelatedPRI_1.PlayerName $ Default.t_lamerSpree;
			else
				return Default.t_lamerSpree_P;
		case 4:
			if(RelatedPRI_1 != RelatedPRI_2)
			{
				if(RelatedPRI_1.bIsFemale)
					return RelatedPRI_1.PlayerName $ Default.t_lamerSpreeEnd_F;
				else
					return RelatedPRI_1.PlayerName $ Default.t_lamerSpreeEnd_M;
			}
			else
				return Default.t_lamerSpreeEnd_P;
			
		case 10:
			return Default.t_teams[RelatedPRI_1.Team] $ Default.t_teamLamerSpree;
		case 11:
			return Default.t_teamLamerSpreeEnd1 $ Default.t_teams[RelatedPRI_1.Team] $ Default.t_teamLamerSpreeEnd2 $ RelatedPRI_1.PlayerName $ ".";
		
	}
}

defaultproperties
{
	t_lamerSpree=" is on a lamerspree."
	t_lamerSpree_P="You are on a lamerspree."
	t_lamerSpreeEnd_M=" has ended his lamerspree."
	t_lamerSpreeEnd_F=" has ended her lamerspree."
	t_lamerSpreeEnd_P="You ended your lamerspree :)"
	t_teamLamerSpree=" is on a lamerspree."
	t_teamLamerSpreeEnd1="The lamerspree of "
	t_teamLamerSpreeEnd2=" was ended by "

	bBeep=False
	YPos=480
}