/*
EnhancedFeedback 2
   Copyright (C) 2011 Xil[e]y
   
   This program is free software; you can redistribute and/or modify 
   it under the terms of the Open Unreal Mod License version 1.1.
*/
#exec AUDIO IMPORT FILE="Sounds\q3humiliation.WAV" NAME="q3humiliation"

class EF_Humiliation expands EF_Messages;

var Sound s_humiliation;

var string t_humiliation;
var string t_humiliation_P;

var string t_teamKilling;

static function color GetColor(
    optional int Switch,
    optional PlayerReplicationInfo RelatedPRI_1, 
    optional PlayerReplicationInfo RelatedPRI_2
    )
{

switch(Switch)
{
	case 2:
		if(RelatedPRI_1 != RelatedPRI_2)
			return Default.WHITE;
		else
			return Default.ORANGE;
	case 14:
		return Default.RED;

}

}


static function string GetString
(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
)
{
	switch(Switch)
	{
		case 2:
			if(RelatedPRI_1 != RelatedPRI_2)
				return RelatedPRI_1.PlayerName $ Default.t_humiliation $ PlayerReplicationInfo(OptionalObject).PlayerName;
			else
				return Default.t_humiliation_P;
		case 14:
			return Default.t_teams[RelatedPRI_1.Team] $ Default.t_teamKilling;

	}
}

static function ClientReceive( 
    PlayerPawn P,
    optional int Switch,
    optional PlayerReplicationInfo RelatedPRI_1, 
    optional PlayerReplicationInfo RelatedPRI_2,
    optional Object OptionalObject
    )
{
	
    if ( P.myHUD != None )
        P.myHUD.LocalizedMessage( Default.Class, Switch, RelatedPRI_1, P.PlayerReplicationInfo, RelatedPRI_2);

	switch(Switch)
	{
		case 2:
			if(P.PlayerReplicationInfo == RelatedPRI_2)//killer gets the sound too
				P.ClientPlaySound(Default.s_humiliation,, True);
			else if(P.PlayerReplicationInfo == RelatedPRI_1)
				P.ClientPlaySound(Default.s_humiliation,, True);
				
			break;
	}
	
	//beep if wanted; configured and no sound was played
	if (Default.bBeep && P.bMessageBeep )
		P.PlayBeepSound();
	
    if ( Default.bIsConsoleMessage )
    {
        if ((P.Player != None) && (P.Player.Console != None))
            P.Player.Console.AddString(Static.GetString( Switch, RelatedPRI_1, P.PlayerReplicationInfo, RelatedPRI_2 ));
    }
}


defaultproperties
{
	s_humiliation=Sound'q3humiliation'
	
	t_humiliation=" was humiliated by "
	t_humiliation_P="You were humiliated o_O"
	
	t_teamkilling=" is teamkilling!!!"
	
	YPos=96
}


