/*
EnhancedFeedback 2
   Copyright (C) 2011 Xil[e]y
   
   This program is free software; you can redistribute and/or modify 
   it under the terms of the Open Unreal Mod License version 1.1.
*/
#exec AUDIO IMPORT FILE="Sounds\q33frags.WAV" NAME="q33frags"
#exec AUDIO IMPORT FILE="Sounds\q32frags.WAV" NAME="q32frags"
#exec AUDIO IMPORT FILE="Sounds\q31frag.WAV" NAME="q31frag"

class EF_Countdown_TSpree expands EF_Messages;

var Sound s_3fragsLeft;
var Sound s_2fragsLeft;
var Sound s_1fragLeft;

var string t_3fragsLeft;
var string t_2fragsLeft;
var string t_1fragLeft;

var string t_teamKillingSpree;
var string t_teamKillingSpreeEnd1;
var string t_teamKillingSpreeEnd2;



static function color GetColor(
    optional int Switch,
    optional PlayerReplicationInfo RelatedPRI_1, 
    optional PlayerReplicationInfo RelatedPRI_2
    )
{

switch(Switch)
{	
	case 5:
	case 6:
	case 7:
		return Default.WHITE;
	case 8:
		if(RelatedPRI_1.Team == RelatedPRI_2.Team)
			return Default.GreenColor;
		else
			return Default.WHITE;
	case 9:
		if(RelatedPRI_1.Team != RelatedPRI_2.Team)
			return Default.WHITE;
		else
			return Default.RED;
	
}

}

static function string GetString
(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
)
{
	switch(Switch)
	{
		case 5:
			return Default.t_3fragsLeft;
		case 6:
			return Default.t_2fragsLeft;
		case 7:
			return Default.t_1fragLeft;
		case 8:
			return Default.t_teams[RelatedPRI_1.Team] $ Default.t_teamKillingSpree;
		case 9:
			return Default.t_teamKillingSpreeEnd1 $ Default.t_teams[RelatedPRI_1.Team] $ Default.t_teamKillingSpreeEnd2 $ PlayerReplicationInfo(OptionalObject).PlayerName $ ".";
	}
}

static function ClientReceive( 
    PlayerPawn P,
    optional int Switch,
    optional PlayerReplicationInfo RelatedPRI_1, 
    optional PlayerReplicationInfo RelatedPRI_2,
    optional Object OptionalObject
    )
{
	
	local bool bDoBeep;
	
    if ( P.myHUD != None )
        P.myHUD.LocalizedMessage( Default.Class, Switch, RelatedPRI_1, P.PlayerReplicationInfo, RelatedPRI_2);

	switch(Switch)
	{
		case 5:
			P.ClientPlaySound(Default.s_3fragsLeft,, True);
			break;
		case 6:
			P.ClientPlaySound(Default.s_2fragsLeft,, True);
			break;
		case 7:
			P.ClientPlaySound(Default.s_1fragLeft,, True);
			break;			
		case 8:
			if(P.PlayerReplicationInfo.Team == RelatedPRI_1.Team)
				P.ClientPlaySound(Sound'Announcer.Killingspree',, True);
			else
				bDoBeep = True;
			break;
		case 9:
				bDoBeep = True;
			break;
	}
	
	//beep if wanted; configured and no sound was played
	if (bDoBeep && Default.bBeep && P.bMessageBeep )
		P.PlayBeepSound();
	
    if ( Default.bIsConsoleMessage )
    {
        if ((P.Player != None) && (P.Player.Console != None))
            P.Player.Console.AddString(Static.GetString( Switch, RelatedPRI_1, P.PlayerReplicationInfo, RelatedPRI_2 ));
    }
}

defaultproperties
{
	s_3fragsLeft=Sound'q33frags'
	s_2fragsLeft=Sound'q32frags';
	s_1fragLeft=Sound'q31frag'
		
	t_3fragsLeft="3 frags left!"
	t_2fragsLeft="2 frags left!"
	t_1fragLeft="1 frag left!!!"

	t_teamKillingSpree=" is on a killingspree!"
	t_teamKillingSpreeEnd1="The killingspree of "
	t_teamKillingSpreeEnd2=" was ended by "	
	
	YPos=384
}
