/*
EnhancedFeedback 2.1
   Copyright (C) 2011 Xil[e]y
   
   This program is free software; you can redistribute and/or modify 
   it under the terms of the Open Unreal Mod License version 1.1.
*/
class EnhancedFeedback expands Mutator;

var bool bDidPreInit;
//right gametype/different actions
var bool bIsDM;
var bool bIsTDM;
var bool bFFOn;
var bool bNoHumiliation;
var int numTeams;
var float goalScore;
var int announcedGap;

struct PLAYERSTRUCT
{
	var int 		ID;
	var Pawn		p;
	var int			lameCount;
};

var PLAYERSTRUCT ps[32];
var int leadingFrags;
var bool bMultipleLeaders;

struct TEAMSTRUCT
{
	var int			spreeCount;
	var int			lameCount;
	var int 		fragCount;
	var int 		teamKills;
};

var TEAMSTRUCT ts[4];

function PreBeginPlay()
{
	local TeamGamePlus tgp;
	
	if(bDidPreInit)
		return;
		
	bDidPreInit = True;
	
	//see what kind of game it is
	if(Level.Game.class == class'DeathMatchPlus')
	{
		bIsDM = True;
		goalScore = DeathMatchPlus(Level.Game).FragLimit;
	}
	else if(Level.Game.class == class'TeamGamePlus')
	{
		if(Level.Game.MaxPlayers == 2)
		{
			bIsDM = True;
			goalScore = TeamGamePlus(Level.Game).GoalTeamScore;
		}
		else
		{
			bIsTDM = True;
			tgp = TeamGamePlus(Level.Game);
			goalScore = tgp.GoalTeamScore;
			numTeams = tgp.MaxTeams;
			if(tgp.FriendlyFireScale > 0)
				bFFOn = True;
		}
	}
	else //no no never
	{
		Log(">> EnhancedFeedback 2.1 only runs with DM and TDM!");
		Self.Destroy();
		return;
	}
	
		
	if(Level.Game.BaseMutator != None && Level.Game.BaseMutator.DefaultWeapon != None && Level.Game.BaseMutator.DefaultWeapon.Default.bMeleeWeapon)
		bNoHumiliation = True;
		
	
	Log("============================");
	Log("EnhancedFeedback 2.1 running");
	Log("============================");
	
}


function int GetStructIndex(Pawn p)
{
	local int i, ID, e;
	
	ID = p.PlayerReplicationInfo.PlayerID;
	e = -1;
	
	for(i = 0;i<32;i++)
	{
		if(ps[i].p == None)
		{
			if(e == -1)
				e = i;
		}
		else if(ID == ps[i].ID)//refound?
			return i;
	}
	
	//new player:: reset/init
	ps[e].lameCount = 0;
	ps[e].ID = p.PlayerReplicationInfo.PlayerID;
	ps[e].p = p;
	
	return e;
}

function ScoreKill(Pawn Killer, Pawn Other)
{
	local int index;
	local PlayerPawn pp;
	local Pawn p;

    if ( NextMutator != None )
        NextMutator.ScoreKill(Killer, Other);

	if(Level.Game.bGameEnded)
		return;
	
	//Process killer
	if(Killer != None)
	{
		if(Other == Killer)
		{
			ProcessFragsDecrement(Other, False);
			return;
		}
		
		if(!bNoHumiliation && Killer.Weapon != None && Killer.Weapon.bMeleeWeapon)//humiliation took place
		{
			BroadcastLocalizedMessage(class'EF_Humiliation', 2, Other.PlayerReplicationInfo, Killer.PlayerReplicationInfo);
		}
		
		//this is not lame!
		if(bIsDM)
		{
			//KILLER
			index = GetStructIndex(Killer);
			//lamerspree ended?
			if(ps[index].lameCount >= 3)
			{
				//spread the message
				BroadcastLocalizedMessage(class'EF_LamerSpree', 4, Killer.PlayerReplicationInfo);
			}
			ps[index].lameCount = 0;//reset
			
			//new leader?
			if(int(Killer.PlayerReplicationInfo.Score) > leadingFrags)
			{
				leadingFrags = Killer.PlayerReplicationInfo.Score;
				
				if(bMultipleLeaders)
				{
					//spread the message
					BroadcastLocalizedMessage(class'EF_LeadTie', 0, Killer.PlayerReplicationInfo);
					
					//all other players left behind get a lost_lead snd
					if(leadingFrags != 1)
					{
						for(p = Level.PawnList; p!=None; p = p.nextPawn)
						{
							//lost the lead?
							if(p.bIsPlayer && p.bIsHuman && !p.PlayerReplicationInfo.bIsSpectator && (int(p.PlayerReplicationInfo.Score) + 1) == leadingFrags)
								class'EF_LeadTie'.static.PlayLostLeadSnd(PlayerPawn(p));
						}
					}
					
					
					//now -> this guy is leading alone
					bMultipleLeaders = False;
				}
				//else leading alone
				
			}
			else if(int(Killer.PlayerReplicationInfo.Score) == leadingFrags)//tied for the lead
			{
				//spread the message
				BroadcastLocalizedMessage(class'EF_LeadTie', 1, Killer.PlayerReplicationInfo);
				bMultipleLeaders = True;//run-up situation
			}
			
			//VICTIM on spree?
			UpdatePlayersLamerSpree(GetStructIndex(Other));

		}
		else if(bIsTDM)
		{
			///VICTIM FIRST
			index = Other.PlayerReplicationInfo.Team;
			TeamDoingLame(index, Killer, Other);
		
			//NOW THE KILLER
			index = Killer.PlayerReplicationInfo.Team;
			ts[index].spreeCount ++;
			ts[index].fragCount ++;
			if(ts[index].lameCount >= 3) //was dying before
			{
				//end lamerspree
				BroadcastLocalizedMessage(class'EF_LamerSpree', 11, Killer.PlayerReplicationInfo);
			}
			else if(ts[index].spreeCount == 5)
			{
				//killingspree
				BroadcastLocalizedMessage(class'EF_Countdown_TSpree', 8, Killer.PlayerReplicationInfo);
			}
			ts[index].lameCount = 0;
			//____________________________
			
			//new leading team?
			if(ts[index].fragCount > leadingFrags)
			{
				leadingFrags = ts[index].fragCount;
				
				if(bMultipleLeaders)//several teams had same score
				{
					//spread the message
					BroadcastLocalizedMessage(class'EF_LeadTie', 12, Killer.PlayerReplicationInfo);
					
					//all players from teams that had the same score get a lost_lead snd
					if(leadingFrags != 1)
					{
						for(p = Level.PawnList; p!=None; p = p.nextPawn)
						{
							//lost the lead?
							if(p.bIsPlayer && p.bIsHuman && !p.PlayerReplicationInfo.bIsSpectator && (ts[p.PlayerReplicationInfo.Team].fragCount + 1) == leadingFrags)
								class'EF_LeadTie'.static.PlayLostLeadSnd(PlayerPawn(p));
						}
					}
					
					//now -> this team is leading alone
					bMultipleLeaders = False;
				}
				//else leading alone 
			}
			else if(ts[index].fragCount == leadingFrags)//tied for the lead
			{
				//spread the message
				BroadcastLocalizedMessage(class'EF_LeadTie', 13, Killer.PlayerReplicationInfo);
				bMultipleLeaders = True;//run-up situation
			}
		}
		
		FragsLeft();
	}
	else
	{
		ProcessFragsDecrement(Other, False);
		//return;
	}

}

function UpdatePlayersLamerSpree(int index)
{
	ps[index].lameCount ++;//count
	
	//lamerspree?
	if(ps[index].lameCount == 3)
	{
		//spread the message
		BroadcastLocalizedMessage(class'EF_LamerSpree', 3, ps[index].p.PlayerReplicationInfo);
	}
}

function ProcessFragsDecrement(Pawn p, bool teamkill, optional Pawn Killer)
{
	local int index, i, max_i;
	local int maxFrags;
	local bool bMulti, bDone;
	local Pawn pwn, max;
	
		
	if(bIsDM)
	{
		index = GetStructIndex(p);
	
		//count as 'lame action'
		UpdatePlayersLamerSpree(index);
		
		//?see if player was a leader, but now fell behind
		if(int(p.PlayerReplicationInfo.Score) + 1 == leadingFrags)
		{
			maxFrags = -9999;
		
			//iterate all players
			for(pwn = Level.PawnList; pwn != None; pwn = pwn.nextPawn)
			{
				if(pwn.bIsPlayer && !pwn.PlayerReplicationInfo.bIsSpectator)
				{
					if(maxFrags < int(pwn.PlayerReplicationInfo.Score))//new best
					{
						maxFrags = pwn.PlayerReplicationInfo.Score;
						max = pwn;
						bMulti = False;
					}
					else if(maxFrags == int(pwn.PlayerReplicationInfo.Score))
						bMulti = True;
				}
			}
			
			//what's the result?
			if(maxFrags == leadingFrags)//still someone else has the leadingFrags-score
			{
				if(!bMulti)//new leader
				{
					BroadcastLocalizedMessage(class'EF_LeadTie', 0, max.PlayerReplicationInfo);
					//p lost lead
					class'EF_LeadTie'.static.PlayLostLeadSnd(PlayerPawn(p));
				}
				
			}
			else //new leader(s) with maxFrags = leadingfrags - 1
			{
				if(bMulti)//suiciding player equalized with others
				{
					BroadcastLocalizedMessage(class'EF_LeadTie', 1, p.PlayerReplicationInfo);

					//tied snd for players now equal to leader falling behind
					for(pwn = Level.PawnList; pwn!=None; pwn = pwn.nextPawn)
					{
						//lost the lead?
						if(pwn.bIsPlayer && pwn.bIsHuman && !pwn.PlayerReplicationInfo.bIsSpectator && (int(pwn.PlayerReplicationInfo.Score) == maxFrags))
							class'EF_LeadTie'.static.PlayTiedLeadSnd(PlayerPawn(pwn));
					}
				}
			}
			
			//now refer
			bMultipleLeaders = bMulti;
			leadingFrags = maxFrags;
		}
	}
	else if(bIsTDM)
	{
		index = p.PlayerReplicationInfo.Team;
		


		//count teamkills
		if(teamkill)
		{
			ts[index].teamKills ++;
			if(ts[index].teamKills == 5)//5 teamkills -> give msg
			{
				ts[index].teamKills = 0;
				BroadcastLocalizedMessage(class'EF_Humiliation', 14, p.PlayerReplicationInfo);
			}
			//look at sprees
			TeamDoingLame(index, Killer, p);
		}
		else //look at sprees
			TeamDoingLame(index, p, p);

		//maybe deal with frags decrement
		if(!teamkill || bFFOn)
		{
			ts[index].fragCount--;
		
			//?see if team was a leading one, but now fell behind (old leadingFrags)
			if(ts[index].fragCount + 1 == leadingFrags)
			{
				maxFrags = -9999;
			
				//iterate all teams
				for(i = 0;i<numTeams;i++)
				{
					if(maxFrags < ts[i].fragCount)//new best
					{
						maxFrags = ts[i].fragCount;
						max_i = i;
						bMulti = False;
					}
					else if(maxFrags == ts[i].fragCount)
						bMulti = True;
				
				}
				
				//what's the result?
				if(maxFrags == leadingFrags)//still some team has the leadingFrags-score
				{
					if(!bMulti)//new leader
					{
						//find player of that team
						for(pwn = Level.PawnList; pwn != None; pwn = pwn.nextPawn)
						{
							if(!bDone && pwn.PlayerReplicationInfo.Team == max_i)
							{
								BroadcastLocalizedMessage(class'EF_LeadTie', 12, pwn.PlayerReplicationInfo);		
								bDone = True;
							}
							//teammembers get lost_lead snd
							if(p.PlayerReplicationInfo.Team == pwn.PlayerReplicationInfo.Team)
								class'EF_LeadTie'.static.PlayLostLeadSnd(PlayerPawn(pwn));
						}
					}
				}
				else //new leader(s) with less frags
				{
					if(bMulti)//team of suiciding player paired with others
					{
						//announce tied-for-lead
						BroadcastLocalizedMessage(class'EF_LeadTie', 13, p.PlayerReplicationInfo);
						//sound for players tieing through this
						for(pwn = Level.PawnList; pwn!=None; pwn = pwn.nextPawn)
						{
							//lost the lead?
							if(pwn.bIsPlayer && pwn.bIsHuman && !pwn.PlayerReplicationInfo.bIsSpectator && (ts[pwn.PlayerReplicationInfo.Team].fragCount + 1) == leadingFrags)
								class'EF_LeadTie'.static.PlayTiedLeadSnd(PlayerPawn(pwn));
						}
					}
				}
				
				//now refer 
				bMultipleLeaders = bMulti;
				leadingFrags = maxFrags;
			}
		}
	}
	
	FragsLeft();
}

function FragsLeft()
{
	local int delta;
	//announce frags left?
	delta = goalScore - leadingFrags;

	if(delta != announcedGap && delta > 0 && delta < 4)//right range and did announce smth else/nothing before
	{
		announcedGap = delta;
		BroadcastLocalizedMessage(class'EF_Countdown_TSpree', 8 - delta);
	}

}

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
	local Pawn pwn;
	local int i;

	//DM: update situation possibly messed up by joining/leaving players
	
	if(bIsDM)
	{
		leadingFrags = -9999;
		bMultipleLeaders = False;
	
		for(pwn = Level.PawnList; pwn != None; pwn = pwn.nextPawn)
		{
			if(pwn.bIsPlayer && !pwn.PlayerReplicationInfo.bIsSpectator)
			{
				if(leadingFrags < int(pwn.PlayerReplicationInfo.Score))//new best
				{
					leadingFrags = pwn.PlayerReplicationInfo.Score;
					bMultipleLeaders = False;
				}
				else if(leadingFrags == int(pwn.PlayerReplicationInfo.Score))//same
					bMultipleLeaders = True;
			}
		}
	}
	else if(bIsTDM)
	{
		//teamkills don't reach scoreKill
		if(Killer != None && Killed.PlayerReplicationInfo.Team == Killer.PlayerReplicationInfo.Team && 
			Killed != Killer)
		{
			ProcessFragsDecrement(Killed, True, Killer);
		}	
	}
	
	if ( NextMutator != None )
		return NextMutator.PreventDeath(Killed,Killer, damageType,HitLocation);
	return false;
}

function TeamDoingLame(int index, Pawn Killer, Pawn Victim)
{
	ts[index].lameCount ++;
	if(ts[index].spreeCount >= 5)
	{
		BroadcastLocalizedMessage(class'EF_Countdown_TSpree', 9, Victim.PlayerReplicationInfo, Killer.PlayerReplicationInfo);
	}
	else if(ts[index].lameCount == 3)
	{
		BroadcastLocalizedMessage(class'EF_LamerSpree', 10, Victim.PlayerReplicationInfo);
	}
	ts[index].spreeCount = 0;
}


defaultproperties
{
	bMultipleLeaders=True
}