/*
EnhancedFeedback 2.1
   Copyright (C) 2011 Xil[e]y
   
   This program is free software; you can redistribute and/or modify 
   it under the terms of the Open Unreal Mod License version 1.1.
*/
class EF_Messages expands CriticalEventPlus 
	abstract;

var color RED;
var color WHITE;

var string t_teams[4];

/*
SWITCH_TABLE
0 == tookLead; PRI1 = new leader
1 == tiedLead; PRI1 = player joining leader
2 == humiliation; PRI1 = player being humiliated; PRI2 == humiliatedby
3 == lamerspree start; PRI1 = player on a lamerspree
4 == lamerspree end; PRI1 = player ended the lamerspree
5 == 3 frags left
6 == 2 frags left
7 == 1 frag left
8 == team killingspree PRI1 = example player (killer)
9 == end team killingspree PRI1 = example player (victim)/PRI2 = killer
10 == teamlamerspree PRI1 = example player (victim)
11 == end teamlamerspree PRI1 = example player (killer)
12 == teamLead; PRI1 = leading team
13 == teamTied;
14 == teamkilling
*/

static function ClientReceive( 
    PlayerPawn P,
    optional int Switch,
    optional PlayerReplicationInfo RelatedPRI_1, 
    optional PlayerReplicationInfo RelatedPRI_2,
    optional Object OptionalObject
    )
{
	
    if ( P.myHUD != None )
        P.myHUD.LocalizedMessage( Default.Class, Switch, RelatedPRI_1, P.PlayerReplicationInfo, RelatedPRI_2);

	
	if (Default.bBeep && P.bMessageBeep )
		P.PlayBeepSound();
	
    if ( Default.bIsConsoleMessage )
    {
        if ((P.Player != None) && (P.Player.Console != None))
            P.Player.Console.AddString(Static.GetString( Switch, RelatedPRI_1, P.PlayerReplicationInfo, RelatedPRI_2 ));
    }
}


defaultproperties
{
	RED=(R=255)
	WHITE=(R=255,G=255,B=255)

	t_teams(0)="Team RED"
	t_teams(1)="Team BLUE"
	t_teams(2)="Team GREEN"
	t_teams(3)="Team GOLD"
	
	LifeTime=4
}
