/*
EnhancedFeedback 2.1
   Copyright (C) 2011 Xil[e]y
   
   This program is free software; you can redistribute and/or modify 
   it under the terms of the Open Unreal Mod License version 1.1.
*/

#exec AUDIO IMPORT FILE="Sounds\q3takenlead.WAV" NAME="q3takenlead"
#exec AUDIO IMPORT FILE="Sounds\q3tiedlead.WAV" NAME="q3tiedlead"
#exec AUDIO IMPORT FILE="Sounds\q3lostlead.WAV" NAME="q3lostlead"

class EF_LeadTie expands EF_Messages;

var Sound s_tookLead;
var Sound s_tiedLead;
var Sound s_lostLead;

var string t_tookLead;
var string t_tookLead_P;
var string t_tiedLead;
var string t_tiedLead_P;

static function color GetColor(
    optional int Switch,
    optional PlayerReplicationInfo RelatedPRI_1, 
    optional PlayerReplicationInfo RelatedPRI_2
    )
{

switch(Switch)
{
	case 0:
		if(RelatedPRI_1 != RelatedPRI_2)
			return Default.WHITE;
		else
			return Default.GreenColor;
	case 1:
		if(RelatedPRI_1 != RelatedPRI_2)
			return Default.WHITE;
		else
			return Default.GreenColor;
	case 12:
	case 13:
		if(RelatedPRI_1.Team == RelatedPRI_2.Team)
			return Default.GreenColor;
		else
			return Default.WHITE;
}

}


static function string GetString
(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1, 
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
)
{
	switch(Switch)
	{
		case 0:
			if(RelatedPRI_1 != RelatedPRI_2)
				return RelatedPRI_1.PlayerName $ Default.t_tookLead;
			else
				return Default.t_tookLead_P;
		case 1:
			if(RelatedPRI_1 != RelatedPRI_2)
				return RelatedPRI_1.Playername $ Default.t_tiedLead;
			else
				return Default.t_tiedLead_P;
		case 12:
			return Default.t_teams[RelatedPRI_1.Team] $ Default.t_tookLead;
		case 13:
			return Default.t_teams[RelatedPRI_1.Team] $ Default.t_tiedLead;
	}
}

static function ClientReceive( 
    PlayerPawn P,
    optional int Switch,
    optional PlayerReplicationInfo RelatedPRI_1, 
    optional PlayerReplicationInfo RelatedPRI_2,
    optional Object OptionalObject
    )
{
	local bool bDoBeep;
	
    if ( P.myHUD != None )
        P.myHUD.LocalizedMessage( Default.Class, Switch, RelatedPRI_1, P.PlayerReplicationInfo, RelatedPRI_2);

	switch(Switch)
	{
		case 0:
			if(P.PlayerReplicationInfo == RelatedPRI_1)
				P.ClientPlaySound(Default.s_tookLead,, True);
			else
				bDoBeep = True;
			break;
		case 1:
			if(P.PlayerReplicationInfo == RelatedPRI_1)
				P.ClientPlaySound(Default.s_tiedLead,, True);
			else
				bDoBeep = True;
			break;
		
		
		
		case 12:
			if(P.PlayerReplicationInfo.Team != RelatedPRI_1.Team)
				bDoBeep = True;
			else
				P.ClientPlaySound(Default.s_tookLead,, True);
				
			break;
		case 13:
			if(P.PlayerReplicationInfo.Team == RelatedPRI_1.Team)
				P.ClientPlaySound(Default.s_tiedLead,, True);
			else
				bDoBeep = True;
			break;
	}
	
	//beep if wanted; configured and no sound was played
	if (bDoBeep && Default.bBeep && P.bMessageBeep )
		P.PlayBeepSound();
	
    if ( Default.bIsConsoleMessage )
    {
        if ((P.Player != None) && (P.Player.Console != None))
            P.Player.Console.AddString(Static.GetString( Switch, RelatedPRI_1, P.PlayerReplicationInfo, RelatedPRI_2 ));
    }
}

static function PlayLostLeadSnd(PlayerPawn pp)
{
	if(pp != None)
		pp.ClientPlaySound(Default.s_lostLead,, True);
}

static function PlayTiedLeadSnd(PlayerPawn pp)
{
	if(pp != None)
		pp.ClientPlaySound(Default.s_tiedLead,, True);
}


defaultproperties
{
	t_tookLead=" has taken the lead!"
	t_tookLead_P="You took the lead!"
	t_tiedLead=" has tied for the lead."
	t_tiedLead_P="You tied for the lead."
	
	s_tookLead=Sound'q3takenlead'
	s_tiedLead=Sound'q3tiedlead'
	s_lostLead=Sound'q3lostlead'

	YPos=624
}