//================================================================================
// VAServer.
//================================================================================

class VAServer extends Mutator;

var string nextoptions;
var string MenuName;
var string RevertVoice;

static simulated function VAPRI GetVAPRI (Actor A)
{
  return class'VAPRI'.static.GetVAPRI(A);
}
/* 
function PreBeginPlay ()
{
  Spawn(class'VAPlayerFixActor');
  Spawn(Class'NN_DemoRecSN');
  Spawn(Class'DummyRI');
}
 */
function ModifyPlayer (Pawn Other)
{
  Super.ModifyPlayer(Other);   
}

function PostBeginPlay ()
{
  local string Pound; 

  Class'VASettings'.static.staticsaveconfig();
    
  Pound = "________________________________";
  Log(Pound);
  Log("      #       #    #");
  Log("       #     #    # #");
  Log("        #   #    #####");
  Log("         # #    #     #");
  Log("          #    #       #");
  Log(Pound);
  Log("#  Valhalla Avatar for NewNet  #");
  if ( Level.NetMode != NM_DedicatedServer )
  {
    Log("#     Error: Only for use      #");
    Log("#    on Dedicated Servers!     #");
    Destroy();
  } else {
    Log("#    Success: Initialized!     #");
  }
  if ( bDeleteMe )
  {
    return;
  }
    Log("Client overrides:" @ string(class'VASettings'.default.AllowClientOverride));
    Log("Default player:" @ class'VASettings'.default.DefaultPlayer);
    Log("Gesture interval:" @ string(class'VASettings'.default.gesturetime));
  if ( Class'VASettings'.Default.MeshSkinAllowChange == 0 )
  {
    Log("Mesh and skin in-game changing disabled!");
  } else {
    if ( Class'VASettings'.Default.MeshSkinAllowChange == 1 )
    {
      Log("skin in-game changing enabled, but mesh changing is disabled!");
    } else {
      Log("Mesh and skin in-game changing enabled!");
    }
  }
  Log(Pound);
  NextMutator = Level.Game.BaseMutator.NextMutator;
  Level.Game.BaseMutator.NextMutator = self;
  Spawn(Class'ShieldNotify');
}

function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{
  nextoptions = Options;

  if ( NextMutator != None )
  {
    NextMutator.ModifyLogin(SpawnClass,Portal,Options);
  }
  RevertVoice = SpawnClass.Default.VoiceType;
  if (  !ClassIsChildOf(SpawnClass,Class'Spectator') )
  {
    SpawnClass = Class'VAPlayer';
  }
}

function bool CheckReplacement (Actor thing, out byte i)
{
  local Class<VoicePack> vpclass;
  local PlayerReplicationInfo PRI;
  local VAPRI APRI;
  local BotReplicationInfo Bp;

  if ( VAPlayer(thing) != None )
  {
    Spawn(Class'VAPRI',thing);
    VAPlayer(thing).zzNoOverride =  !Class'VASettings'.Default.AllowClientOverride;
  }
  Bp = BotReplicationInfo(thing);
  if ( (Bp != None) && (thing.Owner != None) && (VAPlayer(thing.Owner.Owner) != None) )
  {
    thing = Bp;
  }
  if ( (PlayerReplicationInfo(thing) != None) && (VAPlayer(thing.Owner) != None) && (Class'VAPRI'.static.GetVAPRI(thing) != None) )
  {
    PRI = PlayerReplicationInfo(thing);
    GetVAPRI(thing).PRI = PRI;
    GetVAPRI(thing).zzVoicestring = Level.Game.ParseOption(nextoptions,"Voice");
    GetVAPRI(thing).zzClassString = xxclasscheck(Level.Game.ParseOption(nextoptions,"Class"));
    GetVAPRI(thing).zzskinstring = Level.Game.ParseOption(nextoptions,"Skin");
    GetVAPRI(thing).zzfacestring = Level.Game.ParseOption(nextoptions,"Face");
    if ( GetVAPRI(thing).zzskinstring == "" )
    {
      GetVAPRI(thing).zzskinstring = "None";
    }
    if ( GetVAPRI(thing).zzfacestring == "" )
    {
      GetVAPRI(thing).zzfacestring = "None";
    }
    Log(PRI.PlayerName $ "VA - Options: Class:" @ GetVAPRI(thing).zzClassString @ "Skin:" @ GetVAPRI(thing).zzskinstring @ "Face:" @ GetVAPRI(thing).zzfacestring @ "Voice:" @ GetVAPRI(thing).zzVoicestring);
    PlayerPawn(thing.Owner).MenuName = MenuName;
    vpclass = Class<VoicePack>(DynamicLoadObject(RevertVoice,Class'Class',True));
    if ( vpclass != None )
    {
      PRI.VoiceType = vpclass;
    }
  }
  return True;
}

function string xxclasscheck (string inclass)
{
  local int i;
  local Class<PlayerPawn> LocalCheck;

  MenuName = "";
  switch (Caps(inclass))
  {
	case "OLDSKOOL.MALEONE":
	case "OLDMODELS.OLDMODELSMALEONE":
	case "UNREAL1MODELS.TMALEONE":
	case "UNREALI.MALEONE":
	inclass="UnrealI.MaleOne";
	MenuName="Male 1";
	break;
	case "OLDSKOOL.MALETWO":
	case "OLDMODELS.OLDMODELSMALETWO":
	case "UNREAL1MODELS.TMALETWO":
	case "UNREALI.MALETWO":
	inclass="UnrealI.MaleTwo";
	MenuName="Male 2";
	break;
	case "OLDSKOOL.MALETHREE":
	case "OLDMODELS.OLDMODELSMALETHEEE":
	case "UNREAL1MODELS.TMALETHREE":
	case "UNREALI.MALETHREE":
	inclass="UnrealI.MaleThree";
	MenuName="Male 3";
	break;
	case "OLDSKOOL.FEMALEONE":
	case "OLDMODELS.OLDMODELSFEMALEONE":
	case "UNREAL1MODELS.TFEMALEONE":
	case "UNREALI.FEMALEONE":
	inclass="UnrealI.FemaleOne";
	MenuName="Female 1";
	break;
	case "OLDSKOOL.FEMALETWO":
	case "UNREAL1MODELS.TFEMALETWO":
	case "OLDMODELS.OLDMODELSFEMALETWO":
	case "UNREALI.FEMALETWO":
	inclass="UnrealI.FemaleTwo";
	MenuName="Female 2";
	break;
	case "UNREALI.NALIPLAYER":
	case "NALIFIX.TNALI2":
	case "UNREAL1MODELS.TOURNAMENTNALI":
	case "MULTIMESH.TNALI":
	inclass="MultiMesh.TNali";
	MenuName="Nali";
	break;
	case "OLDSKOOL.SKTROOPER":
	case "OLDMODELS.OLDMODELSSKTROOPER":
	case "UNREAL1MODELS.TOURNAMENTSKTROOPER":
	case "UNREALI.SKAARJPLAYER":
	inclass="UnrealI.SkaarjPlayer";
	MenuName="Skaarj Trooper";
	break;
	case "MULTIMESH.TSKAARJ":
	MenuName="Skaarj Hybrid";
	break;
	case "COWFIX.TCOWFIXED":
	case "MULTIMESH.TCOW":
	inclass="MultiMesh.TCow";
	MenuName="Nali Cow";
	break;
	case "SKELETALCHARSFIX313.WARBOSSFIX313":
	case "SKELETALCHARSFIX313.WARBOSSMFIX313":
	case "SKELETALCHARS.WARBOSS":
	inclass="SkeletalChars.WarBoss";
	MenuName="War Boss";
	break;
	case "SKELETALCHARSFIX313.XANMK2FIX313":
	case "SKELETALCHARSFIX313.XANMK2MFIX313":
	case "SKELETALCHARS.XANMK2":
	inclass="SkeletalChars.XanMk2";
	MenuName="Xan Mark ][";
	break;
	case "BOSSFACE.TBOSSFACE":
	inclass="BotPack.TBoss";
	MenuName="Boss";
	break;
	case "VABETA.VAPlayer":
	case "":
	inclass=Class'VASettings'.Default.DefaultPlayer;
	break;
  }
  for(i = 0; i < 64; i++)
  {
    if ( Class'VASettings'.Default.BadClasses[i] ~= inclass )
    {
      MenuName = "";
      inclass = Class'VASettings'.Default.DefaultPlayer;
      break;
    } 
  }
  
  if ( MenuName == "" )
  {
    LocalCheck = Class<PlayerPawn>(DynamicLoadObject(inclass,Class'Class',True));
    if ( LocalCheck != None )
    {
      MenuName = LocalCheck.Default.MenuName;
    } else {
      MenuName = GetItemName(inclass);
    }
  }
  return inclass;
}

function Destroyed ()
{
  local Mutator zzm;

  if ( Level.Game == None )
  {
    return;
  }
  for(zzm = Level.Game.BaseMutator; zzm != None; zzm = zzm.NextMutator)
  {
    if ( zzm.NextMutator == self )
      break;
  }
  zzm.NextMutator = NextMutator;
  NextMutator = None;
}