class VACarcass extends UTHumanCarcass;

var float LastHit;
var float Oldlasthit;
var bool bJerking;
var name Jerks[4];
var VAPRI PRI;
var byte zzdeathanim;
var Vector zzmyloc;
var bool zzinitialized;
var Class<VAGibber> GibberClass;

replication
{
  reliable if ( ROLE == ROLE_Authority )
    LastHit,bJerking,PRI,zzmyloc;
  reliable if ( (ROLE == ROLE_Authority) && bNetInitial )
    zzdeathanim;
}

function PostBeginPlay ()
{  
  Super.PostBeginPlay();
  if ( Region.Zone.bWaterZone )
  {
    SetCollision(bCollideActors,False,False);
  }  
}

function ZoneChange (ZoneInfo NewZone)
{
  Super.ZoneChange(NewZone);
  if ( NewZone.bWaterZone )
  {
    SetCollision(bCollideActors,False,False);
  }
}

simulated function xxInit ()
{
  local int i;
  local float Rand;
  
  zzinitialized = True;
  if ( PRI != None )
  {
    PlayerOwner = PRI.PRI;
  }
  if ( zzdeathanim == 0 )
  {
    bHidden = True;
    return;
  }
  if ( PRI != None )
  {
    for(i = 0; i < 8 ; i++)
    {
      MultiSkins[i] = PRI.MultiSkins[i];
      if ( MultiSkins[i] != None )
        MultiSkins[i].LODSet = LODSET_Skin;
    }
  }
  Oldlasthit = LastHit + Level.TimeSeconds;
  if ( PRI != None )
  {
    Mesh = PRI.zzMyClass.Default.Mesh;
    Skin = PRI.Skin;
  }
  if ( Skin != None )
  {
    Skin.LODSet = LODSET_Skin;
  }
  
  if ( PRI != None )
  {
    Texture = PRI.Texture;
    DrawScale = PRI.DrawScale;
    
    if(string(PRI.zzMyClass) ~= "unreali.skaarjplayer")
    {
      AnimSequence = 'Death2';
      AnimFrame = 0.922;
      SimAnim.X = 9200.0;
    }    
  }
  
  if ( HasAnim('DeathEnd') )
  {
    Rand = FRand();
    if ( (Rand < 0.331) ||  !HasAnim('DeathEnd2') )
    {
      PlayAnim('DeathEnd');
    } else {
      if ( (Rand < 0.663) ||  !HasAnim('DeathEnd3') )
      {
        PlayAnim('DeathEnd2');
      } else {
        PlayAnim('DeathEnd3');
      }
    }
  } else {
    PlayAnim('Dead2',60.0,0.01);
  }
  if ( Class'GameInfo'.Default.bVeryLowGore )
  {
    bGreenBlood = True;
  }
}

simulated function SetDeathAnim ()
{
  if(PRI.Owner == none)
  {
    Log("VA: Error owner none!");
    return;
  }
  if ( PRI.Owner.ROLE == ROLE_SimulatedProxy )
  {
    VAPlayer(PRI.Owner).MeshInfo.static.PlayDying(VAPlayer(PRI.Owner),zzdeathanim - 1);
  }
  AnimSequence = PRI.Owner.AnimSequence;
  AnimFrame = PRI.Owner.AnimFrame;
  AnimRate = PRI.Owner.AnimRate;
  TweenRate = PRI.Owner.TweenRate;
  AnimMinRate = PRI.Owner.AnimMinRate;
  AnimLast = PRI.Owner.AnimLast;
  bAnimLoop = PRI.Owner.bAnimLoop;
  SimAnim.X = 10000.0 * AnimFrame;
  SimAnim.Y = 5000.0 * AnimRate;
  SimAnim.Z = 1000.0 * TweenRate;
  SimAnim.W = 10000.0 * AnimLast;
  bAnimFinished = PRI.Owner.bAnimFinished;
}

function Initfor (Actor Other)
{
  local Rotator carcRotation;

  PlayerOwner = Pawn(Other).PlayerReplicationInfo;
  PRI = Class'VAPRI'.static.GetVAPRI(PlayerOwner);
  bReducedHeight = False;
  PrePivot = vect(0.00,0.00,3.00);
  if ( bDecorative )
  {
    DeathZone = Region.Zone;
    DeathZone.NumCarcasses++;
  }
  bDecorative = False;
  bMeshCurvy = Other.bMeshCurvy;
  bMeshEnviroMap = Other.bMeshEnviroMap;
  Fatness = Other.Fatness;
  SetCollisionSize(Other.CollisionRadius + 4,Other.CollisionHeight);
  if (  !SetLocation(Location) )
  {
    SetCollisionSize(CollisionRadius - 4,CollisionHeight);
  }
  DesiredRotation = Other.Rotation;
  DesiredRotation.Roll = 0;
  DesiredRotation.Pitch = 0;
  Velocity = Other.Velocity;
  Mass = Other.Mass;
  if ( Buoyancy < 0.81 * Mass )
  {
    Buoyancy = 0.89999998 * Mass;
  }
}

function TakeDamage (int Damage, Pawn instigatedBy, Vector HitLocation, Vector Momentum, name DamageType)
{
  local bool bRiddled;

  if ( bJerking )
  {
    bJerking = True;
    if ( Damage < 23 )
    {
      LastHit = Level.TimeSeconds;
    } else {
      bJerking = False;
    }
  }
  Super.TakeDamage(Damage,instigatedBy,HitLocation,Momentum,DamageType);
  if ( bJerking )
  {
    CumulativeDamage = 50;
    Velocity.Z = FMax(Velocity.Z,40.0);
    if ( instigatedBy == None )
    {
      bJerking = False;
    }
  }
  if ( bJerking && (VSize(instigatedBy.Location - Location) < 150) && (instigatedBy.Acceleration != vect(0.00,0.00,0.00)) && (Normal(instigatedBy.Velocity) Dot Normal(Location - instigatedBy.Location) > 0.69999999) )
  {
    bJerking = False;
  }
}

function xxsetanim (byte zzAnim)
{
  local VAGibber zzgib;

  zzdeathanim = zzAnim + 1;
  bJerking = zzAnim == 5;
  LastHit = Level.TimeSeconds;
  zzgib = Spawn(GibberClass,,,Location);
  zzgib.zzmycarc = self;
}

simulated function Tick (float Delta)
{
  if ( Level.NetMode != NM_Client )
  {
    Disable('Tick');
    return;
  }

  if (  !zzinitialized && (PRI != None) )
    xxInit();    

  if ( zzmyloc != vect(0.00,0.00,0.00) )
  {
    SetLocation(zzmyloc);
    zzmyloc = vect(0.00,0.00,0.00);
  }
}

simulated function ClientChunk ()
{
  local UTMasterCreatureChunk carc;
  local MasterCreatureChunk oldCarc;
  local Class<MasterCreatureChunk> oldCarcClass;
  local UT_BloodBurst B;

  GotoState('ClientGibbing');
  bHidden = True;
  B = Spawn(Class'UT_BigBloodHit',,,Location,rot(-16384,0,0));
  if ( bGreenBlood )
  {
    B.GreenBlood();
  }
  SetCollision(False,False,False);
  Disable('Tick');
  if ( Class'GameInfo'.Default.bLowGore )
  {
    return;
  }
  if ( ClassIsChildOf(PRI.zzMyClass,Class'UnrealIPlayer') )
  {
    if ( string(PRI.zzMyClass) ~= "unreali.skaarjplayer" )
    {
      oldCarcClass = Class'troopermasterchunk';
    } else {
      oldCarcClass = Class<MasterCreatureChunk>(Class<HumanCarcass>(PRI.zzMyClass.Default.CarcassType).Default.MasterReplacement);
    }
    oldCarcClass.Default.bMasterChunk = False;
    oldCarc = Spawn(oldCarcClass,,,Location + CollisionHeight * vect(0.00,0.00,0.50));
    oldCarcClass.Default.bMasterChunk = True;
    if ( oldCarc != None )
    {
      oldCarc.RemoteRole = ROLE_None;
      oldCarc.bMasterChunk = True;
      oldCarc.PlayerRep = PlayerOwner;
      oldCarc.bGreenBlood = bGreenBlood;
      oldCarc.Initfor(self);
      oldCarc.bMasterChunk = False;
    }
  } else {
    carc = Spawn(Class<UTHumanCarcass>(PRI.zzMyClass.Default.CarcassType).Default.MasterReplacement,,,Location + CollisionHeight * vect(0.00,0.00,0.50));
    if ( carc != None )
    {
      carc.RemoteRole = ROLE_None;
      carc.PlayerRep = PlayerOwner;
      carc.Initfor(self);
      carc.Disable('Tick');
      carc.ClientExtraChunks();
    }
  }
}

function ChunkUp (int Damage)
{
  local VAGibber zzgib;

  if ( bPermanent )
  {
    return;
  }
  if ( Region.Zone.bPainZone && (Region.Zone.DamagePerSec > 0) )
  {
    if ( Bugs != None )
    {
      Bugs.Destroy();
    }
  }
  zzdeathanim = 0;
  SetPhysics(PHYS_Rotating);
  zzgib = Spawn(GibberClass,,,Location);
  zzgib.zzmycarc = self;
  zzgib.zzbgib = True;
  SetCollision(False,False,False);
  bProjTarget = False;
  Disable('Tick');
  GotoState('Gibbing');
}

simulated function AnimEnd ()
{
  local name newAnim;
  local bool checkjerk;
  local int zzi;

  if ( ROLE == ROLE_Authority )
  {
    return;
  }
  if (  !bJerking )
  {
    checkjerk = (AnimSequence == 'Dead9');        
    if (  !checkjerk )
    {
      for(zzi = 0; zzi < 4; zzi++)
      {
        if ( AnimSequence == Jerks[zzi] )
        {
          checkjerk = True;
          break;
        }
      }
    }
  }
  if (  !bJerking &&  !checkjerk )
  {
    if ( Physics == PHYS_None )
    {
      LieStill();
    } else {
      if ( Region.Zone.bWaterZone )
      {
        bThumped = True;
        LieStill();
      }
    }
  } else {
    if ( checkjerk && (LastHit + Level.TimeSeconds - Oldlasthit < 0.25) && (FRand() > 0.02) )
    {
      Oldlasthit = LastHit;
      newAnim = Jerks[Rand(4)];
      if ( newAnim == AnimSequence )
      {
        if ( newAnim == Jerks[0] )
        {
          newAnim = Jerks[1];
        } else {
          newAnim = Jerks[0];
        }
      }
      TweenAnim(newAnim,0.151);
    } else {
      bJerking = False;
      if ( HasAnim('Dead9B') )
      {
        PlayAnim('Dead9B',1.12,0.1);
      }
    }
  }
}

function ReduceCylinder ()
{
  local float OldHeight;
  local Vector OldLocation;

  if ( ROLE == ROLE_SimulatedProxy )
  {
    return;
  }
  bReducedHeight = True;
  SetCollision(bCollideActors,False,False);
  OldHeight = CollisionHeight;
  if ( ReducedHeightFactor < Default.ReducedHeightFactor )
  {
    SetCollisionSize(CollisionRadius,CollisionHeight * ReducedHeightFactor);
  } else {
    SetCollisionSize(CollisionRadius + 4,CollisionHeight * ReducedHeightFactor);
  }
  PrePivot = vect(0.00,0.00,1.00) * (OldHeight - CollisionHeight);
  OldLocation = Location;
  if (  !SetLocation(OldLocation - PrePivot) )
  {
    SetCollisionSize(CollisionRadius - 4,CollisionHeight);
    if (  !SetLocation(OldLocation - PrePivot) )
    {
      SetCollisionSize(CollisionRadius,OldHeight);
      SetCollision(False,False,False);
      PrePivot = vect(0.00,0.00,0.00);
      if (  !SetLocation(OldLocation) )
      {
        ChunkUp(200);
      }
    }
  }
  zzmyloc = Location;
  PrePivot = PrePivot + vect(0.00,0.00,3.00);
  Mass = Mass * 0.81;
  Buoyancy = Buoyancy * 0.81;
}

simulated function LieStill ()
{
  if ( Role != ROLE_Authority )
  {
    SimAnim.X = 10000.0 * AnimFrame;
    SimAnim.Y = 5000.0 * AnimRate;
  }
  if (  !bThumped &&  !bDecorative )
  {
    LandThump();
  }
  if (  !bReducedHeight )
  {
    ReduceCylinder();
  }
}

simulated function UIGibSound ()
{
  local float decision;

  decision = FRand();
  if ( decision < 0.2 )
  {
    PlaySound(Sound'Gib1',SLOT_Interact,0.06 * Mass);
    PlaySound(Sound'Gib1',SLOT_Misc,0.05 * Mass);
  } else {
    if ( decision < 0.34999999 )
    {
      PlaySound(Sound'Gib2',SLOT_Interact,0.06 * Mass);
      PlaySound(Sound'Gib2',SLOT_Misc,0.05 * Mass);
    } else {
      if ( decision < 0.5 )
      {
        PlaySound(Sound'Gib3',SLOT_Interact,0.06 * Mass);
        PlaySound(Sound'Gib3',SLOT_Misc,0.05 * Mass);
      } else {
        if ( decision < 0.81 )
        {
          PlaySound(Sound'Gib4',SLOT_Interact,0.06 * Mass);
          PlaySound(Sound'Gib4',SLOT_Misc,0.05 * Mass);
        } else {
          PlaySound(Sound'Gib5',SLOT_Interact,0.06 * Mass);
          PlaySound(Sound'Gib5',SLOT_Misc,0.05 * Mass);
        }
      }
    }
  }
}

state Gibbing
{
  ignores  TakeDamage;
  
  function Tick (float Delta)
  {
    if ( PlayerPawn(PRI.Owner).ViewTarget != self )
    {
      Destroy();
    }
  }

  function BeginState ()
  {
    Disable('Tick');
  }
Begin:    
  Sleep(1.5);
  SetPhysics(PHYS_None);
  Sleep(3.0);
  Enable('Tick');
  if (  !bPlayerCarcass )
  {
    Destroy();
  }
}

simulated state ClientGibbing
{
  ignores  TakeDamage;
  
  simulated function GibSound ()
  {
    local int R;
  
    R = Rand(4);
    GibSounds[R] = Class<UTHumanCarcass>(PRI.zzMyClass.Default.CarcassType).Default.GibSounds[R];
    PlaySound(GibSounds[R],SLOT_Interact,16.0);
    PlaySound(GibSounds[R],SLOT_Misc,12.0);
  }
Begin:  
  if ( ClassIsChildOf(PRI.zzMyClass,Class'UnrealIPlayer') )
  {
    Sleep(0.2);
    UIGibSound();
  } else {
    Sleep(0.25);
    GibSound();
  }
}

defaultproperties
{
     Jerks(0)=GutHit
     Jerks(1)=HeadHit
     Jerks(2)=LeftHit
     Jerks(3)=RightHit
     GibberClass=Class'VAGibber'
     MasterReplacement=Class'Botpack.TMaleMasterChunk'
     LifeSpan=0.000000
     AnimSequence=Dead1
     AnimFrame=0.000000
     Mesh=LodMesh'Botpack.Commando'
     Texture=Texture'None'
     bBlockActors=True
     bBlockPlayers=True
     Mass=100.000000
}