class SkaarjPlayerMeshInfo extends UnrealiPlayerMeshInfo;

static function PlayDodgeL (VAPlayer Other)
{
  Other.PlayAnim('LeftDodge',1.352,0.06);
}

static function PlayDodgeR (VAPlayer Other)
{
  Other.PlayAnim('RightDodge',1.352,0.06);
}

static function PlayDodgeF (VAPlayer Other)
{
  Other.PlayAnim('lunge',1.25,0.06);
}

static function PlayTurning (VAPlayer Other)
{
  Other.PlayAnim('Turn',0.31,0.31);
}

static function TweenToWalking (VAPlayer Other)
{
  Other.TweenAnim('Walk',0.1);
}

static function TweenToWalkingPoint (VAPlayer Other)
{
  Other.TweenAnim('WalkFire',0.1);
}

static function PlayRunning (VAPlayer Other, byte Type, bool tween)
{
  local bool Point;
  local name Sequence;

  if ( (Other.ROLE == ROLE_AutonomousProxy) && (Other.Weapon != None) )
  {
    Point = Other.Weapon.bPointing;
  } else {
    if ( (Type > 1) && (Other.Weapon != None) )
    {
      Point = GuessIfPointing(Other.Weapon);
    }
  }
  if ( Type == 2 )
  {
    Type = byte(Point);
  }
  if ( Type == 3 )
  {
    if ( Point )
    {
      Sequence = 'StrafeRightFr';
    } else {
      Sequence = 'StrafeRight';
    }
  } else {
    if ( Type == 4 )
    {
      if ( Point )
      {
        Sequence = 'StrafeLeftFr';
      } else {
        Sequence = 'StrafeLeft';
      }
    } else {
      if ( Type == 1 )
      {
        Sequence = 'JogFire';
      } else {
        Sequence = 'Jog';
      }
    }
  }
  if ( tween )
  {
    if ( Type > 2 )
    {
      Other.PlayAnim(Sequence,1.75,0.1);
    } else {
      Other.PlayAnim(Sequence,1.0,0.1);
    }
  } else {
    if ( Type > 2 )
    {
      Other.LoopAnim(Sequence,-2.5 / Other.GroundSpeed,0.1,1.0);
    } else {
      Other.LoopAnim(Sequence,1.12);
    }
  }
}

static function PlayWalking (VAPlayer Other)
{
  Other.LoopAnim('Walk',1.12);
}

static function PlayWalkingPoint (VAPlayer Other)
{
  Other.LoopAnim('WalkFire',1.12);
}

static function PlayRising (VAPlayer Other)
{
  Other.PlayAnim('GetUp',0.69999999,0.1);
}

static function PlayFeignDeath (VAPlayer Other)
{
  Other.PlayAnim('Death2',0.69999999);
}

static function PlayDying(VAPlayer Other, byte type)
{
  local carcass carc;


  if ( type==3 )   //suicide
  {
    Other.PlayAnim('Death3', 0.7, 0.1);
    return;
  }

  // check for head hit
  if ( (type==4 || type==6) //second switch is based on hitloc> 0.7. here should be >0.6  no biggie though.
     && !class'GameInfo'.Default.bLowGore )
  {
    PlayDecap(Other);
    return;
  }

   if ( FRand() < 0.15)
  {
    Other.PlayAnim('Death3', 0.7, 0.1);
    return;
  }

  // check for big hit   //non-replicated info (so yes, different people have different anims)
  if ( (Other.Velocity.Z > 250) && (FRand() < 0.7) )
  {
    if ( FRand() < 0.5 )
      Other.PlayAnim('Death2', 0.7, 0.1);
    else
      Other.PlayAnim('Death4', 0.7, 0.1);
    return;
  }

  // check for repeater death
  if ( type==5 )
  {
    Other.PlayAnim('Death',, 0.1);
    return;
  }

  if ( FRand() < 0.15 )
  {
    Other.PlayAnim('Death',0.7,0.1);
    return;
  }

  if (type==0) //then hit in front or back
    Other.PlayAnim('Death3', 0.7, 0.1);
  else
  {
    if (type==1)
      Other.PlayAnim('Death', 0.7, 0.1);
    else
      Other.PlayAnim('Death4', 0.7, 0.1);
    return;
  }
           //implament unreali loc checks here??????
  if ( Other.Region.Zone.bWaterZone || (FRand() < 0.5) ) //then hit in front or back
    Other.PlayAnim('Death4',, 0.1);
  else
    Other.PlayAnim('Death3',, 0.1);
}
static function PlayDecap(VAPlayer Other)   //always done on client :D
{
  local carcass carc;

    Other.PlayAnim('Death5', 0.7, 0.1);
    carc = other.Spawn(class 'CreatureChunks',,, other.Location + other.CollisionHeight * vect(0,0,0.8), other.Rotation + rot(3000,0,16384) );
    if (carc != None)
    {
      carc.remoterole=role_none;
      carc.Mesh = mesh'SkaarjHead';
      carc.Initfor(other);
      carc.Velocity = other.Velocity + VSize(other.Velocity) * VRand();
      carc.Velocity.Z = FMax(carc.Velocity.Z, other.Velocity.Z);
    }
}

static function PlayGutHit (VAPlayer Other)
{
  if ( Other.AnimSequence == 'GutHit' )
  {
    if ( FRand() < 0.5 )
    {
      Other.TweenAnim('LeftHit',0.1);
    } else {
      Other.TweenAnim('RightHit',0.1);
    }
  } else {
    Other.TweenAnim('GutHit',0.1);
  }
}

static function PlayHeadHit (VAPlayer Other)
{
  if ( Other.AnimSequence == 'HeadHit' )
  {
    Other.TweenAnim('GutHit',0.1);
  } else {
    Other.TweenAnim('HeadHit',0.1);
  }
}

static function PlayLeftHit (VAPlayer Other)
{
  if ( Other.AnimSequence == 'LeftHit' )
  {
    Other.TweenAnim('GutHit',0.1);
  } else {
    Other.TweenAnim('LeftHit',0.1);
  }
}

static function PlayRightHit (VAPlayer Other)
{
  if ( Other.AnimSequence == 'RightHit' )
  {
    Other.TweenAnim('GutHit',0.1);
  } else {
    Other.TweenAnim('RightHit',0.1);
  }
}

static function PlayLanded (VAPlayer Other, float impactVel)
{
  impactVel = impactVel / Other.JumpZ;
  impactVel = 0.1 * impactVel * impactVel;
  if ( impactVel > 0.17 )
  {
    Other.PlaySound(Class<UnrealIPlayer>(Class'VAPRI'.static.GetVAPRI(Other.PlayerReplicationInfo).zzMyClass).Default.LandGrunt,SLOT_Talk,FMin(5.0,5.0 * impactVel),False,1200.0,FRand() * 0.41 + 0.81);
  }
  if (  !Other.FootRegion.Zone.bWaterZone && (impactVel > 0.01) )
  {
    Other.PlaySound(Class'VAPRI'.static.GetVAPRI(Other.PlayerReplicationInfo).zzMyClass.Default.Land,SLOT_Interact,FClamp(4.5 * impactVel,0.5,6.0),False,1000.0,1.0);
  }
  if ( (GetMyAnimGroup(Other) == 'Dodge') && Other.IsAnimating() )
  {
    return;
  }
  if ( (impactVel > 0.06) || (GetMyAnimGroup(Other) == 'Jumping') )
  {
    Other.TweenAnim('Land',0.12);
  } else {
    if (  !Other.IsAnimating() )
    {
      if ( GetMyAnimGroup(Other) == 'TakeHit' )
      {
        Other.AnimEnd();
      } else {
        Other.TweenAnim('Land',0.12);
      }
    }
  }
}

static function PlayInAir (VAPlayer Other)
{
  Other.TweenAnim('InAir',0.41);
}

static function PlayDuck (VAPlayer Other)
{
  Other.TweenAnim('Duck',0.25);
}

static function PlayCrawling (VAPlayer Other)
{
  Other.LoopAnim('Duckwalk');
}

static function TweenToWaiting (VAPlayer Other, float TweenTime)
{
  if ( Other.IsInState('PlayerSwimming') || (Other.ROLE == ROLE_AutonomousProxy) && (Other.Physics == 3) || (Other.ROLE == ROLE_SimulatedProxy) && Other.Region.Zone.bWaterZone )
  {
    Other.TweenAnim('Swim',TweenTime);
  } else {
    Other.TweenAnim('Firing',TweenTime);
  }
}

static function PlayRecoil (VAPlayer Other)
{
  if ( Other.Weapon.bRapidFire )
  {
    if (  !Other.IsAnimating() && ((Other.ROLE == ROLE_AutonomousProxy) && (Other.Physics == 1) || (Other.ROLE == ROLE_SimulatedProxy) && (Other.myState == 'PlayerWalking') && (Other.BaseAnim != 0)) )
    {
      Other.TweenAnim('Firing',0.31);
    }
  }
}

static function PlayDoubleRecoil (VAPlayer Other)
{
  PlayRecoil(Other);
}

static function PlayWaiting (VAPlayer Other, byte Type)
{
  local name newAnim;

  if ( Other.IsInState('PlayerSwimming') || (Other.ROLE == ROLE_AutonomousProxy) && (Other.Physics == 3) || (Other.ROLE == ROLE_SimulatedProxy) && Other.Region.Zone.bWaterZone )
  {
    Other.LoopAnim('Swim');
  } else {
    if ( (Type > 1) && (Other.Weapon != None) )
    {
      Type = byte(GuessIfPointing(Other.Weapon));
    }
    if ( (Other.Weapon != None) && (Type == 1) )
    {
      Other.TweenAnim('Firing',0.31);
    } else {
      if ( FRand() < 0.2 )
      {
        newAnim = 'Breath';
      } else {
        newAnim = 'Breath2';
      }
      if ( Other.AnimSequence == newAnim )
      {
        Other.LoopAnim(newAnim,0.31 + 0.69999999 * FRand());
      } else {
        Other.PlayAnim(newAnim,0.31 + 0.69999999 * FRand(),0.25);
      }
    }
  }
}

static function PlayFiring (VAPlayer Other)
{
  if ( Other.AnimSequence == 'Jog' )
  {
    Other.AnimSequence = 'JogFire';
  } else {
    if ( Other.AnimSequence == 'Walk' )
    {
      Other.AnimSequence = 'WalkFire';
    } else {
      if ( Other.AnimSequence == 'InAir' )
      {
        Other.TweenAnim('JogFire',0.03);
      } else {
        if ( (GetMyAnimGroup(Other) != 'Attack') && (GetMyAnimGroup(Other) != 'MovingAttack') && (GetMyAnimGroup(Other) != 'Dodge') && (Other.AnimSequence != 'Swim') )
        {
          Other.TweenAnim('Firing',0.02);
        }
      }
    }
  }
}

static function PlayWeaponSwitch (VAPlayer Other);

static function PlayBigWeaponSwitch (VAPlayer Other);

static function PlaySwimming (VAPlayer Other)
{
  Other.LoopAnim('Swim');
}

static function TweenToSwimming (VAPlayer Other, float TweenTime)
{
  Other.TweenAnim('Swim',TweenTime);
}

static function SwimAnimUpdate (VAPlayer Other, bool bNotForward)
{
  if (  !Other.bAnimTransition && (GetMyAnimGroup(Other) != 'Gesture') && (Other.AnimSequence != 'Swim') )
  {
    Other.TweenToSwimming(0.1);
  }
}

static function Taunt (VAPlayer Other, name Sequence)
{
  if ( Sequence == 'Wave' )
  {
    Sequence = 'Shield';
  } else {
    if ( Sequence == 'Victory1' )
    {
      Sequence = 'spin';
    } else {
      if ( Sequence == 'Thrust' )
      {
        Sequence = 'claw';
      } else {
        if ( Sequence == 'Challenge' )
        {
          Sequence = 'ShldTest';
        }
      }
    }
  }
  Other.PlayAnim(Sequence,0.69999999,0.2);
}

static function name GetMyAnimGroup (VAPlayer Other)
{
  if ( (Other.AnimSequence == 'claw') || (Other.AnimSequence == 'Shield') || (Other.AnimSequence == 'spin') || (Other.AnimSequence == 'ShldTest') )
  {
    return 'Gesture';
  } else {
    if ( Other.AnimSequence == 'gunfix' )
    {
      return 'Waiting';
    }
  }
  return Other.GetAnimGroup(Other.AnimSequence);
}

static function PlayChatting (VAPlayer Other)
{
  if ( Other.AnimSequence != 'gunfix' )
  {
    Other.TweenAnim('gunfix',0.31);
  } else {
    Other.LoopAnim('gunfix');
  }
}
