class PlayerInfoGrid expands UWindowGrid;

static final simulated function VAPRI GetVAPRI(Actor A)
{
    return class'VAPRI'.static.GetVAPRI(A);
}

function Created() 
{
  Super.Created();

  RowHeight = 12;

  AddColumn(class'UBrowserPlayerGrid'.default.NameText, 80);
  AddColumn(class'UBrowserPlayerGrid'.default.MeshText, 160);
  AddColumn("Skin Package", 130);
  AddColumn(class'UBrowserPlayerGrid'.default.SkinText, 80);
  AddColumn(class'UBrowserPlayerGrid'.default.FaceText, 60);
  AddColumn("VoicePack", 170);
}
function PaintColumn(Canvas C, UWindowGridColumn Column, float MouseX, float MouseY)
{
  local int Visible;
  local int Count;
  local int Skipped;
  local int Y;
  local int TopMargin;
  local int BottomMargin;
  local int zzi;
  local VAPRI l;
  local byte zzinfo;

  if(bShowHorizSB)
    BottomMargin = LookAndFeel.Size_ScrollbarWidth;
  else
    BottomMargin = 0;

  TopMargin = LookAndFeel.ColumnHeadingHeight;

  for (skipped=0;skipped<32;skipped++){
    if (getplayerowner().gamereplicationinfo.priarray[skipped]!=none)
      count++;
    else
      break;
  }

  C.Font = Root.Fonts[F_Normal];
  Visible = int((WinHeight - (TopMargin + BottomMargin))/RowHeight);
  
  VertSB.SetRange(0, Count+1, Visible);
  TopRow = VertSB.Pos;

  Skipped = 0;
  visible=0;
  Y = 1;
  L = GetVAPRI(GetPlayerOwner().GameReplicationInfo.PRIArray[0]);
  while(visible<count&&(Y < RowHeight + WinHeight - RowHeight - (TopMargin + BottomMargin)))
  {
    if (l!=none){
     if(Skipped >= VertSB.Pos)
     {
      switch(Column.ColumnNum)
      {
      case 0:
        Column.ClipText( C, 2, Y + TopMargin, L.PRI.PlayerName );
        break;
      case 1:
        Column.ClipText( C, 2, Y + TopMargin, l.GetMesh(zzinfo) );
        PaintCheck(C,Column,bool(zzinfo),Y+ TopMargin);
        break;
      case 2:
        Column.ClipText( C, 2, Y + TopMargin, l.getskinpackage(zzinfo) );
        PaintCheck(C,Column,bool(zzinfo),Y+ TopMargin);
        break;
      case 3:
        Column.ClipText( C, 2, Y + TopMargin, l.GetSkinItem() );
        break;
      case 4:
        Column.ClipText( C, 2, Y + TopMargin, l.GetFaceItem() );
        break;
      case 5:
        Column.ClipText( C, 2, Y + TopMargin, l.zzVoicestring );
         PaintCheck(C,Column,L.zzVoicestring ~= string(L.PRI.VoiceType),Y + TopMargin);
        break;
      }

      Y = Y + RowHeight;      
     }
     Skipped ++;
    }
    visible++;
    if (visible<32)
	L = class'VAPRI'.static.GetVAPRI(GetPlayerOwner().GameReplicationInfo.PRIArray[Visible]);
  }
}

function SortColumn (UWindowGridColumn Column)
{
}

function PaintCheck (Canvas C, UWindowGridColumn Column, bool bchecked,int Y){
if (bchecked)
  Column.DrawClippedTexture( C, Column.WinWidth - 13, Y, Texture'ChkChecked');
else
  Column.DrawClippedTexture( C, Column.WinWidth - 13, Y, Texture'ChkUnchecked');
}