//=============================================================================
// MaleMeshInfo.
//=============================================================================
class MaleMeshInfo extends HumanMeshInfo;

// may need to override PlayDying here to use UnrealShare.Male function
static function PlayDying(VAPlayer Other, byte type)
{
  local carcass carc;

  if ( type==3 )   //suicide
  {
    Other.PlayAnim('Dead7', 0.7, 0.1);
    return;
  }

  // check for head hit
  if ( (type==4 || type==6) //second switch is based on hitloc> 0.7. here should be >0.6  no biggie though.
     && !class'GameInfo'.Default.bLowGore )
  {
    PlayDecap(Other);
    return;
  }
  if ( FRand() < 0.15 )
  {
    Other.PlayAnim('Dead2',0.7,0.1);
    return;
  }

  // check for big hit   //non-replicated info (so yes, different people have different anims)
  if ( (Other.Velocity.Z > 250) && (FRand() < 0.7) )
  {
    if ( FRand() < 0.5 )
      Other.PlayAnim('Dead1', 0.7, 0.1);
    else
      Other.PlayAnim('Dead7', 0.7, 0.1);
    return;
  }

  // check for repeater death
  if ( type==5 )
  {
    Other.PlayAnim('Dead6',, 0.1);
    return;
  }

  if ( FRand() < 0.15)
  {
    Other.PlayAnim('Dead1', 0.7, 0.1);
    return;
  }

  if (type==0) //then hit in front or back
    Other.PlayAnim('Dead7', 0.7, 0.1);
  else
  {
    if ( type==1 && !class'GameInfo'.Default.bVeryLowGore )
    {
	  carc = Other.Spawn(class'VAMaleChunks',,, Other.Location);
      if (carc != None)
      {
        carc.remoterole=role_none;
        carc.Initfor(Other);
        carc.Velocity = Other.Velocity + VSize(Other.Velocity) * VRand();
        carc.Velocity.Z = FMax(carc.Velocity.Z, Other.Velocity.Z);
      }
      Other.PlayAnim('Dead5', 0.7, 0.1);
    return;
  }
           //implament unreali loc checks here??????
  if ( Other.Region.Zone.bWaterZone || (FRand() < 0.5) ) //then hit in front or back
    Other.PlayAnim('Dead3',, 0.1);
  else
    Other.PlayAnim('Dead2',, 0.1);
  }
}
static function PlayDecap(VAPlayer Other)   //always done on client :D
{
  local carcass carc;

  Other.PlayAnim('Dead4',, 0.1);

    carc = Other.Spawn(class'MaleHead',,, Other.Location + Other.CollisionHeight * vect(0,0,0.8), Other.Rotation + rot(3000,0,16384));
    if (carc != None)
    {
      carc.remoterole=role_none;
      carc.Initfor(Other);
      carc.Velocity = Other.Velocity + VSize(Other.Velocity) * VRand();
      carc.Velocity.Z = FMax(carc.Velocity.Z, Other.Velocity.Z);
    }
}

static function PlayGutHit(VAPlayer Other)
{
  if ( (Other.AnimSequence == 'GutHit') || (Other.AnimSequence == 'Dead2') )
  {
    if (FRand() < 0.5)
      Other.TweenAnim('LeftHit', 0.1);
    else
      Other.TweenAnim('RightHit', 0.1);
  }
  else if ( FRand() < 0.6 )
    Other.TweenAnim('GutHit', 0.1);
  else
    Other.TweenAnim('Dead2', 0.1);

}

static function PlayHeadHit(VAPlayer Other)
{
  if ( (Other.AnimSequence == 'HeadHit') || (Other.AnimSequence == 'Dead4') )
    Other.TweenAnim('GutHit', 0.1);
  else if ( FRand() < 0.6 )
    Other.TweenAnim('HeadHit', 0.1);
  else
    Other.TweenAnim('Dead4', 0.1);
}

static function PlayLeftHit(VAPlayer Other)
{
  if ( (Other.AnimSequence == 'LeftHit') || (Other.AnimSequence == 'Dead6') )
    Other.TweenAnim('GutHit', 0.1);
  else if ( FRand() < 0.6 )
    Other.TweenAnim('LeftHit', 0.1);
  else
    Other.TweenAnim('Dead6', 0.1);
}

static function PlayRightHit(VAPlayer Other)
{
  if ( (Other.AnimSequence == 'RightHit') || (Other.AnimSequence == 'Dead1') )
    Other.TweenAnim('GutHit', 0.1);
  else if ( FRand() < 0.6 )
    Other.TweenAnim('RightHit', 0.1);
  else
    Other.TweenAnim('Dead1', 0.1);
}
/*
//called ONLY if mesh==male1
static function PlaySpecial(VAPlayer Other, name Type)
{
local sound step;
local float decision;
  if ( other.FootRegion.Zone.bWaterZone )
  {
    other.PlaySound(sound 'LSplash', SLOT_Interact, 1, false, 1000.0, 1.0);
    return;
  }

  decision = FRand();
  if ( decision < 0.34 )
    step = sound'MetWalk1';
  else if (decision < 0.67 )
    step = sound'MetWalk2';
  else
    step = sound'MetWalk3';
  //check autonomous walk or sim walk.
  if ( (other.role==role_autonomousproxy&&bIsWalking)||(other.role==role_simulatedproxy&&(other.baseanim=='playwalking'||other.baseanim=='playwalkingpoint') ) )
    other.PlaySound(step, SLOT_Interact, 0.5, false, 400.0, 1.0);
  else 
    other.PlaySound(step, SLOT_Interact, 1, false, 800.0, 1.0);
}    */