//=============================================================================
class DPMSSoundInfo extends Info;

//=============================================================================
// Static Sound Playing functions

static function PlayDyingSound(VAPlayer Other);
static function PlayFootStep(VAPlayer Other);
static function FootStepping(VAPlayer Other);
//hit sounds (sent more specific, as damage related which is unknown to clients)
static function drown(VAPlayer other);
static function UWHit(VAPlayer other);
static function Hit1(VAPlayer other);
static function Hit23(VAPlayer other);
static function Hit4(VAPlayer other);

static function Gasp(VAPlayer Other){
other.PlaySound(class<tournamentplayer>(Class'VAPRI'.static.GetVAPRI(other.playerreplicationinfo).zzmyclass).default.GaspSound, SLOT_Talk, 2.0);
}
static function breathagain(VAPlayer other){
other.PlaySound(class<tournamentplayer>(Class'VAPRI'.static.GetVAPRI(other.playerreplicationinfo).zzmyclass).default.BreathAgain, SLOT_Talk, 2.0);
}
// can used to play sounds or call other sound functions
static function PlaySpecial(VAPlayer Other, name Type);
// from Engine.PlayerPawn (UT v4.02)
static final function PlayerLanded(VAPlayer Other)
{
Other.PlaySound(Class'VAPRI'.static.GetVAPRI(other.playerreplicationinfo).zzmyclass.default.Land, SLOT_Interact, 0.3, false, 800, 1.0);
}

static final function DoJump(VAPlayer Other)
{
 Other.PlaySound(Class'VAPRI'.static.GetVAPRI(other.playerreplicationinfo).zzmyclass.default.JumpSound, SLOT_Talk, 1.5, true, 1200, 1.0 );
}
static final function DoDoubleJump(VAPlayer Other)
{
 Other.PlaySound(Class'VAPRI'.static.GetVAPRI(other.playerreplicationinfo).zzmyclass.default.JumpSound, SLOT_None, 1.5, true, 1200, 1.0 + 0.04 * Class'VAPlayer'.Default.nofJumps );
}
static final function DodgeSound(VAPlayer Other)
{
 Other.PlaySound(Class'VAPRI'.static.GetVAPRI(other.playerreplicationinfo).zzmyclass.default.JumpSound, SLOT_Talk, 1.0, true, 800, 1.0 );
}
// From Engine.Pawn
static final function FootZoneChange(VAPlayer Other)
{
//maybe poorly implemented but oh well:
other.PlaySound(Class'VAPRI'.static.GetVAPRI(other.playerreplicationinfo).zzmyclass.default.WaterStep, SLOT_Misc, 1.5 + 0.5 * FClamp(0.000025 * other.mass * (300 - 0.5 * FMax(-500, other.Velocity.Z)), 1.0, 4.0 ));
}