//================================================================================
// VAServer.
//================================================================================

class VAServer extends Mutator;

var string nextoptions;
var string MenuName;
var string RevertVoice;

static simulated function ALPRI GetALPRI (Actor A)
{
  return class'ALPRI'.static.GetALPRI(A);
}

function PreBeginPlay ()
{
  Spawn(Class'NN_DemoRecSN');
  Spawn(Class'DummyRI');    
}

function ModifyPlayer (Pawn Other)
{
  Super.ModifyPlayer(Other);   
}

function PostBeginPlay ()
{
  local string Pound; 

  Class'VASettings'.static.staticsaveconfig();
    
  Pound = "_______________________________";
  Log(Pound);
  Log("    # Build  #    ##");
  Log("     #      #    #  #");
  Log("      #    #    ######");
  Log("       #  #    #      #");
  Log("        ##    #   1.0  #");
  Log(Pound);
  Log("#     VALHALLA AVATAR 1.0     #");
  if ( Level.NetMode != NM_DedicatedServer )
  {
    Log("#    ERROR: Only for use      #");
    Log("#   on DEDICATED SERVERS!     #");
    Destroy();
  } else {
    Log("#    Success: Initialized!    #");
  }
  if ( bDeleteMe )
  {
    return;
  }
    Log("Client overrides:" @ string(class'VASettings'.default.AllowClientOverride));
    Log("Default player:" @ class'VASettings'.default.DefaultPlayer);
    Log("Gesture interval:" @ string(class'VASettings'.default.gesturetime));
  if ( Class'VASettings'.Default.MeshSkinAllowChange == 0 )
  {
    Log("Mesh and skin in-game changing disabled!");
  } else {
    if ( Class'VASettings'.Default.MeshSkinAllowChange == 1 )
    {
      Log("skin in-game changing enabled, but mesh changing is disabled!");
    } else {
      Log("Mesh and skin in-game changing enabled!");
    }
  }
  Log(Pound);
  NextMutator = Level.Game.BaseMutator.NextMutator;
  Level.Game.BaseMutator.NextMutator = self;
  Spawn(Class'ShieldNotify');
}

function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{
  nextoptions = Options;  
  
  if ( Class'VASettings'.Default.bDoNotLoadSMVServerSide )
  {
    FixOptions(Options,"Class","Botpack.TMale2");
    FixOptions(Options,"skin","SoldierSkins.blkt");
    FixOptions(Options,"Face","SoldierSkins.Othello");
    FixOptions(Options,"Voice","BotPack.VoiceMaleTwo");
  }
  if ( NextMutator != None )
  {
    NextMutator.ModifyLogin(SpawnClass,Portal,Options);
  }
  RevertVoice = SpawnClass.Default.VoiceType;
  if (  !ClassIsChildOf(SpawnClass,Class'Spectator') )
  {
    SpawnClass = Class'ALplayer';
  }
}

function FixOptions (out string Options, string Key, string Value)
{
  local string L;
  local string R;
  local string PName;
  local int pos;

  pos = InStr(Caps(Options),"?" $ Caps(Key) $ "=");
  if ( pos == -1 )
  {
    return;
  }
  L = Options;
  L = Left(L,pos);
  R = Options;
  R = Mid(R,pos + 2 + Len(Key));
  pos = InStr(R,"?");
  PName = Left(R,pos);
  R = Mid(R,pos);
  Options = L $ "?" $ Key $ "=" $ Value $ R;
}

function bool CheckReplacement (Actor thing, out byte i)
{
  local Class<VoicePack> vpclass;
  local PlayerReplicationInfo PRI;
  local ALPRI APRI;
  local BotReplicationInfo Bp;

  if ( ALplayer(thing) != None )
  {
    Spawn(Class'ALPRI',thing);
    ALplayer(thing).zzNoOverride =  !Class'VASettings'.Default.AllowClientOverride;
  }
  Bp = BotReplicationInfo(thing);
  if ( (Bp != None) && (thing.Owner != None) && (ALplayer(thing.Owner.Owner) != None) )
  {
    thing = Bp;
  }
  if ( (PlayerReplicationInfo(thing) != None) && (ALplayer(thing.Owner) != None) && (Class'ALPRI'.static.GetALPRI(thing) != None) )
  {
    PRI = PlayerReplicationInfo(thing);
    GetALPRI(thing).PRI = PRI;
    GetALPRI(thing).zzVoicestring = Level.Game.ParseOption(nextoptions,"Voice");
    GetALPRI(thing).zzClassString = xxclasscheck(Level.Game.ParseOption(nextoptions,"Class"));
    GetALPRI(thing).zzskinstring = Level.Game.ParseOption(nextoptions,"Skin");
    GetALPRI(thing).zzfacestring = Level.Game.ParseOption(nextoptions,"Face");
    if ( GetALPRI(thing).zzskinstring == "" )
    {
      GetALPRI(thing).zzskinstring = "None";
    }
    if ( GetALPRI(thing).zzfacestring == "" )
    {
      GetALPRI(thing).zzfacestring = "None";
    }
    Log(PRI.PlayerName @ "Options: Class:" @ GetALPRI(thing).zzClassString @ "Skin:" @ GetALPRI(thing).zzskinstring @ "Face:" @ GetALPRI(thing).zzfacestring @ "Voice:" @ GetALPRI(thing).zzVoicestring);
    PlayerPawn(thing.Owner).MenuName = MenuName;
    vpclass = Class<VoicePack>(DynamicLoadObject(RevertVoice,Class'Class',True));
    if ( vpclass != None )
    {
      PRI.VoiceType = vpclass;
    }
  }
  return True;
}

function string xxclasscheck (string inclass)
{
  local int i;
  local Class<PlayerPawn> LocalCheck;

  MenuName = "";
  switch (Caps(inclass))
  {
	case "OLDSKOOL.MALEONE":
	case "OLDMODELS.OLDMODELSMALEONE":
	case "UNREAL1MODELS.TMALEONE":
	case "UNREALI.MALEONE":
	inclass="unreali.maleone";
	MenuName="Male 1";
	break;
	case "OLDSKOOL.MALETWO":
	case "OLDMODELS.OLDMODELSMALETWO":
	case "UNREAL1MODELS.TMALETWO":
	case "UNREALI.MALETWO":
	inclass="unreali.maletwo";
	MenuName="Male 2";
	break;
	case "OLDSKOOL.MALETHREE":
	case "OLDMODELS.OLDMODELSMALETHEEE":
	case "UNREAL1MODELS.TMALETHREE":
	case "UNREALI.MALETHREE":
	inclass="unreali.malethree";
	MenuName="Male 3";
	break;
	case "OLDSKOOL.FEMALEONE":
	case "OLDMODELS.OLDMODELSFEMALEONE":
	case "UNREAL1MODELS.TFEMALEONE":
	case "UNREALI.FEMALEONE":
	inclass="unreali.femaleone";
	MenuName="Female 1";
	break;
	case "OLDSKOOL.FEMALETWO":
	case "UNREAL1MODELS.TFEMALETWO":
	case "OLDMODELS.OLDMODELSFEMALETWO":
	case "UNREALI.FEMALETWO":
	inclass="unreali.femaletwo";
	MenuName="Female 2";
	break;
	case "UNREALI.NALIPLAYER":
	case "NALIFIX.TNALI2":
	case "UNREAL1MODELS.TOURNAMENTNALI":
	case "MULTIMESH.TNALI":
	inclass="multimesh.tnali";
	MenuName="Nali";
	break;
	case "OLDSKOOL.SKTROOPER":
	case "OLDMODELS.OLDMODELSSKTROOPER":
	case "UNREAL1MODELS.TOURNAMENTSKTROOPER":
	case "UNREALI.SKAARJPLAYER":
	inclass="unreali.skaarjplayer";
	MenuName="Skaarj Trooper";
	break;
	case "MULTIMESH.TSKAARJ":
	MenuName="Skaarj Hybrid";
	break;
	case "COWFIX.TCOWFIXED":
	case "MULTIMESH.TCOW":
	inclass="multimesh.tcow";
	MenuName="Nali Cow";
	break;
	case "SKELETALCHARSFIX313.WARBOSSFIX313":
	case "SKELETALCHARSFIX313.WARBOSSMFIX313":
	case "SKELETALCHARS.WARBOSS":
	inclass="skeletalchars.warboss";
	MenuName="War Boss";
	break;
	case "SKELETALCHARSFIX313.XANMK2FIX313":
	case "SKELETALCHARSFIX313.XANMK2MFIX313":
	case "SKELETALCHARS.XANMK2":
	inclass="skeletalchars.xanmk2";
	MenuName="Xan Mark ][";
	break;
	case "BOSSFACE.TBOSSFACE":
	inclass="botpack.tboss";
	MenuName="Boss";
	break;
	case "VABETA.ALPLAYER":
	case "":
	inclass=Class'VASettings'.Default.DefaultPlayer;
	break;
	default:
  }
  for(i = 0; i < 64; i++)
  {
    if ( Class'VASettings'.Default.BadClasses[i] ~= inclass )
    {
      MenuName = "";
      inclass = Class'VASettings'.Default.DefaultPlayer;
      break;
    } 
  }
  
  if ( MenuName == "" )
  {
    LocalCheck = Class<PlayerPawn>(DynamicLoadObject(inclass,Class'Class',True));
    if ( LocalCheck != None )
    {
      MenuName = LocalCheck.Default.MenuName;
    } else {
      MenuName = GetItemName(inclass);
    }
  }
  return inclass;
}

function Destroyed ()
{
  local Mutator zzm;

  if ( Level.Game == None )
  {
    return;
  }
  for(zzm = Level.Game.BaseMutator; zzm != None; zzm = zzm.NextMutator)
  {
    if ( zzm.NextMutator == self )
      break;
  }
  zzm.NextMutator = NextMutator;
  NextMutator = None;
}