//================================================================================
// VAPlayerFixActor.
//================================================================================

class VAPlayerFixActor extends ReplicationInfo;

var PlayerPawn POwner;

simulated function Tick (float Delta)
{
  local PlayerReplicationInfo PRI;
  local VAPlayer P;
  local GameReplicationInfo GRI;
  local int i;
  local byte AnimType;
  local ENetRole R;

  if ( Level.NetMode == NM_DedicatedServer )
  {
    Disable('Tick');
    return;
  }
  if ( POwner == None )
  {
    foreach AllActors(Class'PlayerPawn',POwner)
    {
      if ( (POwner.Player == None) || (POwner.Player.Actor == None) )
      {
        continue;
      }
      break;
    }
    if ( POwner == None )
      return;
  }
  GRI = POwner.GameReplicationInfo;
  if ( GRI == None )
  {
    return;
  }
  
  for(i = 0; i < 32; i++)
  {
	PRI = GRI.PRIArray[i];
    if ( PRI == None )
    {
      return;
    }
    P = VAPlayer(PRI.Owner);
    if ( (P != None) &&  !P.bCheckNNClass )
    {
      P.bCheckNNClass = True;
      R = P.Role;
      P.Role = ROLE_Authority;
      if ( P.GetPropertyText("bNewNet") != "" )
      {
        P.bNNClass = True;
      }
      P.Role = R;
    }
    if ( (P == None) || (P == POwner) || (P.Mesh == None) )
      return;
    if (  !P.bHidden && P.bPrevHidden )
    {
      AnimType = P.GetWaitingAnimType();
      P.MeshInfo.static.PlayWaiting(P,AnimType - 1);
    } else {
      if ( P.bHidden &&  !P.bPrevHidden && P.bNNClass )
      {
        P.SetCollision(False,False,False);
        P.Velocity = vect(0.00,0.00,0.00);
      }
    }
    P.bPrevHidden = P.bHidden;
  }
}

defaultproperties
{
    RemoteRole=ROLE_SimulatedProxy
}
