//================================================================================
// VAPlayer.
//================================================================================

class VAPlayer extends bbPlayer;

#exec MESH IMPORT MESH=Player ANIVFILE=MODELS\Player_a.3d DATAFILE=MODELS\Player_d.3d UNMIRROR=1 LODSTYLE=12
#exec MESH ORIGIN MESH=Player X=-150 Y=40 Z=0 YAW=64 ROLL=-64

#exec MESH SEQUENCE MESH=Player SEQ=All       STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=Player SEQ=GutHit    STARTFRAME=0 NUMFRAMES=30				Group=TakeHit
#exec MESH SEQUENCE MESH=Player SEQ=AimDnLg   STARTFRAME=0 NUMFRAMES=30				Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=AimDnSm   STARTFRAME=0 NUMFRAMES=30				Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=AimUpLg   STARTFRAME=0 NUMFRAMES=30				Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=AimUpSm   STARTFRAME=0 NUMFRAMES=30				Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=Taunt1    STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Player SEQ=Breath1   STARTFRAME=0 NUMFRAMES=30 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=Breath2   STARTFRAME=0 NUMFRAMES=30 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=CockGun   STARTFRAME=0 NUMFRAMES=30 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=DuckWlkL  STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Player SEQ=DuckWlkS  STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Ducking
#exec MESH SEQUENCE MESH=Player SEQ=HeadHit   STARTFRAME=0 NUMFRAMES=30				Group=TakeHit
#exec MESH SEQUENCE MESH=Player SEQ=JumpLgFr  STARTFRAME=0 NUMFRAMES=30				Group=Jumping
#exec MESH SEQUENCE MESH=Player SEQ=JumpSmFr  STARTFRAME=0 NUMFRAMES=30				Group=Jumping
#exec MESH SEQUENCE MESH=Player SEQ=LandLgFr  STARTFRAME=0 NUMFRAMES=30				Group=Landing
#exec MESH SEQUENCE MESH=Player SEQ=LandSmFr  STARTFRAME=0 NUMFRAMES=30				Group=Landing
#exec MESH SEQUENCE MESH=Player SEQ=LeftHit   STARTFRAME=0 NUMFRAMES=30				Group=TakeHit
#exec MESH SEQUENCE MESH=Player SEQ=Look      STARTFRAME=0 NUMFRAMES=30 RATE=15     Group=Waiting 
#exec MESH SEQUENCE MESH=Player SEQ=RightHit  STARTFRAME=0 NUMFRAMES=30				Group=TakeHit
#exec MESH SEQUENCE MESH=Player SEQ=RunLg     STARTFRAME=0 NUMFRAMES=30 RATE=17
#exec MESH SEQUENCE MESH=Player SEQ=RunLgFr   STARTFRAME=0 NUMFRAMES=30 RATE=17     Group=MovingFire
#exec MESH SEQUENCE MESH=Player SEQ=RunSm     STARTFRAME=0 NUMFRAMES=30 RATE=17
#exec MESH SEQUENCE MESH=Player SEQ=RunSmFr   STARTFRAME=0 NUMFRAMES=30 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Player SEQ=StillFrRp STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=StillLgFr STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=StillSmFr STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=SwimLg    STARTFRAME=0 NUMFRAMES=30 RATE=15
#exec MESH SEQUENCE MESH=Player SEQ=SwimSm    STARTFRAME=0 NUMFRAMES=30 RATE=15
#exec MESH SEQUENCE MESH=Player SEQ=TreadLg   STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=TreadSm   STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=Victory1  STARTFRAME=0 NUMFRAMES=30 RATE=11 	Group=Gesture
#exec MESH SEQUENCE MESH=Player SEQ=WalkLg    STARTFRAME=0 NUMFRAMES=30 RATE=18
#exec MESH SEQUENCE MESH=Player SEQ=WalkLgFr  STARTFRAME=0 NUMFRAMES=30 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Player SEQ=WalkSm    STARTFRAME=0 NUMFRAMES=30 RATE=18
#exec MESH SEQUENCE MESH=Player SEQ=WalkSmFr  STARTFRAME=0 NUMFRAMES=30 RATE=18		Group=MovingFire
#exec MESH SEQUENCE MESH=Player SEQ=Wave      STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Player SEQ=Walk      STARTFRAME=0 NUMFRAMES=30 RATE=18
#exec MESH SEQUENCE MESH=Player SEQ=TurnLg    STARTFRAME=0 NUMFRAMES=30 RATE=15
#exec MESH SEQUENCE MESH=Player SEQ=TurnSm    STARTFRAME=0 NUMFRAMES=30 RATE=15
#exec MESH SEQUENCE MESH=Player SEQ=Breath1L  STARTFRAME=0 NUMFRAMES=30 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=Breath2L  STARTFRAME=0 NUMFRAMES=30 RATE=7		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=CockGunL  STARTFRAME=0 NUMFRAMES=30 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=LookL     STARTFRAME=0 NUMFRAMES=30 RATE=15     Group=Waiting 
#exec MESH SEQUENCE MESH=Player SEQ=WaveL     STARTFRAME=0 NUMFRAMES=30 RATE=15		Group=Gesture
#exec MESH SEQUENCE MESH=Player SEQ=Chat1     STARTFRAME=0 NUMFRAMES=30 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=Chat2     STARTFRAME=0 NUMFRAMES=30 RATE=6		Group=Waiting
#exec MESH SEQUENCE MESH=Player SEQ=Thrust    STARTFRAME=0 NUMFRAMES=30 RATE=20		Group=Gesture
#exec MESH SEQUENCE MESH=Player SEQ=DodgeB    STARTFRAME=0 NUMFRAMES=30				Group=Jumping
#exec MESH SEQUENCE MESH=Player SEQ=DodgeF    STARTFRAME=0 NUMFRAMES=30				Group=Jumping
#exec MESH SEQUENCE MESH=Player SEQ=DodgeR    STARTFRAME=0 NUMFRAMES=30				Group=Jumping
#exec MESH SEQUENCE MESH=Player SEQ=DodgeL    STARTFRAME=0 NUMFRAMES=30				Group=Jumping
#exec MESH SEQUENCE MESH=Player SEQ=Fighter   STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=Player SEQ=Flip      STARTFRAME=0 NUMFRAMES=30				Group=Jumping
#exec MESH SEQUENCE MESH=Player SEQ=Dead1     STARTFRAME=0 NUMFRAMES=30 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=Player SEQ=Dead2     STARTFRAME=0 NUMFRAMES=30 RATE=10		
#exec MESH SEQUENCE MESH=Player SEQ=Dead3     STARTFRAME=0 NUMFRAMES=30 RATE=10
#exec MESH SEQUENCE MESH=Player SEQ=Dead4     STARTFRAME=0 NUMFRAMES=30 RATE=10
#exec MESH SEQUENCE MESH=Player SEQ=Dead7     STARTFRAME=0 NUMFRAMES=30 RATE=12		Group=TakeHit
#exec MESH SEQUENCE MESH=Player SEQ=Dead8     STARTFRAME=0 NUMFRAMES=30 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=Player SEQ=Dead9     STARTFRAME=0 NUMFRAMES=30 RATE=30		Group=TakeHit
#exec MESH SEQUENCE MESH=Player SEQ=Dead9B    STARTFRAME=0 NUMFRAMES=30 RATE=15		
#exec MESH SEQUENCE MESH=Player SEQ=Dead11    STARTFRAME=0 NUMFRAMES=30 RATE=10
#exec MESH SEQUENCE MESH=Player SEQ=BackRun   STARTFRAME=0 NUMFRAMES=30 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Player SEQ=StrafeL   STARTFRAME=0 NUMFRAMES=30 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=Player SEQ=StrafeR   STARTFRAME=0 NUMFRAMES=30 RATE=17		Group=MovingFire

#exec MESH SEQUENCE MESH=Player SEQ=DeathEnd  STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=Player SEQ=DeathEnd2 STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=Player SEQ=DeathEnd3 STARTFRAME=0 NUMFRAMES=30

#exec MESHMAP SCALE MESHMAP=Player X=0.0625 Y=0.0625 Z=0.125

#exec MESH NOTIFY MESH=Player SEQ=RunLG TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=RunLG TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=RunLGFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=RunLGFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=RunSM TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=RunSM TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=RunSMFR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=RunSMFR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=StrafeL TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=StrafeL TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=StrafeR TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=StrafeR TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=BackRun TIME=0.25 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=BackRun TIME=0.75 FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=Player SEQ=Dead1 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Player SEQ=Dead2 TIME=0.9 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Player SEQ=Dead3 TIME=0.45 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Player SEQ=Dead4 TIME=0.6 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Player SEQ=Dead7 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Player SEQ=Dead8 TIME=0.7 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Player SEQ=Dead9B TIME=0.8 FUNCTION=LandThump
#exec MESH NOTIFY MESH=Player SEQ=Dead11 TIME=0.57 FUNCTION=LandThump

var float lastgesturetime;
var byte zzNextAnim;
var byte BaseAnim;
var bool bAnimOn;
var name myState;
var Class<DPMSMeshInfo> MeshInfo;
var Class<DPMSSoundInfo> SoundInfo;
var byte zzPendingDeath;
var name LastAnim;
var float LastAFrame;
var Teleporter zzLastTP;
var() Class<UWindowWindow> PlayerSetupWindowClass;
var bool bMenuClassSetup;
var bool bmsg;
var bool zzNoOverride;
var bool Initialized;
var byte zzNextSound;

replication
{
  reliable if (remoterole==ROLE_simulatedproxy||(bdemorecording&&!bclientdemorecording))
    zzNextSound, zzNextAnim, myState, BaseAnim;
  reliable if (bNetOwner && Role==ROLE_Authority &&!bdemorecording)
    zzNoOverride;
  reliable if (role < ROLE_Authority)
    xxServerSetVPString, xxSetMeshClass, xxServerTaunt;
}

static final simulated function VAPRI GetVAPRI (Actor A)
{
  return Class'VAPRI'.static.GetVAPRI(A);
}

function xxServerSound (byte zzid)
{
  local byte zzCurTime;

  zzCurTime = zzNextSound >> 5;
  if (zzCurTime == 7)
    zzCurTime = -1;
  zzNextSound = zzid;
  zzNextSound += zzCurTime + 1 << 5;
}

function xxServerAnim (byte zzid)
{
  local byte zzCurTime;

  zzCurTime = zzNextAnim >> 5 & 3;
  if (zzCurTime == 3)
    zzCurTime=-1;
  zzNextAnim = zzid;
  zzNextAnim += zzCurTime + 1 << 5;
}

simulated function xxSetSounds ()
{
  zzNextSound = zzNextSound & 31;
  switch (zzNextSound)
  {
    case 1:
    SoundInfo.static.Gasp(self);
    break;
    case 2:
    SoundInfo.static.breathagain(self);
    break;
    case 3:
    SoundInfo.static.DoJump(self);
    break;
    case 4:
    SoundInfo.static.PlayDyingSound(self);
    break;
    case 5:
    SoundInfo.static.FootZoneChange(self);
    break;
    case 6:
    SoundInfo.static.PlayerLanded(self);
    break;
    case 7:
    SoundInfo.static.drown(self);
    break;
    case 8:
    SoundInfo.static.UWHit(self);
    break;
    case 9:
    SoundInfo.static.Hit1(self);
    break;
    case 10:
    SoundInfo.static.Hit23(self);
    break;
    case 11:
    SoundInfo.static.Hit4(self);
    break;
    case 12:
    SoundInfo.static.DodgeSound(self);
    break;
  }
  zzNextSound = 0;
}

exec function ChangeMyTeam (int N)
{
  ChangeTeam(N);
}

final simulated function class<DPMSMeshInfo> xxGetMeshInfo()
{
  local Class<PlayerPawn> zzMyClass;

  if ( PlayerReplicationInfo == None )
    return Class'DPMSMeshInfo';

  if (left(mesh,14)~="SkeletalChars.")
    return class'AMSMeshInfo';
  
  if (string(mesh)~="unreali.sktrooper")
    return class'skaarjplayermeshinfo';

  zzMyClass = GetVAPRI(PlayerReplicationInfo).zzMyClass;
  
   if (classischildof(zzmyclass,class'Male'))
  {
      return class'MaleMeshInfo';
  }
   if (classischildof(zzmyclass,class'Female'))
  {
      return class'HumanMeshInfo';
  }
  if (class<tournamentplayer>(zzmyclass).default.FixedSkin==213)
    return class'AMSMeshInfo';
  
  if (string(mesh)~="visor.visor")
    return class'VisorMeshInfo';
  
  if (string(mesh)~="crash.crash")
    return class'CrashMeshInfo';
  
  if (string(mesh)~="EpicCustomModels.TCowMesh")
    return class'CowMeshInfo';
  
  if (string(mesh)~="EpicCustomModels.tnalimesh")
    return class'NaliMeshInfo';
  
  if (string(mesh)~="EpicCustomModels.TSkM")
    return class'TSkaarjMeshInfo';
  
  if (hasanim('Duckuplgfr'))
    return class'HLMeshInfo';

   if (zzmyclass.default.CarcassType==Class'botpack.TBossCarcass')
    return class'TBossMeshInfo';

   if (classischildof(zzmyclass,class'TournamentMale'))
  {
      return class'TournamentMaleMeshInfo';
  }
   if (classischildof(zzmyclass,class'TournamentFemale'))
  {
      return class'TournamentFemaleMeshInfo';
  }
  if(zzMyClass.default.bisfemale)
    return class'TournamentFemaleMeshInfo';
	else
    return class'TournamentMaleMeshInfo';
}

event UpdateEyeHeight (float DeltaTime)
{
  Super.UpdateEyeHeight(DeltaTime);
  Tick(DeltaTime);
}

simulated event Init ()
{
  local int i;

  Initialized = True;
  zzNextSound = 0;
  if ( PlayerReplicationInfo != None )
  {
    if ( PlayerReplicationInfo.Owner == None )
    {
      PlayerReplicationInfo.SetOwner(self);
    }
    bIsFemale = PlayerReplicationInfo.bIsFemale;
    SkelAnim = None;
    Mesh = static.GetVAPRI(PlayerReplicationInfo).zzMyClass.default.Mesh;
    for(i = 0; i < 8; i++)
    {
      MultiSkins[i] = PlayerReplicationInfo.MultiSkins[i];
      if ( MultiSkins[i] != None )
      {
        MultiSkins[i].LODSet = LODSET_Skin;
      }
    }
    Skin = PlayerReplicationInfo.Skin;
    if ( Skin != None )
    {
      Skin.LODSet = LODSET_Skin;
    }
    DrawScale = PlayerReplicationInfo.DrawScale;
    PrePivot = PlayerReplicationInfo.PrePivot;
    if(ClassIsChildOf(GetVAPRI(PlayerReplicationInfo).zzMyClass, class'TournamentPlayer'))
    {
      StatusDoll = class<TournamentPlayer>(static.GetVAPRI(PlayerReplicationInfo).zzMyClass).default.StatusDoll;
      StatusBelt = class<TournamentPlayer>(static.GetVAPRI(PlayerReplicationInfo).zzMyClass).default.StatusBelt;
    } else {
      if(static.GetVAPRI(PlayerReplicationInfo).zzMyClass.default.bIsFemale)
      {
        StatusDoll = Texture'Woman';
        StatusBelt = Texture'WomanBelt';
      }
    }
  }
}

simulated function Tick (float Delta)
{
  Super.Tick(Delta);

  if ( ROLE == ROLE_Authority )
  {
    myState = GetStateName();
      return;
  }
  if ( (ROLE == ROLE_AutonomousProxy) && (IsInState('PlayerWaiting') || IsInState('PlayerSpectating') || IsInState('PlayerShip')) )
    return;
    
  if ( (myState == 'PlayerWaiting') || (myState == 'PlayerSpectating') || (myState == 'PlayerShip') )
  {
    Mesh = None;
    return;
  }

  if (  !Initialized )
  {
    if ( (GetVAPRI(PlayerReplicationInfo) != None) && (GetVAPRI(PlayerReplicationInfo).zzMyClass != None) && GetVAPRI(PlayerReplicationInfo).bxxsetclass )
      Init();
    else
      return;
  }
  if ( SoundInfo == None )
  {
    if ( ClassIsChildOf(GetVAPRI(PlayerReplicationInfo).zzMyClass,Class'UnrealIPlayer') )
      SoundInfo = Class'UnrealIPlayerSoundInfo';
    else
      SoundInfo = Class'TournamentPlayerSoundInfo';    
  }
  
  if ( MeshInfo == Class'DPMSMeshInfo' )
    MeshInfo = xxGetMeshInfo();
    
  if ( (Role != ROLE_SimulatedProxy) && (Level.NetMode != NM_Standalone) || (Delta == 0) )
    return;
    
  if ( zzNextSound != 0 )
    xxSetSounds();
    
  if ( (myState != '') && (myState != GetStateName()) )
    GotoState(myState);
  else
    if ( (myState == '') &&  !IsInState('PlayerWalking') )
      GotoState('PlayerWalking');
      
  if ( MeshInfo != None )
    MeshInfo.static.xxUpdateAnims(self);
    
  if ( bAnimFinished || bAnimLoop && (LastAnim == AnimSequence) && ((AnimFrame == AnimLast) || (AnimFrame < LastAFrame)) )
    AnimEnd();
    
  LastAFrame = AnimFrame;
  LastAnim = AnimSequence;
}

event PreRender (Canvas Canvas)
{
  Super.PreRender(Canvas);

  if (  !bMenuClassSetup )
    InitMenu();
  if (  !bmsg && (myHUD != None) )
  {
    ClientMessage("This server is running Valhalla Avatar 1.0, Type 'help' for more information or hit ESC and view the ValAvatar menus!",'DeathMessage',true);
    bmsg = True;
  }
}

function InitMenu ()
{
  local WindowConsole PlayerConsole;
  local UMenuMenuBar MenuBar;
  local UWindowMenuBarItem aMenu;
  local Class<UWindowWindow> OldClass;

  if ( Player != None )
  {
    PlayerConsole = Windowconsole(Player.Console);
    if (PlayerConsole == none || !PlayerConsole.bCreatedRoot)
    {
      //Log("[--Debug--]: PlayerConsole == none");
      return;
    }
    MenuBar = UMenuRootWindow(PlayerConsole.Root).MenuBar;
    if (MenuBar == none)
    {
      return;
    }
      
    if ( UMenuOptionsMenu(MenuBar.OptionsItem.Menu).PlayerWindowClass != Class'DPMSPlayerWindow' )
    {
      OldClass = UMenuOptionsMenu(MenuBar.OptionsItem.Menu).PlayerWindowClass;
      UMenuOptionsMenu(MenuBar.OptionsItem.Menu).PlayerWindowClass = Class'DPMSPlayerWindow';
    }
    
    for( aMenu = UWindowMenuBarItem(MenuBar.Items.Next); aMenu != None; aMenu = UWindowMenuBarItem(aMenu.Next) ) 
    {
      if ( aMenu.Caption == "&ValAvatar" )
        return;
    }    
    aMenu = MenuBar.AddItem("&ValAvatar");
    VAMenu(aMenu.CreateMenu(Class'VAMenu')).OldClass = OldClass;
    bMenuClassSetup = True;
  }
}

static function SetMultiSkin (Actor SkinActor, string SkinName, string FaceName, byte TeamNum);

static function GetMultiSkin (Actor SkinActor, out string SkinName, out string FaceName)
{
  if ( SkinActor.Class != Class'VAPlayer' )
    return;
  SkinName = GetVAPRI(Pawn(SkinActor).PlayerReplicationInfo).zzskinstring;
  if ( GetVAPRI(Pawn(SkinActor).PlayerReplicationInfo).zzfacestring != "" )
  {
    FaceName = GetVAPRI(Pawn(SkinActor).PlayerReplicationInfo).zzfacestring;
  }
}

simulated function SetMesh ()
{
  SkelAnim = None;
  if ( (ROLE == ROLE_Authority) && (Level.NetMode != NM_Standalone) || (PlayerReplicationInfo == None) && (Mesh == None) )
    Mesh=default.Mesh;
  else
    Mesh=PlayerReplicationInfo.Mesh;
}

function ServerChangeSkin (coerce string SkinName, coerce string FaceName, byte TeamNum)
{
  if ( Class'VASettings'.Default.MeshSkinAllowChange > 0 )
  {
    GetVAPRI(PlayerReplicationInfo).zzskinstring = SkinName;
    GetVAPRI(PlayerReplicationInfo).zzfacestring = FaceName;
  }
}

event FootZoneChange(ZoneInfo newFootZone)
{
  local actor HitActor;
  local vector HitNormal, HitLocation;
  local float splashSize;
  local actor splash;
  
  if (Level.NetMode == NM_Client)
  {
    if ( Level.TimeSeconds - SplashTime > 0.25 )
    {
      SplashTime = Level.TimeSeconds;
      if (!FootRegion.Zone.bWaterZone&&newFootZone.bWaterZone)
    {
        if ( newFootZone.EntrySound != None )
        {
          HitActor = Trace(HitLocation, HitNormal, Location - (CollisionHeight + 40) * vect(0,0,0.8),
               Location - CollisionHeight * vect(0,0,0.8), false);
           
          if ( HitActor != None )
            SoundInfo.static.FootZoneChange(self);
        }
      }
    }
  
    if (FootRegion.Zone.bPainZone)
    {
      if ( !newFootZone.bPainZone && !HeadRegion.Zone.bWaterZone )
        PainTime = -1.0;
    }
    else if (newFootZone.bPainZone)
      PainTime = 0.01;
    
    return;
  }
  if ( Level.TimeSeconds - SplashTime > 0.25 )
  {
    SplashTime = Level.TimeSeconds;
  
    if (Physics == PHYS_Falling)
      MakeNoise(1.0);
    else
      MakeNoise(0.3);
    
    if ( FootRegion.Zone.bWaterZone )
    {
      if ( !newFootZone.bWaterZone && (Role==ROLE_Authority) )
      {
        if ( FootRegion.Zone.ExitSound != None )
          PlaySound(FootRegion.Zone.ExitSound, SLOT_Interact, 1);
      
        if ( FootRegion.Zone.ExitActor != None )
          Spawn(FootRegion.Zone.ExitActor,,,Location - CollisionHeight * vect(0,0,1));
      }
    }
    else if ( newFootZone.bWaterZone)
    {
      splashSize = FClamp(0.000025 * Mass * (300 - 0.5 * FMax(-500, Velocity.Z)), 1.0, 4.0 );
    
      if ( newFootZone.EntrySound != None )
      {
        HitActor = Trace(HitLocation, HitNormal,
          Location - (CollisionHeight + 40) * vect(0,0,0.8), Location - CollisionHeight * vect(0,0,0.8), false);
      
        if ( HitActor == None )
          PlaySound(newFootZone.EntrySound, SLOT_Misc, 2 * splashSize);
        else
        {
          xxServerSound(5);
        }
      }
    
      if( newFootZone.EntryActor != None )
      {
        splash = Spawn(newFootZone.EntryActor,,,Location - CollisionHeight * vect(0,0,1));
        if ( splash != None )
          splash.DrawScale = splashSize;
      }
    }
  }
  
  if (FootRegion.Zone.bPainZone)
  {
    if ( !newFootZone.bPainZone && !HeadRegion.Zone.bWaterZone )
      PainTime = -1.0;
  }
  else if (newFootZone.bPainZone)
    PainTime = 0.01;
}

function PlayDyingSound ()
{
  if ( Role == ROLE_Authority )
    xxServerSound(4);
  else
    SoundInfo.static.PlayDyingSound(self);
}
function DoJump( optional float F )
{
	local UT_JumpBoots zzBoots;
	
	if ( CarriedDecoration != None )
		return;
	
	if (Level.NetMode == NM_Client)
	{
		zzBoots = UT_JumpBoots(FindInventoryType(class'UT_JumpBoots'));
		if (zzBoots != None && zzBoots.Charge <= 0)
			JumpZ = Default.JumpZ;
	}
	
	if ( !bIsCrouching && (Physics == PHYS_Walking) )
	{
		if ( !bUpdating )
		{
		  if (Role == ROLE_AutonomousProxy)
			SoundInfo.static.DoJump(self);
		  else
			xxServerSound(3);
		}
		if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
			MakeNoise(0.1 * Level.Game.Difficulty);
		PlayInAir();
		if ( bCountJumps && (Role == ROLE_Authority) && (Inventory != None) )
			Inventory.OwnerJumped();
		if ( bIsWalking )
			Velocity.Z = Default.JumpZ;
		else
			Velocity.Z = JumpZ;
		if ( (Base != Level) && (Base != None) )
			Velocity.Z += Base.Velocity.Z; 
		SetPhysics(PHYS_Falling);
	}
	else if (bDoubleJump && Physics == PHYS_Falling && nofJumps < maxJumps && Velocity.Z > -160.0 && (zzbIsWarmingUp || PlayerReplicationInfo.HasFlag == none))
	{	
		Velocity.Z = JumpZ * 1.2;
		if ( !bUpdating )
			
			if (Role == ROLE_AutonomousProxy)
				SoundInfo.static.DoDoubleJump(self);
			else
			xxServerSound(3);
		if ( bCountJumps && (Role == ROLE_Authority) && (Inventory != None) )
			Inventory.OwnerJumped();
		
		nofJumps++;
		if (nofJumps == maxJumps)
		{
			if ( AnimSequence=='DodgeR' && HasAnim('ROLLRIGHT') )
				PlayAnim('RollRight', 1.35 * FMax(0.35, Region.Zone.ZoneGravity.Z/Region.Zone.Default.ZoneGravity.Z), 0.06);
			else if ( AnimSequence=='DodgeL' && HasAnim('ROLLLEFT') )
				PlayAnim('RollLeft', 1.35 * FMax(0.35, Region.Zone.ZoneGravity.Z/Region.Zone.Default.ZoneGravity.Z), 0.06);
			else if ( HasAnim('Flip') )
				PlayAnim('Flip', 1.35 * FMax(0.35, Region.Zone.ZoneGravity.Z/Region.Zone.Default.ZoneGravity.Z), 0.06);
		}
	}
}

simulated function FootStepping()
{
  if (Role<ROLE_Authority)
    SoundInfo.static.FootStepping(self);
}

function PlayTakeHitSound(int damage, name damageType, int Mult)
{
  if ( Level.TimeSeconds - LastPainSound < 0.3 )
    return;
  
  LastPainSound = Level.TimeSeconds;
  
  if ( HeadRegion.Zone.bWaterZone )
  {
    if ( damageType == 'Drowned' )
      xxServerSound(7);
    else
      xxServerSound(8);
    
    return;
  }
  
  damage *= FRand();

  if (damage < 8) 
    xxServerSound(9);
  else if (damage < 25)
  {
    xxServerSound(10);
  }
  else
    xxServerSound(11);
}

function ClientPlayTakeHit(vector HitLoc, byte Damage, bool bServerGuessWeapon)
{
  super.ClientPlayTakeHit(hitloc,damage,bServerGuessWeapon);
  
  if ( Level.TimeSeconds - LastPainSound < 0.3 )
    return;
  
  LastPainSound = Level.TimeSeconds;

  if ( HeadRegion.Zone.bWaterZone )
  {
    if ( Hitloc == CollisionHeight * vect(0,0,0.5))
      SoundInfo.static.drown(self);
    else if ( FRand() < 0.5 )
      soundinfo.static.uwhit(self);
    
    return;
  }
  damage *= FRand();

  if (damage < 8) 
    soundinfo.static.hit1(self);
  else if (damage < 25)
  {
    soundinfo.static.hit23(self);
  }
  else
    soundinfo.static.hit4(self);
}

function Gasp()
{
  if ( PainTime < 2 )
    xxServerSound(1);
  else
    xxServerSound(2);
}

event HeadZoneChange(ZoneInfo newHeadZone)
{
  if (role==role_authority)
  {
    super.headzonechange(newheadzone);
    return;
  }
  
  if (HeadRegion.Zone.bWaterZone)
  {
    if (!newHeadZone.bWaterZone)
    {
      if (PainTime > 0 && (PainTime < 8) )
    {
        if ( PainTime < 2 )
          soundinfo.static.gasp(self);
        else
          soundinfo.static.breathagain(self);
      }
    
      bDrowning = false;
      if ( !FootRegion.Zone.bPainZone )
        PainTime = -1.0;
    }
  }
  else if (newHeadZone.bWaterZone && !FootRegion.Zone.bPainZone )
    PainTime = UnderWaterTime;
}

event PainTimer()
{
  local float depth;
  
  if (Level.NetMode != NM_Client)
  {
    super.paintimer();
    return;
  }
  
  if (Health < 0)
    return;
  
  if ( FootRegion.Zone.bPainZone )
      PainTime = 1.0;
  else if ( HeadRegion.Zone.bWaterZone )
      PainTime = 2.0;
}

simulated function PlayMetalStep()
{
  if (role<ROLE_Authority)
    SoundInfo.static.PlaySpecial(self, 'MetalStep');
}

simulated function WalkStep()
{
  if (role<ROLE_Authority)
    SoundInfo.static.PlaySpecial(self, 'WalkStep');
}

simulated function RunStep()
{
  if (role<ROLE_Authority)
    SoundInfo.static.PlaySpecial(self, 'RunStep');
}

state FeigningDeath   //this has been overloaded to use a timer, for animations no longer occur server-side :P
{
ignores SeePlayer, HearNoise, Bump;

  function Rise()
  {
    if ( (Role == ROLE_Authority) && (Health <= 0) )
    {
      GotoState('Dying');
      return;
    }
  
    if ( !bRising )
    {
      settimer(0.7,false); //as tweenanim is noramlly 0.7 :P
      BaseEyeHeight = Default.BaseEyeHeight;
      bRising = true;
      banimon=true;
      PlayRising();
    }
  }

function bool FeignAnimCheck(){ //for VA compatibility
  return bAnimon;
}

/*  function PlayerMove( float DeltaTime)
  {
    local rotator currentRot;
    local vector NewAccel;

    aLookup  *= 0.24;
    aTurn    *= 0.24;

    // Update acceleration.
    if ( !banimon && (aForward != 0) || (aStrafe != 0) )
      NewAccel = vect(0,0,1);
    else
      NewAccel = vect(0,0,0);

    // Update view rotation.
    currentRot = Rotation;
    UpdateRotation(DeltaTime, 1);
    SetRotation(currentRot);

    if ( Role < ROLE_Authority ) // then save this move and replicate it
      ReplicateMove(DeltaTime, NewAccel, DODGE_None, Rot(0,0,0));
    else
      ProcessMove(DeltaTime, NewAccel, DODGE_None, Rot(0,0,0));
    
    bPressedJump = false;
  }
 */
  function PlayTakeHit(float tweentime, vector HitLoc, int Damage)
  {
    if ( bAnimOn )
    {
      SetTimer(tweentime, false);
      bAnimOn=true;
      Global.PlayTakeHit(tweentime, HitLoc, Damage);
    }
  }
  
  function timer()
  {
    if ( Role < ROLE_Authority )
      return;
    
    if ( Health <= 0 )
    {
      GotoState('Dying');
      return;
    }
  
    GotoState('PlayerWalking');
    PendingWeapon.SetDefaultDisplayProperties();
    ChangedWeapon();
  }
  
  function PlayDying(name DamageType, vector HitLocation)
  {
    BaseEyeHeight = Default.BaseEyeHeight;
  
    if ( bRising || bAnimOn)
      Global.PlayDying(DamageType, HitLocation);
  }
  
  function Landed(vector HitNormal)
  {
//    lastsoundtimer=-1*level.timeseconds;
    if ( Role == ROLE_Authority )
      //nextsound=Sound_playerlanded;
      xxServerSound(6);
    else
      SoundInfo.static.PlayerLanded(self); //autonomous
    
    if ( bUpdating )
      return;
    
    TakeFallingDamage();
    bJustLanded = true;  
  }
  
  simulated function BeginState()
  {
    if (role==role_simulatedproxy)  //do it directly (else seeing feigned player could get b0rked)
      meshinfo.static.PlayFeignDeath(self);
    else
      super.beginstate();
    
    bAnimOn=false;
  }
}

function PlayTurning()
{
  BaseEyeHeight = Default.BaseEyeHeight;
  if (role<role_authority)
    MeshInfo.static.PlayTurning(self);
  else
    baseanim=13;
}

function TweenToWalking(float tweentime)
{
  BaseEyeHeight = Default.BaseEyeHeight;
  
  if ((weapon!=none&&weapon.bpointing)|| (CarriedDecoration != None) )
  {
    if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.TweenToWalkingPoint(self);
  }
  else if (role<role_authority)
    MeshInfo.static.TweenToWalking(self);
}

function PlayDodge (EDodgeDir DodgeMove)
{
	Velocity.Z = 210;
	if (Role < ROLE_Authority)
	{
		if ( DodgeMove == DODGE_Left )
		  MeshInfo.static.PlayDodgeL(self);
		else if ( DodgeMove == DODGE_Right )
		  MeshInfo.static.PlayDodgeR(self);
		else if (dodgemove == DODGE_BACK)
		  MeshInfo.static.PlayDodgeB(self);
		else
		  MeshInfo.static.PlayDodgeF(self);
	}
	else
	{
		if ( DodgeMove == DODGE_Left )
		  xxServerAnim(1);
		else if ( DodgeMove == DODGE_Right )
		  xxServerAnim(2);
		else if (dodgemove == DODGE_BACK)
		  xxServerAnim(3);
		else
		  xxServerAnim(4);
	}
}

function PlayWalking()
{
  BaseEyeHeight = Default.BaseEyeHeight;
  if ((weapon!=none&&weapon.bpointing)|| (CarriedDecoration != None) )
  {
    if (Role < ROLE_Authority)
      MeshInfo.static.PlayWalkingPoint(self);
    else
//      baseanim='playwalkingpoint';
      baseanim=12;
  }
  else if (role<role_authority)
    MeshInfo.static.PlayWalking(self);
  else
      //baseanim='playwalking';
      baseanim=11;
}

function TweenToRunning(float tweentime)  //always tweentime=0.1
{
  local vector X,Y,Z, Dir;
  
  BaseEyeHeight = Default.BaseEyeHeight;
  if (bIsWalking)
  {
    TweenToWalking(0.1);
    return;
  }
  
  GetAxes(Rotation, X,Y,Z);
  Dir = Normal(Acceleration);
  
  if (Role<ROLE_Authority)
  {
    if ( (Dir Dot X < 0.75) && (Dir != vect(0,0,0)) )
    {
      // strafing or backing up
      if ( Dir Dot X < -0.75 )
        MeshInfo.static.Playrunning(self,2,true);
      else if ( Dir Dot Y > 0 )
        MeshInfo.static.Playrunning(self,3,true);
      else
        MeshInfo.static.Playrunning(self,4,true);
    }
    else if (weapon!=none&&weapon.bpointing)
      meshinfo.static.Playrunning(self,1,true);
    else
      MeshInfo.static.Playrunning(self,0,true);
  }
 /* else{
    if ( (Dir Dot X < 0.75) && (Dir != vect(0,0,0)) )
    {
      // strafing or backing up
      if ( Dir Dot X < -0.75 )
        nextanim='TBackRun';
      else if ( Dir Dot Y > 0 )
        nextanim='TStrafeR';
      else
        nextanim='TStrafeL';
    }
    else if (weapon!=none&&weapon.bpointing)
      nextanim='TPlayRunningPoint';
    else
      nextanim='TPlayRunning';
  }  */
}

function PlayRunning()
{
  local vector X,Y,Z, Dir;
  
  BaseEyeHeight = Default.BaseEyeHeight;
  GetAxes(Rotation, X,Y,Z);
  Dir = Normal(Acceleration);
  
  if (Role < ROLE_Authority)
  {
    if ( (Dir Dot X < 0.75) && (Dir != vect(0,0,0)) )
    {
      // strafing or backing up
      if ( Dir Dot X < -0.75 )
        MeshInfo.static.Playrunning(self,2,false);
      else if ( Dir Dot Y > 0 )
        MeshInfo.static.Playrunning(self,3,false);
      else
        MeshInfo.static.Playrunning(self,4,false);
    }
    else if (weapon!=none&&weapon.bpointing)
      meshinfo.static.Playrunning(self,1,false);
    else
      MeshInfo.static.PlayRunning(self,0,false);
  }
  else
  {
    if ( (Dir Dot X < 0.75) && (Dir != vect(0,0,0)) )
    {
      // strafing or backing up
      if ( Dir Dot X < -0.75 )
        //baseanim='BackRun';
        baseanim=8;
      else if ( Dir Dot Y > 0 )
        //baseanim='StrafeR';
        baseanim=9;
      else
        //baseanim='StrafeL';
        baseanim=10;
    }
    else if (weapon!=none&&weapon.bpointing)
      //baseanim='PlayRunningPoint';
      baseanim=7;
    else
      //baseanim='PlayRunning';
      baseanim=6;
  }
}

function PlayRising()
{
  BaseEyeHeight = 0.4 * Default.BaseEyeHeight;
  if (role<role_authority)
    MeshInfo.static.PlayRising(self);
  else
  {
/*    lastanimtimer=-1*level.timeseconds;
    nextanim='PlayRising';*/
    xxServerAnim(5);
  }
}

function PlayFeignDeath()
{
  BaseEyeHeight = 0;
  if (role<role_authority)
    MeshInfo.static.PlayFeignDeath(self);
//else                             //no replication. I decided to go with beginstate();
// nextanim='PlayFeignDeath';
}

//landed hax for all those replication problemz... now it is simulated :P
/*simulated */ /* function Landed(vector HitNormal)
{
  //Note - physics changes type to PHYS_Walking by default for landed pawns
  if ( bUpdating )
    return;
  
  PlayLanded(Velocity.Z);
//  if (role>role_simulatedproxy){ //only local & server.
  LandBob = FMin(50, 0.055 * Velocity.Z);
  TakeFallingDamage();
  bJustLanded = true;
  nofJumps = 1;
//  }
} */

/*simulated */function PlayLanded(float impactVel) //now simulated as well :P   (beware of bugs!)
{
 // if (role>role_simulatedproxy)
  BaseEyeHeight = Default.BaseEyeHeight;

/*  else{
    nextanim='playlanded'; //wierd hax thingies :P
//    lastanim='playlanded';
  }  */
//  if (role<role_authority)
  if (role==role_authority) //compress landed veloc.
  {
    impactvel /= -20; //terminal velocity is 2500 max, so this makes it fit into 7 bits.
    if (impactvel >= 1)
  {
      zzNextAnim = impactvel;
      zzNextAnim += 128;   //flags last byte as 8th.
    }
//    log ("Server sayz that impactvel is"@impactvel@"and nextanim is"@zznextanim);
  }
  else
    MeshInfo.static.PlayLanded(self, impactVel); //one of the few that have params.
}

//This var also allows sim clients to detect physics!
function PlayInAir()   //may be a little wierd due to acceleration not being replicated, but oh well...
{
  BaseEyeHeight =  0.7 * Default.BaseEyeHeight;
  
  if (role==role_autonomousproxy)
    MeshInfo.static.PlayInAir(self);
  else {
    //log ("server play in air.  Current baseanim is"@baseanim@"and nextanim is"@nextanim);
    //baseanim='playinair'; //it must be base (continuous loop) and base (immediately swaps)
//    lastanimtimer=-1*level.timeseconds;
//    nextanim='playinair';
      if (DodgeDir != DODGE_Active)   //me supposes
        xxServerAnim(16);
  }
}

function PlayDuck()
{
  BaseEyeHeight = 0;
  
  if (role==role_autonomousproxy)
    MeshInfo.static.PlayDuck(self);
  else
    //baseanim='playduck';
    baseanim=15;
}

function PlayCrawling()
{
  BaseEyeHeight = 0;
  if (role==role_autonomousproxy)
    MeshInfo.static.PlayCrawling(self);
  else
    //baseanim='PlayCrawling';
    baseanim=16;
}

function TweenToWaiting(float tweentime)  //never actually replicated. hell I'm not even sure if it is called...
{
  if ( (IsInState('PlayerSwimming')) || (physics==phys_swimming) )
    BaseEyeHeight = 0.7 * Default.BaseEyeHeight;
  else
    BaseEyeHeight = Default.BaseEyeHeight;
//  if (role==role_authority)
  //  nextanim='tweentowaiting';
  //else
  if (role==role_autonomousproxy)
    MeshInfo.static.TweenToWaiting(self, tweentime);   //only case where it is called server-side.
}

function PlayRecoil(float Rate)  //note rate, with exception of duel enforcer, is always weapon.firingrate.  checks for enforcer thing
{
  if (role==role_autonomousproxy){
    if (rate>=1.9*weapon.FiringSpeed)
      MeshInfo.static.PlayDoubleRecoil(self);  //for 2x recoil
    else
      MeshInfo.static.PlayRecoil(self);
  }
  else
  {
    //lastanimtimer=level.timeseconds;
    if (rate>=1.9*weapon.FiringSpeed)
     // nextanim='PlayDoubleRecoil';  //for 2x recoil
     xxServerAnim(7);
    else
      //nextanim='playrecoil';
      xxServerAnim(8);
  }
}

function PlayFiring()   //FIX ME: HL anim viewrot support
{
  if (role==role_autonomousproxy)
    MeshInfo.static.PlayFiring(self);
  else
  {
    if ((zznextanim>0&&zznextanim<5)||zznextanim==16)
      return;
//    lastanimtimer=level.timeseconds;
  //  nextanim='playfiring';
    xxServerAnim(9);
  }
}

function PlayWeaponSwitch(Weapon NewWeapon)
{
  if ( (Weapon == None) || (Weapon.Mass < 20) )
  {
    if ( (NewWeapon != None) && (NewWeapon.Mass > 20) )
    {
      if (role==role_autonomousproxy)
        MeshInfo.static.PlayBigWeaponSwitch(self);
      else
    {
        if ((zznextanim>0&&zznextanim<5)||zznextanim==16)
          return;
       // lastanimtimer=level.timeseconds;
      //  nextanim='PlayBigWeaponSwitch';
        xxServerAnim(10);
      }
    }
  }
  else if ( (NewWeapon == None) || (NewWeapon.Mass < 20) )
  {  
    if (role==role_autonomousproxy)
      MeshInfo.static.PlayWeaponSwitch(self);
    else
  {
      if ((zznextanim>0&&zznextanim<5)||zznextanim==16)
        return;
      //nextanim='PlayWeaponSwitch';
      //lastanimtimer=level.timeseconds;
      xxServerAnim(11);
    }
  }
}

function PlaySwimming()       //no anim replicated.  (only called autonomously or in animends)
{
  BaseEyeHeight = 0.7 * Default.BaseEyeHeight;
  
  if (role==role_autonomousproxy)
    MeshInfo.static.PlaySwimming(self);
//  else
   // nextanim='playswimming';
}

function TweenToSwimming(float tweentime)  //no anim replicated
{
  if (role<role_authority)
    MeshInfo.static.TweenToSwimming(self, tweentime);
}

//DYING ANIMATIONS:
//Note: there are some issues involved with dying.  With unreali players it won't always use the intended animation (such as in case of repeater), but what can I say?
// carcass heads and body parts are all spawned client-side, due to anim stuff. of course this screws up take damage, but oh well...
function PlayDying(name DamageType, vector HitLoc)
{
  //used for unreali player anim changing.
  local vector X,Y,Z, HitVec, HitVec2D;
  local float dotp;
  //known: suicide, decap, dead9, high, type1 (normal), type2, type3
  BaseEyeHeight = Default.BaseEyeHeight;
  PlayDyingSound();
      
  if ( DamageType == 'Suicided' )
  {
    if (role==role_authority)
  //nextanim='suicide';
      zzPendingDeath=3;
    else
      MeshInfo.static.PlayDying(self,3);
    
    return;
  }
  
  if (DamageType == 'Decapitated')
  {
    if (role==role_authority)
      //nextanim='decap';
      zzPendingDeath=4;
    else
      MeshInfo.static.PlayDying(self,4);
    
    return;
  }
  // check for repeater death
  if ( (Health > -10) && ((DamageType == 'shot') || (DamageType == 'zapped')) )
  {
    if (role==role_authority)
  //  nextanim='dead9r';  //s3?
      zzPendingDeath=5;
    else
      MeshInfo.static.PlayDying(self,5);
    
    return;
  }
  
  if ( HitLoc.Z - Location.Z > 0.7 * CollisionHeight){ //high hit
    if (role==role_authority)
//      nextanim='highdead';
      zzPendingDeath=6;
    else
      MeshInfo.static.PlayDying(self,6);
    return;
  }
  GetAxes(Rotation,X,Y,Z);
  X.Z = 0;
  HitVec = Normal(HitLoc - Location);
  HitVec2D= HitVec;
  HitVec2D.Z = 0;
  dotp = HitVec2D dot X;
  
  if (Abs(dotp) > 0.71){ //then hit in front or back
    if (role==role_authority)
      //nextanim='type0';
      zzPendingDeath=0;
    else
      MeshInfo.static.PlayDying(self,0);
    }
  else
  {
    dotp = HitVec dot Y;
    if (dotp > 0.0){
      if (role==role_authority)
        //nextanim='type1';
        zzPendingDeath=1;
      else
        MeshInfo.static.PlayDying(self,1); }
    else{
    if (role==role_authority)
//      nextanim='type2';
      zzPendingDeath=2;
    else
      MeshInfo.static.PlayDying(self,2); }
  }
}

function Carcass SpawnCarcass()    //custom carcass functions.
{
local VACarcass carc;
carc=VACarcass(super.spawncarcass());
//if (nextanim=='dead9r')
//carc.bjerking=true; //set jerk this way.
//carc.zzdeathanim=zzPendingDeath+1;      //anim seq of carc.
carc.xxsetanim(zzPendingDeath);
//carc.lasthit=level.timeseconds; //saves bandwith
}

function PlayGutHit(float tweentime)  //all tweentimes of hits are 0.1!
{
  if (role==role_autonomousproxy)
    MeshInfo.static.PlayGutHit(self);
  else{
   // lastanimtimer=level.timeseconds;
   // nextanim='playguthit';
   xxServerAnim(12);
  }
}

function PlayHeadHit(float tweentime)
{
  if (role==role_autonomousproxy)
    MeshInfo.static.PlayHeadHit(self);
  else{
   // nextanim='playheadhit';
    //lastanimtimer=level.timeseconds;
    xxServerAnim(13);
  }
}

function PlayLeftHit(float tweentime)
{
  if (role==role_autonomousproxy)
    MeshInfo.static.PlayLeftHit(self);
  else  {
   // nextanim='playlefthit';
    //lastanimtimer=level.timeseconds;
    xxServerAnim(14);
  }
}

function PlayRightHit(float tweentime)
{
  if (role==role_autonomousproxy)
    MeshInfo.static.PlayRightHit(self);
  else {
   // nextanim='playrighthit';
   // lastanimtimer=level.timeseconds;
    xxServerAnim(15);
  }
}
///////////////////////////////////////////////////////
// Crap because of stupid animation checks!!!!!!!!!!!!!
////////////////////////////////////////////////////////
function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
  local float rnd;
  local Bubble1 bub;
  local bool bServerGuessWeapon;
 //local class<DamageType> DamageClass;
  local vector BloodOffset, Mo;
  local int iDam;

  if ( (Damage <= 0) && (ReducedDamageType != 'All') )
    return;

  //DamageClass = class(damageType);
  if ( ReducedDamageType != 'All' ) //spawn some blood
  {
    if (damageType == 'Drowned')
    {
      bub = spawn(class 'Bubble1',,, Location 
        + 0.7 * CollisionRadius * vector(ViewRotation) + 0.3 * EyeHeight * vect(0,0,1));
      if (bub != None)
        bub.DrawScale = FRand()*0.06+0.04; 
    }
    else if ( (damageType != 'Burned') && (damageType != 'Corroded') 
          && (damageType != 'Fell') )
    {
      BloodOffset = 0.2 * CollisionRadius * Normal(HitLocation - Location);
      BloodOffset.Z = BloodOffset.Z * 0.5;
      if ( (DamageType == 'shot') || (DamageType == 'decapitated') || (DamageType == 'shredded') )
      {
        Mo = Momentum;
        if ( Mo.Z > 0 )
          Mo.Z *= 0.5;
        spawn(class 'UT_BloodHit',self,,hitLocation + BloodOffset, rotator(Mo));
      }
      else
        spawn(class 'UT_BloodBurst',self,,hitLocation + BloodOffset);
    }
  }  

  rnd = FClamp(Damage, 20, 60);
  if ( damageType == 'Burned' )
    ClientFlash( -0.009375 * rnd, rnd * vect(16.41, 11.719, 4.6875));
  else if ( damageType == 'Corroded' )
    ClientFlash( -0.01171875 * rnd, rnd * vect(9.375, 14.0625, 4.6875));
  else if ( damageType == 'Drowned' )
    ClientFlash(-0.390, vect(312.5,468.75,468.75));
  else 
    ClientFlash( -0.019 * rnd, rnd * vect(26.5, 4.5, 4.5));

  ShakeView(0.15 + 0.005 * Damage, Damage * 30, 0.3 * Damage); 
  PlayTakeHitSound(Damage, damageType, 1);
  //overloaded due to anim checks
  bServerGuessWeapon = ( ((Weapon != None) && Weapon.bPointing) || DodgeDir == DODGE_Active/*(nextanim=='PlayDodgeR'||nextanim=='PlayDodgeL'||nextanim=='PlaydodgeF'||nextanim=='PlaydodgeB')*/);
  iDam = Clamp(Damage,0,200);
  ClientPlayTakeHit(hitLocation - Location, iDam, bServerGuessWeapon ); 
  if ( !bServerGuessWeapon 
    && ((Level.NetMode == NM_DedicatedServer) || (Level.NetMode == NM_ListenServer)) )
  {
    //Enable('AnimEnd');
    BaseEyeHeight = Default.BaseEyeHeight;
    //bAnimTransition = true;
    PlayTakeHit(0.1, hitLocation, Damage);
  }
}

// "GetAnimGroup()" functions from "Engine.Pawn"
function SwimAnimUpdate(bool bNotForward)
{
  if (role==role_autonomousproxy)
    MeshInfo.static.SwimAnimUpdate(self, bNotForward);
  else if (bnotforward)     //client anim analysis will send proper param.
    //baseanim='swimanimupdatenotf';
    baseanim=18;
  else
    //baseanim='swimanimupdate';
    baseanim=17;
}

state PlayerSwimming
{
ignores SeePlayer, HearNoise, Bump;
  simulated function AnimEnd()    //from the swim anim update, I can tell what anim to play!
  {
    if (role<role_authority)
      MeshInfo.static.xxSwimAnimEnd(self);
  }
  simulated function beginstate(){
    if (role==role_simulatedproxy&&!IsAnimating())
      TweenToWaiting(0.3);
    else if (role>role_simulatedproxy)
      super.beginstate();
  }
  event UpdateEyeHeight(float DeltaTime) //lets local playerpawns still tick   why not playertick? too lazy to overwrite every tick()...
  {
    super.updateeyeheight(deltatime);
    tick(deltatime);
  }
  function playduck(){
    local byte zzoldanim;
    zzoldanim=baseanim;
    global.playduck();
    baseanim=zzoldanim;
    if (role==role_authority)
      xxServerAnim(17);
  }
}

state playerFlying
{
ignores SeePlayer, HearNoise, Bump;
    
  simulated function AnimEnd()
  {
    if (role<role_authority)
      meshinfo.static.PlaySwimming(self);
  }// From Engine.PlayerPawn
}
state CheatFlying
{
ignores SeePlayer, HearNoise, Bump, TakeDamage;
    
  simulated function AnimEnd()
  {
    if (role<role_authority)
      meshinfo.static.PlaySwimming(self);
  }// From Engine.PlayerPawn
}
//////////////////////////////////////////////////////
// AutonomousWalkAnim: Processes anims autonomously with overloadable getanimgroup()
//////////////////////////////////////////////////////
function AutonomousWalkAnim(vector oldaccel)
{
  if ( (Physics == PHYS_Walking) && (meshinfo.static.GetMyAnimGroup(self) != 'Dodge') )
    {
      if (!bIsCrouching)
      {
        if (bDuck != 0)
        {
          bIsCrouching = true;
          PlayDuck();
        }
      }
      else if (bDuck == 0)
      {
        OldAccel = vect(0,0,0);
        bIsCrouching = false;
        TweenToRunning(0.1);
      }

      if ( !bIsCrouching )
      {
        if ( (!bAnimTransition || (AnimFrame > 0)) && (meshinfo.static.GetMyAnimGroup(self) != 'Landing') )
        {
          if ( Acceleration != vect(0,0,0) )
          {
            if ( (meshinfo.static.GetMyAnimGroup(self) == 'Waiting') || (meshinfo.static.GetMyAnimGroup(self) == 'Gesture') || (meshinfo.static.GetMyAnimGroup(self) == 'TakeHit') )
            {
              bAnimTransition = true;
              TweenToRunning(0.1);
            }
          }
           else if ( (Velocity.X * Velocity.X + Velocity.Y * Velocity.Y < 1000) 
            && (meshinfo.static.GetMyAnimGroup(self) != 'Gesture') )
           {
             if ( meshinfo.static.GetMyAnimGroup(self) == 'Waiting' )
             {
              if ( bIsTurning && (AnimFrame >= 0) ) 
              {
                bAnimTransition = true;
                PlayTurning();
              }
            }
             else if ( !bIsTurning ) 
            {
              bAnimTransition = true;
              TweenToWaiting(0.2);
            }
          }
        }
      }
      else
      {
        if ( (OldAccel == vect(0,0,0)) && (Acceleration != vect(0,0,0)) )
          PlayCrawling();
        else if ( !bIsTurning && (Acceleration == vect(0,0,0)) && (AnimFrame > 0.1) )
          PlayDuck();
      }
    }
}

state PlayerWalking
{
ignores SeePlayer, HearNoise, Bump;
  function Dodge(eDodgeDir DodgeMove)
  {
    local vector x,y,z;
    if ( bIsCrouching || (Physics != PHYS_Walking) )
      return;

    GetAxes(Rotation,X,Y,Z);
    if (DodgeMove == DODGE_Forward)
      Velocity = 1.5*GroundSpeed*X + (Velocity Dot Y)*Y;
    else if (DodgeMove == DODGE_Back)
      Velocity = -1.5*GroundSpeed*X + (Velocity Dot Y)*Y; 
    else if (DodgeMove == DODGE_Left)
      Velocity = 1.5*GroundSpeed*Y + (Velocity Dot X)*X; 
    else if (DodgeMove == DODGE_Right)
      Velocity = -1.5*GroundSpeed*Y + (Velocity Dot X)*X; 

    Velocity.Z = 160;
    if (role==role_authority)
	{
      //lastsoundtimer=-1*level.timeseconds;
      //nextsound=Sound_dodgesound;
      xxServerSound(12);
    }
    else
      soundinfo.static.dodgesound(self);
    PlayDodge(DodgeMove);
    DodgeDir = DODGE_Active;
    SetPhysics(PHYS_Falling);
  }

  simulated function AnimEnd()   //a b1tch to handle
  {
    if (role<role_authority)
      MeshInfo.static.xxWalkingAnimEnd(self);
  }
  //This is actually now the base anim setter-upper :D
  function ProcessMove(float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot)
  {    //the client will end up fixing up most of these things to follow same rules as this for animend and such.
    local vector OldAccel;
    
    OldAccel = Acceleration;
    Acceleration = NewAccel;
    bIsTurning = ( Abs(DeltaRot.Yaw/DeltaTime) > 5000 );
    if ( (DodgeMove == DODGE_Active) && (Physics == PHYS_Falling) )
      DodgeDir = DODGE_Active;  
    else if ( (DodgeMove != DODGE_None) && (DodgeMove < DODGE_Active) )
      Dodge(DodgeMove);

    if ( bPressedJump )
      DoJump();
    if (role==role_autonomousproxy){ //FIXME: May require overload for anim group stuff.
      AutonomousWalkanim(oldaccel);
      return;
    }
    if ( (Physics == PHYS_Walking) && (dodgedir!=DODGE_ACTIVE) )
    {
      if (!bIsCrouching)
      {
        if (bDuck != 0)
        {
          bIsCrouching = true;
         // PlayDuck();
        }
      }
      else if (bDuck == 0)
      {
        OldAccel = vect(0,0,0);
        bIsCrouching = false;
      }

      if ( !bIsCrouching )
      {
        if ( Acceleration != vect(0,0,0) )
        {
          if (biswalking)
            playwalking();
          else
            playrunning();
        }
        else if ( bIsTurning)
        {
          PlayTurning();
        }
        else
          playwaiting(); //replicated crap
      }
        //  }
   // }
  //}
      else
      {
        if ( Acceleration != vect(0,0,0) ||bisturning)
          PlayCrawling();
        else
          PlayDuck();
      }
    }
  else
    //baseanim='playinair'; //for purpose of client-physics check?
    baseanim=0;
  }
  simulated function BeginState()
  {
    if (role>role_simulatedproxy){
      super.beginstate();
      return;
    }
    if ( Mesh == None )
      SetMesh();
    if ( !IsAnimating() )
      PlayWaiting();
  }
  
}

function xxServerSetReadyToPlay()
{
	if (zzUTPure.zzDMP == None)
		return;
//	Log("moo:"@DMP.bRequireReady@DMP.CountDown);
	if (zzUTPure.zzDMP.bTournament && zzUTPure.bWarmup && zzUTPure.zzDMP.bRequireReady && (zzUTPure.zzDMP.CountDown >= 10))
	{
		zzbForceUpdate = true;
		zzIgnoreUpdateUntil = 0;
		
		PlayerRestartState = 'VAPlayerWarmup';
		GotoState('VAPlayerWarmup');
		zzUTPure.zzDMP.ReStartPlayer(Self);
		zzUTPure.zzbWarmupPlayers = True;
	}

}

state VAPlayerWarmup extends PlayerWalking
{
	function BeginState()
	{
		local float NewJumpZ;
		
		NewJumpZ = Default.JumpZ * Level.Game.PlayerJumpZScaling();
		if (NewJumpZ > 0)
			JumpZ = NewJumpZ;
			
		zzbIsWarmingUp = true;
		
		GiveMeWeapons();
		Super.BeginState();
	}

	exec function SetProgressMessage( string S, int Index )
	{	// Bugly hack. But why not :/ It's only used during warmup anyway.
		// This also means that admins may not use say # >:|
		if (S == Class'DeathMatchPlus'.Default.ReadyMessage || S == Class'TeamGamePlus'.Default.TeamChangeMessage)
		{
			ClearProgressMessages();
			return;
		}
		Super.SetProgressMessage( S, Index );
	}
/*
	simulated function PreRender(Canvas zzC)
	{
		Global.PreRender(zzC);
		Super.SetProgressMessage( ">>>WARMUP<<<", 0 );
	}
*/

	function TakeDamage( int Damage, Pawn InstigatedBy, Vector HitLocation, 
							Vector momentum, name damageType)
	{
		//if (Self == InstigatedBy)
		//{
		//	Damage = 0;		// No self damage in warmup.
		//	momentum *= 2;		// And 2x momentum.
		//}
		Global.TakeDamage(Damage, InstigatedBy, HitLocation, Momentum, DamageType);
	}

}

function int xxID(){ //16-bit IDENTIFICATION TAG. (anti-leak security) add IP based encryption?
return 31645;
}
function PlayWaiting()    //contains many animations, as some vars used are not client-side.
{
  if ( bIsTyping )
  {
    PlayChatting();
    return;
  }

  if ( (IsInState('PlayerSwimming')) || (Physics == PHYS_Swimming) )       //a tiny check for eyeheight only
    BaseEyeHeight = 0.7 * Default.BaseEyeHeight;         //region/state is checked on client.
  else
    BaseEyeHeight = Default.BaseEyeHeight;
  ViewRotation.Pitch = ViewRotation.Pitch & 65535;
  If ( (ViewRotation.Pitch > RotationRate.Pitch)
    && (ViewRotation.Pitch < 65536 - RotationRate.Pitch) )
  {
    If (ViewRotation.Pitch < 32768)
    {
      if (role==role_authority)
        //baseanim='AimUp';
        baseanim=2;
      else
        MeshInfo.static.Playwaiting(self,1);
    }
    else
    {
      if (role==role_authority)
        //baseanim='AimDown';
        baseanim=3;
      else
        MeshInfo.static.Playwaiting(self,2);
    }
  }
  else if ( (Weapon != None) && Weapon.bPointing )  //client doesn't know much
  {
    if ( Weapon.bRapidFire && ((bFire != 0) || (bAltFire != 0)) )
    {
      if (role==role_authority)
        //baseanim='Playrapid';
        baseanim=4;
      else
        MeshInfo.static.Playwaiting(self,3);
    }
    else
    {
      if (role==role_authority)
        //baseanim='PlayWeapPoint';
        baseanim=5;
      else
        MeshInfo.static.Playwaiting(self,4);
    }
  }
  else
  {
    if (role==role_authority)
      //baseanim='PlayWaiting';
      baseanim=1;
    else
      meshinfo.static.Playwaiting(self,0);
  }
}

function PlayChatting()
{
  if (role==role_autonomousproxy)
    MeshInfo.static.PlayChatting(self);
  else
    //baseanim='playchatting';
    baseanim=14;
}
function ServerTaunt (name Sequence);

function xxServerTaunt(byte zzsequence)
{
  if (zzsequence<5)
	xxServerAnim(zzsequence+18);
}

exec function Taunt (name zzsequence)
{
  local byte zzseq;

  if ( Mesh == None )
    return;

  switch (zzsequence)
  {
    case 'Taunt1':
    zzseq = 0;
    break;
    case 'Thrust':
    zzseq = 1;
    break;
    case 'Victory1':
    zzseq = 2;
    break;
    case 'Wave':
    zzseq = 3;
    break;
    case 'Challenge':
    zzseq = 4;
    break;
  }
  xxServerTaunt(zzseq);
  MeshInfo.static.Taunt(self, zzsequence);
}

function ClientWeaponEvent(name EventType)  //s3 hack fix.....
{
  if (string(weapon.class)~="botpack.impacthammer"&&eventtype!='FireBlast'){
    log("Abnormal clientweaponeventtype:"@EventType);
    eventtype='FireBlast';
  }
  else if (string(weapon.class)~="botpack.translocator"&&eventtype!='TouchTarget'){
    log("Abnormal clientweaponeventtype:"@EventType);
    eventtype='TouchTarget';
  }
  super.ClientWeaponEvent(EventType);
}

function SendVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messagetype, byte messageID, name broadcasttype)
{
  super.sendvoicemessage(playerreplicationinfo,recipient,messagetype,messageID,broadcasttype);  //lame anti-cheat :P
}

function SetVoice (Class<ChallengeVoicePack> V)
{
  PlayerReplicationInfo.VoiceType = V;
  UpdateURL("Voice",string(V),True);
  ServerSetVoice(V);
  xxServerSetVPString(string(V));
}

function ServerSetVoice(class<ChallengeVoicePack> V)
{
  if (V!=none)
    PlayerReplicationInfo.VoiceType = V;
}

function xxServerSetVPString(string V){
  if (v!="")
    GetVAPRI(playerreplicationinfo).zzvoicestring=v;
}

exec function Help(string cmd){
//ClearProgressMessages();
if (cmd==""){
  Clientmessage("Welcome to Valhalla Avatar 1.0");
  Clientmessage("Commands: (type help [command name] for more info)");
 // Clientmessage("About: Credits");
//  Clientmessage("info: Information About Valhalla Avatar");
//  Clientmessage("PlayerInfo: Displays info about each player's model, skin, and voicepack.");
  Clientmessage("SetDefault (string): Set default mesh");
  Clientmessage("SetGestureTime (float): Set gesture time");
  Clientmessage("More info can be found by hitting ESC and viewing the ValAvatar menus.");
}
else if (cmd~="about"||cmd~="info"||cmd~="playerinfo")
  Clientmessage("Obsolete commands. Please use menus by hitting ESC");
//  Clientmessage("Self-Explainatory");
//else if (cmd~="PlayerInfo")
//  Clientmessage("This displays information on what model, skin, and voicepack each player in the game has intended to use.  Installed tells if you have that file installed and it is being used (if not, a default is).");
else if (cmd~="SetDefault"){
  ClientMessage("Specify a player class to be used if you do not have one another player is using installed");
  Clientmessage("Note that this will not work if the server has disabled 'AllowClientOverride'");
  Clientmessage("Ex: SetDefault Botpack.Tmale2");
}
else if (cmd~="SetGestureTime"){
  ClientMessage("Set the amount of time in seconds between player gestures.  Ignored at end of game.");
  Clientmessage("If you choose 0, then no gestures, other than your own, will occur");
  Clientmessage("Ex: SetGesture 2.12");
}
else
  Clientmessage(cmd$": Unknown command!");
}

exec function About ()
{
  ClientMessage("OBSOLETE! Please use menus.");
}

exec function Info ()
{
  ClientMessage("OBSOLETE! Please use menus.");
}

exec function SetDefault (string Cmd)
{
  if ( Cmd == "" )
    ClientMessage("Please specify a class");
  else if ( Class<PlayerPawn>(DynamicLoadObject(Cmd,Class'Class')) == None )
      ClientMessage("The class" @ Cmd @ "is invalid or not installed on this computer");
    else
	{
      Class'VASettings'.Default.DefaultPlayer = Cmd;
      Class'VASettings'.StaticSaveConfig();
      ClientMessage("Default model is now" @ Cmd);
    }
}

exec function SetGestureTime (float Cmd)
{
  Class'VASettings'.Default.gesturetime = Cmd;
  Class'VASettings'.StaticSaveConfig();
  if ( Cmd == 0 )
    ClientMessage("Gestures Disabled!");
  else
    ClientMessage("Gestures will play every" @ string(Cmd) @ "seconds.");
}

exec function PlayerInfo ()
{
  ClientMessage("OBSOLETE! Please use menus.");
}

function xxSetMeshClass (coerce string zzmesh, coerce string SkinName, coerce string FaceName)
{
  local Mutator zzM;

  if ( (Class'VASettings'.Default.MeshSkinAllowChange != 2) || (zzmesh == "") )
    return;

  for(zzm = Level.Game.BaseMutator; zzm != None ; zzm = zzm.NextMutator)
    if ( zzm.Class == Class'VAServer' )
       break;
  zzmesh = VAServer(zzM).xxclasscheck(zzmesh);
  MenuName = VAServer(zzM).MenuName;
  GetVAPRI(PlayerReplicationInfo).zzClassString = zzmesh;
  ServerChangeSkin(SkinName,FaceName,PlayerReplicationInfo.Team);
}

exec function TeamSay( string Msg )
{
  local string OutMsg;
  local string cmd;
  local int pos,i, zzi;
  local int ArmorAmount;
  local inventory inv;
  local TournamentWeapon Weap,tw;
  local TournamentPickup Item,Special,a;

  local int x;
  local int zone;
  local flagbase Red_FB, Blue_FB;
  local CTFFlag F,Red_F, Blue_F;
  local float dRed_b, dBlue_b, dRed_f, dBlue_f;


  if (PlayerReplicationInfo.Team==255)
  {
    super.TeamSay(Msg);
    return;
  }
  
  OutMsg = "";
  pos = InStr(Msg,"%");
  if (pos>-1)
  {
    for (i=0;i<100;i=1)
    {
      if (pos>0)
      {
        OutMsg = OutMsg$Left(Msg,pos);
        Msg = Mid(Msg,pos);
        pos = 0;
        }

      x = len(Msg);
      cmd = mid(Msg,pos,2);
      if (x-2 > 0)
        Msg = right(msg,x-2);
      else
        Msg = "";
     
      if (cmd~="%H")
      {
      OutMsg = OutMsg$Health$" Health";
      }
      else if (cmd~="%W")
      {
        OutMsg = OutMsg$Weapon.GetHumanName();
      }
      else if (cmd~="%A")
      {
        ArmorAmount = 0;
        for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )
        { 
          if (Inv.bIsAnArmor) 
          {
            if ( Inv.IsA('UT_Shieldbelt') )
              OutMsg = OutMsg$"PowerShield ("$Inv.Charge$") and ";
            else 
              ArmorAmount += Inv.Charge;
          }
        }
      
         OutMsg = OutMsg$ArmorAmount$" Armor";
      }
  else if (cmd~="%P"&&gamereplicationinfo.isa('CTFReplicationInfo'))
      {
        for (zzi=0;zzi<4;zzi++){
          f=CTFReplicationInfo(gamereplicationinfo).FlagList[zzi];
          if (f==none)
            break;
          if (F.homebase.team==0)
            Red_FB = F.homebase;
          else if (F.homebase.team==1)
            Blue_FB = F.homebase;
          if (F.Team==0)
            Red_F = F;
          else if (F.Team==1)
            Blue_F = F;
        }
        dRed_b = vSize(Location - Red_FB.Location);
        dBlue_b = vSize(Location - Blue_FB.Location);
        dRed_f = vSize(Location - Red_F.Position().Location);
        dBlue_f = vSize(Location - Blue_F.Position().Location);

        if (PlayerReplicationInfo.Team==0)
        {
          if (dRed_f<2048 && Red_F.Holder != None&&(Blue_f.holder==none||dRed_f<dBlue_f))
            zone = 0;
          else if (dBlue_f<2048 && Blue_F.Holder != None&&(Red_f.holder==none||dRed_f>dBlue_f))
            zone = 1;
          else if (dBlue_b<2049)
            zone = 2;
          else if (dRed_b<2048)
            zone = 3;
          else
            zone = 4;
        }
        else if (PlayerReplicationInfo.Team==1)
        {
          if (dBlue_f<2048 && Blue_f.Holder != None&&(Red_f.holder==none||dRed_f>=dBlue_f))
            zone = 0;
          else if (dRed_f<2048 && Red_f.Holder != None&&(Blue_f.holder==none||dRed_f<dBlue_f))
            zone = 1;
          else if (dRed_b<2048)
            zone = 2;
          else if (dBlue_b<2048)
            zone = 3;
          else
            zone = 4;
        }

        if ( (Blue_f.Holder == Self) ||
             (Red_f.Holder == Self) )
            zone = 5;

        switch (zone)
        {
          case 0: OutMsg = OutMsg$"Attacking Enemy Flag Carrier";break;
          case 1: OutMsg = OutMsg$"Supporting Our Flag Carrier";break;
          case 2: OutMsg = OutMsg$"Attacking";break;
          case 3: OutMsg = OutMsg$"Defending";break;
          case 4: OutMsg = OutMsg$"Floating";break;
          case 5: OutMsg = OutMsg$"Carrying Flag";break;
        }
      }
      else if (cmd=="%%")
        OutMsg = OutMsg$"%";
      else
      {
        OutMsg = OutMsg$cmd;
      }
      
      pos = InStr(Msg,"%");
  
      if (Pos==-1)
        break;
    }  
    if (len(msg)>0)
      OutMsg = OutMsg$Msg;
  }
  else
    OutMsg = Msg;

  super.TeamSay(OutMsg);
}
state PlayerWaiting
{
ignores SeePlayer, HearNoise, Bump, TakeDamage, Died, ZoneChange, FootZoneChange;

  function BeginState()
  {
    super.beginstate();
    drawtype=DT_none;
  }
  function EndState(){
    super.EndState();
    drawtype=DT_mesh;
  }
}

state PlayerSpectating
{
ignores SeePlayer, HearNoise, Bump, TakeDamage, Died, ZoneChange, FootZoneChange;

  function BeginState()
  {
    super.beginstate();
    drawtype=DT_none;
  }
  function EndState(){
    super.EndState();
    drawtype=DT_mesh;
  }  
}

state GameEnded  //anim no move
{
  ignores SeePlayer, HearNoise, KilledBy, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, TakeDamage, PainTimer, Died;

//these functions are not used under network!
  function ServerReStartGame();
  exec function Fire( optional float F );

  simulated function BeginState()    //rewrote force anim stopping client-side.
  {
    local Pawn P;

    if (role==role_simulatedproxy){   //force anim stopping!
      AnimRate = 0.0;
      SimAnim.Y = 0;
    }
    else
      super.beginstate(); //call parents
  }
}
defaultproperties
{
    lastgesturetime=-1000.00
    MeshInfo=Class'DPMSMeshInfo'
    CarcassType=Class'VACarcass'
    bAlwaysRelevant=True
	Mesh=Player
}