class NN_VACarcassSpawner extends Actor;

var PlayerPawn SSDTemp;

replication
{
  unreliable if ( ROLE == ROLE_Authority )
    ALClientSpawnCarcass;
}

function PostBeginPlay ()
{
  local NN_VACarcassSpawner CS;

  if ( Owner == None )
  {
    Destroy();
    return;
  }
  foreach Owner.ChildActors(Class'NN_VACarcassSpawner',CS)
  {
    if ( CS != self )
    {
      CS.Destroy();
    }
  }
}

function Tick (float F)
{
  if ( Owner == None )
  {
    Destroy();
    return;
  }
}

final simulated function ALClientSpawnCarcass (VAPlayer Other, Vector Vel, Vector Loc, Rotator Rot, byte zzPD)
{
  local Carcass carc;

  if ( (Level.NetMode != NM_Client) || (Other == None) || (PlayerPawn(Owner) == None) )
  {
    return;
  }
  if ( Class'NN_DemoRecStats'.Default.bServerSideDemo )
  {
    if ( Default.SSDTemp == None )
    {
      Default.SSDTemp = PlayerPawn(Owner);
    }
    if ( Default.SSDTemp != Owner )
    {
      return;
    }
  }
  if (  !(Class'NN_ClientSideDemoStats'.static.GetDemoOwner(self) != None) && (Class'NN_ClientSideDemoStats'.static.GetDemoOwner(self) == self) )
  {
    Other.Velocity = Vel;
    Other.SetLocation(Loc);
    Other.SetRotation(Rot);
  }
  carc = Spawn(Class'NN_VACarcass',Other,,Other.Location,Other.Rotation);
  if ( carc == None )
  {
    return;
  }
  carc.Initfor(Other);
  if ( PlayerPawn(Owner).Player != None )
  {
    carc.bPlayerCarcass = True;
  }
  if ( (Other == Owner) && (Owner.GetStateName() != 'GameEnded') && (Carcass(PlayerPawn(Owner).ViewTarget) == None) )
  {
    PlayerPawn(Owner).ViewTarget = carc;
  }
  if ( VACarcass(carc) != None )
  {
    VACarcass(carc).xxsetanim(zzPD);
    if (  !VACarcass(carc).zzinitialized )
    {
      VACarcass(carc).xxInit();
    }
  }
  return;
}

function ALClientSpawnGibbedCarcass (VAPlayer Other, Vector Vel, Vector Loc, Rotator Rot);

defaultproperties
{
     bHidden=True
}