class NN_VACarcass extends VACarcass;

simulated function xxsetanim (byte zzAnim)
{
  local VAGibber zzgib;

  zzdeathanim = zzAnim + 1;
  bJerking = zzAnim == 5;
  LastHit = Level.TimeSeconds;
  zzgib = Spawn(GibberClass,,,Location);
  zzgib.zzmycarc = self;
  zzgib.Init();
}

simulated function Tick (float Delta)
{
  if (  !zzinitialized && (PRI != None) )
  {
    xxInit();
  }
  if ( zzmyloc != vect(0.00,0.00,0.00) )
  {
    SetLocation(zzmyloc);
    zzmyloc = vect(0.00,0.00,0.00);
  }
}

simulated function AnimEnd ()
{
  local name newAnim;
  local bool checkjerk;
  local int zzi;

  if (  !bJerking )
  {
    checkjerk = AnimSequence == 'Dead9';
    if (  !checkjerk )
    {
      for(zzi = 0; zzi < 4; zzi++)
      {
        if ( AnimSequence == Jerks[zzi] )
        {
          checkjerk = True;
          break;
        } 
      }
    }
  }
  if (  !bJerking &&  !checkjerk )
  {
    if ( Physics == 0 )
    {
      LieStill();
    } else {
      if ( Region.Zone.bWaterZone )
      {
        bThumped = True;
        LieStill();
      }
    }
  } else {
    if ( checkjerk && (LastHit + Level.TimeSeconds - Oldlasthit < 0.25) && (FRand() > 0.02) )
    {
      Oldlasthit = LastHit;
      newAnim = Jerks[Rand(4)];
      if ( newAnim == AnimSequence )
      {
        if ( newAnim == Jerks[0] )
        {
          newAnim = Jerks[1];
        } else {
          newAnim = Jerks[0];
        }
      }
      TweenAnim(newAnim,0.151);
    } else {
      bJerking = False;
      if ( HasAnim('Dead9B') )
      {
        PlayAnim('Dead9B',1.12,0.1);
      }
    }
  }
}

simulated function ReduceCylinder ()
{
  local float OldHeight;
  local Vector OldLocation;

  bReducedHeight = True;
  SetCollision(bCollideActors,False,False);
  OldHeight = CollisionHeight;
  if ( ReducedHeightFactor < Default.ReducedHeightFactor )
  {
    SetCollisionSize(CollisionRadius,CollisionHeight * ReducedHeightFactor);
  } else {
    SetCollisionSize(CollisionRadius + 4,CollisionHeight * ReducedHeightFactor);
  }
  PrePivot = vect(0.00,0.00,1.00) * (OldHeight - CollisionHeight);
  OldLocation = Location;
  if (  !SetLocation(OldLocation - PrePivot) )
  {
    SetCollisionSize(CollisionRadius - 4,CollisionHeight);
    if (  !SetLocation(OldLocation - PrePivot) )
    {
      SetCollisionSize(CollisionRadius,OldHeight);
      SetCollision(False,False,False);
      PrePivot = vect(0.00,0.00,0.00);
      if (  !SetLocation(OldLocation) )
      {
        ChunkUp(200);
      }
    }
  }
  zzmyloc = Location;
  PrePivot = PrePivot + vect(0.00,0.00,3.00);
  Mass = Mass * 0.81;
  Buoyancy = Buoyancy * 0.81;
}

simulated function LieStill ()
{
  SimAnim.X = 10000.0 * AnimFrame;
  SimAnim.Y = 5000.0 * AnimRate;
  if (  !bThumped &&  !bDecorative )
  {
    LandThump();
  }
  if (  !bReducedHeight )
  {
    ReduceCylinder();
  }
}

defaultproperties
{
     GibberClass=Class'NN_VAGibber'
     LifeSpan=7.500000
     Mesh=None
}
