//================================================================================
// ALplayer.
//================================================================================

class ALplayer extends bbPlayer
  Config(User);

const PMP_CLASS = Class'PickupMessagePlus';

struct PickupMessageInfo
{
    var string Msg;
    var float EndOfTime;
    var float Lifetime;
    var int Count;
};

var float lastgesturetime;
var byte zzNextAnim;
var byte BaseAnim;
var bool bAnimOn;
var name myState;
var Class<DPMSMeshInfo> MeshInfo;
var Class<DPMSSoundInfo> SoundInfo;
var byte zzPendingDeath;
var name LastAnim;
var float LastAFrame;
var Teleporter zzLastTP;
var Class<UWindowWindow> PlayerSetupWindowClass;
var bool bMenuClassSetup;
var bool bmsg;
var bool zzNoOverride;
var bool Initialized;
var byte zzNextSound;
var bool bFirstTick;
var Actor SPAPW;
var bool bConCheck;
var bool bCheckNNClass;
var bool bNNClass;
var bool bNNUU;
var private PickupMessageInfo PMI[12];
var PickupMessageInfo EmptyPMI;
var private int PMINum;
var bool bDebug;
var int FrameCount;
var float TotalFrame;
var int SMCount;
var int CACount;
var float SSDelta;
var float CSDelta;
var float TweakF;
var bool bLoadClientTickConfig;
var ClientTickConfig CTConfig;
var bool bForceClientTickTweak;
var float ClientTweakScale;
var bool bPrevHidden;
var string LastTossWeapon;
var int AdminLoginTries;
var float xxLastView;
var float xxLastView2;
var VATweakBlockConf TBConf;
var float CurrentDelta;
var bool bCanSprint;
var float SprintStartTime;
var float SprintAcceleration;
var float SprintMaxSpeed;
var bool bSprint;
var bool bSprintVelResetNextFrame;
var bool bSprintJustJump;
var float SprintTime;
var float SprintGroundSpeed;

replication
{
  unreliable if ( Role < ROLE_Authority )
    xxSetMeshClass,xxServerSetVPString,xxServerTaunt;
  unreliable if ( Role < ROLE_Authority )
    xxNNPlayServerAnim;
  reliable if ( Role == ROLE_Authority )
    ClientMotionReset;
  reliable if ( Role < ROLE_Authority )
    ServerSetTickConf;
  reliable if ( (RemoteRole == ROLE_SimulatedProxy) || bDemoRecording &&  !bClientDemoRecording )
    zzNextAnim,BaseAnim,myState,zzNextSound;
  reliable if ( bNetOwner && (Role == ROLE_Authority) &&  !bDemoRecording )
    zzNoOverride;
  reliable if ( bNetInitial && (Role == ROLE_Authority) )
    SSDelta;
  reliable if ( Role < ROLE_Authority )
    CSDelta;
  reliable if ( Role == ROLE_Authority )
    bCanSprint,SprintStartTime,SprintAcceleration,SprintMaxSpeed;
}

function TakeDamage (int Damage, Pawn instigatedBy, Vector HitLocation, Vector Momentum, name DamageType)
{
  SprintStop();
  Super.TakeDamage(Damage,instigatedBy,HitLocation,Momentum,DamageType);
}

function TossWeapon ()
{
  if ( (Weapon != None) && (Health > 0) )
  {
    LastTossWeapon = string(Weapon.Class);
  }
  Super.TossWeapon();
}

event ClientMessage (coerce string S, optional name Type, optional bool bBeep)
{
  if ( Type == 'Pickup' )
  {
    Class'MyPickupMessagePlus'.Default.NewMsg = S;
    ReceiveLocalizedMessage(Class'MyPickupMessagePlus',0,None,None,None);
    return;
  }
  Super.ClientMessage(S,Type,bBeep);
}

event Possess ()
{
  bNNUU = bool(GetItemName("IsNewNetUU"));
  Super.Possess();
  if ( Role == ROLE_Authority )
  {
    bCanSprint = Class'VASettings'.Default.bCanSprint;
    SprintStartTime = Class'VASettings'.Default.SprintStartTime;
    SprintAcceleration = Class'VASettings'.Default.SprintAcceleration;
    SprintMaxSpeed = Class'VASettings'.Default.SprintMaxSpeed;
  }
}

static final simulated function dlog (optional coerce string S)
{
  if (  !Class'ALplayer'.Default.bDebug )
  {
    return;
  }
  Log(S,'MyDEBUG');
}

function ClientReStart ()
{
  local int i;

  for(i = 0; i < 12; i++)
  {
    PMI[i] = EmptyPMI;
  }
  PMINum = -1;
  Super.ClientReStart();
}

static final simulated function ALPRI GetALPRI (Actor A)
{
  return Class'ALPRI'.static.GetALPRI(A);
}

simulated function string GetItemName (string S)
{
  local string temp;

  if ( S ~= "PlayJumpSound" )
  {
    PlayJumpSound();
    return "";
  }
  if ( S ~= "GET LastTossWeapon" )
  {
    temp = LastTossWeapon;
    LastTossWeapon = "";
    return temp;
  }
  return Super.GetItemName(S);
}

final simulated function PlayJumpSound ()
{
  if (  !bUpdating )
  {
    if ( (ROLE == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
      SoundInfo.static.DoJump(self);
    if ( Role != ROLE_AutonomousProxy )
      xxServerSound(3);
  }
}

final simulated exec function ToggleClientTickConfig ()
{
  if ( (Level.NetMode == NM_DedicatedServer) || (CTConfig == None) )
    return;
  CTConfig.bForceClientTickTweak =  !CTConfig.bForceClientTickTweak;
  CTConfig.SaveConfig();
  ServerSetTickConf(CTConfig.bForceClientTickTweak,CTConfig.ClientTweakScale);
}

final simulated exec function SetClientTweakScale (float Scale)
{
  if ( (Level.NetMode == NM_DedicatedServer) || (CTConfig == None) )
    return;
  CTConfig.ClientTweakScale = Scale;
  CTConfig.SaveConfig();
  ServerSetTickConf(CTConfig.bForceClientTickTweak,CTConfig.ClientTweakScale);
}

final function ServerSetTickConf (bool bEnable, float NewScale)
{
  if ( bNNClass )
    return;
  if ( bEnable != bForceClientTickTweak )
    ClientMessage("bForceClientTickTweak=" $ string(bEnable));
  if ( ClientTweakScale != NewScale )
  {
    ClientMessage("ClientTweakScale=" $ string(NewScale));
  }
  bForceClientTickTweak = bEnable;
  ClientTweakScale = NewScale;
}

function VATweakBlockConf ReturnTBConf ()
{
  if ( Default.TBConf != None )
    return Default.TBConf;
    
  Default.TBConf = new (Class'VATweakBlockConf','VATweakBlockConf') Class'VATweakBlockConf';
  Default.TBConf.SaveConfig();
  return Default.TBConf;
}

function DoViewClass (Class<Actor> aClass, optional bool bQuiet)
{
  local Actor Other, first;
  local bool bFound;

  if ( (Level.Game != None) &&  !Level.Game.bCanViewOthers )
  {
    return;
  }
  first = None;
  foreach AllActors(aClass,Other)
  {
    if ( (first == None) && (Other != self) && (bAdmin && (Level.Game == None) || Level.Game.CanSpectate(self,Other)) )
    {
      first = Other;
      bFound = True;
    }
    if ( Other == ViewTarget )
    {
      first = None;
    }
  }
  if ( first != None )
  {
    if (  !bQuiet )
    {
      if ( first.IsA('Pawn') && Pawn(first).bIsPlayer && (Pawn(first).PlayerReplicationInfo.PlayerName != "") )
      {
        ClientMessage(ViewingFrom @ Pawn(first).PlayerReplicationInfo.PlayerName,'Event',True);
      } else {
        ClientMessage(ViewingFrom @ string(first),'Event',True);
      }
    }
    ViewTarget = first;
  } else {
    if (  !bQuiet )
    {
      if ( bFound )
      {
        ClientMessage(ViewingFrom @ OwnCamera,'Event',True);
      } else {
        ClientMessage(FailedView,'Event',True);
      }
    }
    ViewTarget = None;
  }
  bBehindView = ViewTarget != None;
  if ( bBehindView )
  {
    ViewTarget.BecomeViewTarget();
  }
}

exec function BehindView (bool B)
{
  if ( IsA('bbPlayer') )
  {
    Super.BehindView(B);
    return;
  }
  if ( ReturnTBConf().bAllowBehindView )
  {
    bBehindView = B;
  } else {
    if ( (ViewTarget != None) && (ViewTarget != self) )
    {
      bBehindView = B;
    } else {
      bBehindView = False;
    }
  }
}

exec function ViewClass (Class<Actor> aClass, optional bool bQuiet)
{
  if ( IsA('bbPlayer') )
  {
    Super.ViewClass(aClass,bQuiet);
    return;
  }
  if ( xxLastView2 != Level.TimeSeconds )
  {
    DoViewClass(aClass,bQuiet);
    xxLastView2 = Level.TimeSeconds;
  }
}

exec function ViewPlayer (string S)
{
  if ( IsA('bbPlayer') )
  {
    Super.ViewPlayer(S);
    return;
  }
  if ( xxLastView != Level.TimeSeconds )
  {
    Super.ViewPlayer(S);
    xxLastView = Level.TimeSeconds;
  }
}

exec function ViewPlayerNum (optional int Num)
{
  if ( IsA('bbPlayer') )
  {
    Super.ViewPlayerNum(Num);
    return;
  }
  if ( xxLastView != Level.TimeSeconds )
  {
    DoViewPlayerNum(Num);
    xxLastView = Level.TimeSeconds;
  }
}

function DoViewPlayerNum (int Num)
{
  local Pawn P;

  if (  !PlayerReplicationInfo.bIsSpectator &&  !Level.Game.bTeamGame )
  {
    return;
  }
  if ( Num >= 0 )
  {
    P = Pawn(ViewTarget);
    if ( (P != None) && P.bIsPlayer && (P.PlayerReplicationInfo.PlayerID == Num) )
    {
      ViewTarget = None;
      bBehindView = False;
      return;
    }
    for(P = Level.PawnList; P != None ; P = P.nextPawn)
    {
      if ( (P.PlayerReplicationInfo != None) && (P.PlayerReplicationInfo.Team == PlayerReplicationInfo.Team) &&  !P.PlayerReplicationInfo.bIsSpectator && (P.PlayerReplicationInfo.PlayerID == Num) )
      {
        if ( P != self )
        {
          ViewTarget = P;
          bBehindView = True;
        }
        return;
      }
    }
    return;
  }
  if ( ROLE == ROLE_Authority )
  {
    DoViewClass(Class'Pawn',True);
    while( (ViewTarget != None) && ( !Pawn(ViewTarget).bIsPlayer || Pawn(ViewTarget).PlayerReplicationInfo.bIsSpectator) )
    {
      DoViewClass(Class'Pawn',True);
    }
    
    if ( ViewTarget != None )
    {
      ClientMessage(ViewingFrom @ Pawn(ViewTarget).PlayerReplicationInfo.PlayerName,'Event',True);
    } else {
      ClientMessage(ViewingFrom @ OwnCamera,'Event',True);
    }
  }
}

exec function AdminLogin (string Password)
{
  local string S;

  if ( IsA('bbPlayer') )
  {
    Super.AdminLogin(Password);
    return;
  }
  AdminLoginTries++;
  Level.Game.AdminLogin(self,Password);
  if ( bAdmin )
  {
    AdminLoginTries = 0;
  } else {
    if ( AdminLoginTries == 5 )
    {
      S = GetPlayerNetworkAddress();
      S = Left(S,InStr(S,":"));
      Log("");
      Log(PlayerReplicationInfo.PlayerName @ "Failed Adminlogin 5 times!");
      Log("IP:" $ S);
      Destroy();
    }
  }
}

function float ReturnNewDelta ()
{
  local float ClientFrameRate;
  local float ServerFrameRate;
  local float Scale;

  if ( (CSDelta == 0) || (SSDelta == 0) )
  {
    return 0.0;
  }
  if ( bForceClientTickTweak )
  {
    return ClientTweakScale;
  }
  ClientFrameRate = 1.0 / CSDelta;
  ServerFrameRate = 1.0 / SSDelta;
  if ( ClientFrameRate <= ServerFrameRate )
  {
    return 1.0;
  }
  Scale = ClientFrameRate / ServerFrameRate;
  Scale *= 2;
  Scale = FMin(3.3,Scale);
  return Scale;
}

function ServerMove (float TimeStamp, Vector InAccel, Vector ClientLoc, bool NewbRun, bool NewbDuck, bool NewbJumpStatus, bool bFired, bool bAltFired, bool bForceFire, bool bForceAltFire, EDodgeDir DodgeMove, byte ClientRoll, int View, optional byte OldTimeDelta, optional int OldAccel)
{
  SMCount++;
  Super.ServerMove(TimeStamp,InAccel,ClientLoc,NewbRun,NewbDuck,NewbJumpStatus,bFired,bAltFired,bForceFire,bForceAltFire,DodgeMove,ClientRoll,View,OldTimeDelta,OldAccel);
  return;
}

function ClientAdjustPosition (float TimeStamp, name NewState, EPhysics newPhysics, float NewLocX, float NewLocY, float NewLocZ, float NewVelX, float NewVelY, float NewVelZ, Actor NewBase)
{
  local float Scale;

  Scale = ReturnNewDelta();
  if ( Scale > 0 )
  {
    TweakF += 1 / Scale;
    if ( TweakF >= 1 )
    {
      TweakF -= 1;
    } else {
      return;
    }
  }
  CACount++;
  Super.ClientAdjustPosition(TimeStamp,NewState,newPhysics,NewLocX,NewLocY,NewLocZ,NewVelX,NewVelY,NewVelZ,NewBase);
}

exec function GetWeapon (Class<Weapon> NewWeaponClass)
{
  local Inventory Inv;

  if ( IsA('bbPlayer') )
  {
    Super.GetWeapon(NewWeaponClass);
    return;
  }
  if ( (Inventory == None) || (NewWeaponClass == None)
		|| ((Weapon != None) && (Weapon.Class == NewWeaponClass)) )
		return;

	for ( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )
		if ( Inv.Class == NewWeaponClass )
		{
			PendingWeapon = Weapon(Inv);
			if ( (PendingWeapon.AmmoType != None) && (PendingWeapon.AmmoType.AmmoAmount <= 0) )
			{
				Pawn(Owner).ClientMessage( PendingWeapon.ItemName$PendingWeapon.MessageNoAmmo );
				PendingWeapon = None;
				return;
			}
			Weapon.PutDown();
			return;
		}
}

event PostBeginPlay ()
{
  Super.PostBeginPlay();
  if ( (Role == ROLE_Authority) && (Level.NetMode != NM_Standalone) )
  {
    SSDelta = int(ConsoleCommand("get IpDrv.TcpNetDriver NetServerMaxTickRate"));
    SSDelta = 1.0 / SSDelta;
  }
  if ( GetPropertyText("bNewNet") != "" )
  {
    bNNClass = True;
  }
}

simulated function ClientMotionReset (Pawn Other)
{
  if ( Other == None )
  {
    return;
  }
  Other.AnimEnd();
}

function SpawnGibbedCarcass ()
{
  local NN_ALcarcassSpawner CS;

  if (  !bNNClass )
  {
    Super.SpawnGibbedCarcass();
    return;
  }
  foreach AllActors(Class'NN_ALcarcassSpawner',CS)
  {
    CS.ALClientSpawnGibbedCarcass(self,Velocity,Location,Rotation);
  }
}

event bool EncroachingOn (Actor Other)
{
  if ( (GameReplicationInfo.bTeamGame || GameReplicationInfo.IsA('RAGameReplicationInfo')) && Other.bIsPawn && (Pawn(Other).PlayerReplicationInfo != None) && (Pawn(Other).PlayerReplicationInfo.Team == PlayerReplicationInfo.Team) )
  {
    if ( (Role == ROLE_Authority) && Level.Game.IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).bStartMatch )
    {
      return Super.EncroachingOn(Other);
    } else {
      return True;
    }
  }
  return Super.EncroachingOn(Other);
}

event PlayerTick (float Time)
{
  local Rotator Rot;

  if ( IsA('bbPlayer') &&  !bNNUU )
  {
    Rot = ViewRotation;
  }
  Super.PlayerTick(Time);
  if ( IsA('bbPlayer') &&  !bNNUU )
  {
    ViewRotation = Rot;
  }
}

event Trigger (Actor Other, Pawn EventInstigator)
{
  if ( IsA('bbPlayer') )
  {
    Super.Trigger(Other,EventInstigator);
    return;
  }
  Super(Actor).Trigger(Other,EventInstigator);
}

function xxServerSound (byte zzid)
{
  local byte zzCurTime;

  zzCurTime = zzNextSound >> 5;
  if (zzCurTime == 7)
    zzCurTime = -1;
  zzNextSound = zzid;
  zzNextSound += zzCurTime + 1 << 5;
}

function xxServerAnim (byte zzid)
{
  local byte zzCurTime;

  zzCurTime = zzNextAnim >> 5 & 3;
  if (zzCurTime == 3)
    zzCurTime=-1;
  zzNextAnim = zzid;
  zzNextAnim += zzCurTime + 1 << 5;
}

simulated function xxSetSounds ()
{
  zzNextSound = zzNextSound & 31;
  switch (zzNextSound)
  {
    case 1:
    SoundInfo.static.Gasp(self);
    break;
    case 2:
    SoundInfo.static.breathagain(self);
    break;
    case 3:
    SoundInfo.static.DoJump(self);
    break;
    case 4:
    SoundInfo.static.PlayDyingSound(self);
    break;
    case 5:
    SoundInfo.static.FootZoneChange(self);
    break;
    case 6:
    SoundInfo.static.PlayerLanded(self);
    break;
    case 7:
    SoundInfo.static.drown(self);
    break;
    case 8:
    SoundInfo.static.UWHit(self);
    break;
    case 9:
    SoundInfo.static.Hit1(self);
    break;
    case 10:
    SoundInfo.static.Hit23(self);
    break;
    case 11:
    SoundInfo.static.Hit4(self);
    break;
    case 12:
    SoundInfo.static.DodgeSound(self);
    break;
  }
  zzNextSound = 0;
}

exec function ChangeMyTeam (int N)
{
  ChangeTeam(N);
}

final simulated function class<DPMSMeshInfo> xxGetMeshInfo()
{
  local Class<PlayerPawn> zzMyClass;

  if ( PlayerReplicationInfo == None )
    return Class'DPMSMeshInfo';

  if (left(mesh,14)~="SkeletalChars.")
    return class'AMSMeshInfo';
  
  if (string(mesh)~="unreali.sktrooper")
    return class'skaarjplayermeshinfo';

  zzMyClass = GetALPRI(PlayerReplicationInfo).zzMyClass;
  
   if (classischildof(zzmyclass,class'Male'))
  {
      return class'MaleMeshInfo';
  }
   if (classischildof(zzmyclass,class'Female'))
  {
      return class'HumanMeshInfo';
  }
  if (class<tournamentplayer>(zzmyclass).default.FixedSkin==213)
    return class'AMSMeshInfo';
  
  if (string(mesh)~="visor.visor")
    return class'VisorMeshInfo';
  
  if (string(mesh)~="crash.crash")
    return class'CrashMeshInfo';
  
  if (string(mesh)~="EpicCustomModels.TCowMesh")
    return class'CowMeshInfo';
  
  if (string(mesh)~="EpicCustomModels.tnalimesh")
    return class'NaliMeshInfo';
  
  if (string(mesh)~="EpicCustomModels.TSkM")
    return class'TSkaarjMeshInfo';
  
  if (hasanim('Duckuplgfr'))
    return class'HLMeshInfo';

   if (zzmyclass.default.CarcassType==Class'botpack.TBossCarcass')
    return class'TBossMeshInfo';

   if (classischildof(zzmyclass,class'TournamentMale'))
  {
      return class'TournamentMaleMeshInfo';
  }
   if (classischildof(zzmyclass,class'TournamentFemale'))
  {
      return class'TournamentFemaleMeshInfo';
  }
  if(zzMyClass.default.bisfemale)
    return class'TournamentFemaleMeshInfo';
	else
    return class'TournamentMaleMeshInfo';
}

event UpdateEyeHeight (float DeltaTime)
{
  Super.UpdateEyeHeight(DeltaTime);
  Tick(DeltaTime);
}

simulated event Init ()
{
  local int i;

  Initialized = True;
  zzNextSound = 0;
  if ( PlayerReplicationInfo != None )
  {
    if ( PlayerReplicationInfo.Owner == None )
    {
      PlayerReplicationInfo.SetOwner(self);
    }
    bIsFemale = PlayerReplicationInfo.bIsFemale;
    SkelAnim = None;
    Mesh = static.GetALPRI(PlayerReplicationInfo).zzMyClass.default.Mesh;
    for(i = 0; i < 8; i++)
    {
      MultiSkins[i] = PlayerReplicationInfo.MultiSkins[i];
      if ( MultiSkins[i] != None )
      {
        MultiSkins[i].LODSet = LODSET_Skin;
      }
    }
    Skin = PlayerReplicationInfo.Skin;
    if ( Skin != None )
    {
      Skin.LODSet = LODSET_Skin;
    }
    DrawScale = PlayerReplicationInfo.DrawScale;
    PrePivot = PlayerReplicationInfo.PrePivot;
    if(ClassIsChildOf(GetALPRI(PlayerReplicationInfo).zzMyClass, class'TournamentPlayer'))
    {
      StatusDoll = class<TournamentPlayer>(static.GetALPRI(PlayerReplicationInfo).zzMyClass).default.StatusDoll;
      StatusBelt = class<TournamentPlayer>(static.GetALPRI(PlayerReplicationInfo).zzMyClass).default.StatusBelt;
    } else {
      if(static.GetALPRI(PlayerReplicationInfo).zzMyClass.default.bIsFemale)
      {
        StatusDoll = Texture'Woman';
        StatusBelt = Texture'WomanBelt';
      }
    }
  }
}

simulated final function bool TraceGround ()
{
  local Actor A;
  local Vector HL, HN, TE, TS, ex;

  ex.X = CollisionRadius;
  ex.Y = CollisionRadius;
  ex.Z = 1.0;
  TS = Location + vect(0.00,0.00,-1.00) * Default.CollisionHeight;
  TE = TS + vect(0.00,0.00,-4.00);
  A = Trace(HL,HN,TE,TS,False,ex);
  if ( A != None )
  {
    return True;
  }
  A = Trace(HL,HN,TE,TS,True,ex);
  if ( A != None )
  {
    return True;
  }
  return False;
}

simulated final simulated function SprintStop ()
{
  if ( GroundSpeed != Default.GroundSpeed )
  {
    GroundSpeed = Default.GroundSpeed;
  }
  bSprint = False;
  SprintTime = 0.0;
  SprintGroundSpeed = 0.0;
}

simulated final simulated function SprintVelReset ()
{
  local float PrevZ;
  local Vector V;

  PrevZ = Velocity.Z;
  V = Velocity;
  V.Z = 0.0;
  if ( VSize(V) > Default.GroundSpeed )
  {
    Velocity = Normal(Velocity) * Default.GroundSpeed;
    Velocity.Z = FMin(PrevZ,JumpZ);
  }
}

simulated final simulated function SprintCheck (float Delta)
{
  local Vector X;
  local Vector Y;
  local Vector Z;
  local Rotator Rot;
  local float movef;
  local float MaxGroundSpeed;
  local bool bAddSpeed;

  Rot = ViewRotation;
  Rot.Yaw = ViewRotation.Yaw;
  GetAxes(Rot,X,Y,Z);
  movef = VSize(X - Normal(Acceleration));
  if ( bSprint )
  {
    if ( (movef > 1) || (VSize(Acceleration) == 0) || (Health <= 0) )
    {
      SprintStop();
      return;
    }
  }
  if ( movef <= 1 )
  {
    bSprint = True;
  }
  if (  !bSprint )
  {
    return;
  }
  if ( (Physics != PHYS_Falling) && (Physics != PHYS_None) && (Physics != PHYS_Flying) )
  {
    SprintTime += Delta;
  } else {
    if ( GroundSpeed != Default.GroundSpeed )
    {
      GroundSpeed = Default.GroundSpeed;
    }
    SprintGroundSpeed = GroundSpeed;
    return;
  }
  if ( SprintTime >= SprintStartTime )
  {
    SprintGroundSpeed = VSize(Velocity);
    if ( SprintGroundSpeed < Default.GroundSpeed )
    {
      SprintGroundSpeed = Default.GroundSpeed;
    }
    SprintGroundSpeed += SprintAcceleration * Delta;
    GroundSpeed = FClamp(SprintGroundSpeed,Default.GroundSpeed,SprintMaxSpeed);
    SprintGroundSpeed = GroundSpeed;
  }
}

event BaseChange ()
{
  local float PrevZ;

  Super.BaseChange();
  if (  !bSprint || bSprintJustJump )
  {
    return;
  }
  if ( Base == None )
  {
    if ( (Level.NetMode == NM_Client) && (Physics == PHYS_Walking) )
    {
      return;
    }
    bSprintVelResetNextFrame = True;
    SprintVelReset();
  }
}

simulated function Tick (float Delta)
{
  local string S;

  Super.Tick(Delta);
  if ( bCanSprint )
  {
    bSprintJustJump = False;
    SprintCheck(Delta);
    if ( bSprintVelResetNextFrame )
    {
      bSprintVelResetNextFrame = False;
      SprintVelReset();
    }
  }
  CurrentDelta = Delta;
  if ( (Level.NetMode == NM_Client) && (Player != None) && (Player.Actor != None) &&  !bNNClass )
  {
    if ( (Physics == PHYS_Walking) && (DodgeDir == DODGE_Active) )
    {
      DodgeDir = DODGE_None;
    }
    TotalFrame += Delta;
    FrameCount++;
    if ( TotalFrame >= 1 )
    {
      CSDelta = 1.0 / FrameCount;
      TotalFrame = 0.0;
      FrameCount = 0;
      CACount = 0;
    }
  }
  if ( (Role == ROLE_Authority) && (Level.NetMode != NM_Standalone) )
  {
    TotalFrame += Delta;
    FrameCount++;
    if ( TotalFrame >= 1 )
    {
      TotalFrame = 0.0;
      FrameCount = 0;
      SMCount = 0;
    }
  }
  if ( (ROLE == ROLE_Authority) &&  !bFirstTick )
  {
    bFirstTick = True;
    foreach ChildActors(Class'Actor',SPAPW)
    {
      if ( Mid(string(SPAPW.Class),InStr(string(SPAPW.Class),".") + 1) ~= "SPAPlayerWatcher" )
        break;
    }
  }
 
  if ( ROLE == ROLE_Authority )
  {
    myState = GetStateName();
    if ( Level.NetMode != NM_Standalone )
    {
      return;
    }
  }
  if ( (ROLE == ROLE_AutonomousProxy) && (IsInState('PlayerWaiting') || IsInState('PlayerSpectating') || IsInState('PlayerShip')) )
    return;
    
  if ( (myState == 'PlayerWaiting') || (myState == 'PlayerSpectating') || (myState == 'PlayerShip') )
  {
    Mesh = None;
    return;
  }

  if (  !Initialized )
  {
    if ( (GetALPRI(PlayerReplicationInfo) != None) && (GetALPRI(PlayerReplicationInfo).zzMyClass != None) && GetALPRI(PlayerReplicationInfo).bxxsetclass )
      Init();
    else
      return;
  }
  if ( SoundInfo == None )
  {
    if ( ClassIsChildOf(GetALPRI(PlayerReplicationInfo).zzMyClass,Class'UnrealIPlayer') )
      SoundInfo = Class'UnrealIPlayerSoundInfo';
    else
      SoundInfo = Class'TournamentPlayerSoundInfo';    
  }
  
  if ( MeshInfo == Class'DPMSMeshInfo' )
    MeshInfo = xxGetMeshInfo();
    
  if ( (Role != ROLE_SimulatedProxy) && (Level.NetMode != NM_Standalone) || (Delta == 0) )
    return;
    
  if ( zzNextSound != 0 )
    xxSetSounds();
    
  if ( (myState != 'None') && (myState != GetStateName()) )
    GotoState(myState);
  else
    if ( (myState == 'None') &&  !IsInState('PlayerWalking') )
      GotoState('PlayerWalking');
      
  if ( MeshInfo != None )
    MeshInfo.static.xxUpdateAnims(self);
    
  if ( bAnimFinished || bAnimLoop && (LastAnim == AnimSequence) && ((AnimFrame == AnimLast) || (AnimFrame < LastAFrame)) )
    AnimEnd();
    
  LastAFrame = AnimFrame;
  LastAnim = AnimSequence;
}

simulated event RenderOverlays (Canvas Canvas)
{
  Super.RenderOverlays(Canvas);
}

event PostRender (Canvas Canvas)
{
  local Object ini;

  if ( (Level.NetMode != NM_DedicatedServer) &&  !bLoadClientTickConfig )
  {
    bLoadClientTickConfig = True;
    ini = new(none,'ClientTickConfig') class'Object';
    CTConfig = new (ini, 'ClientTickConfig') class'ClientTickConfig';
    CTConfig.SaveConfig();
    if ( CTConfig.bForceClientTickTweak )
    {
      ServerSetTickConf(True,CTConfig.ClientTweakScale);
    }
    //Class'ALplayer'.Default.bDebug = CTConfig.bDebug;
  }
  Super.PostRender(Canvas);
/*   if ( (PMINum != -1) && (PMI[PMINum].Count > 1) && (ChallengeHUD(myHUD) != None) )
  {
    DrawPickupCount(Canvas);
  } */
}
/* 
final simulated function DrawPickupCount (Canvas C)
{
  local float XL;
  local float YL;
  local string Str;
  local ChallengeHUD H;
  local float FadeValue;
  local float XPos;
  local float YPos;

  H = ChallengeHUD(myHUD);
  if ( bShowScores || H.bShowInfo )
  {
    return;
  }
  if ( PMI[PMINum].EndOfTime + H.TimerCounter < Level.TimeSeconds )
  {
    PMINum = -1;
    return;
  }
  Str = string(PMI[PMINum].Count);
  Str = " x" @ Str;
  C.Font = H.MyFonts.GetBigFont(C.ClipX);
  if ( Level.bHighDetailMode )
  {
    FadeValue = PMI[PMINum].EndOfTime - Level.TimeSeconds;
    C.Style = 3;
    C.DrawColor = H.WhiteColor * FadeValue / PMI[PMINum].Lifetime;
    if ( FadeValue <= 0 )
    {
      return;
    }
  } else {
    C.Style = 1;
    C.DrawColor = H.WhiteColor;
  }
  C.StrLen(PMI[PMINum].Msg,XL,YL);
  XPos = 0.5 * (C.ClipX - XL);
  XPos += XL;
  YPos = Class'PickupMessagePlus'.GetOffset(0,YL,C.ClipY);
  C.SetPos(XPos,YPos);
  C.DrawText(Str,False);
}
 */
event PreRender (Canvas Canvas)
{
  local ENetRole R;
  local Console C;

  if ( bConCheck )
  {
    R = Role;
  }
  Super.PreRender(Canvas);

  bConCheck = True;
  if (  !bMenuClassSetup )
  {
    InitMenu();
  }
  if (  !bmsg && (myHUD != None) )
  {
    ClientMessage("This server is running Valhalla Avatar 1.0, Type 'help' for more information or hit ESC and view the ValAvatar menus!",'DeathMessage',true);
    bmsg = True;
  }
}

function InitMenu ()
{
  local WindowConsole PlayerConsole;
  local UMenuMenuBar MenuBar;
  local UWindowMenuBarItem aMenu;
  local Class<UWindowWindow> OldClass;

  if ( Player != None )
  {
    PlayerConsole = WindowConsole(Player.Console);
    
    if ( (PlayerConsole == None) ||  !PlayerConsole.bCreatedRoot )
      return;
      
    MenuBar = UMenuRootWindow(PlayerConsole.Root).MenuBar;
    if ( MenuBar == None )
      return;
      
    if ( UMenuOptionsMenu(MenuBar.OptionsItem.Menu).PlayerWindowClass != Class'DPMSPlayerWindow' )
    {
      OldClass = UMenuOptionsMenu(MenuBar.OptionsItem.Menu).PlayerWindowClass;
      UMenuOptionsMenu(MenuBar.OptionsItem.Menu).PlayerWindowClass = Class'DPMSPlayerWindow';
    }
    
    for( aMenu = UWindowMenuBarItem(MenuBar.Items.Next); aMenu != None; aMenu = UWindowMenuBarItem(aMenu.Next) ) 
    {
      if ( aMenu.Caption == "&ValAvatar" )
        return;
    }    
    aMenu = MenuBar.AddItem("&ValAvatar");
    VAMenu(aMenu.CreateMenu(Class'VAMenu')).OldClass = OldClass;
    bMenuClassSetup = True;
  }
}

static function SetMultiSkin (Actor SkinActor, string SkinName, string FaceName, byte TeamNum);

static function GetMultiSkin (Actor SkinActor, out string SkinName, out string FaceName)
{
  if ( SkinActor.Class != Class'ALplayer' )
    return;
  SkinName = GetALPRI(Pawn(SkinActor).PlayerReplicationInfo).zzskinstring;
  if ( GetALPRI(Pawn(SkinActor).PlayerReplicationInfo).zzfacestring != "" )
  {
    FaceName = GetALPRI(Pawn(SkinActor).PlayerReplicationInfo).zzfacestring;
  }
}

simulated function SetMesh ()
{
  SkelAnim = None;
  if ( (ROLE == ROLE_Authority) && (Level.NetMode != NM_Standalone) || (PlayerReplicationInfo == None) && (Mesh == None) )
    Mesh=default.Mesh;
  else
    Mesh=PlayerReplicationInfo.Mesh;
}

function ServerChangeSkin (coerce string SkinName, coerce string FaceName, byte TeamNum)
{
  if ( Class'VASettings'.Default.MeshSkinAllowChange > 0 )
  {
    GetALPRI(PlayerReplicationInfo).zzskinstring = SkinName;
    GetALPRI(PlayerReplicationInfo).zzfacestring = FaceName;
  }
}

event FootZoneChange(ZoneInfo newFootZone)
{
  local actor HitActor;
  local vector HitNormal, HitLocation;
  local float splashSize;
  local actor splash;
  
  if (Level.NetMode == NM_Client)
  {
    if ( Level.TimeSeconds - SplashTime > 0.25 )
    {
      SplashTime = Level.TimeSeconds;
      if (!FootRegion.Zone.bWaterZone&&newFootZone.bWaterZone)
    {
        if ( newFootZone.EntrySound != None )
        {
          HitActor = Trace(HitLocation, HitNormal, Location - (CollisionHeight + 40) * vect(0,0,0.8),
               Location - CollisionHeight * vect(0,0,0.8), false);
           
          if ( HitActor != None )
            SoundInfo.static.FootZoneChange(self);
        }
      }
    }
  
    if (FootRegion.Zone.bPainZone)
    {
      if ( !newFootZone.bPainZone && !HeadRegion.Zone.bWaterZone )
        PainTime = -1.0;
    }
    else if (newFootZone.bPainZone)
      PainTime = 0.01;
    
    return;
  }
  if ( Level.TimeSeconds - SplashTime > 0.25 )
  {
    SplashTime = Level.TimeSeconds;
  
    if (Physics == PHYS_Falling)
      MakeNoise(1.0);
    else
      MakeNoise(0.3);
    
    if ( FootRegion.Zone.bWaterZone )
    {
      if ( !newFootZone.bWaterZone && (Role==ROLE_Authority) )
      {
        if ( FootRegion.Zone.ExitSound != None )
          PlaySound(FootRegion.Zone.ExitSound, SLOT_Interact, 1);
      
        if ( FootRegion.Zone.ExitActor != None )
          Spawn(FootRegion.Zone.ExitActor,,,Location - CollisionHeight * vect(0,0,1));
      }
    }
    else if ( newFootZone.bWaterZone)
    {
      splashSize = FClamp(0.000025 * Mass * (300 - 0.5 * FMax(-500, Velocity.Z)), 1.0, 4.0 );
    
      if ( newFootZone.EntrySound != None )
      {
        HitActor = Trace(HitLocation, HitNormal,
          Location - (CollisionHeight + 40) * vect(0,0,0.8), Location - CollisionHeight * vect(0,0,0.8), false);
      
        if ( HitActor == None )
          PlaySound(newFootZone.EntrySound, SLOT_Misc, 2 * splashSize);
        else
        {
          xxServerSound(5);
        }
      }
    
      if( newFootZone.EntryActor != None )
      {
        splash = Spawn(newFootZone.EntryActor,,,Location - CollisionHeight * vect(0,0,1));
        if ( splash != None )
          splash.DrawScale = splashSize;
      }
    }
  }
  
  if (FootRegion.Zone.bPainZone)
  {
    if ( !newFootZone.bPainZone && !HeadRegion.Zone.bWaterZone )
      PainTime = -1.0;
  }
  else if (newFootZone.bPainZone)
    PainTime = 0.01;
}

function PlayDyingSound ()
{
  if ( Role == ROLE_Authority )
    xxServerSound(4);
  else
    SoundInfo.static.PlayDyingSound(self);
}

function DoJump (optional float F)
{
  if ( CarriedDecoration != None )
		return;

  if ( bSprint )
  {
    bSprintJustJump = True;
    SprintVelReset();
  }
  if ( IsA('bbPlayer') )
  {
    GetItemName("PreDoJump");
  }
  if (  !bIsCrouching && (Physics == PHYS_Walking) )
  {
    if ( IsA('bbPlayer') )
    {
      GetItemName("FirstJumpNotify");
    }
    if ( !bUpdating )
	{
	  if (Role == ROLE_AutonomousProxy)
		SoundInfo.static.DoJump(self);
	  else
		xxServerSound(3);
	}
	if ( (Level.Game != None) && (Level.Game.Difficulty > 0) )
		MakeNoise(0.1 * Level.Game.Difficulty);
	PlayInAir();
	if ( bCountJumps && (Role == ROLE_Authority) && (Inventory != None) )
		Inventory.OwnerJumped();
	if ( bIsWalking )
		Velocity.Z = Default.JumpZ;
	else
		Velocity.Z = JumpZ;
	if ( (Base != Level) && (Base != None) )
		Velocity.Z += Base.Velocity.Z; 
	SetPhysics(PHYS_Falling);
 	}
/*	else if (bDoubleJump && Physics == PHYS_Falling && nofJumps < maxJumps && Velocity.Z > -160.0 && (zzbIsWarmingUp || PlayerReplicationInfo.HasFlag == none))
	{	
		Velocity.Z = JumpZ * 1.2;
		if ( !bUpdating )
			
			if (Role == ROLE_AutonomousProxy)
				SoundInfo.static.DoDoubleJump(self);
			else
			xxServerSound(3);
		if ( bCountJumps && (Role == ROLE_Authority) && (Inventory != None) )
			Inventory.OwnerJumped();
		
		nofJumps++;
		if (nofJumps == maxJumps)
		{
			if ( AnimSequence=='DodgeR' && HasAnim('ROLLRIGHT') )
				PlayAnim('RollRight', 1.35 * FMax(0.35, Region.Zone.ZoneGravity.Z/Region.Zone.Default.ZoneGravity.Z), 0.06);
			else if ( AnimSequence=='DodgeL' && HasAnim('ROLLLEFT') )
				PlayAnim('RollLeft', 1.35 * FMax(0.35, Region.Zone.ZoneGravity.Z/Region.Zone.Default.ZoneGravity.Z), 0.06);
			else if ( HasAnim('Flip') )
				PlayAnim('Flip', 1.35 * FMax(0.35, Region.Zone.ZoneGravity.Z/Region.Zone.Default.ZoneGravity.Z), 0.06);
		}
	} */
  if ( IsA('bbPlayer') )
  {
    Super.DoJump(F);
  }
}

simulated function FootStepping()
{
  if (Role<ROLE_Authority)
    SoundInfo.static.FootStepping(self);
}

function PlayTakeHitSound(int damage, name damageType, int Mult)
{
  if ( Level.TimeSeconds - LastPainSound < 0.3 )
    return;
  
  LastPainSound = Level.TimeSeconds;
  
  if ( HeadRegion.Zone.bWaterZone )
  {
    if ( damageType == 'Drowned' )
      xxServerSound(7);
    else
      xxServerSound(8);
    
    return;
  }
  
  damage *= FRand();

  if (damage < 8) 
    xxServerSound(9);
  else if (damage < 25)
  {
    xxServerSound(10);
  }
  else
    xxServerSound(11);
}

function ClientPlayTakeHit(vector HitLoc, byte Damage, bool bServerGuessWeapon)
{
  super.ClientPlayTakeHit(hitloc,damage,bServerGuessWeapon);
  
  if ( Level.TimeSeconds - LastPainSound < 0.3 )
    return;
  
  LastPainSound = Level.TimeSeconds;

  if ( HeadRegion.Zone.bWaterZone )
  {
    if ( Hitloc == CollisionHeight * vect(0,0,0.5))
      SoundInfo.static.drown(self);
    else if ( FRand() < 0.5 )
      soundinfo.static.uwhit(self);
    
    return;
  }
  damage *= FRand();

  if (damage < 8) 
    soundinfo.static.hit1(self);
  else if (damage < 25)
  {
    soundinfo.static.hit23(self);
  }
  else
    soundinfo.static.hit4(self);
}

function Gasp()
{
  if ( PainTime < 2 )
    xxServerSound(1);
  else
    xxServerSound(2);
}

event HeadZoneChange(ZoneInfo newHeadZone)
{
  if (role==role_authority)
  {
    super.headzonechange(newheadzone);
    return;
  }
  
  if (HeadRegion.Zone.bWaterZone)
  {
    if (!newHeadZone.bWaterZone)
    {
      if (PainTime > 0 && (PainTime < 8) )
    {
        if ( PainTime < 2 )
          soundinfo.static.gasp(self);
        else
          soundinfo.static.breathagain(self);
      }
    
      bDrowning = false;
      if ( !FootRegion.Zone.bPainZone )
        PainTime = -1.0;
    }
  }
  else if (newHeadZone.bWaterZone && !FootRegion.Zone.bPainZone )
    PainTime = UnderWaterTime;
}

event PainTimer()
{
  local float depth;
  
  if (Level.NetMode != NM_Client)
  {
    super.paintimer();
    return;
  }
  
  if (Health < 0)
    return;
  
  if ( FootRegion.Zone.bPainZone )
      PainTime = 1.0;
  else if ( HeadRegion.Zone.bWaterZone )
      PainTime = 2.0;
}

simulated function PlayMetalStep()
{
  if (role<ROLE_Authority)
    SoundInfo.static.PlaySpecial(self, 'MetalStep');
}

simulated function WalkStep()
{
  if (role<ROLE_Authority)
    SoundInfo.static.PlaySpecial(self, 'WalkStep');
}

simulated function RunStep()
{
  if (role<ROLE_Authority)
    SoundInfo.static.PlaySpecial(self, 'RunStep');
}

state FeigningDeath
{
  event PlayerTick (float Time)
  {
    local Rotator Rot;
  
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      Rot = ViewRotation;
    }
    Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      ViewRotation = Rot;
    }
  }
  
  function Rise ()
  {
    if ( (Role == ROLE_Authority) && (Health <= 0) )
    {
      GotoState('Dying');
      return;
    }
    if (  !bRising )
    {
      SetTimer(0.7,False);
      BaseEyeHeight = Default.BaseEyeHeight;
      bRising = True;
      bAnimOn = True;
      PlayRising();
    }
  }
  function bool FeignAnimCheck ()
  {
    return bAnimOn;
  }
  function PlayTakeHit (float TweenTime, Vector HitLoc, int Damage)
  {
    if ( bAnimOn )
    {
      SetTimer(TweenTime,False);
      bAnimOn = True;
      Global.PlayTakeHit(TweenTime,HitLoc,Damage);
    }
  }
  
  function Timer ()
  {
    if ( Role < ROLE_Authority )
      return;

    if ( Health <= 0 )
    {
      GotoState('Dying');
      return;
    }
    GotoState('PlayerWalking');
    PendingWeapon.SetDefaultDisplayProperties();
    ChangedWeapon();
  }
  
  function PlayDying (name DamageType, Vector HitLocation)
  {
    BaseEyeHeight = Default.BaseEyeHeight;
    if ( bRising || bAnimOn )
    {
      Global.PlayDying(DamageType,HitLocation);
    }
  }
  
  function Landed (Vector HitNormal)
  {
    if ( IsA('bbPlayer') )
    {
      GetItemName("LandedNotify");
    }
    if ( Role == ROLE_Authority )
    {
      LandedCheck(HitNormal,True);
    }
    if ( Role == ROLE_Authority )
      xxServerSound(6);
    else
      SoundInfo.static.PlayerLanded(self);
    
    if ( bUpdating )
      return;
    
    TakeFallingDamage();
    bJustLanded = true;
    if ( Role == ROLE_Authority )
    {
      LandedCheck(HitNormal);
    }
  }
  
  simulated function BeginState ()
  {
    if ( ROLE == ROLE_SimulatedProxy )
    {
      MeshInfo.static.PlayFeignDeath(self);
    }
    if ( (Role != ROLE_SimulatedProxy) || (Level.NetMode == NM_Standalone) )
    {
      Super.BeginState();
    }
    bAnimOn = False;
  }
}

function PlayTurning()
{
  BaseEyeHeight = Default.BaseEyeHeight;
  if (role<role_authority)
    MeshInfo.static.PlayTurning(self);
  else
    baseanim=13;
}

function TweenToWalking(float tweentime)
{
  BaseEyeHeight = Default.BaseEyeHeight;
  
  if ((weapon!=none&&weapon.bpointing)|| (CarriedDecoration != None) )
  {
    if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.TweenToWalkingPoint(self);
  }
  else if (role<role_authority)
    MeshInfo.static.TweenToWalking(self);
}

function PlayDodge (EDodgeDir DodgeMove)
{
  local Vector X, Y, Z;

  if ( bSprint )
  {
    bSprintJustJump = True;
    GroundSpeed = Default.GroundSpeed;
    if ( VSize(Velocity) > GroundSpeed )
    {
      Velocity = Normal(Velocity);
      Velocity *= GroundSpeed;
    }
    GetAxes(Rotation,X,Y,Z);
	if (DodgeMove == DODGE_Forward)
		Velocity = 1.5*GroundSpeed*X + (Velocity Dot Y)*Y;
	else if (DodgeMove == DODGE_Back)
		Velocity = -1.5*GroundSpeed*X + (Velocity Dot Y)*Y;
	else if (DodgeMove == DODGE_Left)
		Velocity = 1.5*GroundSpeed*Y + (Velocity Dot X)*X;
	else if (DodgeMove == DODGE_Right)
		Velocity = -1.5*GroundSpeed*Y + (Velocity Dot X)*X;

	Velocity.Z = 210;
	if ( Mesh == None )
		return;

	if (Role < ROLE_Authority)
	{
		if ( DodgeMove == DODGE_Left )
		  MeshInfo.static.PlayDodgeL(self);
		else if ( DodgeMove == DODGE_Right )
		  MeshInfo.static.PlayDodgeR(self);
		else if (dodgemove == DODGE_BACK)
		  MeshInfo.static.PlayDodgeB(self);
		else
		  MeshInfo.static.PlayDodgeF(self);
	}
	else
	{
		if ( DodgeMove == DODGE_Left )
		  xxServerAnim(1);
		else if ( DodgeMove == DODGE_Right )
		  xxServerAnim(2);
		else if (dodgemove == DODGE_BACK)
		  xxServerAnim(3);
		else
		  xxServerAnim(4);
	}
  }
}

final function xxNNPlayServerAnim (byte zzid)
{
  xxServerAnim(zzid);
}

function PlayWalking ()
{
  BaseEyeHeight = Default.BaseEyeHeight;
  if ( Mesh == None )
    return;

  if ((weapon!=none&&weapon.bpointing)|| (CarriedDecoration != None) )
  {
    if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlayWalkingPoint(self);
    if(Role == ROLE_Authority)
      baseanim=12;
  }
  else
  {
	if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
		MeshInfo.static.PlayWalking(self);
	if(Role == ROLE_Authority)
		baseanim=11;
  }
}

function TweenToRunning (float TweenTime)
{
  local vector X,Y,Z, Dir;
  
  BaseEyeHeight = Default.BaseEyeHeight;
  if (bIsWalking)
  {
    TweenToWalking(0.1);
    return;
  }
  
  GetAxes(Rotation, X,Y,Z);
  Dir = Normal(Acceleration);
  
  if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
  {
    if ( (Dir Dot X < 0.75) && (Dir != vect(0,0,0)) )
    {
      if ( Dir Dot X < -0.75 )
        MeshInfo.static.Playrunning(self,2,true);
      else if ( Dir Dot Y > 0 )
        MeshInfo.static.Playrunning(self,3,true);
      else
        MeshInfo.static.Playrunning(self,4,true);
    }
    else if (weapon!=none&&weapon.bpointing)
      meshinfo.static.Playrunning(self,1,true);
    else
      MeshInfo.static.Playrunning(self,0,true);
  }
}

function PlayRunning()
{
  local vector X,Y,Z, Dir;
  
  BaseEyeHeight = Default.BaseEyeHeight;
  if ( Mesh == None )
    return;
  GetAxes(Rotation, X,Y,Z);
  Dir = Normal(Acceleration);
  
  if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
  {
    if ( (Dir Dot X < 0.75) && (Dir != vect(0,0,0)) )
    {
      if ( Dir Dot X < -0.75 )
        MeshInfo.static.Playrunning(self,2,false);
      else if ( Dir Dot Y > 0 )
        MeshInfo.static.Playrunning(self,3,false);
      else
        MeshInfo.static.Playrunning(self,4,false);
    }
    else if (weapon!=none&&weapon.bpointing)
      meshinfo.static.Playrunning(self,1,false);
    else
      MeshInfo.static.PlayRunning(self,0,false);
  }
  if ( (Role == ROLE_Authority) || (Level.NetMode == NM_Standalone) )
  {
    if ( (Dir Dot X < 0.75) && (Dir != vect(0,0,0)) )
    {
      if ( Dir Dot X < -0.75 )
        baseanim=8;
      else if ( Dir Dot Y > 0 )
        baseanim=9;
      else
        baseanim=10;
    }
    else if (weapon!=none&&weapon.bpointing)
      baseanim=7;
    else
      baseanim=6;
  }
}

function PlayRising()
{
  BaseEyeHeight = 0.41 * Default.BaseEyeHeight;
  if ( Mesh == None )
    return;

  if (role<role_authority)
    MeshInfo.static.PlayRising(self);
  if ( (Role == ROLE_Authority) || (Level.NetMode == NM_Standalone) )
    xxServerAnim(5);
}

function PlayFeignDeath()
{
  BaseEyeHeight = 0;
  if ( Mesh == None )
    return;
  if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayFeignDeath(self);
}

function Landed (Vector HitNormal)
{
  if ( IsA('bbPlayer') )
    GetItemName("LandedNotify");
  if ( ROLE == ROLE_Authority )
    LandedCheck(HitNormal,True);
  if ( bUpdating )
    return;

  PlayLanded(Velocity.Z);
  LandBob = FMin(50.0,0.05 * Velocity.Z);
  TakeFallingDamage();
  bJustLanded = True;
  if ( ROLE == ROLE_Authority )
  {
    LandedCheck(HitNormal);
  }
  Super.Landed(HitNormal);
}

function PlayLanded(float impactVel)
{
    BaseEyeHeight = default.BaseEyeHeight;
    if ( Mesh == None )
		return;
    if(Role == ROLE_Authority)
    {
        impactVel /= -20;
        if(impactVel >= 1)
        {
            zzNextAnim = impactVel;
            zzNextAnim += 128;
        }
    }
    if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
        MeshInfo.static.PlayLanded(self, impactVel);
}

function PlayInAir()
{
  BaseEyeHeight =  0.7 * Default.BaseEyeHeight;
  if ( Mesh == None )
	  return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayInAir(self);
  if(Role != ROLE_AutonomousProxy)
  {
      if (DodgeDir != DODGE_Active)
        xxServerAnim(16);
  }
}

function PlayDuck()
{
  BaseEyeHeight = 0;
  if ( Mesh == None )
	return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayDuck(self);
  if ( Role != ROLE_AutonomousProxy )
    baseanim=15;
}

function PlayCrawling()
{
  BaseEyeHeight = 0;
  if ( Mesh == None )
	return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayCrawling(self);
  if ( Role != ROLE_AutonomousProxy )
    baseanim=16;
}

function TweenToWaiting(float tweentime)
{
  if ( (IsInState('PlayerSwimming')) || (physics==phys_swimming) )
    BaseEyeHeight = 0.7 * Default.BaseEyeHeight;
  else
    BaseEyeHeight = Default.BaseEyeHeight;
  if ( Mesh == None )
	return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.TweenToWaiting(self, tweentime);
}

function PlayRecoil (float Rate)
{
  if ( Mesh == None )
    return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
  {
    if ( (Weapon != None) && (Rate >= 1.9 * Weapon.FiringSpeed) )
      MeshInfo.static.PlayDoubleRecoil(self);
    else
      MeshInfo.static.PlayRecoil(self);
  }
  if ( Role != ROLE_AutonomousProxy )
  {
    if ( (Weapon != None) && (Rate >= 1.9 * Weapon.FiringSpeed) )
      xxServerAnim(7);
    else
      xxServerAnim(8);
  }
}

function PlayFiring ()
{
  if ( Mesh == None )
    return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayFiring(self);
  if ( Role != ROLE_AutonomousProxy )
  {
    if ( (zzNextAnim > 0) && (zzNextAnim < 5) || (zzNextAnim == 16) )
      return;
    xxServerAnim(9);
  }
}

function PlayWeaponSwitch (Weapon NewWeapon)
{
  if ( Mesh == None )
    return;
  if ( (Weapon == None) || (Weapon.Mass < 20) )
  {
    if ( (NewWeapon != None) && (NewWeapon.Mass > 20) )
    {
      if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
        MeshInfo.static.PlayBigWeaponSwitch(self);
      if ( Role != ROLE_AutonomousProxy )
	  {
        if ( (zzNextAnim > 0) && (zzNextAnim < 5) || (zzNextAnim == 16) )
          return;
        xxServerAnim(10);
      }
    }
  }
  else if ( (NewWeapon == None) || (NewWeapon.Mass < 20) )
  {
	if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
		MeshInfo.static.PlayWeaponSwitch(self);
	if ( Role != ROLE_AutonomousProxy )
	{
		if ( (zzNextAnim > 0) && (zzNextAnim < 5) || (zzNextAnim == 16) )
			return;
		xxServerAnim(11);
	}
  }
}

function PlaySwimming ()
{
  BaseEyeHeight = 0.7 * Default.BaseEyeHeight;
  if ( Mesh == None )
    return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlaySwimming(self);
}

function TweenToSwimming (float TweenTime)
{
  if ( Mesh == None )
    return;
  if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.TweenToSwimming(self,TweenTime);
}

function PlayDying (name DamageType, Vector HitLoc)
{
  local vector X,Y,Z, HitVec, HitVec2D;
  local float dotp;

  BaseEyeHeight = Default.BaseEyeHeight;
  PlayDyingSound();
  if ( Mesh == None )
    return;
  if ( DamageType == 'Suicided' )
  {
    if ( Role == ROLE_Authority )
      zzPendingDeath = 3;
    if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlayDying(self,3);
		return;
  }
  if ( DamageType == 'Decapitated' )
  {
    if ( Role == ROLE_Authority )
      zzPendingDeath = 4;
    if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlayDying(self,4);
		return;
  }
  if ( (Health > -10) && ((DamageType == 'shot') || (DamageType == 'zapped')) )
  {
    if ( Role == ROLE_Authority )
      zzPendingDeath = 5;
    if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlayDying(self,5);
		return;
  }
  if ( HitLoc.Z - Location.Z > 0.7 * CollisionHeight )
  {
    if ( Role == ROLE_Authority )
      zzPendingDeath = 6;
    if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlayDying(self,6);
		return;
  }
  GetAxes(Rotation,X,Y,Z);
  X.Z = 0.0;
  HitVec = Normal(HitLoc - Location);
  HitVec2D = HitVec;
  HitVec2D.Z = 0.0;
  dotp = HitVec2D Dot X;
  if ( Abs(dotp) > 0.71 )
  {
    if ( Role == ROLE_Authority )
      zzPendingDeath = 0;
    if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlayDying(self,0);
  }
  else
  {
    dotp = HitVec Dot Y;
    if ( dotp > 0.0 )
	{
      if ( Role == ROLE_Authority )
        zzPendingDeath = 1;
      if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
        MeshInfo.static.PlayDying(self,1);
    }
	else
	{
      if ( Role == ROLE_Authority )
        zzPendingDeath = 2;
      if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
        MeshInfo.static.PlayDying(self,2);
    }
  }
}

function Carcass SpawnCarcass ()
{
  local Carcass carc;
  local NN_ALcarcassSpawner CS;

  if (  !bNNClass )
  {
    carc = Super(PlayerPawn).SpawnCarcass();
    if ( ALcarcass(carc) != None )
    {
      ALcarcass(carc).xxsetanim(zzPendingDeath);
    }
  } else {
    foreach AllActors(Class'NN_ALcarcassSpawner',CS)
    {
      CS.ALClientSpawnCarcass(self,Velocity,Location,Rotation,zzPendingDeath);
    }
  }
}

function PlayGutHit (float TweenTime)
{
  if ( Mesh == None )
    return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayGutHit(self);
  if ( Role != ROLE_AutonomousProxy )
    xxServerAnim(12);
}

function PlayHeadHit (float TweenTime)
{
  if ( Mesh == None )
    return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayHeadHit(self);
  if ( Role != ROLE_AutonomousProxy )
    xxServerAnim(13);
}

function PlayLeftHit (float TweenTime)
{
  if ( Mesh == None )
    return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayLeftHit(self);
  if ( Role != ROLE_AutonomousProxy )
    xxServerAnim(14);
}

function PlayRightHit (float TweenTime)
{
  if ( Mesh == None )
    return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayRightHit(self);
  if ( Role != ROLE_AutonomousProxy )
    xxServerAnim(15);
}

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
  local float rnd;
  local Bubble1 bub;
  local bool bServerGuessWeapon;
  local vector BloodOffset, Mo;
  local int iDam;

  if ( (Damage <= 0) && (ReducedDamageType != 'All') )
    return;

  if ( ReducedDamageType != 'All' )
  {
    if (damageType == 'Drowned')
    {
      bub = spawn(class 'Bubble1',,, Location 
        + 0.7 * CollisionRadius * vector(ViewRotation) + 0.3 * EyeHeight * vect(0,0,1));
      if (bub != None)
        bub.DrawScale = FRand()*0.06+0.04; 
    }
    else if ( (damageType != 'Burned') && (damageType != 'Corroded') 
          && (damageType != 'Fell') )
    {
      BloodOffset = 0.2 * CollisionRadius * Normal(HitLocation - Location);
      BloodOffset.Z = BloodOffset.Z * 0.5;
      if ( (DamageType == 'shot') || (DamageType == 'decapitated') || (DamageType == 'shredded') )
      {
        Mo = Momentum;
        if ( Mo.Z > 0 )
          Mo.Z *= 0.5;
        spawn(class 'UT_BloodHit',self,,hitLocation + BloodOffset, rotator(Mo));
      }
      else
        spawn(class 'UT_BloodBurst',self,,hitLocation + BloodOffset);
    }
  }
  rnd = FClamp(Damage, 20, 60);
  if ( damageType == 'Burned' )
    ClientFlash( -0.009375 * rnd, rnd * vect(16.41, 11.719, 4.6875));
  else if ( damageType == 'Corroded' )
    ClientFlash( -0.01171875 * rnd, rnd * vect(9.375, 14.0625, 4.6875));
  else if ( damageType == 'Drowned' )
    ClientFlash(-0.390, vect(312.5,468.75,468.75));
  else 
    ClientFlash( -0.019 * rnd, rnd * vect(26.5, 4.5, 4.5));

  ShakeView(0.15 + 0.005 * Damage, Damage * 30, 0.3 * Damage); 
  PlayTakeHitSound(Damage, damageType, 1);
  bServerGuessWeapon = ( ((Weapon != None) && Weapon.bPointing) || DodgeDir == DODGE_Active);
  iDam = Clamp(Damage,0,200);
  ClientPlayTakeHit(hitLocation - Location, iDam, bServerGuessWeapon ); 
  if ( !bServerGuessWeapon 
    && ((Level.NetMode == NM_DedicatedServer) || (Level.NetMode == NM_ListenServer)) )
  {
    BaseEyeHeight = Default.BaseEyeHeight;
    PlayTakeHit(0.1, hitLocation, Damage);
  }
}

function SwimAnimUpdate (bool bNotForward)
{
  if ( Mesh == None )
    return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.SwimAnimUpdate(self,bNotForward);
  if ( Role != ROLE_AutonomousProxy )
  {
    if ( bNotForward )
      BaseAnim = 18;
    else
      BaseAnim = 17;
  }
}

state PlayerSwimming
{
  event PlayerTick (float Time)
  {
    local Rotator Rot;

	Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
      Rot = ViewRotation;
    if ( IsA('bbPlayer') &&  !bNNUU )
      ViewRotation = Rot;
  }
  
  simulated function AnimEnd ()
  {
    if ( Mesh == None )
      return;
    if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.xxSwimAnimEnd(self);
  }
  
  simulated function BeginState ()
  {
    if ( ((Level.NetMode == NM_Standalone) || (Role == ROLE_SimulatedProxy)) &&  !IsAnimating() )
      TweenToWaiting(0.31);
    if (  !(Role == ROLE_SimulatedProxy) &&  !IsAnimating() )
    {
      if ( Role > ROLE_SimulatedProxy )
        Super.BeginState();
    }
  }
  
  event UpdateEyeHeight (float DeltaTime)
  {
    Super.UpdateEyeHeight(DeltaTime);
    Tick(DeltaTime);
  }
  
  function PlayDuck ()
  {
    local byte zzoldanim;
  
    zzoldanim = BaseAnim;
    Global.PlayDuck();
    BaseAnim = zzoldanim;
    if ( Role == ROLE_Authority )
      xxServerAnim(17);
  }
  
}

state PlayerFlying
{
  event PlayerTick (float Time)
  {
    local Rotator Rot;

    Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
      Rot = ViewRotation;
    if ( IsA('bbPlayer') &&  !bNNUU )
      ViewRotation = Rot;
  }
  
  simulated function AnimEnd ()
  {
    if ( Mesh == None )
      return;
    if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlaySwimming(self);
  }
}

state CheatFlying
{
  ignores  TakeDamage;
  
  event PlayerTick (float Time)
  {
    local Rotator Rot;

    Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
      Rot = ViewRotation;
    if ( IsA('bbPlayer') &&  !bNNUU )
      ViewRotation = Rot;
  }
  
  simulated function AnimEnd ()
  {
    if ( Mesh == None )
      return;
    if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlaySwimming(self);
  }
}

function AutonomousWalkAnim(vector oldaccel)
{
  if ( (Physics == PHYS_Walking) && (meshinfo.static.GetMyAnimGroup(self) != 'Dodge') )
    {
      if (!bIsCrouching)
      {
        if (bDuck != 0)
        {
          bIsCrouching = true;
          PlayDuck();
        }
      }
      else if (bDuck == 0)
      {
        OldAccel = vect(0,0,0);
        bIsCrouching = false;
        TweenToRunning(0.1);
      }

      if ( !bIsCrouching )
      {
        if ( (!bAnimTransition || (AnimFrame > 0)) && (meshinfo.static.GetMyAnimGroup(self) != 'Landing') )
        {
          if ( Acceleration != vect(0,0,0) )
          {
            if ( (meshinfo.static.GetMyAnimGroup(self) == 'Waiting') || (meshinfo.static.GetMyAnimGroup(self) == 'Gesture') || (meshinfo.static.GetMyAnimGroup(self) == 'TakeHit') )
            {
              bAnimTransition = true;
              TweenToRunning(0.1);
            }
          }
           else if ( (Velocity.X * Velocity.X + Velocity.Y * Velocity.Y < 1000) 
            && (meshinfo.static.GetMyAnimGroup(self) != 'Gesture') )
           {
             if ( meshinfo.static.GetMyAnimGroup(self) == 'Waiting' )
             {
              if ( bIsTurning && (AnimFrame >= 0) ) 
              {
                bAnimTransition = true;
                PlayTurning();
              }
            }
             else if ( !bIsTurning ) 
            {
              bAnimTransition = true;
              TweenToWaiting(0.2);
            }
          }
        }
      }
      else
      {
        if ( (OldAccel == vect(0,0,0)) && (Acceleration != vect(0,0,0)) )
          PlayCrawling();
        else if ( !bIsTurning && (Acceleration == vect(0,0,0)) && (AnimFrame > 0.1) )
          PlayDuck();
      }
    }
}

state PlayerWalking
{
  event PlayerTick (float Time)
  {
    local Rotator Rot;

    Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
      Rot = ViewRotation;
    if ( IsA('bbPlayer') &&  !bNNUU )
      ViewRotation = Rot;
  }
  
  function PlayDuck ()
  {
    BaseEyeHeight = 0.0;
    if ( Mesh == None )
      return;
    if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlayDuck(self);
    if ( Role != ROLE_AutonomousProxy )
      BaseAnim = 15;
  }
  
  function PlayCrawling ()
  {
    BaseEyeHeight = 0.0;
    if ( Mesh == None )
      return;
    if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.PlayCrawling(self);
    if ( Role != ROLE_AutonomousProxy )
      BaseAnim = 16;
  }
  
  function Dodge (EDodgeDir DodgeMove)
  {
    local Vector X, Y, Z;
  
    if ( bIsCrouching || (Physics != PHYS_Walking) )
			return;

		GetAxes(Rotation,X,Y,Z);
    if ( bSprint )
    {
      if ( VSize(Velocity) > Default.GroundSpeed )
      {
        Velocity = Default.GroundSpeed * Normal(Velocity);
      }
      bSprintJustJump = True;
      GroundSpeed = Default.GroundSpeed;
    }
		if (DodgeMove == DODGE_Forward)
			Velocity = 1.5*GroundSpeed*X + (Velocity Dot Y)*Y;
		else if (DodgeMove == DODGE_Back)
			Velocity = -1.5*GroundSpeed*X + (Velocity Dot Y)*Y;
		else if (DodgeMove == DODGE_Left)
			Velocity = 1.5*GroundSpeed*Y + (Velocity Dot X)*X;
		else if (DodgeMove == DODGE_Right)
			Velocity = -1.5*GroundSpeed*Y + (Velocity Dot X)*X;

		Velocity.Z = 160;
    if ( Role == ROLE_Authority )
    {
      xxServerSound(12);
    }
    if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
    {
      SoundInfo.static.DodgeSound(self);
    }
    PlayDodge(DodgeMove);
	DodgeDir = DODGE_Active;
	SetPhysics(PHYS_Falling);
  }
  
  simulated function AnimEnd ()
  {
    if ( Mesh == None )
      return;
    if ( (Role < ROLE_Authority) || (Level.NetMode == NM_Standalone) )
      MeshInfo.static.xxWalkingAnimEnd(self);
  }
  
  function ProcessMove(float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot)
  {
    local vector OldAccel;
    
    OldAccel = Acceleration;
    Acceleration = NewAccel;
    bIsTurning = ( Abs(DeltaRot.Yaw/DeltaTime) > 5000 );
    if ( (DodgeMove == DODGE_Active) && (Physics == PHYS_Falling) )
      DodgeDir = DODGE_Active;  
    else if ( (DodgeMove != DODGE_None) && (DodgeMove < DODGE_Active) )
      Dodge(DodgeMove);

    if ( bPressedJump )
      DoJump();
    if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
	{
      AutonomousWalkAnim(oldaccel);
	  if(Level.NetMode != NM_Standalone)
	  {
		return;
	  }
    }
    if ( (Physics == PHYS_Walking) && (dodgedir!=DODGE_ACTIVE) )
    {
      if (!bIsCrouching)
      {
        if (bDuck != 0)
        {
          bIsCrouching = true;
        }
      }
      else if (bDuck == 0)
      {
        OldAccel = vect(0,0,0);
        bIsCrouching = false;
      }

      if ( !bIsCrouching )
      {
        if ( Acceleration != vect(0,0,0) )
        {
          if (biswalking)
            playwalking();
          else
            playrunning();
        }
        else if ( bIsTurning)
        {
          PlayTurning();
        }
        else
          playwaiting();
      }
      else
      {
        if ( Acceleration != vect(0,0,0) ||bisturning)
          PlayCrawling();
        else
          PlayDuck();
      }
    }
  else
    baseanim=0;
  }
  
  event UpdateEyeHeight (float DeltaTime)
  {
    Super.UpdateEyeHeight(DeltaTime);
    Tick(DeltaTime);
  }
  
  simulated function BeginState ()
  {
    if ( Role > ROLE_SimulatedProxy )
    {
      Super.BeginState();
      if ( Level.NetMode != NM_Standalone )
        return;
    }
    if ( Mesh == None )
      SetMesh();
    if (  !IsAnimating() )
      PlayWaiting();
  }
}

function int xxID ()
{
  return 31645;
}

final simulated function byte GetWaitingAnimType ()
{
  ViewRotation.Pitch = ViewRotation.Pitch & 65535;
  if ( (ViewRotation.Pitch > RotationRate.Pitch) && (ViewRotation.Pitch < 65536 - RotationRate.Pitch) )
  {
    if ( ViewRotation.Pitch < 32768 )
      return 2;
    else
      return 3;
  }
  else
  {
    if ( (Weapon != None) && Weapon.bPointing )
    {
      if ( Weapon.bRapidFire && ((bFire != 0) || (bAltFire != 0)) )
        return 4;
      else
        return 5;
    } 
	else 
      return 1;
  }
}

function PlayWaiting ()
{
  local byte AnimType;

  if ( bIsTyping )
  {
    PlayChatting();
    return;
  }
  if ( IsInState('PlayerSwimming') || (Physics == PHYS_Swimming) )
  {
    BaseEyeHeight = 0.7 * Default.BaseEyeHeight;
  } else {
    BaseEyeHeight = Default.BaseEyeHeight;
  }
  AnimType = GetWaitingAnimType();
  if ( ROLE == ROLE_Authority )
  {
    BaseAnim = AnimType;
  }
  if ( (Role != ROLE_Authority) || (Level.NetMode == NM_Standalone) )
  {
    if ( Mesh == None )
      return;
    if ( AnimType > 0 )
      MeshInfo.static.PlayWaiting(self,AnimType - 1);
  }
}

function PlayChatting ()
{
  if ( Mesh == None )
    return;
  if ( (Role == ROLE_AutonomousProxy) || (Level.NetMode == NM_Standalone) )
    MeshInfo.static.PlayChatting(self);
  if ( Role != ROLE_AutonomousProxy )
    BaseAnim = 14;
}

function ServerTaunt (name Sequence);

function xxServerTaunt(byte zzsequence)
{
  if (zzsequence<5)
	xxServerAnim(zzsequence+18);
}

exec function Taunt (name zzsequence)
{
  local byte zzseq;

  if ( Mesh == None )
    return;

  switch (zzsequence)
  {
    case 'Taunt1':
    zzseq = 0;
    break;
    case 'Thrust':
    zzseq = 1;
    break;
    case 'Victory1':
    zzseq = 2;
    break;
    case 'Wave':
    zzseq = 3;
    break;
    case 'Challenge':
    zzseq = 4;
    break;
  }
  xxServerTaunt(zzseq);
  MeshInfo.static.Taunt(self, zzsequence);
}

function ClientWeaponEvent(name EventType)  //s3 hack fix.....
{
  if (string(weapon.class)~="botpack.impacthammer"&&eventtype!='FireBlast'){
    log("Abnormal clientweaponeventtype:"@EventType);
    eventtype='FireBlast';
  }
  else if (string(weapon.class)~="botpack.translocator"&&eventtype!='TouchTarget'){
    log("Abnormal clientweaponeventtype:"@EventType);
    eventtype='TouchTarget';
  }
  super.ClientWeaponEvent(EventType);
}

function SendVoiceMessage(PlayerReplicationInfo Sender, PlayerReplicationInfo Recipient, name messagetype, byte messageID, name broadcasttype)
{
  super.sendvoicemessage(playerreplicationinfo,recipient,messagetype,messageID,broadcasttype);  //lame anti-cheat :P
}

function SetVoice (Class<ChallengeVoicePack> V)
{
  PlayerReplicationInfo.VoiceType = V;
  UpdateURL("Voice",string(V),True);
  ServerSetVoice(V);
  xxServerSetVPString(string(V));
}

function ServerSetVoice(class<ChallengeVoicePack> V)
{
  if (V!=none)
    PlayerReplicationInfo.VoiceType = V;
}

function xxServerSetVPString(string V){
  if (v!="")
    GetALPRI(playerreplicationinfo).zzvoicestring=v;
}

exec function Help(string cmd){
//ClearProgressMessages();
if (cmd==""){
  Clientmessage("Welcome to Valhalla Avatar 1.0");
  Clientmessage("Commands: (type help [command name] for more info)");
 // Clientmessage("About: Credits");
//  Clientmessage("info: Information About Valhalla Avatar");
//  Clientmessage("PlayerInfo: Displays info about each player's model, skin, and voicepack.");
  Clientmessage("SetDefault (string): Set default mesh");
  Clientmessage("SetGestureTime (float): Set gesture time");
  Clientmessage("More info can be found by hitting ESC and viewing the ValAvatar menus.");
}
else if (cmd~="about"||cmd~="info"||cmd~="playerinfo")
  Clientmessage("Obsolete commands. Please use menus by hitting ESC");
//  Clientmessage("Self-Explainatory");
//else if (cmd~="PlayerInfo")
//  Clientmessage("This displays information on what model, skin, and voicepack each player in the game has intended to use.  Installed tells if you have that file installed and it is being used (if not, a default is).");
else if (cmd~="SetDefault"){
  ClientMessage("Specify a player class to be used if you do not have one another player is using installed");
  Clientmessage("Note that this will not work if the server has disabled 'AllowClientOverride'");
  Clientmessage("Ex: SetDefault Botpack.Tmale2");
}
else if (cmd~="SetGestureTime"){
  ClientMessage("Set the amount of time in seconds between player gestures.  Ignored at end of game.");
  Clientmessage("If you choose 0, then no gestures, other than your own, will occur");
  Clientmessage("Ex: SetGesture 2.12");
}
else
  Clientmessage(cmd$": Unknown command!");
}

exec function About ()
{
  ClientMessage("OBSOLETE! Please use menus.");
}

exec function Info ()
{
  ClientMessage("OBSOLETE! Please use menus.");
}

exec function SetDefault (string Cmd)
{
  if ( Cmd == "" )
    ClientMessage("Please specify a class");
  else if ( Class<PlayerPawn>(DynamicLoadObject(Cmd,Class'Class')) == None )
      ClientMessage("The class" @ Cmd @ "is invalid or not installed on this computer");
    else
	{
      Class'VASettings'.Default.DefaultPlayer = Cmd;
      Class'VASettings'.StaticSaveConfig();
      ClientMessage("Default model is now" @ Cmd);
    }
}

exec function SetGestureTime (float Cmd)
{
  Class'VASettings'.Default.gesturetime = Cmd;
  Class'VASettings'.StaticSaveConfig();
  if ( Cmd == 0 )
    ClientMessage("Gestures Disabled!");
  else
    ClientMessage("Gestures will play every" @ string(Cmd) @ "seconds.");
}

exec function PlayerInfo ()
{
  ClientMessage("OBSOLETE! Please use menus.");
}

function xxSetMeshClass (coerce string zzmesh, coerce string SkinName, coerce string FaceName)
{
  local Mutator zzM;

  if ( (Class'VASettings'.Default.MeshSkinAllowChange != 2) || (zzmesh == "") )
    return;

  for(zzm = Level.Game.BaseMutator; zzm != None ; zzm = zzm.NextMutator)
    if ( zzm.Class == Class'VAServer' )
       break;
  zzmesh = VAServer(zzM).xxclasscheck(zzmesh);
  MenuName = VAServer(zzM).MenuName;
  GetALPRI(PlayerReplicationInfo).zzClassString = zzmesh;
  ServerChangeSkin(SkinName,FaceName,PlayerReplicationInfo.Team);
}

exec function TeamSay( string Msg )
{
  local string OutMsg;
  local string cmd;
  local int pos,i, zzi;
  local int ArmorAmount;
  local inventory inv;
  local TournamentWeapon Weap,tw;
  local TournamentPickup Item,Special,a;

  local int x;
  local int zone;
  local flagbase Red_FB, Blue_FB;
  local CTFFlag F,Red_F, Blue_F;
  local float dRed_b, dBlue_b, dRed_f, dBlue_f;


  if (PlayerReplicationInfo.Team==255)
  {
    super.TeamSay(Msg);
    return;
  }
  
  OutMsg = "";
  pos = InStr(Msg,"%");
  if (pos>-1)
  {
    for (i=0;i<100;i=1)
    {
      if (pos>0)
      {
        OutMsg = OutMsg$Left(Msg,pos);
        Msg = Mid(Msg,pos);
        pos = 0;
        }

      x = len(Msg);
      cmd = mid(Msg,pos,2);
      if (x-2 > 0)
        Msg = right(msg,x-2);
      else
        Msg = "";
     
      if (cmd~="%H")
      {
      OutMsg = OutMsg$Health$" Health";
      }
      else if (cmd~="%W")
      {
        OutMsg = OutMsg$Weapon.GetHumanName();
      }
      else if (cmd~="%A")
      {
        ArmorAmount = 0;
        for( Inv=Inventory; Inv!=None; Inv=Inv.Inventory )
        { 
          if (Inv.bIsAnArmor) 
          {
            if ( Inv.IsA('UT_Shieldbelt') )
              OutMsg = OutMsg$"PowerShield ("$Inv.Charge$") and ";
            else 
              ArmorAmount += Inv.Charge;
          }
        }
      
         OutMsg = OutMsg$ArmorAmount$" Armor";
      }
  else if (cmd~="%P"&&gamereplicationinfo.isa('CTFReplicationInfo'))
      {
        for (zzi=0;zzi<4;zzi++){
          f=CTFReplicationInfo(gamereplicationinfo).FlagList[zzi];
          if (f==none)
            break;
          if (F.homebase.team==0)
            Red_FB = F.homebase;
          else if (F.homebase.team==1)
            Blue_FB = F.homebase;
          if (F.Team==0)
            Red_F = F;
          else if (F.Team==1)
            Blue_F = F;
        }
        dRed_b = vSize(Location - Red_FB.Location);
        dBlue_b = vSize(Location - Blue_FB.Location);
        dRed_f = vSize(Location - Red_F.Position().Location);
        dBlue_f = vSize(Location - Blue_F.Position().Location);

        if (PlayerReplicationInfo.Team==0)
        {
          if (dRed_f<2048 && Red_F.Holder != None&&(Blue_f.holder==none||dRed_f<dBlue_f))
            zone = 0;
          else if (dBlue_f<2048 && Blue_F.Holder != None&&(Red_f.holder==none||dRed_f>dBlue_f))
            zone = 1;
          else if (dBlue_b<2049)
            zone = 2;
          else if (dRed_b<2048)
            zone = 3;
          else
            zone = 4;
        }
        else if (PlayerReplicationInfo.Team==1)
        {
          if (dBlue_f<2048 && Blue_f.Holder != None&&(Red_f.holder==none||dRed_f>=dBlue_f))
            zone = 0;
          else if (dRed_f<2048 && Red_f.Holder != None&&(Blue_f.holder==none||dRed_f<dBlue_f))
            zone = 1;
          else if (dRed_b<2048)
            zone = 2;
          else if (dBlue_b<2048)
            zone = 3;
          else
            zone = 4;
        }

        if ( (Blue_f.Holder == Self) ||
             (Red_f.Holder == Self) )
            zone = 5;

        switch (zone)
        {
          case 0: OutMsg = OutMsg$"Attacking Enemy Flag Carrier";break;
          case 1: OutMsg = OutMsg$"Supporting Our Flag Carrier";break;
          case 2: OutMsg = OutMsg$"Attacking";break;
          case 3: OutMsg = OutMsg$"Defending";break;
          case 4: OutMsg = OutMsg$"Floating";break;
          case 5: OutMsg = OutMsg$"Carrying Flag";break;
        }
      }
      else if (cmd=="%%")
        OutMsg = OutMsg$"%";
      else
      {
        OutMsg = OutMsg$cmd;
      }
      
      pos = InStr(Msg,"%");
  
      if (Pos==-1)
        break;
    }  
    if (len(msg)>0)
      OutMsg = OutMsg$Msg;
  }
  else
    OutMsg = Msg;

  super.TeamSay(OutMsg);
}

function LandedCheck (Vector HitNormal, optional bool bPreLanded)
{
  local Inventory Inv;

  if ( SPAPW != None )
  {
    if ( bPreLanded )
      SPAPW.GotoState('PreOwnerLanded');
    else
      SPAPW.GotoState('OwnerLanded');
  }
  for(Inv = Inventory; Inv != None; Inv = Inv.Inventory)
  {
    if ( Inv.GetItemName("Landed") ~= "LandedCheck" )
      Inv.Landed(HitNormal);
  }
}

state PlayerWaiting
{
  ignores  TakeDamage, Died;
  
  event PlayerTick (float Time)
  {
    local Rotator Rot;
  
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      Rot = ViewRotation;
    }
    Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      ViewRotation = Rot;
    }
  }
  
  function ProcessMove (float DeltaTime, Vector newAccel, EDodgeDir DodgeMove, Rotator DeltaRot)
  {
    local Teleporter TP;
    local Teleporter DestTP;
  
    Super.ProcessMove(DeltaTime,newAccel,DodgeMove,DeltaRot);
    if ( IsA('bbPlayer') )
    {
      return;
    }
    foreach RadiusActors(Class'Teleporter',DestTP,CollisionRadius,Location)
    {
      TP = DestTP;
    }
    if ( TP != None )
    {
      if ( zzLastTP != TP )
      {
        foreach AllActors(Class'Teleporter',DestTP)
        {
          if ( string(DestTP.Tag) ~= TP.URL )
          {
            zzLastTP = DestTP;
            TP.Touch(self);
            return;
          }
        }
      }
    } else {
      zzLastTP = None;
    }
  }
  
  function BeginState ()
  {
    Super.BeginState();
    drawtype=DT_none;
  }
  
  function EndState ()
  {
    SetMesh();
    if ( PlayerReplicationInfo != None )
    {
      PlayerReplicationInfo.bIsSpectator = False;
      PlayerReplicationInfo.bWaitingPlayer = False;
    }
    SetCollision(True,True,True);
    drawtype=DT_mesh;
  }
}

state PlayerSpectating
{
  ignores  TakeDamage, Died;
  
  event PlayerTick (float Time)
  {
    local Rotator Rot;
  
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      Rot = ViewRotation;
    }
    Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      ViewRotation = Rot;
    }
  }
  
  function ProcessMove (float DeltaTime, Vector newAccel, EDodgeDir DodgeMove, Rotator DeltaRot)
  {
    local Teleporter TP;
    local Teleporter DestTP;
  
    Super.ProcessMove(DeltaTime,newAccel,DodgeMove,DeltaRot);
    if ( IsA('bbPlayer') )
    {
      return;
    }
    foreach RadiusActors(Class'Teleporter',DestTP,CollisionRadius,Location)
    {
      TP = DestTP;
    }
    if ( TP != None )
    {
      if ( zzLastTP != TP )
      {
        foreach AllActors(Class'Teleporter',DestTP)
        {
          if ( string(DestTP.Tag) ~= TP.URL )
          {
            zzLastTP = DestTP;
            TP.Touch(self);
            return;
          }
        }
      }
    } else {
      zzLastTP = None;
    }
  }
  function BeginState()
  {
    super.beginstate();
    drawtype=DT_none;
  }
  function EndState(){
    super.EndState();
    drawtype=DT_mesh;
  }
}

state PlayerWaking
{
  event PlayerTick (float Time)
  {
    local Rotator Rot;
  
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      Rot = ViewRotation;
    }
    Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      ViewRotation = Rot;
    }
  }
  
}

state Dying
{
  event PlayerTick (float Time)
  {
    local Rotator Rot;
  
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      Rot = ViewRotation;
    }
    Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      ViewRotation = Rot;
    }
  }
}

state GameEnded
{
  ignores  KilledBy, TakeDamage, Died, ServerReStartGame, Fire;
  
  event PlayerTick (float Time)
  {
    local Rotator Rot;
  
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      Rot = ViewRotation;
    }
    Super.PlayerTick(Time);
    if ( IsA('bbPlayer') &&  !bNNUU )
    {
      ViewRotation = Rot;
    }
  }
  
  simulated function BeginState ()
  {
    local Pawn P;
  
    if ( (Role == ROLE_SimulatedProxy) || (Level.NetMode == NM_Standalone) )
    {
      AnimRate = 0.0;
      SimAnim.Y = 0.0;
    }
    if ( Role != ROLE_SimulatedProxy )
    {
      Super.BeginState();
    }
  }
}

defaultproperties
{
    lastgesturetime=-1000.00
    MeshInfo=Class'DPMSMeshInfo'
    CarcassType=Class'ALcarcass'
    Texture=Texture'Botpack.miniammoledbase'
    Mesh=LodMesh'Botpack.Commando'
}